/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.coxph;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.coxph.CoxPHMojoModel;
import java.io.IOException;
import java.util.HashMap;

public class CoxPHMojoReader
extends ModelMojoReader<CoxPHMojoModel> {
    @Override
    public String getModelName() {
        return "CoxPH";
    }

    @Override
    protected void readModelData() throws IOException {
        ((CoxPHMojoModel)this._model)._x_mean_cat = this.readRectangularDoubleArray("x_mean_cat");
        ((CoxPHMojoModel)this._model)._x_mean_num = this.readRectangularDoubleArray("x_mean_num");
        ((CoxPHMojoModel)this._model)._coef = (double[])this.readkv("coef");
        ((CoxPHMojoModel)this._model)._strata = this.readStrata();
        ((CoxPHMojoModel)this._model)._strata_len = this.readStrataLen();
        ((CoxPHMojoModel)this._model)._cat_offsets = (int[])this.readkv("cat_offsets");
        ((CoxPHMojoModel)this._model)._cats = (Integer)this.readkv("cats");
        ((CoxPHMojoModel)this._model)._useAllFactorLevels = (Boolean)this.readkv("use_all_factor_levels");
        ((CoxPHMojoModel)this._model)._lpBase = ((CoxPHMojoModel)this._model).computeLpBase();
    }

    private HashMap<CoxPHMojoModel.Strata, Integer> readStrata() {
        int count2 = (Integer)this.readkv("strata_count");
        HashMap<CoxPHMojoModel.Strata, Integer> result = new HashMap<CoxPHMojoModel.Strata, Integer>(count2);
        for (int i2 = 0; i2 < count2; ++i2) {
            double[] strata = (double[])this.readkv("strata_" + i2);
            result.put(new CoxPHMojoModel.Strata(strata, strata.length), i2);
        }
        return result;
    }

    private int readStrataLen() {
        int count2 = (Integer)this.readkv("strata_count");
        if (0 == count2) {
            return 0;
        }
        double[] strata = (double[])this.readkv("strata_0");
        return strata.length;
    }

    @Override
    protected CoxPHMojoModel makeModel(String[] columns, String[][] domains, String responseColumn) {
        return new CoxPHMojoModel(columns, domains, responseColumn);
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }
}

