/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.genmodel.tools.PrintMojo;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SharedTreeGraph {
    public final ArrayList<SharedTreeSubgraph> subgraphArray = new ArrayList();

    public SharedTreeSubgraph makeSubgraph(String name) {
        SharedTreeSubgraph sg = new SharedTreeSubgraph(this.subgraphArray.size(), name);
        this.subgraphArray.add(sg);
        return sg;
    }

    public void print() {
        System.out.println("------------------------------------------------------------");
        System.out.println("Graph");
        for (SharedTreeSubgraph sg : this.subgraphArray) {
            sg.print();
        }
    }

    public SharedTreeNode walkNodes(int subgraphId, String path) {
        return this.subgraphArray.get(subgraphId).walkNodes(path);
    }

    public void printDot(PrintStream os2, int maxLevelsToPrintPerEdge, boolean detail, String optionalTitle, PrintMojo.PrintTreeOptions treeOptions) {
        os2.println("/*");
        os2.println("Generated by:");
        os2.println("    http://https://github.com/h2oai/h2o-3/tree/master/h2o-genmodel/src/main/java/hex/genmodel/tools/PrintMojo.java");
        os2.println("*/");
        os2.println("");
        os2.println("/*");
        os2.println("On a mac:");
        os2.println("");
        os2.println("$ brew install graphviz");
        os2.println("$ dot -Tpng file.gv -o file.png");
        os2.println("$ open file.png");
        os2.println("*/");
        os2.println("");
        os2.println("digraph G {");
        for (SharedTreeSubgraph sg : this.subgraphArray) {
            sg.printDot(os2, maxLevelsToPrintPerEdge, detail, optionalTitle, treeOptions);
        }
        os2.println("");
        os2.println("}");
        os2.println("");
    }

    public List<Map<String, Object>> toJson() {
        ArrayList<Map<String, Object>> trees = new ArrayList<Map<String, Object>>();
        for (SharedTreeSubgraph sg : this.subgraphArray) {
            trees.add(sg.toJson());
        }
        return trees;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SharedTreeGraph that = (SharedTreeGraph)o2;
        return Objects.equals(this.subgraphArray, that.subgraphArray);
    }

    public int hashCode() {
        return Objects.hash(this.subgraphArray);
    }
}

