/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.genmodel.easy.CategoricalEncoder;
import java.util.HashMap;
import java.util.Map;

public class EnumLimitedEncoder
implements CategoricalEncoder {
    private final String columnName;
    private final int targetIndex;
    private final Map<String, Integer> domainMap = new HashMap<String, Integer>();

    EnumLimitedEncoder(String columnName, int targetIndex, String[] domainValues, String[] newDomainValues) {
        this.columnName = columnName;
        this.targetIndex = targetIndex;
        for (int j2 = 0; j2 < newDomainValues.length; ++j2) {
            this.domainMap.put(newDomainValues[j2], j2);
        }
        if (this.domainMap.containsKey("other")) {
            Integer otherIndex = this.domainMap.get("other");
            for (int j3 = 0; j3 < domainValues.length; ++j3) {
                if (this.domainMap.containsKey(domainValues[j3])) continue;
                this.domainMap.put(domainValues[j3], otherIndex);
            }
            this.domainMap.remove("other");
        }
    }

    @Override
    public boolean encodeCatValue(String levelName, double[] rawData) {
        Integer levelIndex = this.domainMap.get(levelName);
        if (levelIndex == null) {
            levelIndex = this.domainMap.get(this.columnName + ".top_" + levelName + "_levels");
        }
        if (levelIndex == null) {
            return false;
        }
        rawData[this.targetIndex] = levelIndex.intValue();
        return true;
    }

    @Override
    public void encodeNA(double[] rawData) {
        rawData[this.targetIndex] = Double.NaN;
    }

    public String toString() {
        return "EnumLimited{columnName='" + this.columnName + '\'' + ", targetIndex=" + this.targetIndex + ", domainMap=" + this.domainMap + '}';
    }
}

