/*
 * Decompiled with CFR 0.152.
 */
package hex.gram;

import hex.DataInfo;
import hex.FrameTask2;
import java.util.ArrayList;
import java.util.Arrays;
import jsr166y.ForkJoinTask;
import jsr166y.RecursiveAction;
import water.Futures;
import water.H2O;
import water.H2ORuntime;
import water.Iced;
import water.Job;
import water.Key;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.util.ArrayUtils;

public final class Gram
extends Iced<Gram> {
    boolean _hasIntercept;
    public double[][] _xx;
    public double[] _diag;
    public double[][] _frame2DProduce;
    public int _diagN;
    final int _denseN;
    int _fullN;
    static final int MIN_TSKSZ = 10000;
    public transient XXCache _xxCache;
    public double _diagAdded;
    private static double r2_eps = 1.0E-7;
    private static final int MIN_PAR = 1000;
    private double[][] XX = null;

    public Gram(DataInfo dinfo) {
        this(dinfo.fullN(), dinfo.largestCat(), dinfo.numNums(), dinfo._cats, true);
    }

    public Gram(int N2, int diag, int dense, int sparse, boolean hasIntercept) {
        this._hasIntercept = hasIntercept;
        this._fullN = N2 + (this._hasIntercept ? 1 : 0);
        this._xx = new double[this._fullN - diag][];
        this._diagN = diag;
        this._diag = MemoryManager.malloc8d(this._diagN);
        this._denseN = dense;
        for (int i2 = 0; i2 < this._fullN - this._diagN; ++i2) {
            this._xx[i2] = MemoryManager.malloc8d(diag + i2 + 1);
        }
    }

    public Gram(double[][] xxCacheNew) {
        this._xx = xxCacheNew;
        this._xxCache = new XXCache(xxCacheNew, false, false);
        this._denseN = xxCacheNew.length;
        this._fullN = xxCacheNew.length;
    }

    public void dropIntercept() {
        if (!this._hasIntercept) {
            throw new IllegalArgumentException("Has no intercept");
        }
        double[][] xx = new double[this._xx.length - 1][];
        for (int i2 = 0; i2 < xx.length; ++i2) {
            xx[i2] = this._xx[i2];
        }
        this._xx = xx;
        this._hasIntercept = false;
        --this._fullN;
    }

    public Gram deep_clone() {
        Gram res = (Gram)this.clone();
        if (this._xx != null) {
            res._xx = ArrayUtils.deepClone(this._xx);
        }
        if (this._diag != null) {
            res._diag = (double[])res._diag.clone();
        }
        return res;
    }

    public final int fullN() {
        return this._fullN;
    }

    public void addDiag(double[] ds) {
        int i2;
        for (i2 = 0; i2 < Math.min(this._diagN, ds.length); ++i2) {
            int n2 = i2;
            this._diag[n2] = this._diag[n2] + ds[i2];
        }
        while (i2 < ds.length) {
            double[] dArray = this._xx[i2 - this._diagN];
            int n3 = i2;
            dArray[n3] = dArray[n3] + ds[i2];
            ++i2;
        }
    }

    public void addGAMPenalty(Integer[] activeColumns, double[][][] ds, int[][] gamIndices) {
        int numGamCols = gamIndices.length;
        for (int gamInd = 0; gamInd < numGamCols; ++gamInd) {
            int numKnots = gamIndices[gamInd].length;
            for (int betaInd = 0; betaInd < numKnots; ++betaInd) {
                Integer betaIndex = gamIndices[gamInd][betaInd];
                if (activeColumns != null && (betaIndex = Integer.valueOf(Arrays.binarySearch((Object[])activeColumns, betaIndex))) < 0) continue;
                for (int betaIndj = 0; betaIndj <= betaInd; ++betaIndj) {
                    Integer betaIndexJ = gamIndices[gamInd][betaIndj];
                    if (activeColumns != null && (betaIndexJ = Integer.valueOf(Arrays.binarySearch((Object[])activeColumns, betaIndexJ))) < 0) continue;
                    int rowLen = this._xx[betaIndex - this._diagN].length;
                    if (betaIndexJ >= rowLen) continue;
                    double[] dArray = this._xx[betaIndex - this._diagN];
                    int n2 = betaIndexJ;
                    dArray[n2] = dArray[n2] + 2.0 * ds[gamInd][betaInd][betaIndj];
                }
            }
        }
    }

    public double get(int i2, int j2) {
        if (j2 > i2) {
            int k2 = i2;
            i2 = j2;
            j2 = k2;
        }
        if (i2 < this._diagN) {
            return j2 == i2 ? this._diag[i2] : 0.0;
        }
        return this._xx[i2 - this._diagN][j2];
    }

    public void addDiag(double d2) {
        this.addDiag(d2, false);
    }

    public void addDiag(double d2, boolean add2Intercept) {
        this._diagAdded += d2;
        int i2 = 0;
        while (i2 < this._diag.length) {
            int n2 = i2++;
            this._diag[n2] = this._diag[n2] + d2;
        }
        int ii = !this._hasIntercept || add2Intercept ? 0 : 1;
        for (int i3 = 0; i3 < this._xx.length - ii; ++i3) {
            double[] dArray = this._xx[i3];
            int n3 = this._xx[i3].length - 1;
            dArray[n3] = dArray[n3] + d2;
        }
    }

    public double sparseness() {
        double[][] xx = this.getXX();
        double nzs = 0.0;
        for (int i2 = 0; i2 < xx.length; ++i2) {
            for (int j2 = 0; j2 < xx[i2].length; ++j2) {
                if (xx[i2][j2] == 0.0) continue;
                nzs += 1.0;
            }
        }
        return nzs / (double)(xx.length * xx.length);
    }

    public double diagSum() {
        double res = 0.0;
        if (this._diag != null) {
            for (double d2 : this._diag) {
                res += d2;
            }
        }
        if (this._xx != null) {
            for (double[] x2 : this._xx) {
                res += x2[x2.length - 1];
            }
        }
        return res;
    }

    private final void updateZij(int i2, int j2, double[][] Z, double[] gamma) {
        double[] Zi = Z[i2];
        double Zij = Zi[j2];
        for (int k2 = 0; k2 < j2; ++k2) {
            Zij -= gamma[k2] * Zi[k2];
        }
        Zi[j2] = Zij;
    }

    private final void updateZ(double[] gamma, double[][] Z, int j2) {
        for (int i2 = j2 + 1; i2 < Z.length; ++i2) {
            this.updateZij(i2, j2, Z, gamma);
        }
    }

    public Cholesky qrCholesky(ArrayList<Integer> dropped_cols, boolean standardized) {
        int i2;
        final double[][] Z = this.getXX(true, true);
        double[][] R = new double[Z.length][];
        double[] Zdiag = new double[Z.length];
        double[] ZdiagInv = new double[Z.length];
        for (i2 = 0; i2 < Z.length; ++i2) {
            Zdiag[i2] = Z[i2][i2];
            ZdiagInv[i2] = 1.0 / Zdiag[i2];
        }
        for (int j2 = 0; j2 < Z.length; ++j2) {
            double rs_tot;
            R[j2] = new double[j2 + 1];
            final double[] gamma = R[j2];
            for (int l2 = 0; l2 <= j2; ++l2) {
                gamma[l2] = Z[j2][l2] * ZdiagInv[l2];
            }
            double zjj = Z[j2][j2];
            for (int k2 = 0; k2 < j2; ++k2) {
                zjj += gamma[k2] * (gamma[k2] * Z[k2][k2] - 2.0 * Z[j2][k2]);
            }
            double d2 = rs_tot = standardized ? ZdiagInv[j2] : 1.0 / (Zdiag[j2] - Z[j2][0] * ZdiagInv[0] * Z[j2][0]);
            if (j2 > 0 && zjj * rs_tot < r2_eps) {
                zjj = 0.0;
                dropped_cols.add(j2 - 1);
                ZdiagInv[j2] = 0.0;
            } else {
                ZdiagInv[j2] = 1.0 / zjj;
            }
            Z[j2][j2] = zjj;
            int jchunk = Math.max(1, 1000 / (Z.length - j2));
            int nchunks = (Z.length - j2 - 1) / jchunk;
            nchunks = Math.min(nchunks, H2O.NUMCPUS);
            if (nchunks <= 1) {
                this.updateZ(gamma, Z, j2);
                continue;
            }
            final int fjchunk = (Z.length - 1 - j2) / nchunks;
            int rem = Z.length - 1 - j2 - fjchunk * nchunks;
            for (int i3 = Z.length - rem; i3 < Z.length; ++i3) {
                this.updateZij(i3, j2, Z, gamma);
            }
            RecursiveAction[] ras = new RecursiveAction[nchunks];
            final int fj = j2;
            int k3 = 0;
            for (int i4 = j2 + 1; i4 < Z.length - rem; i4 += fjchunk) {
                final int fi = i4;
                ras[k3++] = new RecursiveAction(){

                    @Override
                    protected final void compute() {
                        int max_i = Math.min(fi + fjchunk, Z.length);
                        for (int i2 = fi; i2 < max_i; ++i2) {
                            Gram.this.updateZij(i2, fj, Z, gamma);
                        }
                    }
                };
            }
            ForkJoinTask.invokeAll(ras);
        }
        if (R.length < 500) {
            for (i2 = 0; i2 < R.length; ++i2) {
                for (int j3 = 0; j3 <= i2; ++j3) {
                    double[] dArray = R[i2];
                    int n2 = j3;
                    dArray[n2] = dArray[n2] * Math.sqrt(Z[j3][j3]);
                }
            }
        } else {
            RecursiveAction[] ras = new RecursiveAction[R.length];
            for (int i5 = 0; i5 < ras.length; ++i5) {
                final int fi = i5;
                final double[] Rrow = R[i5];
                ras[i5] = new RecursiveAction(){

                    @Override
                    protected void compute() {
                        for (int j2 = 0; j2 <= fi; ++j2) {
                            int n2 = j2;
                            Rrow[n2] = Rrow[n2] * Math.sqrt(Z[j2][j2]);
                        }
                    }
                };
            }
            ForkJoinTask.invokeAll(ras);
        }
        if (dropped_cols.isEmpty()) {
            return new Cholesky(R, new double[0], true);
        }
        double[][] Rnew = new double[R.length - dropped_cols.size()][];
        for (int i6 = 0; i6 < Rnew.length; ++i6) {
            Rnew[i6] = new double[i6 + 1];
        }
        int j4 = 0;
        for (int i7 = 0; i7 < R.length; ++i7) {
            if (Z[i7][i7] == 0.0) continue;
            int k4 = 0;
            for (int l3 = 0; l3 <= i7; ++l3) {
                if (k4 < dropped_cols.size() && l3 == dropped_cols.get(k4) + 1) {
                    ++k4;
                    continue;
                }
                Rnew[j4][l3 - k4] = R[i7][l3];
            }
            ++j4;
        }
        return new Cholesky(Rnew, new double[0], true);
    }

    public void dropCols(int[] cols) {
        int i2;
        int diagCols = 0;
        for (int i3 = 0; i3 < cols.length && cols[i3] < this._diagN; ++i3) {
            ++diagCols;
        }
        int j2 = 0;
        if (diagCols > 0) {
            double[] diag = MemoryManager.malloc8d(this._diagN - diagCols);
            int k2 = 0;
            for (i2 = 0; i2 < this._diagN; ++i2) {
                if (j2 < cols.length && cols[j2] == i2) {
                    ++j2;
                    continue;
                }
                diag[k2++] = this._diag[i2];
            }
            this._diag = diag;
        }
        double[][] xxNew = new double[this._xx.length - cols.length + diagCols][];
        int iNew = 0;
        for (i2 = 0; i2 < this._xx.length; ++i2) {
            if (j2 < cols.length && this._diagN + i2 == cols[j2]) {
                ++j2;
                continue;
            }
            if (j2 == 0) {
                xxNew[iNew++] = this._xx[i2];
                continue;
            }
            int l2 = 0;
            int m4 = 0;
            double[] x2 = MemoryManager.malloc8d(this._xx[i2].length - j2);
            for (int k3 = 0; k3 < this._xx[i2].length; ++k3) {
                if (l2 < cols.length && k3 == cols[l2]) {
                    ++l2;
                    continue;
                }
                x2[m4++] = this._xx[i2][k3];
            }
            xxNew[iNew++] = x2;
        }
        this._xx = xxNew;
        this._diagN = this._diag.length;
        this._fullN = this._xx[this._xx.length - 1].length;
    }

    public int[] findZeroCols() {
        int i2;
        ArrayList<Integer> zeros = new ArrayList<Integer>();
        if (this._diag != null) {
            for (i2 = 0; i2 < this._diag.length; ++i2) {
                if (this._diag[i2] != 0.0) continue;
                zeros.add(i2);
            }
        }
        for (i2 = 0; i2 < this._xx.length; ++i2) {
            if (this._xx[i2][this._xx[i2].length - 1] != 0.0) continue;
            zeros.add(this._xx[i2].length - 1);
        }
        if (zeros.size() == 0) {
            return new int[0];
        }
        int[] ary = new int[zeros.size()];
        for (int i3 = 0; i3 < zeros.size(); ++i3) {
            ary[i3] = (Integer)zeros.get(i3);
        }
        return ary;
    }

    public String toString() {
        if (this._fullN >= 1000) {
            return "Gram(" + this._fullN + ")";
        }
        return ArrayUtils.pprint(this.getXX(true, false));
    }

    public Cholesky cholesky(Cholesky chol) {
        return this.cholesky(chol, true, "");
    }

    public Cholesky cholesky(Cholesky chol, boolean parallelize, String id) {
        int fi;
        int i2;
        long start = System.currentTimeMillis();
        if (chol == null) {
            double[][] xx = (double[][])this._xx.clone();
            for (int i3 = 0; i3 < xx.length; ++i3) {
                xx[i3] = (double[])xx[i3].clone();
            }
            chol = new Cholesky(xx, (double[])this._diag.clone());
        }
        final Cholesky fchol = chol;
        final int sparseN = this._diag.length;
        int denseN = this._fullN - sparseN;
        if (this._diag != null) {
            for (int i4 = 0; i4 < sparseN; ++i4) {
                chol._diag[i4] = Math.sqrt(this._diag[i4]);
                double d2 = 1.0 / chol._diag[i4];
                for (int j2 = 0; j2 < denseN; ++j2) {
                    chol._xx[j2][i4] = d2 * this._xx[j2][i4];
                }
            }
        }
        ForkJoinTask[] fjts = new ForkJoinTask[denseN];
        final int[][] nz = new int[denseN][];
        for (i2 = 0; i2 < denseN; ++i2) {
            fi = i2;
            fjts[i2] = new RecursiveAction(){

                @Override
                protected void compute() {
                    int[] tmp = new int[sparseN];
                    double[] rowi = fchol._xx[fi];
                    int n2 = 0;
                    for (int k2 = 0; k2 < sparseN; ++k2) {
                        if (rowi[k2] == 0.0) continue;
                        tmp[n2++] = k2;
                    }
                    nz[fi] = Arrays.copyOf(tmp, n2);
                }
            };
        }
        ForkJoinTask.invokeAll(fjts);
        for (i2 = 0; i2 < denseN; ++i2) {
            fi = i2;
            fjts[i2] = new RecursiveAction(){

                @Override
                protected void compute() {
                    double[] rowi = fchol._xx[fi];
                    int[] nzi = nz[fi];
                    for (int j2 = 0; j2 <= fi; ++j2) {
                        double[] rowj = fchol._xx[j2];
                        int[] nzj = nz[j2];
                        double s2 = 0.0;
                        int t2 = 0;
                        int z2 = 0;
                        while (t2 < nzi.length && z2 < nzj.length) {
                            int k1 = nzi[t2];
                            int k2 = nzj[z2];
                            if (k1 < k2) {
                                ++t2;
                                continue;
                            }
                            if (k1 > k2) {
                                ++z2;
                                continue;
                            }
                            s2 += rowi[k1] * rowj[k1];
                            ++t2;
                            ++z2;
                        }
                        rowi[j2 + sparseN] = Gram.this._xx[fi][j2 + sparseN] - s2;
                    }
                }
            };
        }
        ForkJoinTask.invokeAll(fjts);
        Object arr = new double[denseN][];
        for (int i5 = 0; i5 < ((double[][])arr).length; ++i5) {
            arr[i5] = Arrays.copyOfRange(fchol._xx[i5], sparseN, sparseN + denseN);
        }
        int p2 = H2ORuntime.availableProcessors();
        InPlaceCholesky d3 = InPlaceCholesky.decompose_2(arr, 10, p2);
        fchol.setSPD(d3.isSPD());
        arr = d3.getL();
        for (int i6 = 0; i6 < ((double[][])arr).length; ++i6) {
            for (int j3 = 0; j3 < i6 + 1; ++j3) {
                fchol._xx[i6][sparseN + j3] = arr[i6][j3];
            }
        }
        return chol;
    }

    public double[][] getXX() {
        return this.getXX(false, false);
    }

    public double[][] getXX(boolean lowerDiag, boolean icptFist) {
        if (this._xxCache != null && this._xxCache.match(lowerDiag, icptFist)) {
            return this._xxCache.xx;
        }
        int N2 = this._fullN;
        double[][] xx = new double[N2][];
        for (int i2 = 0; i2 < N2; ++i2) {
            xx[i2] = MemoryManager.malloc8d(lowerDiag ? i2 + 1 : N2);
        }
        return this.getXX(xx, lowerDiag, icptFist);
    }

    public double[][] getXX(double[][] xalloc) {
        return this.getXX(xalloc, false, false);
    }

    public double[][] getXX(double[][] xalloc, boolean lowerDiag, boolean icptFist) {
        int i2;
        int N2 = this._fullN;
        double[][] xx = xalloc;
        int off = 0;
        if (this._hasIntercept && icptFist) {
            double[] icptRow = this._xx[this._xx.length - 1];
            xx[0][0] = icptRow[icptRow.length - 1];
            for (int i3 = 0; i3 < icptRow.length - 1; ++i3) {
                xx[i3 + 1][0] = icptRow[i3];
            }
            off = 1;
        }
        for (i2 = 0; i2 < this._diag.length; ++i2) {
            xx[i2 + off][i2 + off] = this._diag[i2];
            if (lowerDiag) continue;
            int col = i2 + off;
            double[] xrow = xx[i2 + off];
            for (int j2 = off; j2 < this._xx.length; ++j2) {
                xrow[j2 + this._diagN] = this._xx[j2][col];
            }
        }
        for (i2 = 0; i2 < this._xx.length - off; ++i2) {
            double[] xrow = xx[i2 + this._diag.length + off];
            double[] xrowOld = this._xx[i2];
            System.arraycopy(xrowOld, 0, xrow, off, xrowOld.length);
            if (lowerDiag) continue;
            int col = xrowOld.length - 1;
            int row = i2 + 1;
            for (int j3 = col + 1; j3 < xrow.length; ++j3) {
                xrow[j3] = this._xx[row++][col];
            }
        }
        this._xxCache = new XXCache(xx, lowerDiag, icptFist);
        return xx;
    }

    public void add(Gram grm) {
        ArrayUtils.add(this._xx, grm._xx);
        ArrayUtils.add(this._diag, grm._diag);
    }

    public final boolean hasNaNsOrInfs() {
        for (int i2 = 0; i2 < this._xx.length; ++i2) {
            for (int j2 = 0; j2 < this._xx[i2].length; ++j2) {
                if (!Double.isInfinite(this._xx[i2][j2]) && !Double.isNaN(this._xx[i2][j2])) continue;
                return true;
            }
        }
        for (double d2 : this._diag) {
            if (!Double.isInfinite(d2) && !Double.isNaN(d2)) continue;
            return true;
        }
        return false;
    }

    public final void addRowSparse(DataInfo.Row r2, double w2) {
        int i2;
        double[] mrow;
        int intercept = this._hasIntercept ? 1 : 0;
        int denseRowStart = this._fullN - this._denseN - this._diagN - intercept;
        assert (this._denseN + denseRowStart == this._xx.length - intercept);
        double[] interceptRow = this._hasIntercept ? this._xx[this._xx.length - 1] : null;
        for (int i3 = 0; i3 < r2.nNums; ++i3) {
            int j2;
            int cid = r2.numIds[i3];
            mrow = this._xx[cid - this._diagN];
            double d2 = w2 * r2.numVals[i3];
            for (j2 = 0; j2 <= i3; ++j2) {
                int n2 = r2.numIds[j2];
                mrow[n2] = mrow[n2] + d2 * r2.numVals[j2];
            }
            if (this._hasIntercept) {
                int n3 = cid;
                interceptRow[n3] = interceptRow[n3] + d2;
            }
            for (j2 = 0; j2 < r2.nBins; ++j2) {
                int n4 = r2.binIds[j2];
                mrow[n4] = mrow[n4] + d2;
            }
        }
        if (this._hasIntercept) {
            int n5 = interceptRow.length - 1;
            interceptRow[n5] = interceptRow[n5] + w2;
            for (int j3 = 0; j3 < r2.nBins; ++j3) {
                int n6 = r2.binIds[j3];
                interceptRow[n6] = interceptRow[n6] + w2;
            }
        }
        boolean hasDiag = this._diagN > 0 && r2.nBins > 0 && r2.binIds[0] < this._diagN;
        int n7 = i2 = hasDiag ? 1 : 0;
        while (i2 < r2.nBins) {
            mrow = this._xx[r2.binIds[i2] - this._diagN];
            for (int j4 = 0; j4 <= i2; ++j4) {
                int n8 = r2.binIds[j4];
                mrow[n8] = mrow[n8] + w2;
            }
            ++i2;
        }
        if (hasDiag && r2.nBins > 0) {
            int n9 = r2.binIds[0];
            this._diag[n9] = this._diag[n9] + w2;
        }
    }

    public final void addRow(DataInfo.Row row, double w2) {
        if (row.numIds == null) {
            this.addRowDense(row, w2);
        } else {
            this.addRowSparse(row, w2);
        }
    }

    public final void addRowDense(DataInfo.Row row, double w2) {
        int i2;
        int intercept = this._hasIntercept ? 1 : 0;
        int denseRowStart = this._fullN - this._denseN - this._diagN - intercept;
        int denseColStart = this._fullN - this._denseN - intercept;
        assert (this._denseN + denseRowStart == this._xx.length - intercept);
        double[] interceptRow = this._hasIntercept ? this._xx[this._denseN + denseRowStart] : null;
        for (int i3 = 0; i3 < this._denseN; ++i3) {
            int j2;
            if (row.numVals[i3] == 0.0) continue;
            double[] mrow = this._xx[i3 + denseRowStart];
            double d2 = w2 * row.numVals[i3];
            for (j2 = 0; j2 <= i3; ++j2) {
                if (row.numVals[j2] == 0.0) continue;
                int n2 = j2 + denseColStart;
                mrow[n2] = mrow[n2] + d2 * row.numVals[j2];
            }
            if (this._hasIntercept) {
                int n3 = i3 + denseColStart;
                interceptRow[n3] = interceptRow[n3] + d2;
            }
            for (j2 = 0; j2 < row.nBins; ++j2) {
                int n4 = row.binIds[j2];
                mrow[n4] = mrow[n4] + d2;
            }
        }
        if (this._hasIntercept) {
            int n5 = this._denseN + denseColStart;
            interceptRow[n5] = interceptRow[n5] + w2;
            for (int j3 = 0; j3 < row.nBins; ++j3) {
                int n6 = row.binIds[j3];
                interceptRow[n6] = interceptRow[n6] + w2;
            }
        }
        boolean hasDiag = this._diagN > 0 && row.nBins > 0 && row.binIds[0] < this._diagN;
        int n7 = i2 = hasDiag ? 1 : 0;
        while (i2 < row.nBins) {
            double[] mrow = this._xx[row.binIds[i2] - this._diagN];
            for (int j4 = 0; j4 <= i2; ++j4) {
                int n8 = row.binIds[j4];
                mrow[n8] = mrow[n8] + w2;
            }
            ++i2;
        }
        if (hasDiag) {
            int n9 = row.binIds[0];
            this._diag[n9] = this._diag[n9] + w2;
        }
    }

    public void mul(double x2) {
        int i2;
        if (this._diag != null) {
            i2 = 0;
            while (i2 < this._diag.length) {
                int n2 = i2++;
                this._diag[n2] = this._diag[n2] * x2;
            }
        }
        for (i2 = 0; i2 < this._xx.length; ++i2) {
            int j2 = 0;
            while (j2 < this._xx[i2].length) {
                double[] dArray = this._xx[i2];
                int n3 = j2++;
                dArray[n3] = dArray[n3] * x2;
            }
        }
    }

    public double[] mul(double[] x2) {
        double[] res = MemoryManager.malloc8d(x2.length);
        this.mul(x2, res);
        return res;
    }

    public void mul(double[] x2, double[] res) {
        int colSize = this.fullN();
        int offsetForCat = colSize - this._xx.length;
        for (int rowIndex = 0; rowIndex < colSize; ++rowIndex) {
            int colIndex;
            double d2 = 0.0;
            if (rowIndex >= offsetForCat) {
                for (colIndex = 0; colIndex < rowIndex; ++colIndex) {
                    d2 += this._xx[rowIndex - offsetForCat][colIndex] * x2[colIndex];
                }
            }
            d2 += rowIndex >= offsetForCat ? this._xx[rowIndex - offsetForCat][rowIndex] * x2[rowIndex] : this._diag[rowIndex] * x2[rowIndex];
            for (colIndex = rowIndex + 1; colIndex < colSize; ++colIndex) {
                if (rowIndex < offsetForCat) {
                    if (colIndex < offsetForCat) continue;
                    d2 += this._xx[colIndex - offsetForCat][rowIndex] * x2[colIndex];
                    continue;
                }
                d2 += this._xx[colIndex - offsetForCat][rowIndex] * x2[colIndex];
            }
            res[rowIndex] = d2;
        }
    }

    public static class CollinearColumnsException
    extends RuntimeException {
        public CollinearColumnsException() {
        }

        public CollinearColumnsException(String msg) {
            super(msg);
        }
    }

    public static class NonSPDMatrixException
    extends RuntimeException {
        public NonSPDMatrixException() {
        }

        public NonSPDMatrixException(String msg) {
            super(msg);
        }
    }

    public static class GramTask
    extends FrameTask2<GramTask> {
        private boolean _std = true;
        public Gram _gram;
        public long _nobs;
        boolean _intercept = false;
        double _prev = 0.0;

        public GramTask(Key<Job> jobKey, DataInfo dinfo) {
            super(null, dinfo, jobKey);
        }

        public GramTask(Key<Job> jobKey, DataInfo dinfo, boolean std, boolean intercept) {
            super(null, dinfo, jobKey);
            this._std = std;
            this._intercept = intercept;
        }

        @Override
        public void chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo.numNums(), this._dinfo._cats, this._intercept);
        }

        @Override
        protected void processRow(DataInfo.Row r2) {
            this._gram.addRow(r2, r2.weight);
            ++this._nobs;
            double current = this._gram.get(this._dinfo.fullN() - 1, this._dinfo.fullN() - 1) - this._prev;
            this._prev += current;
        }

        @Override
        public void chunkDone() {
            if (this._std && this._nobs > 0L) {
                double r2 = 1.0 / (double)this._nobs;
                this._gram.mul(r2);
            }
        }

        @Override
        public void reduce(GramTask gt) {
            if (this._std && this._nobs > 0L && gt._nobs > 0L) {
                double r1 = (double)this._nobs / (double)(this._nobs + gt._nobs);
                this._gram.mul(r1);
                double r2 = (double)gt._nobs / (double)(this._nobs + gt._nobs);
                gt._gram.mul(r2);
            }
            this._gram.add(gt._gram);
            this._nobs += gt._nobs;
        }
    }

    public static class OuterGramTask
    extends MRTask<OuterGramTask> {
        public Gram _gram;
        public long _nobs;
        boolean _intercept = false;
        int[] _catOffsets;
        double _scale;
        final Key<Job> _jobKey;
        protected final DataInfo _dinfo;

        public OuterGramTask(Key<Job> jobKey, DataInfo dinfo) {
            this._dinfo = dinfo;
            this._jobKey = jobKey;
            this._catOffsets = dinfo._catOffsets != null ? Arrays.copyOf(dinfo._catOffsets, dinfo._catOffsets.length) : null;
            this._scale = dinfo._adaptedFrame.numRows() > 0L ? 1.0 / (double)dinfo._adaptedFrame.numRows() : 0.0;
        }

        @Override
        public void map(Chunk[] chks) {
            this.chunkInit();
            DataInfo.Row rowi = this._dinfo.newDenseRow();
            DataInfo.Row rowj = this._dinfo.newDenseRow();
            Chunk[] chks2 = new Chunk[chks.length];
            this.innerProductChunk(rowi, rowj, chks, chks);
            for (int chkIndex = 0; chkIndex < chks[0].cidx(); ++chkIndex) {
                for (int colIndex = 0; colIndex < chks2.length; ++colIndex) {
                    chks2[colIndex] = this._fr.vec(colIndex).chunkForChunkIdx(chkIndex);
                }
                this.innerProductChunk(rowi, rowj, chks, chks2);
            }
            this.chunkDone();
        }

        public void innerProductChunk(DataInfo.Row rowi, DataInfo.Row rowj, Chunk[] localChunk, Chunk[] alterChunk) {
            int rowOffsetLocal = (int)localChunk[0].start();
            int rowOffsetAlter = (int)alterChunk[0].start();
            int localChkRows = localChunk[0]._len;
            int alterChkRows = alterChunk[0]._len;
            for (int rowL = 0; rowL < localChkRows; ++rowL) {
                int rowJOffset;
                this._dinfo.extractDenseRow(localChunk, rowL, rowi);
                if (rowi.isBad()) continue;
                ++this._nobs;
                int rowIOffset = rowL + rowOffsetLocal;
                for (int j2 = 0; j2 < alterChkRows && (rowJOffset = j2 + rowOffsetAlter) <= rowIOffset; ++j2) {
                    this._dinfo.extractDenseRow(alterChunk, j2, rowj);
                    if (rowi.isBad() || rowi.weight == 0.0 || rowj.isBad() || rowj.weight == 0.0) continue;
                    this._gram._xx[rowIOffset][rowJOffset] = rowi.dotSame(rowj);
                }
            }
        }

        public void chunkInit() {
            this._gram = new Gram((int)this._dinfo._adaptedFrame.numRows(), 0, this._dinfo.numNums(), this._dinfo._cats, this._intercept);
        }

        public void chunkDone() {
            this._gram.mul(this._scale);
        }

        @Override
        public void reduce(OuterGramTask gt) {
            this._gram.add(gt._gram);
            this._nobs += gt._nobs;
        }
    }

    public static final class Cholesky {
        public final double[][] _xx;
        protected final double[] _diag;
        private boolean _isSPD;
        private boolean _icptFirst;

        public Cholesky(double[][] xx, double[] diag) {
            this._xx = xx;
            this._diag = diag;
            this._icptFirst = false;
        }

        public Cholesky(double[][] xx, double[] diag, boolean icptFirst) {
            this._xx = xx;
            this._diag = diag;
            this._icptFirst = icptFirst;
            this._isSPD = true;
        }

        public void solve(final double[][] ys) {
            RecursiveAction[] ras = new RecursiveAction[ys.length];
            for (int i2 = 0; i2 < ras.length; ++i2) {
                final int fi = i2;
                ras[i2] = new RecursiveAction(){

                    @Override
                    protected void compute() {
                        ys[fi][fi] = 1.0;
                        this.solve(ys[fi]);
                    }
                };
            }
            ForkJoinTask.invokeAll(ras);
        }

        public double[][] getInv() {
            double[][] res = new double[this._xx[this._xx.length - 1].length][this._xx[this._xx.length - 1].length];
            for (int i2 = 0; i2 < res.length; ++i2) {
                res[i2][i2] = 1.0;
            }
            this.solve(res);
            return res;
        }

        public double[] getInvDiag() {
            final double[] res = new double[this._xx.length + this._diag.length];
            RecursiveAction[] ras = new RecursiveAction[res.length];
            for (int i2 = 0; i2 < ras.length; ++i2) {
                final int fi = i2;
                ras[i2] = new RecursiveAction(){

                    @Override
                    protected void compute() {
                        double[] tmp = new double[res.length];
                        tmp[fi] = 1.0;
                        this.solve(tmp);
                        res[fi] = tmp[fi];
                    }
                };
            }
            ForkJoinTask.invokeAll(ras);
            return res;
        }

        public double[][] getL() {
            int i2;
            int N2 = this._xx.length + this._diag.length;
            double[][] xx = new double[N2][];
            for (i2 = 0; i2 < N2; ++i2) {
                xx[i2] = MemoryManager.malloc8d(N2);
            }
            for (i2 = 0; i2 < this._diag.length; ++i2) {
                xx[i2][i2] = this._diag[i2];
            }
            for (i2 = 0; i2 < this._xx.length; ++i2) {
                for (int j2 = 0; j2 < this._xx[i2].length; ++j2) {
                    xx[i2 + this._diag.length][j2] = this._xx[i2][j2];
                }
            }
            return xx;
        }

        public final void solve(double[] y2) {
            int k2;
            int i2;
            if (!this.isSPD()) {
                throw new NonSPDMatrixException();
            }
            if (this._icptFirst) {
                double icpt = y2[y2.length - 1];
                for (i2 = y2.length - 1; i2 > 0; --i2) {
                    y2[i2] = y2[i2 - 1];
                }
                y2[0] = icpt;
            }
            for (int k3 = 0; k3 < this._diag.length; ++k3) {
                int n2 = k3;
                y2[n2] = y2[n2] / this._diag[k3];
            }
            int n3 = this._xx.length == 0 ? 0 : this._xx[this._xx.length - 1].length;
            for (k2 = this._diag.length; k2 < n3; ++k2) {
                double d2 = 0.0;
                for (int i3 = 0; i3 < k2; ++i3) {
                    d2 += y2[i3] * this._xx[k2 - this._diag.length][i3];
                }
                y2[k2] = (y2[k2] - d2) / this._xx[k2 - this._diag.length][k2];
            }
            for (k2 = n3 - 1; k2 >= this._diag.length; --k2) {
                int n4 = k2;
                y2[n4] = y2[n4] / this._xx[k2 - this._diag.length][k2];
                for (i2 = 0; i2 < k2; ++i2) {
                    int n5 = i2;
                    y2[n5] = y2[n5] - y2[k2] * this._xx[k2 - this._diag.length][i2];
                }
            }
            for (k2 = this._diag.length - 1; k2 >= 0; --k2) {
                int n6 = k2;
                y2[n6] = y2[n6] / this._diag[k2];
            }
            if (this._icptFirst) {
                double icpt = y2[0];
                for (int i4 = 1; i4 < y2.length; ++i4) {
                    y2[i4 - 1] = y2[i4];
                }
                y2[y2.length - 1] = icpt;
            }
        }

        public final boolean isSPD() {
            return this._isSPD;
        }

        public final void setSPD(boolean b2) {
            this._isSPD = b2;
        }
    }

    public static class InPlaceCholesky {
        final double[][] _xx;
        private boolean _isSPD;

        private InPlaceCholesky(double[][] xx, boolean isspd) {
            this._xx = xx;
            this._isSPD = isspd;
        }

        public static InPlaceCholesky decompose_2(double[][] xx, int STEP, int P2) {
            boolean isspd = true;
            int N2 = xx.length;
            P2 = Math.max(1, P2);
            for (int j2 = 0; j2 < N2; j2 += STEP) {
                int p2;
                int i2;
                int tjR = Math.min(j2 + STEP, N2);
                for (i2 = j2; i2 < tjR; ++i2) {
                    double[] rowi = xx[i2];
                    double d2 = 0.0;
                    for (int k2 = j2; k2 < i2; ++k2) {
                        double[] rowk = xx[k2];
                        double s2 = 0.0;
                        for (int jj = 0; jj < k2; ++jj) {
                            s2 += rowk[jj] * rowi[jj];
                        }
                        rowi[k2] = s2 = (rowi[k2] - s2) / rowk[k2];
                        d2 += s2 * s2;
                    }
                    for (int jj = 0; jj < j2; ++jj) {
                        double s3 = rowi[jj];
                        d2 += s3 * s3;
                    }
                    d2 = rowi[i2] - d2;
                    isspd = isspd && d2 > 0.0;
                    rowi[i2] = Math.sqrt(Math.max(0.0, d2));
                }
                if (tjR == N2) break;
                i2 = tjR;
                Futures fs = new Futures();
                int rpb = 0;
                for (p2 = P2; tjR * (rpb = (N2 - tjR) / p2) < 10000 && p2 > 1; --p2) {
                }
                while (p2-- > 1) {
                    fs.add(new BlockTask(xx, i2, i2 + rpb, j2, tjR).fork());
                    i2 += rpb;
                }
                new BlockTask(xx, i2, N2, j2, tjR).compute();
                fs.blockForPending();
            }
            return new InPlaceCholesky(xx, isspd);
        }

        public double[][] getL() {
            return this._xx;
        }

        public boolean isSPD() {
            return this._isSPD;
        }

        private static class BlockTask
        extends RecursiveAction {
            final double[][] _xx;
            final int _i0;
            final int _i1;
            final int _j0;
            final int _j1;

            public BlockTask(double[][] xx, int ifr, int ito, int jfr, int jto) {
                this._xx = xx;
                this._i0 = ifr;
                this._i1 = ito;
                this._j0 = jfr;
                this._j1 = jto;
            }

            @Override
            public void compute() {
                for (int i2 = this._i0; i2 < this._i1; ++i2) {
                    double[] rowi = this._xx[i2];
                    for (int k2 = this._j0; k2 < this._j1; ++k2) {
                        double[] rowk = this._xx[k2];
                        double s2 = 0.0;
                        for (int jj = 0; jj < k2; ++jj) {
                            s2 += rowk[jj] * rowi[jj];
                        }
                        rowi[k2] = (rowi[k2] - s2) / rowk[k2];
                    }
                }
            }
        }
    }

    private static class XXCache {
        public final boolean lowerDiag;
        public final boolean icptFirst;
        public final double[][] xx;

        public XXCache(double[][] xx, boolean lowerDiag, boolean icptFirst) {
            this.xx = xx;
            this.lowerDiag = lowerDiag;
            this.icptFirst = icptFirst;
        }

        public boolean match(boolean lowerDiag, boolean icptFirst) {
            return this.lowerDiag == lowerDiag && this.icptFirst == icptFirst;
        }
    }
}

