/*
 * Decompiled with CFR 0.152.
 */
package hex.kmeans;

import water.MRTask;
import water.fvec.Chunk;
import water.util.ArrayUtils;

class AssignClusterTask
extends MRTask<AssignClusterTask> {
    private int _constraintsLength;
    private boolean _hasWeightsColumn;
    private int _weightIndex;
    private int _distanceIndexStart;
    private int _flowIndexStart;
    private int _oldAssignmentIndex;
    private int _newAssignmentIndex;
    private int _distanceAssignmentIndex;
    private int _dataStopIndex;
    int[] _numberOfPointsInCluster;

    AssignClusterTask(int constraintsLength, boolean hasWeightsColumn, int numCols) {
        this._constraintsLength = constraintsLength;
        this._hasWeightsColumn = hasWeightsColumn;
        this._distanceAssignmentIndex = numCols - 3 - constraintsLength;
        this._oldAssignmentIndex = numCols - 2 - constraintsLength;
        this._newAssignmentIndex = numCols - 1 - constraintsLength;
        this._weightIndex = this._dataStopIndex = numCols - (this._hasWeightsColumn ? 1 : 0) - 3 * this._constraintsLength - 3;
        this._distanceIndexStart = this._dataStopIndex + (this._hasWeightsColumn ? 1 : 0);
        this._flowIndexStart = numCols - constraintsLength;
    }

    public void assignCluster(Chunk[] cs, int row, int clusterIndex) {
        cs[this._oldAssignmentIndex].set(row, cs[this._newAssignmentIndex].at8(row));
        cs[this._newAssignmentIndex].set(row, clusterIndex);
        cs[this._distanceAssignmentIndex].set(row, cs[this._dataStopIndex + (this._hasWeightsColumn ? 1 : 0) + clusterIndex].atd(row));
        int n2 = clusterIndex;
        this._numberOfPointsInCluster[n2] = this._numberOfPointsInCluster[n2] + 1;
    }

    @Override
    public void map(Chunk[] cs) {
        this._numberOfPointsInCluster = new int[this._constraintsLength];
        for (int i2 = 0; i2 < cs[0].len(); ++i2) {
            if (this._hasWeightsColumn && cs[this._weightIndex].at8(i2) != 1L) continue;
            boolean assigned = false;
            for (int j2 = 0; j2 < this._constraintsLength; ++j2) {
                if (cs[this._flowIndexStart + j2].at8(i2) != 1L) continue;
                this.assignCluster(cs, i2, j2);
                assigned = true;
                break;
            }
            if (assigned) continue;
            double minDistance = cs[this._distanceIndexStart].atd(i2);
            int minIndex = 0;
            for (int j3 = 1; j3 < this._constraintsLength; ++j3) {
                double tmpDistance = cs[this._distanceIndexStart + j3].atd(i2);
                if (!(minDistance > tmpDistance)) continue;
                minDistance = tmpDistance;
                minIndex = j3;
            }
            this.assignCluster(cs, i2, minIndex);
        }
    }

    @Override
    public void reduce(AssignClusterTask mrt) {
        ArrayUtils.add(this._numberOfPointsInCluster, mrt._numberOfPointsInCluster);
    }
}

