/*
 * Decompiled with CFR 0.152.
 */
package hex.kmeans;

import hex.kmeans.AssignClusterTask;
import hex.kmeans.Edge;
import hex.kmeans.FindMinimalWeightTask;
import hex.kmeans.NodesEdgesObject;
import hex.kmeans.SpanningTree;
import water.fvec.Frame;
import water.fvec.Vec;

class KMeansSimplexSolver {
    public Frame _weights;
    public double _sumWeights;
    public boolean _hasWeightsColumn;
    public long _numberOfNonZeroWeightPoints;
    public int _constraintsLength;
    public long _numberOfPoints;
    public long _edgeSize;
    public long _nodeSize;
    public long _resultSize;
    public Vec.Reader _demandsReader;
    public Vec.Reader _capacitiesReader;
    public double _maxAbsDemand;
    public SpanningTree tree;

    public KMeansSimplexSolver(int[] constrains, Frame weights, double sumDistances, boolean hasWeights, long numberOfNonZeroWeightPoints) {
        this._numberOfPoints = weights.numRows();
        this._nodeSize = this._numberOfPoints + (long)constrains.length + 1L;
        this._edgeSize = this._numberOfPoints * (long)constrains.length + (long)constrains.length;
        this._constraintsLength = constrains.length;
        Vec demands = Vec.makeCon(0.0, this._nodeSize, (byte)3);
        Vec capacities = Vec.makeCon(0.0, this._edgeSize + this._nodeSize, (byte)3);
        this._resultSize = this._numberOfPoints * (long)this._constraintsLength;
        this._hasWeightsColumn = hasWeights;
        this._numberOfNonZeroWeightPoints = numberOfNonZeroWeightPoints;
        this._weights = weights;
        this._sumWeights = sumDistances;
        long constraintsSum = 0L;
        this._maxAbsDemand = Double.MIN_VALUE;
        Vec.Writer demandWriter = demands.open();
        for (long i2 = 0L; i2 < this._nodeSize; ++i2) {
            long tmpDemand;
            if (i2 < this._numberOfPoints) {
                demandWriter.set(i2, -1L);
                continue;
            }
            if (i2 < this._nodeSize - 1L) {
                tmpDemand = constrains[(int)(i2 - this._numberOfPoints)];
                constraintsSum += (long)constrains[(int)(i2 - this._numberOfPoints)];
            } else {
                tmpDemand = this._numberOfNonZeroWeightPoints - constraintsSum;
            }
            demandWriter.set(i2, tmpDemand);
            if (!((double)Math.abs(tmpDemand) > this._maxAbsDemand)) continue;
            this._maxAbsDemand = Math.abs(tmpDemand);
        }
        demandWriter.close();
        int edgeIndexStart = this._weights.numCols() - 3 - this._constraintsLength;
        long edgeIndex = 0L;
        for (long i3 = 0L; i3 < this._weights.numRows(); ++i3) {
            for (int j2 = 0; j2 < this._constraintsLength; ++j2) {
                this._weights.vec(edgeIndexStart + j2).set(i3, edgeIndex++);
            }
        }
        Vec.Writer capacitiesWriter = capacities.open();
        for (long i4 = 0L; i4 < this._edgeSize; ++i4) {
            capacitiesWriter.set(i4, Long.MAX_VALUE);
        }
        double maxCapacity = 3.0 * (this._sumWeights > this._maxAbsDemand ? this._sumWeights : this._maxAbsDemand);
        for (long i5 = 0L; i5 < this._nodeSize; ++i5) {
            capacitiesWriter.set(i5 + this._edgeSize, maxCapacity);
        }
        capacitiesWriter.close();
        this._capacitiesReader = new Vec.Reader(capacities);
        this._demandsReader = new Vec.Reader(demands);
        this.tree = new SpanningTree(this._nodeSize, this._edgeSize, this._constraintsLength);
        this.tree.init(this._numberOfPoints, maxCapacity, demands);
    }

    public double getWeight(long edgeIndex) {
        long numberOfFrameWeights = this._numberOfPoints * (long)this._constraintsLength;
        if (edgeIndex < numberOfFrameWeights) {
            int i2 = this._weights.numCols() - 2 * this._constraintsLength - 3 + (int)(edgeIndex % (long)this._constraintsLength);
            long j2 = Math.round(edgeIndex / (long)this._constraintsLength);
            return this._weights.vec(i2).at(j2);
        }
        return 0.0;
    }

    public boolean isNonZeroWeight(long edgeIndex) {
        long numberOfFrameWeights;
        if (this._hasWeightsColumn && edgeIndex < (numberOfFrameWeights = this._numberOfPoints * (long)this._constraintsLength)) {
            long i2 = Math.round(edgeIndex / (long)this._constraintsLength);
            int j2 = this._weights.numCols() - 1 - 2 * this._constraintsLength - 3;
            return this._weights.vec(j2).at8(i2) == 1L;
        }
        return true;
    }

    public long findMinimalReducedWeight() {
        long additiveEdgesIndexStart;
        FindMinimalWeightTask t2 = (FindMinimalWeightTask)new FindMinimalWeightTask(this.tree, this._hasWeightsColumn, this._constraintsLength).doAll(this._weights);
        double minimalWeight = t2.minimalWeight;
        long minimalIndex = t2.minimalIndex;
        for (long i2 = additiveEdgesIndexStart = this._weights.vec(0).length() * (long)this._constraintsLength; i2 < this._edgeSize; ++i2) {
            boolean countValue;
            double tmpWeight = this.tree.reduceWeight(i2, this.getWeight(i2));
            boolean bl = countValue = !this._hasWeightsColumn || this.isNonZeroWeight(i2);
            if (!countValue || !(tmpWeight < minimalWeight)) continue;
            minimalWeight = tmpWeight;
            minimalIndex = i2;
        }
        return minimalIndex;
    }

    public Edge findNextEnteringEdge() {
        if (!this.tree.areConstraintsSatisfied()) {
            long minimalIndex = this.findMinimalReducedWeight();
            if (this.tree.getFlowByEdgeIndex(minimalIndex) == 0L) {
                return new Edge(minimalIndex, this.tree._sources.at8(minimalIndex), this.tree._targets.at8(minimalIndex));
            }
            return new Edge(minimalIndex, this.tree._targets.at8(minimalIndex), this.tree._sources.at8(minimalIndex));
        }
        return null;
    }

    public NodesEdgesObject getCycle(long edgeIndex, long sourceIndex, long targetIndex) {
        long ancestor = this.tree.findAncestor(sourceIndex, targetIndex);
        NodesEdgesObject resultPath = this.tree.getPath(sourceIndex, ancestor);
        resultPath.reverseNodes();
        resultPath.reverseEdges();
        if (resultPath.edgeSize() != 1 || resultPath.getEdge(0) != edgeIndex) {
            resultPath.addEdge(edgeIndex);
        }
        NodesEdgesObject resultPathBack = this.tree.getPath(targetIndex, ancestor);
        resultPathBack.removeLastNode();
        resultPath.addAllNodes(resultPathBack.getNodes());
        resultPath.addAllEdges(resultPathBack.getEdges());
        return resultPath;
    }

    public Edge getLeavingEdge(NodesEdgesObject cycle2) {
        long nodeIndex;
        long edgeIndex;
        cycle2.reverseNodes();
        cycle2.reverseEdges();
        double minResidualCapacity = Double.MAX_VALUE;
        int minIndex = -1;
        for (int i2 = 0; i2 < cycle2.edgeSize(); ++i2) {
            boolean countValue;
            double tmpResidualCapacity = this.tree.getResidualCapacity(cycle2.getEdge(i2), cycle2.getNode(i2), this._capacitiesReader.at(cycle2.getEdge(i2)));
            boolean bl = countValue = !this._hasWeightsColumn || this.isNonZeroWeight(cycle2.getEdge(i2));
            if (!countValue || !(tmpResidualCapacity < minResidualCapacity)) continue;
            minResidualCapacity = tmpResidualCapacity;
            minIndex = i2;
        }
        assert (minIndex != -1);
        return new Edge(edgeIndex, nodeIndex, (nodeIndex = cycle2.getNode(minIndex)) == this.tree._sources.at8(edgeIndex = cycle2.getEdge(minIndex)) ? this.tree._targets.at8(edgeIndex) : this.tree._sources.at8(edgeIndex));
    }

    public void calculateMinimalCostFlow() {
        Edge edge = this.findNextEnteringEdge();
        while (edge != null) {
            long enteringEdgeIndex = edge.getEdgeIndex();
            long enteringEdgeSourceIndex = edge.getSourceIndex();
            long enteringEdgeTargetIndex = edge.getTargetIndex();
            NodesEdgesObject cycle2 = this.getCycle(enteringEdgeIndex, enteringEdgeSourceIndex, enteringEdgeTargetIndex);
            Edge leavingEdge = this.getLeavingEdge(cycle2);
            long leavingEdgeIndex = leavingEdge.getEdgeIndex();
            long leavingEdgeSourceIndex = leavingEdge.getSourceIndex();
            long leavingEdgeTargetIndex = leavingEdge.getTargetIndex();
            double residualCap = this.tree.getResidualCapacity(leavingEdgeIndex, leavingEdgeSourceIndex, this._capacitiesReader.at(leavingEdgeIndex));
            if (residualCap != 0.0) {
                this.tree.augmentFlow(cycle2, residualCap);
            }
            if (enteringEdgeIndex != leavingEdgeIndex) {
                if (leavingEdgeSourceIndex != this.tree._parents.at8(leavingEdgeTargetIndex)) {
                    long tmpS = leavingEdgeSourceIndex;
                    leavingEdgeSourceIndex = leavingEdgeTargetIndex;
                    leavingEdgeTargetIndex = tmpS;
                }
                if (cycle2.indexOfEdge(enteringEdgeIndex) < cycle2.indexOfEdge(leavingEdgeIndex)) {
                    long tmpP = enteringEdgeSourceIndex;
                    enteringEdgeSourceIndex = enteringEdgeTargetIndex;
                    enteringEdgeTargetIndex = tmpP;
                }
                this.tree.removeParentEdge(leavingEdgeSourceIndex, leavingEdgeTargetIndex);
                this.tree.makeRoot(enteringEdgeTargetIndex);
                this.tree.addEdge(enteringEdgeIndex, enteringEdgeSourceIndex, enteringEdgeTargetIndex);
                this.tree.updatePotentials(enteringEdgeIndex, enteringEdgeSourceIndex, enteringEdgeTargetIndex, this.getWeight(enteringEdgeIndex));
            }
            edge = this.findNextEnteringEdge();
        }
    }

    public void checkConstraintsCondition(int[] numberOfPointsInCluster) {
        for (int i2 = 0; i2 < this._constraintsLength; ++i2) {
            assert ((long)numberOfPointsInCluster[i2] >= this._demandsReader.at8(this._numberOfPoints + (long)i2)) : String.format("Cluster %d has %d assigned points however should has assigned at least %d points.", i2 + 1, numberOfPointsInCluster[i2], this._demandsReader.at8(this._numberOfPoints + (long)i2));
        }
    }

    public Frame assignClusters() {
        int i2;
        this.calculateMinimalCostFlow();
        this._weights = this._weights.add(new Frame(this.tree._edgeFlowDataPoints));
        int dataStopLength = this._weights.numCols() - (this._hasWeightsColumn ? 1 : 0) - 3 * this._constraintsLength - 3;
        AssignClusterTask task = new AssignClusterTask(this._constraintsLength, this._hasWeightsColumn, this._weights.numCols());
        task.doAll(this._weights);
        this.checkConstraintsCondition(task._numberOfPointsInCluster);
        for (i2 = 0; i2 < 2 * this._constraintsLength; ++i2) {
            this._weights.remove(dataStopLength + (this._hasWeightsColumn ? 1 : 0));
        }
        for (i2 = 0; i2 < this._constraintsLength; ++i2) {
            this._weights.remove(this._weights.numCols() - 1);
        }
        return this._weights;
    }
}

