/*
 * Decompiled with CFR 0.152.
 */
package hex.pca;

import hex.DataInfo;
import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.pca.ModelMetricsPCA;
import hex.pca.PCA;
import hex.pca.PCAImplementation;
import hex.pca.PCAMojoWriter;
import java.util.ArrayList;
import water.DKV;
import water.Job;
import water.Key;
import water.MRTask;
import water.codegen.CodeGenerator;
import water.codegen.CodeGeneratorPipeline;
import water.exceptions.JCodeSB;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.udf.CFuncRef;
import water.util.JCodeGen;
import water.util.SBPrintStream;
import water.util.TwoDimTable;

public class PCAModel
extends Model<PCAModel, PCAParameters, PCAOutput> {
    public PCAModel(Key selfKey, PCAParameters parms, PCAOutput output) {
        super(selfKey, parms, output);
    }

    @Override
    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new ModelMetricsPCA.PCAModelMetrics(((PCAParameters)this._parms)._k);
    }

    @Override
    protected Model.PredictScoreResult predictScoreImpl(Frame origFr, Frame adaptedFr, String destination_key, final Job j2, boolean computeMetrics, CFuncRef customMetricFunc) {
        Frame adaptFrm = new Frame(adaptedFr);
        for (int i2 = 0; i2 < ((PCAParameters)this._parms)._k; ++i2) {
            adaptFrm.add("PC" + String.valueOf(i2 + 1), adaptFrm.anyVec().makeZero());
        }
        new MRTask(){

            @Override
            public void map(Chunk[] chks) {
                if (this.isCancelled() || j2 != null && j2.stop_requested()) {
                    return;
                }
                double[] tmp = new double[((PCAOutput)PCAModel.this._output)._names.length];
                double[] preds = new double[((PCAParameters)PCAModel.this._parms)._k];
                for (int row = 0; row < chks[0]._len; ++row) {
                    double[] p2 = PCAModel.this.score0(chks, row, tmp, preds);
                    for (int c2 = 0; c2 < preds.length; ++c2) {
                        chks[((PCAOutput)PCAModel.this._output)._names.length + c2].set(row, p2[c2]);
                    }
                }
                if (j2 != null) {
                    j2.update(1L);
                }
            }
        }.doAll(adaptFrm);
        int x2 = ((PCAOutput)this._output)._names.length;
        int y2 = adaptFrm.numCols();
        Frame f2 = adaptFrm.extractFrame(x2, y2);
        f2 = new Frame(Key.make(destination_key), f2.names(), f2.vecs());
        DKV.put(f2);
        ModelMetrics.MetricBuilder mb = this.makeMetricBuilder(null);
        return new Model.PredictScoreResult(this, mb, f2, f2);
    }

    @Override
    protected double[] score0(double[] data, double[] preds) {
        int numStart = ((PCAOutput)this._output)._catOffsets[((PCAOutput)this._output)._catOffsets.length - 1];
        assert (data.length == ((PCAOutput)this._output)._nnums + ((PCAOutput)this._output)._ncats);
        for (int i2 = 0; i2 < ((PCAParameters)this._parms)._k; ++i2) {
            preds[i2] = 0.0;
            for (int j2 = 0; j2 < ((PCAOutput)this._output)._ncats; ++j2) {
                double tmp = data[((PCAOutput)this._output)._permutation[j2]];
                if (Double.isNaN(tmp)) continue;
                int last_cat = ((PCAOutput)this._output)._catOffsets[j2 + 1] - ((PCAOutput)this._output)._catOffsets[j2] - 1;
                int level = (int)tmp - (((PCAParameters)this._parms)._use_all_factor_levels ? 0 : 1);
                if (level < 0 || level > last_cat) continue;
                int n2 = i2;
                preds[n2] = preds[n2] + ((PCAOutput)this._output)._eigenvectors_raw[((PCAOutput)this._output)._catOffsets[j2] + level][i2];
            }
            int dcol = ((PCAOutput)this._output)._ncats;
            int vcol = numStart;
            for (int j3 = 0; j3 < ((PCAOutput)this._output)._nnums; ++j3) {
                int n3 = i2;
                preds[n3] = preds[n3] + (data[((PCAOutput)this._output)._permutation[dcol]] - ((PCAOutput)this._output)._normSub[j3]) * ((PCAOutput)this._output)._normMul[j3] * ((PCAOutput)this._output)._eigenvectors_raw[vcol][i2];
                ++dcol;
                ++vcol;
            }
        }
        return preds;
    }

    @Override
    protected SBPrintStream toJavaInit(SBPrintStream sb, CodeGeneratorPipeline fileCtx) {
        sb = super.toJavaInit(sb, fileCtx);
        sb.ip("public boolean isSupervised() { return " + this.isSupervised() + "; }").nl();
        sb.ip("public int nfeatures() { return " + ((PCAOutput)this._output).nfeatures() + "; }").nl();
        sb.ip("public int nclasses() { return " + ((PCAParameters)this._parms)._k + "; }").nl();
        final String mname = JCodeGen.toJavaId(this._key.toString());
        fileCtx.add(new CodeGenerator(){

            @Override
            public void generate(JCodeSB out) {
                if (((PCAOutput)PCAModel.this._output)._nnums > 0) {
                    JCodeGen.toClassWithArray(out, null, mname + "_NORMMUL", ((PCAOutput)PCAModel.this._output)._normMul, "Standardization/Normalization scaling factor for numerical variables.");
                    JCodeGen.toClassWithArray(out, null, mname + "_NORMSUB", ((PCAOutput)PCAModel.this._output)._normSub, "Standardization/Normalization offset for numerical variables.");
                }
                JCodeGen.toClassWithArray(out, null, mname + "_CATOFFS", ((PCAOutput)PCAModel.this._output)._catOffsets, "Categorical column offsets.");
                JCodeGen.toClassWithArray(out, null, mname + "_PERMUTE", ((PCAOutput)PCAModel.this._output)._permutation, "Permutation index vector.");
                JCodeGen.toClassWithArray(out, null, mname + "_EIGVECS", ((PCAOutput)PCAModel.this._output)._eigenvectors_raw, "Eigenvector matrix.");
            }
        });
        return sb;
    }

    @Override
    protected void toJavaPredictBody(SBPrintStream bodySb, CodeGeneratorPipeline classCtx, CodeGeneratorPipeline fileCtx, boolean verboseCode) {
        String mname = JCodeGen.toJavaId(this._key.toString());
        bodySb.i().p("java.util.Arrays.fill(preds,0);").nl();
        int cats = ((PCAOutput)this._output)._ncats;
        int nums = ((PCAOutput)this._output)._nnums;
        bodySb.i().p("final int nstart = ").pj(mname + "_CATOFFS", "VALUES").p("[").pj(mname + "_CATOFFS", "VALUES").p(".length-1];").nl();
        bodySb.i().p("for(int i = 0; i < ").p(((PCAParameters)this._parms)._k).p("; i++) {").nl();
        bodySb.i(1).p("for(int j = 0; j < ").p(cats).p("; j++) {").nl();
        bodySb.i(2).p("double d = data[").pj(mname + "_PERMUTE", "VALUES").p("[j]];").nl();
        bodySb.i(2).p("if(Double.isNaN(d)) continue;").nl();
        bodySb.i(2).p("int last = ").pj(mname + "_CATOFFS", "VALUES").p("[j+1]-").pj(mname + "_CATOFFS", "VALUES").p("[j]-1;").nl();
        bodySb.i(2).p("int c = (int)d").p(((PCAParameters)this._parms)._use_all_factor_levels ? ";" : "-1;").nl();
        bodySb.i(2).p("if(c < 0 || c > last) continue;").nl();
        bodySb.i(2).p("preds[i] += ").pj(mname + "_EIGVECS", "VALUES").p("[").pj(mname + "_CATOFFS", "VALUES").p("[j]+c][i];").nl();
        bodySb.i(1).p("}").nl();
        if (((PCAOutput)this._output)._nnums > 0) {
            bodySb.i(1).p("for(int j = 0; j < ").p(nums).p("; j++) {").nl();
            bodySb.i(2).p("preds[i] += (data[").pj(mname + "_PERMUTE", "VALUES").p("[j" + (cats > 0 ? "+" + cats : "") + "]]-").pj(mname + "_NORMSUB", "VALUES").p("[j])*").pj(mname + "_NORMMUL", "VALUES").p("[j]*").pj(mname + "_EIGVECS", "VALUES").p("[j" + (cats > 0 ? "+ nstart" : "") + "][i];").nl();
            bodySb.i(1).p("}").nl();
        }
        bodySb.i().p("}").nl();
    }

    @Override
    public PCAMojoWriter getMojo() {
        return new PCAMojoWriter(this);
    }

    public static class PCAOutput
    extends Model.Output {
        public double _objective;
        public double[][] _eigenvectors_raw;
        public TwoDimTable _eigenvectors;
        public double[] _std_deviation;
        public TwoDimTable _importance;
        public int _ncats;
        public int _nnums;
        public long _nobs;
        public double _total_variance;
        public int[] _catOffsets;
        public double[] _normSub;
        public double[] _normMul;
        public int[] _permutation;
        public ArrayList<Long> _training_time_ms = new ArrayList();

        public PCAOutput(PCA b2) {
            super(b2);
        }

        @Override
        public int nfeatures() {
            return this._names.length;
        }

        @Override
        public ModelCategory getModelCategory() {
            return ModelCategory.DimReduction;
        }
    }

    public static class PCAParameters
    extends Model.Parameters {
        public DataInfo.TransformType _transform = DataInfo.TransformType.NONE;
        public Method _pca_method = Method.GramSVD;
        public PCAImplementation _pca_implementation = PCAImplementation.getFastestImplementation();
        public int _k = 1;
        public int _max_iterations = 1000;
        public boolean _use_all_factor_levels = false;
        public boolean _compute_metrics = true;
        public boolean _impute_missing = false;

        @Override
        public String algoName() {
            return "PCA";
        }

        @Override
        public String fullName() {
            return "Principal Components Analysis";
        }

        @Override
        public String javaName() {
            return PCAModel.class.getName();
        }

        @Override
        public long progressUnits() {
            return this._pca_method == Method.GramSVD ? 5L : 3L;
        }

        public static enum Method {
            GramSVD,
            Power,
            Randomized,
            GLRM;

        }
    }
}

