/*
 * Decompiled with CFR 0.152.
 */
package hex.psvm;

import hex.genmodel.algos.psvm.KernelParameters;
import hex.genmodel.utils.ByteBufferWrapper;
import hex.psvm.BulkSupportVectorScorer;
import org.apache.commons.math3.util.FastMath;
import water.fvec.Chunk;

class GaussianScorerRawBytes
implements BulkSupportVectorScorer {
    private final double _gamma;
    private final byte[] _svs;

    GaussianScorerRawBytes(KernelParameters parms, byte[] svs) {
        this(parms._gamma, svs);
    }

    private GaussianScorerRawBytes(double gamma, byte[] svs) {
        this._gamma = gamma;
        this._svs = svs;
    }

    @Override
    public double[] bulkScore0(Chunk[] cs) {
        double[] result = new double[cs[0]._len];
        double[] norms = new double[cs[0]._len];
        ByteBufferWrapper bb = new ByteBufferWrapper(this._svs);
        while (bb.hasRemaining()) {
            double alpha = bb.get8d();
            int cats = bb.get4();
            for (int i2 = 0; i2 < cats; ++i2) {
                int svCat = bb.get4();
                for (int j2 = 0; j2 < norms.length; ++j2) {
                    int n2 = j2;
                    norms[n2] = norms[n2] + ((int)cs[i2].at8(j2) == svCat ? 0.0 : 2.0);
                }
            }
            int nums = bb.get4();
            for (int i3 = 0; i3 < nums; ++i3) {
                double svNum = bb.get8d();
                int j3 = 0;
                while (j3 < norms.length) {
                    double v2 = cs[i3 + cats].atd(j3) - svNum;
                    int n3 = j3++;
                    norms[n3] = norms[n3] + v2 * v2;
                }
            }
            for (int j4 = 0; j4 < result.length; ++j4) {
                int n4 = j4;
                result[n4] = result[n4] + alpha * FastMath.exp((double)(-this._gamma * norms[j4]));
                norms[j4] = 0.0;
            }
        }
        return result;
    }
}

