/*
 * Decompiled with CFR 0.152.
 */
package hex.psvm.psvm;

import water.Iced;
import water.MemoryManager;

class LLMatrix
extends Iced<LLMatrix> {
    private final int _dim;
    private final double[][] _data;

    LLMatrix(int dim) {
        this._dim = dim;
        this._data = new double[dim][];
        for (int i2 = 0; i2 < dim; ++i2) {
            this._data[i2] = new double[dim - i2];
        }
    }

    private int dim() {
        return this._dim;
    }

    final double get(int x2, int y2) {
        return this._data[y2][x2 - y2];
    }

    final void set(int x2, int y2, double value) {
        this._data[y2][x2 - y2] = value;
    }

    final void addUnitMat() {
        for (double[] col : this._data) {
            col[0] = col[0] + 1.0;
        }
    }

    double[] cholSolve(double[] b2) {
        double[] x2 = MemoryManager.malloc8d(b2.length);
        this.cholForwardSub(b2, x2);
        this.cholBackwardSub(x2, b2);
        return b2;
    }

    private void cholBackwardSub(double[] b2, double[] x2) {
        int dim = this.dim();
        for (int k2 = dim - 1; k2 >= 0; --k2) {
            double tmp = b2[k2];
            for (int i2 = k2 + 1; i2 < dim; ++i2) {
                tmp -= x2[i2] * this.get(i2, k2);
            }
            x2[k2] = tmp / this.get(k2, k2);
        }
    }

    private void cholForwardSub(double[] b2, double[] x2) {
        int dim = this.dim();
        for (int k2 = 0; k2 < dim; ++k2) {
            double tmp = b2[k2];
            for (int i2 = 0; i2 < k2; ++i2) {
                tmp -= x2[i2] * this.get(k2, i2);
            }
            x2[k2] = tmp / this.get(k2, k2);
        }
    }

    LLMatrix cf() {
        int dim = this.dim();
        LLMatrix m4 = new LLMatrix(dim);
        for (int i2 = 0; i2 < dim; ++i2) {
            for (int j2 = i2; j2 < dim; ++j2) {
                double sum = this.get(j2, i2);
                for (int k2 = i2 - 1; k2 >= 0; --k2) {
                    sum -= m4.get(i2, k2) * m4.get(j2, k2);
                }
                if (i2 == j2) {
                    if (sum <= 0.0) {
                        throw new IllegalStateException("Only symmetric positive definite matrix can perform Cholesky factorization.");
                    }
                    m4.set(i2, i2, Math.sqrt(sum));
                    continue;
                }
                m4.set(j2, i2, sum / m4.get(i2, i2));
            }
        }
        return m4;
    }
}

