/*
 * Decompiled with CFR 0.152.
 */
package hex.psvm.psvm;

import hex.psvm.psvm.LLMatrix;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class MatrixUtils {
    public static LLMatrix productMtDM(Frame m4, Vec diagonal) {
        Vec[] vecs = ArrayUtils.append(m4.vecs(), diagonal);
        double[] result = ((ProductMMTask)new ProductMMTask().doAll(vecs))._result;
        LLMatrix product2 = new LLMatrix(m4.numCols());
        int pos = 0;
        for (int i2 = 0; i2 < m4.numCols(); ++i2) {
            for (int j2 = 0; j2 <= i2; ++j2) {
                product2.set(i2, j2, result[pos++]);
            }
        }
        return product2;
    }

    public static double[] productMtv(Frame m4, Vec v2) {
        Vec[] vecs = ArrayUtils.append(m4.vecs(), v2);
        return ((ProductMtvTask)new ProductMtvTask().doAll(vecs))._result;
    }

    static class ProductMtvTask
    extends MRTask<ProductMtvTask> {
        private double[] _result;

        ProductMtvTask() {
        }

        @Override
        public void map(Chunk[] cs) {
            int column = cs.length - 1;
            Chunk v2 = cs[column];
            this._result = new double[column];
            for (int j2 = 0; j2 < column; ++j2) {
                double sum = 0.0;
                for (int i2 = 0; i2 < cs[0]._len; ++i2) {
                    sum += cs[j2].atd(i2) * v2.atd(i2);
                }
                this._result[j2] = sum;
            }
        }

        @Override
        public void reduce(ProductMtvTask mrt) {
            ArrayUtils.add(this._result, mrt._result);
        }
    }

    private static class ProductMMTask
    extends MRTask<ProductMMTask> {
        private double[] _result;

        private ProductMMTask() {
        }

        @Override
        public void map(Chunk[] cs) {
            int column = cs.length - 1;
            Chunk diagonal = cs[column];
            this._result = new double[(column + 1) * column / 2];
            double[] buff = new double[cs[0]._len];
            int offset = 0;
            for (int i2 = 0; i2 < column; ++i2) {
                offset += i2;
                for (int p2 = 0; p2 < buff.length; ++p2) {
                    buff[p2] = cs[i2].atd(p2) * diagonal.atd(p2);
                }
                for (int j2 = 0; j2 <= i2; ++j2) {
                    double sum = 0.0;
                    for (int p3 = 0; p3 < buff.length; ++p3) {
                        sum += buff[p3] * cs[j2].atd(p3);
                    }
                    this._result[offset + j2] = sum;
                }
            }
        }

        @Override
        public void reduce(ProductMMTask mrt) {
            ArrayUtils.add(this._result, mrt._result);
        }
    }
}

