/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.glm.GLMModel;
import hex.schemas.GLMV3;
import java.util.Arrays;
import water.MemoryManager;
import water.api.API;
import water.api.schemas3.ModelOutputSchemaV3;
import water.api.schemas3.ModelSchemaV3;
import water.api.schemas3.TwoDimTableV3;
import water.util.ArrayUtils;
import water.util.TwoDimTable;

public class GLMModelV3
extends ModelSchemaV3<GLMModel, GLMModelV3, GLMModel.GLMParameters, GLMV3.GLMParametersV3, GLMModel.GLMOutput, GLMModelOutputV3> {
    public static void calculateVarimpBase(double[] magnitudes, int[] indices, double[] betaNorm) {
        for (int i2 = 0; i2 < magnitudes.length; ++i2) {
            magnitudes[i2] = (float)betaNorm[i2];
            if (!(magnitudes[i2] < 0.0)) continue;
            int n2 = i2;
            magnitudes[n2] = magnitudes[n2] * -1.0;
        }
        ArrayUtils.sort(indices, magnitudes, -1, -1);
    }

    @Override
    public GLMV3.GLMParametersV3 createParametersSchema() {
        return new GLMV3.GLMParametersV3();
    }

    @Override
    public GLMModelOutputV3 createOutputSchema() {
        return new GLMModelOutputV3();
    }

    @Override
    public GLMModel createImpl() {
        GLMModel.GLMParameters parms = (GLMModel.GLMParameters)((GLMV3.GLMParametersV3)this.parameters).createImpl();
        return new GLMModel(this.model_id.key(), parms, null, new double[]{0.0}, 0.0, 0.0, 0L);
    }

    public static final class GLMModelOutputV3
    extends ModelOutputSchemaV3<GLMModel.GLMOutput, GLMModelOutputV3> {
        @API(help="Table of Coefficients")
        TwoDimTableV3 coefficients_table;
        @API(help="Table of Random Coefficients for HGLM")
        TwoDimTableV3 random_coefficients_table;
        @API(help="Table of Coefficients with coefficients denoted with class names for GLM multinonimals only.")
        TwoDimTableV3 coefficients_table_multinomials_with_class_names;
        @API(help="Standardized Coefficient Magnitudes")
        TwoDimTableV3 standardized_coefficient_magnitudes;
        @API(help="Variable Importances", direction=API.Direction.OUTPUT, level=API.Level.secondary)
        TwoDimTableV3 variable_importances;
        @API(help="Lambda minimizing the objective value, only applicable with lambda search or when arrays of alpha and lambdas are provided")
        double lambda_best;
        @API(help="Alpha minimizing the objective value, only applicable when arrays of alphas are given ")
        double alpha_best;
        @API(help="submodel index minimizing the objective value, only applicable for arrays of alphas/lambda ")
        int best_submodel_index;
        @API(help="Lambda best + 1 standard error. Only applicable with lambda search and cross-validation")
        double lambda_1se;
        @API(help="Minimum lambda value calculated that may be used for lambda search.  Early-stop may happen and the minimum lambda value will not be used in this case.")
        double lambda_min;
        @API(help="Starting lambda value used when lambda search is enabled.")
        double lambda_max;
        @API(help="Dispersion parameter, only applicable to Tweedie family (input/output) and fractional Binomial (output only)")
        double dispersion;

        private GLMModelOutputV3 fillMultinomial(GLMModel.GLMOutput impl) {
            if (impl.get_global_beta_multinomial() == null) {
                return this;
            }
            String[] names = (String[])impl.coefficientNames().clone();
            int len = names.length - 1;
            String[] names2 = new String[len];
            int[] indices = new int[len];
            for (int i2 = 0; i2 < indices.length; ++i2) {
                indices[i2] = i2;
            }
            String[] ns = ArrayUtils.append(new String[]{"Intercept"}, Arrays.copyOf(names, names.length - 1));
            this.coefficients_table = new TwoDimTableV3();
            if (impl.nclasses() > 2) {
                this.coefficients_table_multinomials_with_class_names = new TwoDimTableV3();
            }
            int n2 = impl.nclasses();
            String[] cols = new String[n2 * 2];
            String[] cols2 = null;
            if (n2 > 2) {
                cols2 = new String[n2 * 2];
                String[] classNames = impl._domains[impl.responseIdx()];
                for (int i3 = 0; i3 < n2; ++i3) {
                    cols2[i3] = "coefs_class_" + classNames[i3];
                    cols2[n2 + i3] = "std_coefs_class_" + classNames[i3];
                }
            }
            for (int i4 = 0; i4 < n2; ++i4) {
                cols[i4] = "coefs_class_" + i4;
                cols[n2 + i4] = "std_coefs_class_" + i4;
            }
            Object[] colTypes = new String[cols.length];
            Arrays.fill(colTypes, "double");
            Object[] colFormats = new String[cols.length];
            Arrays.fill(colFormats, "%5f");
            double[][] betaNorm = impl.getNormBetaMultinomial();
            if (betaNorm != null) {
                int i5;
                TwoDimTable tdt = new TwoDimTable("Coefficients", "glm multinomial coefficients", ns, cols, (String[])colTypes, (String[])colFormats, "names");
                for (int c2 = 0; c2 < n2; ++c2) {
                    double[] beta = impl.get_global_beta_multinomial()[c2];
                    tdt.set(0, c2, beta[beta.length - 1]);
                    tdt.set(0, n2 + c2, betaNorm[c2][beta.length - 1]);
                    for (int i6 = 0; i6 < beta.length - 1; ++i6) {
                        tdt.set(i6 + 1, c2, beta[i6]);
                        tdt.set(i6 + 1, n2 + c2, betaNorm[c2][i6]);
                    }
                }
                this.coefficients_table.fillFromImpl(tdt);
                if (n2 > 2) {
                    this.coefficients_table_multinomials_with_class_names.fillFromImpl(tdt);
                    this.revertCoeffNames(cols2, n2, this.coefficients_table_multinomials_with_class_names);
                }
                double[] magnitudes = new double[betaNorm[0].length];
                GLMModelOutputV3.calculateVarimpMultinomial(magnitudes, indices, betaNorm);
                for (i5 = 0; i5 < len; ++i5) {
                    names2[i5] = names[indices[i5]];
                }
                tdt = new TwoDimTable("Standardized Coefficient Magnitudes", "standardized coefficient magnitudes", names2, new String[]{"Coefficients", "Sign"}, new String[]{"double", "string"}, new String[]{"%5f", "%s"}, "names");
                for (i5 = 0; i5 < magnitudes.length - 1; ++i5) {
                    tdt.set(i5, 0, magnitudes[indices[i5]]);
                    tdt.set(i5, 1, "POS");
                }
                this.standardized_coefficient_magnitudes = new TwoDimTableV3();
                this.standardized_coefficient_magnitudes.fillFromImpl(tdt);
            }
            return this;
        }

        public static void calculateVarimpMultinomial(double[] magnitudes, int[] indices, double[][] betaNorm) {
            for (int i2 = 0; i2 < betaNorm.length; ++i2) {
                for (int j2 = 0; j2 < betaNorm[i2].length; ++j2) {
                    double d2 = betaNorm[i2][j2];
                    int n2 = j2;
                    magnitudes[n2] = magnitudes[n2] + (d2 < 0.0 ? -d2 : d2);
                }
            }
            ArrayUtils.sort(indices, magnitudes, -1, -1);
        }

        public void revertCoeffNames(String[] colNames, int nclass, TwoDimTableV3 coeffs_table) {
            String newName;
            coeffs_table.name = newName = coeffs_table.name + " with class names";
            boolean bothCoeffStd = colNames.length == 2 * nclass;
            for (int tableIndex = 1; tableIndex <= nclass; ++tableIndex) {
                coeffs_table.columns[tableIndex].name = colNames[tableIndex - 1];
                if (!bothCoeffStd) continue;
                coeffs_table.columns[tableIndex + nclass].name = colNames[tableIndex - 1 + nclass];
            }
        }

        public TwoDimTable buildRandomCoefficients2DTable(double[] ubeta, String[] randomColNames) {
            String[] colTypes = new String[]{"double"};
            String[] colFormats = new String[]{"%5f"};
            String[] colnames = new String[]{"Random Coefficients"};
            TwoDimTable tdt = new TwoDimTable("HGLM Random Coefficients", "HGLM random coefficients", randomColNames, colnames, colTypes, colFormats, "names");
            for (int i2 = 0; i2 < ubeta.length; ++i2) {
                tdt.set(i2, 0, ubeta[i2]);
            }
            return tdt;
        }

        @Override
        public GLMModelOutputV3 fillFromImpl(GLMModel.GLMOutput impl) {
            super.fillFromImpl(impl);
            this.lambda_1se = impl.lambda_1se();
            this.lambda_best = impl.lambda_best();
            this.alpha_best = impl.alpha_best();
            this.best_submodel_index = impl.bestSubmodelIndex();
            this.dispersion = impl.dispersion();
            if (impl._multinomial || impl._ordinal) {
                return this.fillMultinomial(impl);
            }
            String[] names = (String[])impl.coefficientNames().clone();
            String[] ns = ArrayUtils.append(new String[]{"Intercept"}, Arrays.copyOf(names, names.length - 1));
            this.coefficients_table = new TwoDimTableV3();
            if (impl.ubeta() != null && impl.randomcoefficientNames() != null) {
                this.random_coefficients_table = new TwoDimTableV3();
                this.random_coefficients_table.fillFromImpl(this.buildRandomCoefficients2DTable(impl.ubeta(), impl.randomcoefficientNames()));
            }
            double[] beta = impl.beta();
            double[] magnitudes = new double[beta.length];
            int len = magnitudes.length - 1;
            int[] indices = new int[len];
            for (int i2 = 0; i2 < indices.length; ++i2) {
                indices[i2] = i2;
            }
            if (beta == null) {
                beta = MemoryManager.malloc8d(names.length);
            }
            String[] colTypes = new String[]{"double"};
            String[] colFormats = new String[]{"%5f"};
            String[] colnames = new String[]{"Coefficients"};
            if (impl.hasPValues()) {
                colTypes = new String[]{"double", "double", "double", "double"};
                colFormats = new String[]{"%5f", "%5f", "%5f", "%5f"};
                colnames = new String[]{"Coefficients", "Std. Error", "z value", "p value"};
            }
            int stdOff = colnames.length;
            colTypes = ArrayUtils.append(colTypes, "double");
            colFormats = ArrayUtils.append(colFormats, "%5f");
            colnames = ArrayUtils.append(colnames, "Standardized Coefficients");
            TwoDimTable tdt = new TwoDimTable("Coefficients", "glm coefficients", ns, colnames, colTypes, colFormats, "names");
            tdt.set(0, 0, beta[beta.length - 1]);
            for (int i3 = 0; i3 < beta.length - 1; ++i3) {
                tdt.set(i3 + 1, 0, beta[i3]);
            }
            double[] norm_beta = null;
            if (impl.beta() != null) {
                norm_beta = impl.getNormBeta();
                tdt.set(0, stdOff, norm_beta[norm_beta.length - 1]);
                for (int i4 = 0; i4 < norm_beta.length - 1; ++i4) {
                    tdt.set(i4 + 1, stdOff, norm_beta[i4]);
                }
            }
            if (impl.hasPValues()) {
                double[] stdErr = impl.stdErr();
                double[] zVals = impl.zValues();
                double[] pVals = impl.pValues();
                tdt.set(0, 1, stdErr[stdErr.length - 1]);
                tdt.set(0, 2, zVals[zVals.length - 1]);
                tdt.set(0, 3, pVals[pVals.length - 1]);
                for (int i5 = 0; i5 < stdErr.length - 1; ++i5) {
                    tdt.set(i5 + 1, 1, stdErr[i5]);
                    tdt.set(i5 + 1, 2, zVals[i5]);
                    tdt.set(i5 + 1, 3, pVals[i5]);
                }
            }
            this.coefficients_table.fillFromImpl(tdt);
            if (impl.beta() != null) {
                int i6;
                GLMModelV3.calculateVarimpBase(magnitudes, indices, impl.getNormBeta());
                String[] names2 = new String[len];
                for (i6 = 0; i6 < len; ++i6) {
                    names2[i6] = names[indices[i6]];
                }
                tdt = new TwoDimTable("Standardized Coefficient Magnitudes", "standardized coefficient magnitudes", names2, new String[]{"Coefficients", "Sign"}, new String[]{"double", "string"}, new String[]{"%5f", "%s"}, "names");
                for (i6 = 0; i6 < beta.length - 1; ++i6) {
                    tdt.set(i6, 0, magnitudes[indices[i6]]);
                    tdt.set(i6, 1, beta[indices[i6]] < 0.0 ? "NEG" : "POS");
                }
                this.standardized_coefficient_magnitudes = new TwoDimTableV3();
                this.standardized_coefficient_magnitudes.fillFromImpl(tdt);
            }
            return this;
        }
    }
}

