/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.Model;
import hex.ModelMetrics;
import hex.grid.Grid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import water.DKV;
import water.Key;
import water.api.API;
import water.api.SchemaServer;
import water.api.schemas3.KeyV3;
import water.api.schemas3.ModelMetricsBaseV3;
import water.api.schemas3.ModelParametersSchemaV3;
import water.api.schemas3.SchemaV3;
import water.api.schemas3.TwoDimTableV3;
import water.exceptions.H2OIllegalArgumentException;
import water.util.TwoDimTable;

public class GridSchemaV99
extends SchemaV3<Grid, GridSchemaV99> {
    @API(help="Grid id")
    public KeyV3.GridKeyV3 grid_id;
    @API(help="Model performance metric to sort by. Examples: logloss, residual_deviance, mse, rmse, mae,rmsle, auc, r2, f1, recall, precision, accuracy, mcc, err, err_count, lift_top_group, max_per_class_error", required=false, direction=API.Direction.INOUT)
    public String sort_by;
    @API(help="Specify whether sort order should be decreasing.", required=false, direction=API.Direction.INOUT)
    public boolean decreasing;
    @API(help="Model IDs built by a grid search")
    public KeyV3.ModelKeyV3[] model_ids;
    @API(help="Used hyper parameters.", direction=API.Direction.OUTPUT)
    public String[] hyper_names;
    @API(help="List of failed parameters", direction=API.Direction.OUTPUT)
    public ModelParametersSchemaV3[] failed_params;
    @API(help="List of detailed warning messages", direction=API.Direction.OUTPUT)
    public String[] warning_details;
    @API(help="List of detailed failure messages", direction=API.Direction.OUTPUT)
    public String[] failure_details;
    @API(help="List of detailed failure stack traces", direction=API.Direction.OUTPUT)
    public String[] failure_stack_traces;
    @API(help="List of raw parameters causing model building failure", direction=API.Direction.OUTPUT)
    public String[][] failed_raw_params;
    @API(help="Training model metrics for the returned models; only returned if sort_by is set", direction=API.Direction.OUTPUT)
    public ModelMetricsBaseV3[] training_metrics;
    @API(help="Validation model metrics for the returned models; only returned if sort_by is set", direction=API.Direction.OUTPUT)
    public ModelMetricsBaseV3[] validation_metrics;
    @API(help="Cross validation model metrics for the returned models; only returned if sort_by is set", direction=API.Direction.OUTPUT)
    public ModelMetricsBaseV3[] cross_validation_metrics;
    @API(help="Cross validation model metrics summary for the returned models; only returned if sort_by is set", direction=API.Direction.OUTPUT)
    public TwoDimTableV3[] cross_validation_metrics_summary;
    @API(help="Directory for Grid automatic checkpointing", direction=API.Direction.OUTPUT)
    public String export_checkpoints_dir;
    @API(help="Summary", direction=API.Direction.OUTPUT)
    TwoDimTableV3 summary_table;
    @API(help="Scoring history", direction=API.Direction.OUTPUT, level=API.Level.secondary)
    TwoDimTableV3 scoring_history;

    @Override
    public Grid createImpl() {
        return Grid.GRID_PROTO;
    }

    @Override
    public GridSchemaV99 fillFromImpl(Grid grid) {
        TwoDimTable h2;
        Set<String> possibleMetrics;
        Key<Model>[] gridModelKeys = grid.getModelKeys();
        List<Key<Model>> modelKeys = new ArrayList<Key<Model>>(gridModelKeys.length);
        for (Key<Model> k2 : gridModelKeys) {
            if (k2 == null || DKV.get(k2) == null) continue;
            modelKeys.add(k2);
        }
        if (this.sort_by == null && modelKeys.size() > 0 && modelKeys.get(0) != null) {
            Model.GridSortBy sortBy;
            Model m4 = (Model)DKV.getGet((Key)modelKeys.get(0));
            Model.GridSortBy gridSortBy = sortBy = m4 != null ? m4.getDefaultGridSortBy() : null;
            if (sortBy != null) {
                this.sort_by = sortBy._name;
                this.decreasing = sortBy._decreasing;
            }
        }
        if (modelKeys.size() > 0 && this.sort_by != null && !(possibleMetrics = ModelMetrics.getAllowedMetrics((Key)modelKeys.get(0))).contains(this.sort_by.toLowerCase())) {
            throw new H2OIllegalArgumentException("Invalid argument for sort_by specified. Must be one of: " + Arrays.toString(possibleMetrics.toArray(new String[0])));
        }
        if (null != this.sort_by && !this.sort_by.isEmpty()) {
            modelKeys = ModelMetrics.sortModelsByMetric(this.sort_by, this.decreasing, modelKeys);
            this.training_metrics = new ModelMetricsBaseV3[modelKeys.size()];
            this.validation_metrics = new ModelMetricsBaseV3[modelKeys.size()];
            this.cross_validation_metrics = new ModelMetricsBaseV3[modelKeys.size()];
            this.cross_validation_metrics_summary = new TwoDimTableV3[modelKeys.size()];
            for (int i2 = 0; i2 < modelKeys.size(); ++i2) {
                Model m5 = (Model)DKV.getGet(modelKeys.get(i2));
                if (m5 == null) continue;
                Object o2 = m5._output;
                if (null != ((Model.Output)o2)._training_metrics) {
                    this.training_metrics[i2] = (ModelMetricsBaseV3)SchemaServer.schema(3, ((Model.Output)o2)._training_metrics).fillFromImpl(((Model.Output)o2)._training_metrics);
                }
                if (null != ((Model.Output)o2)._validation_metrics) {
                    this.validation_metrics[i2] = (ModelMetricsBaseV3)SchemaServer.schema(3, ((Model.Output)o2)._validation_metrics).fillFromImpl(((Model.Output)o2)._validation_metrics);
                }
                if (null != ((Model.Output)o2)._cross_validation_metrics) {
                    this.cross_validation_metrics[i2] = (ModelMetricsBaseV3)SchemaServer.schema(3, ((Model.Output)o2)._cross_validation_metrics).fillFromImpl(((Model.Output)o2)._cross_validation_metrics);
                }
                if (((Model.Output)o2)._cross_validation_metrics_summary == null) continue;
                this.cross_validation_metrics_summary[i2] = new TwoDimTableV3(((Model.Output)o2)._cross_validation_metrics_summary);
            }
        }
        KeyV3.ModelKeyV3[] modelIds = new KeyV3.ModelKeyV3[modelKeys.size()];
        Key[] keys = new Key[modelKeys.size()];
        for (int i3 = 0; i3 < modelIds.length; ++i3) {
            modelIds[i3] = new KeyV3.ModelKeyV3<Model>(modelKeys.get(i3));
            keys[i3] = modelIds[i3].key();
        }
        this.grid_id = new KeyV3.GridKeyV3((Key<Grid>)grid._key);
        this.model_ids = modelIds;
        this.hyper_names = grid.getHyperNames();
        Grid.SearchFailure failures = grid.getFailures();
        this.failed_params = this.toModelParametersSchema(failures.getFailedParameters());
        this.failure_details = failures.getFailureDetails();
        this.failure_stack_traces = failures.getFailureStackTraces();
        this.failed_raw_params = failures.getFailedRawParameters();
        this.warning_details = failures.getWarningDetails();
        this.export_checkpoints_dir = grid.getParams() != null ? ((Model.Parameters)grid.getParams())._export_checkpoints_dir : null;
        TwoDimTable t2 = grid.createSummaryTable(keys, this.sort_by, this.decreasing);
        if (t2 != null) {
            this.summary_table = new TwoDimTableV3().fillFromImpl(t2);
        }
        if ((h2 = grid.createScoringHistoryTable()) != null) {
            this.scoring_history = new TwoDimTableV3().fillFromImpl(h2);
        }
        return this;
    }

    private ModelParametersSchemaV3[] toModelParametersSchema(Model.Parameters[] modelParameters) {
        if (modelParameters == null) {
            return null;
        }
        ModelParametersSchemaV3[] result = new ModelParametersSchemaV3[modelParameters.length];
        for (int i2 = 0; i2 < modelParameters.length; ++i2) {
            result[i2] = modelParameters[i2] != null ? (ModelParametersSchemaV3)SchemaServer.schema(SchemaServer.getLatestVersion(), modelParameters[i2]).fillFromImpl(modelParameters[i2]) : null;
        }
        return result;
    }
}

