/*
 * Decompiled with CFR 0.152.
 */
package hex.segments;

import hex.Model;
import hex.ModelBuilder;
import java.util.concurrent.Future;
import water.DKV;
import water.Futures;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.api.schemas3.KeyV3;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.util.ArrayUtils;
import water.util.StringUtils;

public class SegmentModels
extends Keyed<SegmentModels> {
    private final Frame _segments;
    private final Vec _results;

    public static SegmentModels make(Key<SegmentModels> key, Frame segments) {
        SegmentModels segmentModels = new SegmentModels(key, segments);
        DKV.put(segmentModels);
        return segmentModels;
    }

    private SegmentModels(Key<SegmentModels> key, Frame segments) {
        super(key);
        this._results = ((MakeResultKeys)new MakeResultKeys().doAll((byte)2, segments)).outputFrame().vec(0);
        this._segments = segments.deepCopy(Key.makeUserHidden(Key.make().toString()).toString());
    }

    SegmentModelResult addResult(long segmentIdx, ModelBuilder mb, Exception e2) {
        Key<SegmentModelResult> resultKey = Key.make(this._results.atStr(new BufferedString(), segmentIdx).toString());
        SegmentModelResult result = new SegmentModelResult(resultKey, mb, e2);
        DKV.put(result);
        return result;
    }

    public Frame toFrame() {
        Frame result = this._segments.deepCopy(null);
        Frame models = ((ToFrame)new ToFrame().doAll(new byte[]{2, 4, 2, 2}, new Frame(this._results))).outputFrame(new String[]{"model", "status", "errors", "warnings"}, new String[][]{null, Job.JobStatus.domain(), null, null});
        result.add(models);
        return result;
    }

    @Override
    public Class<? extends KeyV3> makeSchema() {
        return KeyV3.SegmentModelsKeyV3.class;
    }

    @Override
    protected Futures remove_impl(Futures fs, boolean cascade) {
        if (this._segments != null) {
            this._segments.remove(fs, cascade);
        }
        if (this._results != null) {
            fs.add((Future)new CleanUpSegmentResults().dfork(this._results));
        }
        return fs;
    }

    static class CleanUpSegmentResults
    extends MRTask<CleanUpSegmentResults> {
        CleanUpSegmentResults() {
        }

        @Override
        public void map(Chunk c2) {
            BufferedString bs = new BufferedString();
            Futures fs = new Futures();
            for (int i2 = 0; i2 < c2._len; ++i2) {
                Keyed.remove(Key.make(c2.atStr(bs, i2).toString()), fs, true);
            }
            fs.blockForPending();
        }

        @Override
        protected void postGlobal() {
            this._fr.remove();
        }
    }

    static class ToFrame
    extends MRTask<ToFrame> {
        ToFrame() {
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] ncs) {
            assert (cs.length == 1);
            Chunk c2 = cs[0];
            BufferedString bs = new BufferedString();
            for (int i2 = 0; i2 < c2._len; ++i2) {
                SegmentModelResult result = (SegmentModelResult)DKV.getGet(Key.make(c2.atStr(bs, i2).toString()));
                if (result == null) {
                    for (NewChunk nc : ncs) {
                        nc.addNA();
                    }
                    continue;
                }
                int col = 0;
                ncs[col++].addStr(result._model.toString());
                ncs[col++].addNum(result._status.ordinal());
                if (result._errors != null) {
                    ncs[col++].addStr(String.join((CharSequence)"\n", result._errors));
                } else {
                    ncs[col++].addNA();
                }
                if (result._warns != null) {
                    ncs[col++].addStr(String.join((CharSequence)"\n", result._warns));
                } else {
                    ncs[col++].addNA();
                }
                assert (col == ncs.length);
            }
        }
    }

    private static class MakeResultKeys
    extends MRTask<MakeResultKeys> {
        private MakeResultKeys() {
        }

        @Override
        public void map(Chunk[] cs, NewChunk nc) {
            for (int i2 = 0; i2 < cs[0]._len; ++i2) {
                nc.addStr(Key.makeUserHidden(Key.make().toString()).toString());
            }
        }
    }

    static class SegmentModelResult
    extends Keyed<SegmentModelResult> {
        final Key<Model> _model;
        final Job.JobStatus _status;
        final String[] _errors;
        final String[] _warns;

        SegmentModelResult(Key<SegmentModelResult> selfKey, ModelBuilder mb, Exception e2) {
            this(selfKey, mb.dest(), mb._job.getStatus(), SegmentModelResult.getErrors(mb, e2), mb._job.warns());
        }

        SegmentModelResult(Key<SegmentModelResult> key, Key<Model> model, Job.JobStatus status, String[] errors, String[] warns) {
            super(key);
            this._model = model;
            this._status = status;
            this._errors = errors;
            this._warns = warns;
        }

        private static String[] getErrors(ModelBuilder mb, Exception e2) {
            if (mb.error_count() == 0 && e2 == null) {
                return null;
            }
            String[] errors = new String[]{};
            if (mb.error_count() > 0) {
                errors = ArrayUtils.append(errors, mb.validationErrors());
            }
            if (e2 != null) {
                errors = ArrayUtils.append(errors, StringUtils.toString(e2));
            }
            return errors;
        }

        public boolean isSuccessful() {
            return this._status == Job.JobStatus.SUCCEEDED;
        }

        public String toString() {
            return "model=" + this._model + ", status=" + (Object)((Object)this._status);
        }
    }
}

