/*
 * Decompiled with CFR 0.152.
 */
package hex.splitframe;

import java.util.Random;
import water.DKV;
import water.Futures;
import water.Key;
import water.MRTask;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.MathUtils;

public class ShuffleSplitFrame {
    public static Frame[] shuffleSplitFrame(Frame fr, Key<Frame>[] keys, final double[] ratios, final long seed) {
        assert (keys.length == ratios.length);
        double sum = ratios[0];
        for (int i2 = 1; i2 < ratios.length; ++i2) {
            ratios[i2] = sum += ratios[i2];
        }
        assert (MathUtils.equalsWithinOneSmallUlp(sum, 1.0));
        byte[] types2 = fr.types();
        final int ncols = fr.numCols();
        byte[] alltypes = new byte[ncols * ratios.length];
        for (int i3 = 0; i3 < ratios.length; ++i3) {
            System.arraycopy(types2, 0, alltypes, i3 * ncols, ncols);
        }
        Object mr = new MRTask(){

            @Override
            public void map(Chunk[] cs, NewChunk[] ncs) {
                Random rng = new Random(seed * (long)cs[0].cidx());
                int nrows = cs[0]._len;
                for (int i2 = 0; i2 < nrows; ++i2) {
                    int x2;
                    double r2 = rng.nextDouble();
                    for (x2 = 0; x2 < ratios.length - 1 && !(r2 < ratios[x2]); ++x2) {
                    }
                    x2 *= ncols;
                    block8: for (int j2 = 0; j2 < ncols; ++j2) {
                        byte colType = cs[j2].vec().get_type();
                        switch (colType) {
                            case 0: {
                                continue block8;
                            }
                            case 2: {
                                ncs[x2 + j2].addStr(cs[j2], i2);
                                continue block8;
                            }
                            case 1: {
                                ncs[x2 + j2].addUUID(cs[j2], i2);
                                continue block8;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                ncs[x2 + j2].addNum(cs[j2].atd(i2));
                                continue block8;
                            }
                            default: {
                                throw new IllegalArgumentException("Unsupported vector type: " + colType);
                            }
                        }
                    }
                }
            }
        }.doAll(alltypes, fr);
        Frame[] frames = new Frame[ratios.length];
        Vec[] vecs = fr.vecs();
        String[] names = fr.names();
        Futures fs = new Futures();
        for (int i4 = 0; i4 < ratios.length; ++i4) {
            Vec[] nvecs = new Vec[ncols];
            int rowLayout = ((MRTask)mr).appendables()[i4 * ncols].compute_rowLayout();
            for (int c2 = 0; c2 < ncols; ++c2) {
                AppendableVec av = ((MRTask)mr).appendables()[i4 * ncols + c2];
                av.setDomain(vecs[c2].domain());
                nvecs[c2] = av.close(rowLayout, fs);
            }
            frames[i4] = new Frame(keys[i4], fr.names(), nvecs);
            DKV.put(frames[i4], fs);
        }
        fs.blockForPending();
        return frames;
    }
}

