/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.CompressedTree;
import water.DKV;
import water.Iced;
import water.Key;

public class CompressedForest
extends Iced<CompressedTree> {
    public final Key<CompressedTree>[][] _treeKeys;
    public final String[][] _domains;

    public CompressedForest(Key<CompressedTree>[][] treeKeys, String[][] domains) {
        this._treeKeys = treeKeys;
        this._domains = domains;
    }

    public final int ntrees() {
        return this._treeKeys.length;
    }

    public final LocalCompressedForest fetch() {
        int ntrees = this._treeKeys.length;
        CompressedTree[][] trees = new CompressedTree[ntrees][];
        for (int t2 = 0; t2 < ntrees; ++t2) {
            Key<CompressedTree>[] treek = this._treeKeys[t2];
            trees[t2] = new CompressedTree[treek.length];
            for (int i2 = 0; i2 < treek.length; ++i2) {
                if (treek[i2] == null) continue;
                trees[t2][i2] = (CompressedTree)DKV.get(treek[i2]).get();
            }
        }
        return new LocalCompressedForest(trees, this._domains);
    }

    public static class LocalCompressedForest {
        public CompressedTree[][] _trees;
        public String[][] _domains;

        private LocalCompressedForest(CompressedTree[][] trees, String[][] domains) {
            this._trees = trees;
            this._domains = domains;
        }

        public final void scoreTree(double[] data, double[] preds, int tidx) {
            CompressedTree[] ts = this._trees[tidx];
            for (int c2 = 0; c2 < ts.length; ++c2) {
                if (ts[c2] == null) continue;
                int n2 = ts.length == 1 ? 0 : c2 + 1;
                preds[n2] = preds[n2] + ts[c2].score(data, this._domains);
            }
        }
    }
}

