/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Distribution;
import hex.genmodel.utils.DistributionFamily;
import hex.tree.BranchInteractionConstraints;
import hex.tree.CompressedTree;
import hex.tree.Constraints;
import hex.tree.DHistogram;
import hex.tree.GlobalInteractionConstraints;
import hex.tree.GuidedSplitPoints;
import hex.tree.SharedTreeModel;
import hex.tree.uplift.Divergence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import jsr166y.ForkJoinTask;
import jsr166y.RecursiveAction;
import org.apache.log4j.Logger;
import water.AutoBuffer;
import water.H2O;
import water.Iced;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.IcedBitSet;
import water.util.MathUtils;
import water.util.RandomBase;
import water.util.RandomUtils;
import water.util.StringUtils;

public class DTree
extends Iced {
    private static final Logger LOG = Logger.getLogger(DTree.class);
    final String[] _names;
    final int _ncols;
    final long _seed;
    private Node[] _ns;
    public int _len;
    public int _leaves;
    public int _depth;
    public final int _mtrys;
    public final int _mtrys_per_tree;
    public final transient Random _rand;
    public final transient int[] _cols;
    public transient SharedTreeModel.SharedTreeParameters _parms;
    public static final int NO_PARENT = -1;
    public transient AutoBuffer _abAux;

    public int actual_mtries() {
        return Math.min(Math.max(1, (int)((double)this._mtrys * Math.pow(this._parms._col_sample_rate_change_per_level, this._depth))), this._ncols);
    }

    public DTree(Frame fr, int ncols, int mtrys, int mtrys_per_tree, long seed, SharedTreeModel.SharedTreeParameters parms) {
        this._names = fr.names();
        this._ncols = ncols;
        this._parms = parms;
        this._ns = new Node[1];
        this._mtrys = mtrys;
        this._mtrys_per_tree = mtrys_per_tree;
        this._seed = seed;
        this._rand = RandomUtils.getRNG(seed);
        int[] activeCols = new int[this._ncols];
        for (int i2 = 0; i2 < activeCols.length; ++i2) {
            activeCols[i2] = i2;
        }
        int len = this._ncols;
        if (mtrys_per_tree < this._ncols) {
            RandomBase colSampleRNG = RandomUtils.getRNG(this._seed * 55930L);
            for (int i3 = 0; i3 < mtrys_per_tree && len != 0; ++i3) {
                int idx2 = colSampleRNG.nextInt(len);
                int col = activeCols[idx2];
                activeCols[idx2] = activeCols[--len];
                activeCols[len] = col;
            }
            activeCols = Arrays.copyOfRange(activeCols, len, activeCols.length);
        }
        this._cols = activeCols;
    }

    public DTree(DTree tree) {
        this._names = tree._names;
        this._ncols = tree._ncols;
        this._parms = tree._parms;
        this._ns = new Node[tree._ns.length];
        for (int i2 = 0; i2 < this._ns.length; ++i2) {
            Node node = tree._ns[i2];
            this._ns[i2] = node instanceof UndecidedNode ? new UndecidedNode((UndecidedNode)node, this) : (node instanceof DecidedNode ? new DecidedNode((DecidedNode)node, this) : (node instanceof LeafNode ? new LeafNode((LeafNode)node, this) : null));
        }
        this._mtrys = tree._mtrys;
        this._mtrys_per_tree = tree._mtrys_per_tree;
        this._seed = tree._seed;
        this._rand = tree._rand;
        this._cols = tree._cols;
        this._leaves = tree._leaves;
        this._len = tree._len;
        this._depth = tree._depth;
    }

    public final Node root() {
        return this._ns[0];
    }

    void init_tree() {
        for (int j2 = 0; j2 < this._len; ++j2) {
            this._ns[j2]._tree = this;
        }
    }

    public final Node node(int i2) {
        return this._ns[i2];
    }

    public final UndecidedNode undecided(int i2) {
        return (UndecidedNode)this.node(i2);
    }

    public final DecidedNode decided(int i2) {
        return (DecidedNode)this.node(i2);
    }

    private synchronized int newIdx(Node n2) {
        if (this._len == this._ns.length) {
            this._ns = Arrays.copyOf(this._ns, this._len << 1);
        }
        this._ns[this._len] = n2;
        return this._len++;
    }

    public final int len() {
        return this._len;
    }

    public static boolean isRootNode(Node n2) {
        return n2._pid == -1;
    }

    public CompressedTree compress(int tid, int cls, String[][] domains) {
        int sz = this.root().size();
        if (this.root() instanceof LeafNode) {
            sz += 3;
        }
        AutoBuffer ab = new AutoBuffer(sz);
        this._abAux = new AutoBuffer();
        if (this.root() instanceof LeafNode) {
            ab.put1(0).put2('\uffff');
        }
        this.root().compress(ab, this._abAux);
        assert (ab.position() == sz);
        return new CompressedTree(ab.buf(), this._seed, tid, cls);
    }

    static Split findBestSplitPoint(DHistogram hs, int col, double min_rows, int constraint, double min2, double max, boolean useBounds, Distribution dist) {
        int off;
        if (hs._vals == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": histogram not filled yet."));
            }
            return null;
        }
        int nbins = hs.nbins();
        assert (nbins >= 1);
        boolean hasPreds = hs.hasPreds();
        boolean hasDenom = hs.hasDenominator();
        boolean hasNomin = hs.hasNominator();
        double[] vals = hs._vals;
        int vals_dim = hs._vals_dim;
        int[] idxs = null;
        if (hs._isInt == 2 && hs._step == 1.0) {
            int i2;
            idxs = MemoryManager.malloc4(nbins + 1);
            for (int i3 = 0; i3 < nbins + 1; ++i3) {
                idxs[i3] = i3;
            }
            double[] avgs = MemoryManager.malloc8d(nbins + 1);
            for (i2 = 0; i2 < nbins; ++i2) {
                avgs[i2] = hs.w(i2) == 0.0 ? -1.7976931348623157E308 : hs.wY(i2) / hs.w(i2);
            }
            avgs[nbins] = Double.MAX_VALUE;
            ArrayUtils.sort(idxs, avgs);
            vals = MemoryManager.malloc8d(vals_dim * nbins);
            for (i2 = 0; i2 < nbins; ++i2) {
                int id = idxs[i2];
                vals[vals_dim * i2 + 0] = hs._vals[vals_dim * id + 0];
                vals[vals_dim * i2 + 1] = hs._vals[vals_dim * id + 1];
                vals[vals_dim * i2 + 2] = hs._vals[vals_dim * id + 2];
                if (hasPreds) {
                    vals[vals_dim * i2 + 3] = hs._vals[vals_dim * id + 3];
                    vals[vals_dim * i2 + 4] = hs._vals[vals_dim * id + 4];
                    if (hasDenom) {
                        vals[vals_dim * i2 + 5] = hs._vals[vals_dim * id + 5];
                    }
                    if (hasNomin) {
                        vals[vals_dim * i2 + 6] = hs._vals[vals_dim * id + 6];
                    }
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)(vals[3 * i2] + " obs have avg response [" + i2 + "]=" + avgs[id]));
            }
        }
        double[] wlo = MemoryManager.malloc8d(nbins + 1);
        double[] wYlo = MemoryManager.malloc8d(nbins + 1);
        double[] wYYlo = MemoryManager.malloc8d(nbins + 1);
        double[] pr1lo = hasPreds ? MemoryManager.malloc8d(nbins + 1) : null;
        double[] pr2lo = hasPreds ? MemoryManager.malloc8d(nbins + 1) : null;
        double[] denlo = hasDenom ? MemoryManager.malloc8d(nbins + 1) : wlo;
        double[] nomlo = hasNomin ? MemoryManager.malloc8d(nbins + 1) : wYlo;
        for (int b2 = 1; b2 <= nbins; ++b2) {
            double d1;
            double d0;
            int id = vals_dim * (b2 - 1);
            double n0 = wlo[b2 - 1];
            double n1 = vals[id + 0];
            if (n0 == 0.0 && n1 == 0.0) continue;
            double m0 = wYlo[b2 - 1];
            double m1 = vals[id + 1];
            double s0 = wYYlo[b2 - 1];
            double s1 = vals[id + 2];
            wlo[b2] = n0 + n1;
            wYlo[b2] = m0 + m1;
            wYYlo[b2] = s0 + s1;
            if (!hasPreds) continue;
            double p10 = pr1lo[b2 - 1];
            double p11 = vals[id + 3];
            double p20 = pr2lo[b2 - 1];
            double p21 = vals[id + 4];
            pr1lo[b2] = p10 + p11;
            pr2lo[b2] = p20 + p21;
            if (hasDenom) {
                d0 = denlo[b2 - 1];
                d1 = vals[id + 5];
                denlo[b2] = d0 + d1;
            }
            if (!hasNomin) continue;
            d0 = nomlo[b2 - 1];
            d1 = vals[id + 6];
            nomlo[b2] = d0 + d1;
        }
        double wNA = hs.wNA();
        double tot = wlo[nbins] + wNA;
        if (tot < 2.0 * min_rows) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": min_rows: total number of observations is " + tot));
            }
            return null;
        }
        double wYNA = hs.wYNA();
        double wYYNA = hs.wYYNA();
        double var = (wYYlo[nbins] + wYYNA) * tot - (wYlo[nbins] + wYNA) * (wYlo[nbins] + wYNA);
        if ((float)var == 0.0f) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": var = 0."));
            }
            return null;
        }
        double denNA = hasDenom ? hs.denNA() : wNA;
        double nomNA = hasNomin ? hs.nomNA() : wYNA;
        double[] whi = MemoryManager.malloc8d(nbins + 1);
        double[] wYhi = MemoryManager.malloc8d(nbins + 1);
        double[] wYYhi = MemoryManager.malloc8d(nbins + 1);
        double[] pr1hi = hasPreds ? MemoryManager.malloc8d(nbins + 1) : null;
        double[] pr2hi = hasPreds ? MemoryManager.malloc8d(nbins + 1) : null;
        double[] denhi = hasDenom ? MemoryManager.malloc8d(nbins + 1) : whi;
        double[] nomhi = hasNomin ? MemoryManager.malloc8d(nbins + 1) : wYhi;
        for (int b3 = nbins - 1; b3 >= 0; --b3) {
            double n0 = whi[b3 + 1];
            double n1 = vals[vals_dim * b3];
            if (n0 == 0.0 && n1 == 0.0) continue;
            double m0 = wYhi[b3 + 1];
            double m1 = vals[vals_dim * b3 + 1];
            double s0 = wYYhi[b3 + 1];
            double s1 = vals[vals_dim * b3 + 2];
            whi[b3] = n0 + n1;
            wYhi[b3] = m0 + m1;
            wYYhi[b3] = s0 + s1;
            if (hasPreds) {
                double d1;
                double d0;
                double p10 = pr1hi[b3 + 1];
                double p11 = vals[vals_dim * b3 + 3];
                double p20 = pr2hi[b3 + 1];
                double p21 = vals[vals_dim * b3 + 4];
                pr1hi[b3] = p10 + p11;
                pr2hi[b3] = p20 + p21;
                if (hasDenom) {
                    d0 = denhi[b3 + 1];
                    d1 = vals[vals_dim * b3 + 5];
                    denhi[b3] = d0 + d1;
                }
                if (hasNomin) {
                    d0 = nomhi[b3 + 1];
                    d1 = vals[vals_dim * b3 + 6];
                    nomhi[b3] = d0 + d1;
                }
            }
            assert (MathUtils.compare(wlo[b3] + whi[b3] + wNA, tot, 1.0E-5, 1.0E-5));
        }
        double best_seL = Double.MAX_VALUE;
        double best_seR = Double.MAX_VALUE;
        DHistogram.NASplitDir nasplit = DHistogram.NASplitDir.None;
        double seNonNA = wYYhi[0] - wYhi[0] * wYhi[0] / whi[0];
        if (seNonNA < 0.0) {
            seNonNA = 0.0;
        }
        double seBefore = seNonNA;
        double nLeft = 0.0;
        double nRight = 0.0;
        double predLeft = 0.0;
        double predRight = 0.0;
        double tree_p0 = 0.0;
        double tree_p1 = 0.0;
        if (wNA >= min_rows) {
            double seAll = wYYhi[0] + wYYNA - (wYhi[0] + wYNA) * (wYhi[0] + wYNA) / (whi[0] + wNA);
            double seNA = wYYNA - wYNA * wYNA / wNA;
            if (seNA < 0.0) {
                seNA = 0.0;
            }
            best_seL = seNonNA;
            best_seR = seNA;
            nasplit = DHistogram.NASplitDir.NAvsREST;
            seBefore = seAll;
            nLeft = whi[0];
            predLeft = wYhi[0];
            nRight = wNA;
            predRight = wYNA;
            if (hasDenom) {
                tree_p0 = nomhi[0] / denhi[0];
                tree_p1 = nomNA / denNA;
            } else {
                tree_p0 = predLeft / nLeft;
                tree_p1 = predRight / nRight;
            }
        }
        int best = 0;
        byte equal = 0;
        for (int b4 = 1; b4 <= nbins - 1; ++b4) {
            double tmpPredRight;
            double tmpPredLeft;
            double quantilePosition;
            double n2;
            int quantileBinRight;
            int quantileBinLeft;
            double sehi;
            double selo;
            if (vals[vals_dim * b4] == 0.0 || wlo[b4] + wNA < min_rows) continue;
            if (whi[b4] + wNA < min_rows) break;
            if (wNA == 0.0) {
                selo = wYYlo[b4] - wYlo[b4] * wYlo[b4] / wlo[b4];
                sehi = wYYhi[b4] - wYhi[b4] * wYhi[b4] / whi[b4];
                if (selo < 0.0) {
                    selo = 0.0;
                }
                if (sehi < 0.0) {
                    sehi = 0.0;
                }
                if (!(selo + sehi < best_seL + best_seR) && (selo + sehi != best_seL + best_seR || Math.abs(b4 - (nbins >> 1)) >= Math.abs(best - (nbins >> 1)))) continue;
                if (constraint != 0 && dist._family.equals((Object)DistributionFamily.quantile)) {
                    quantileBinLeft = 0;
                    quantileBinRight = 0;
                    for (int bin = 1; bin <= nbins; ++bin) {
                        if (bin <= b4) {
                            n2 = wlo[b4];
                            quantilePosition = dist._quantileAlpha * n2;
                            if (!(quantilePosition < wlo[bin])) continue;
                            quantileBinLeft = bin;
                            bin = b4 + 1;
                            continue;
                        }
                        n2 = wlo[nbins] - wlo[b4];
                        quantilePosition = dist._quantileAlpha * n2;
                        if (!(quantilePosition < wlo[bin] - wlo[b4])) continue;
                        quantileBinRight = bin;
                        break;
                    }
                    tmpPredLeft = wYlo[quantileBinLeft];
                    tmpPredRight = wYlo[quantileBinRight] - wYlo[b4];
                } else {
                    tmpPredLeft = hasDenom ? nomlo[b4] / denlo[b4] : wYlo[b4] / wlo[b4];
                    double d2 = tmpPredRight = hasDenom ? nomhi[b4] / denhi[b4] : wYhi[b4] / whi[b4];
                }
                if (constraint != 0 && !((double)constraint * tmpPredLeft <= (double)constraint * tmpPredRight)) continue;
                best_seL = selo;
                best_seR = sehi;
                best = b4;
                nLeft = wlo[best];
                nRight = whi[best];
                predLeft = wYlo[best];
                predRight = wYhi[best];
                tree_p0 = tmpPredLeft;
                tree_p1 = tmpPredRight;
                continue;
            }
            selo = wYYlo[b4] + wYYNA - (wYlo[b4] + wYNA) * (wYlo[b4] + wYNA) / (wlo[b4] + wNA);
            sehi = wYYhi[b4] - wYhi[b4] * wYhi[b4] / whi[b4];
            if (selo < 0.0) {
                selo = 0.0;
            }
            if (sehi < 0.0) {
                sehi = 0.0;
            }
            if ((selo + sehi < best_seL + best_seR || selo + sehi == best_seL + best_seR && Math.abs(b4 - (nbins >> 1)) < Math.abs(best - (nbins >> 1))) && wlo[b4] + wNA >= min_rows && whi[b4] >= min_rows) {
                if (constraint != 0 && dist._family.equals((Object)DistributionFamily.quantile)) {
                    quantileBinLeft = 0;
                    quantileBinRight = 0;
                    for (int bin = 1; bin <= nbins; ++bin) {
                        if (bin <= b4) {
                            n2 = wlo[b4];
                            quantilePosition = dist._quantileAlpha * n2;
                            if (!(quantilePosition < wlo[bin])) continue;
                            quantileBinLeft = bin;
                            bin = b4 + 1;
                            continue;
                        }
                        n2 = wlo[nbins] - wlo[b4];
                        quantilePosition = dist._quantileAlpha * n2;
                        if (!(quantilePosition < wlo[bin] - wlo[b4])) continue;
                        quantileBinRight = bin;
                        break;
                    }
                    tmpPredLeft = wYlo[quantileBinLeft] + wYNA;
                    tmpPredRight = wYlo[quantileBinRight] - wYlo[b4];
                } else {
                    tmpPredLeft = hasDenom ? (nomlo[b4] + nomNA) / (denlo[b4] + denNA) : (wYlo[b4] + wYNA) / (wlo[b4] + wNA);
                    double d3 = tmpPredRight = hasDenom ? nomhi[b4] / denhi[b4] : wYhi[b4] / whi[b4];
                }
                if (constraint == 0 || (double)constraint * tmpPredLeft <= (double)constraint * tmpPredRight) {
                    best_seL = selo;
                    best_seR = sehi;
                    best = b4;
                    nLeft = wlo[best] + wNA;
                    nRight = whi[best];
                    predLeft = wYlo[best] + wYNA;
                    predRight = wYhi[best];
                    nasplit = DHistogram.NASplitDir.NALeft;
                    tree_p0 = tmpPredLeft;
                    tree_p1 = tmpPredRight;
                }
            }
            selo = wYYlo[b4] - wYlo[b4] * wYlo[b4] / wlo[b4];
            sehi = wYYhi[b4] + wYYNA - (wYhi[b4] + wYNA) * (wYhi[b4] + wYNA) / (whi[b4] + wNA);
            if (selo < 0.0) {
                selo = 0.0;
            }
            if (sehi < 0.0) {
                sehi = 0.0;
            }
            if (!(selo + sehi < best_seL + best_seR) && (selo + sehi != best_seL + best_seR || Math.abs(b4 - (nbins >> 1)) >= Math.abs(best - (nbins >> 1))) || !(wlo[b4] >= min_rows) || !(whi[b4] + wNA >= min_rows)) continue;
            if (constraint != 0 && dist._family.equals((Object)DistributionFamily.quantile)) {
                quantileBinLeft = 0;
                quantileBinRight = 0;
                double ratio = 1.0;
                double delta = 1.0;
                for (int bin = 1; bin <= nbins; ++bin) {
                    double quantilePosition2;
                    double n3;
                    if (bin <= b4) {
                        n3 = wlo[b4];
                        quantilePosition2 = dist._quantileAlpha * n3;
                        if (!(quantilePosition2 < wlo[bin])) continue;
                        quantileBinLeft = bin;
                        bin = b4 + 1;
                        continue;
                    }
                    n3 = wlo[nbins] - wlo[b4];
                    quantilePosition2 = dist._quantileAlpha * n3;
                    if (!(quantilePosition2 < wlo[bin] - wlo[b4])) continue;
                    quantileBinRight = bin;
                    break;
                }
                tmpPredLeft = wYlo[quantileBinLeft];
                tmpPredRight = wYlo[quantileBinRight] - wYlo[b4] + wYNA;
            } else {
                tmpPredLeft = hasDenom ? nomlo[b4] / denlo[b4] : wYlo[b4] / wlo[b4];
                double d4 = tmpPredRight = hasDenom ? (nomhi[b4] + nomNA) / (denhi[b4] + denNA) : (wYhi[b4] + wYNA) / (whi[b4] + wNA);
            }
            if (constraint != 0 && !((double)constraint * tmpPredLeft <= (double)constraint * tmpPredRight)) continue;
            best_seL = selo;
            best_seR = sehi;
            best = b4;
            nLeft = wlo[best];
            nRight = whi[best] + wNA;
            predLeft = wYlo[best];
            predRight = wYhi[best] + wYNA;
            nasplit = DHistogram.NASplitDir.NARight;
            tree_p0 = tmpPredLeft;
            tree_p1 = tmpPredRight;
        }
        if (best == 0 && nasplit == DHistogram.NASplitDir.None) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": no optimal split found:\n" + hs));
            }
            return null;
        }
        if (!(best_seL + best_seR < seBefore * (1.0 - hs._minSplitImprovement))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": not enough relative improvement: " + (1.0 - (best_seL + best_seR) / seBefore) + "\n" + hs));
            }
            return null;
        }
        assert (Math.abs(tot - (nRight + nLeft)) < 1.0E-5 * tot);
        if (MathUtils.equalsWithinOneSmallUlp((float)(predLeft / nLeft), (float)(predRight / nRight))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": Predictions for left/right are the same."));
            }
            return null;
        }
        if (nLeft < min_rows || nRight < min_rows) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": split would violate min_rows limit."));
            }
            return null;
        }
        double node_p0 = predLeft / nLeft;
        double node_p1 = predRight / nRight;
        if (constraint != 0 && (double)constraint * tree_p0 > (double)constraint * tree_p1) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": split would violate monotone constraint."));
            }
            return null;
        }
        if (!Double.isNaN(min2)) {
            if (tree_p0 < min2) {
                if (!useBounds) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("minimum constraint violated in the left split of " + hs._name + ": node will not split"));
                    }
                    return null;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("minimum constraint violated in the left split of " + hs._name + ": left node will predict minimum bound: " + min2));
                }
                tree_p0 = min2;
                best_seL = nasplit == DHistogram.NASplitDir.NAvsREST ? pr1hi[0] : (nasplit == DHistogram.NASplitDir.NALeft ? pr1lo[best] + hs.seP1NA() : pr1lo[best]);
            }
            if (tree_p1 < min2) {
                if (!useBounds) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("minimum constraint violated in the right split of " + hs._name + ": node will not split"));
                    }
                    return null;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("minimum constraint violated in the right split of " + hs._name + ": right node will predict minimum bound: " + min2));
                }
                tree_p1 = min2;
                best_seR = nasplit == DHistogram.NASplitDir.NAvsREST ? hs.seP1NA() : (nasplit == DHistogram.NASplitDir.NARight ? pr1hi[best] + hs.seP1NA() : pr1hi[best]);
            }
        }
        if (!Double.isNaN(max)) {
            if (tree_p0 > max) {
                if (!useBounds) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("minimum constraint violated in the left split of " + hs._name + ": node will not split"));
                    }
                    return null;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("maximum constraint violated in the left split of " + hs._name + ": left node will predict maximum bound: " + max));
                }
                tree_p0 = max;
                best_seL = nasplit == DHistogram.NASplitDir.NAvsREST ? pr2hi[0] : (nasplit == DHistogram.NASplitDir.NALeft ? pr2lo[best] + hs.seP2NA() : pr2lo[best]);
            }
            if (tree_p1 > max) {
                if (!useBounds) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("minimum constraint violated in the right split of " + hs._name + ": node will not split"));
                    }
                    return null;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("maximum constraint violated in the right split of " + hs._name + ": right node will predict maximum bound: " + max));
                }
                tree_p1 = max;
                best_seR = nasplit == DHistogram.NASplitDir.NAvsREST ? hs.seP2NA() : (nasplit == DHistogram.NASplitDir.NARight ? pr2hi[best] + hs.seP2NA() : pr2hi[best]);
            }
        }
        if (!(best_seL + best_seR < seBefore * (1.0 - hs._minSplitImprovement))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": not enough relative improvement: " + (1.0 - (best_seL + best_seR) / seBefore) + "\n" + hs));
            }
            return null;
        }
        if (MathUtils.equalsWithinOneSmallUlp((float)tree_p0, (float)tree_p1)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": Predictions for left/right are the same."));
            }
            return null;
        }
        IcedBitSet bs = null;
        if (idxs != null && nasplit != DHistogram.NASplitDir.NAvsREST && (equal = DTree.fillBitSet(hs, off = (int)hs._min, idxs, best, nbins, bs = new IcedBitSet(nbins, off))) < 0) {
            return null;
        }
        if (nasplit == DHistogram.NASplitDir.None) {
            DHistogram.NASplitDir nASplitDir = nasplit = nLeft > nRight ? DHistogram.NASplitDir.Left : DHistogram.NASplitDir.Right;
        }
        assert (constraint == 0 || (double)constraint * tree_p0 <= (double)constraint * tree_p1);
        assert ((Double.isNaN(min2) || min2 <= tree_p0) && (Double.isNaN(max) || tree_p0 <= max));
        assert ((Double.isNaN(min2) || min2 <= tree_p1) && (Double.isNaN(max) || tree_p1 <= max));
        Split split2 = new Split(col, best, nasplit, bs, equal, seBefore, best_seL, best_seR, nLeft, nRight, node_p0, node_p1, tree_p0, tree_p1);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("splitting on " + hs._name + ": " + split2));
        }
        return split2;
    }

    static Split findBestSplitPointUplift(DHistogram hs, int col, double min_rows) {
        int off;
        if (hs._valsUplift == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": histogram not filled yet."));
            }
            return null;
        }
        int nbins = hs.nbins();
        assert (nbins >= 1);
        Divergence upliftMetric = hs._upliftMetric;
        double[] vals = hs._vals;
        int vals_dim = hs._vals_dim;
        double[] valsUplift = hs._valsUplift;
        int valsUpliftDim = 4;
        int[] idxs = null;
        if (hs._isInt == 2 && hs._step == 1.0) {
            int i2;
            idxs = MemoryManager.malloc4(nbins + 1);
            for (int i3 = 0; i3 < nbins + 1; ++i3) {
                idxs[i3] = i3;
            }
            double[] avgs = MemoryManager.malloc8d(nbins + 1);
            for (i2 = 0; i2 < nbins; ++i2) {
                avgs[i2] = hs.w(i2) == 0.0 ? -1.7976931348623157E308 : hs.wY(i2) / hs.w(i2);
            }
            avgs[nbins] = Double.MAX_VALUE;
            ArrayUtils.sort(idxs, avgs);
            vals = MemoryManager.malloc8d(vals_dim * nbins);
            valsUplift = MemoryManager.malloc8d(4 * nbins);
            for (i2 = 0; i2 < nbins; ++i2) {
                int id = idxs[i2];
                vals[vals_dim * i2 + 0] = hs._vals[vals_dim * id + 0];
                vals[vals_dim * i2 + 1] = hs._vals[vals_dim * id + 1];
                vals[vals_dim * i2 + 2] = hs._vals[vals_dim * id + 2];
                valsUplift[4 * i2] = valsUplift[4 * id];
                valsUplift[4 * i2 + 1] = valsUplift[4 * id + 1];
                valsUplift[4 * i2 + 2] = valsUplift[4 * id + 2];
                valsUplift[4 * i2 + 3] = valsUplift[4 * id + 3];
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)(vals[3 * i2] + " obs have avg response [" + i2 + "]=" + avgs[id]));
            }
        }
        double[] wlo = MemoryManager.malloc8d(nbins + 1);
        double[] wYlo = MemoryManager.malloc8d(nbins + 1);
        double[] wYYlo = MemoryManager.malloc8d(nbins + 1);
        double[] numloTreat = MemoryManager.malloc8d(nbins + 1);
        double[] resploTreat = MemoryManager.malloc8d(nbins + 1);
        double[] numloContr = MemoryManager.malloc8d(nbins + 1);
        double[] resploContr = MemoryManager.malloc8d(nbins + 1);
        for (int b2 = 1; b2 <= nbins; ++b2) {
            int id = vals_dim * (b2 - 1);
            double n0 = wlo[b2 - 1];
            double n1 = vals[id + 0];
            if (n0 == 0.0 && n1 == 0.0) continue;
            double m0 = wYlo[b2 - 1];
            double m1 = vals[id + 1];
            double s0 = wYYlo[b2 - 1];
            double s1 = vals[id + 2];
            wlo[b2] = n0 + n1;
            wYlo[b2] = m0 + m1;
            wYYlo[b2] = s0 + s1;
            id = 4 * (b2 - 1);
            double nt0 = numloTreat[b2 - 1];
            double nt1 = valsUplift[id];
            numloTreat[b2] = nt0 + nt1;
            double dt0 = resploTreat[b2 - 1];
            double dt1 = valsUplift[id + 1];
            resploTreat[b2] = dt0 + dt1;
            double nc0 = numloContr[b2 - 1];
            double nc1 = valsUplift[id + 2];
            numloContr[b2] = nc0 + nc1;
            double dc0 = resploContr[b2 - 1];
            double dc1 = valsUplift[id + 3];
            resploContr[b2] = dc0 + dc1;
        }
        double wNA = hs.wNA();
        double tot = wlo[nbins] + wNA;
        if (tot < 2.0 * min_rows) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": min_rows: total number of observations is " + tot));
            }
            return null;
        }
        double wYNA = hs.wYNA();
        double wYYNA = hs.wYYNA();
        double var = (wYYlo[nbins] + wYYNA) * tot - (wYlo[nbins] + wYNA) * (wYlo[nbins] + wYNA);
        if ((float)var == 0.0f) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": var = 0."));
            }
            return null;
        }
        double[] whi = MemoryManager.malloc8d(nbins + 1);
        double[] wYhi = MemoryManager.malloc8d(nbins + 1);
        double[] wYYhi = MemoryManager.malloc8d(nbins + 1);
        double[] numhiTreat = MemoryManager.malloc8d(nbins + 1);
        double[] resphiTreat = MemoryManager.malloc8d(nbins + 1);
        double[] numhiContr = MemoryManager.malloc8d(nbins + 1);
        double[] resphiContr = MemoryManager.malloc8d(nbins + 1);
        for (int b3 = nbins - 1; b3 >= 0; --b3) {
            int id = vals_dim * b3;
            double n0 = whi[b3 + 1];
            double n1 = vals[id];
            if (n0 == 0.0 && n1 == 0.0) continue;
            double m0 = wYhi[b3 + 1];
            double m1 = vals[id + 1];
            double s0 = wYYhi[b3 + 1];
            double s1 = vals[id + 2];
            whi[b3] = n0 + n1;
            wYhi[b3] = m0 + m1;
            wYYhi[b3] = s0 + s1;
            id = 4 * b3;
            double nt0 = numhiTreat[b3 + 1];
            double nt1 = valsUplift[id];
            numhiTreat[b3] = nt0 + nt1;
            double dt0 = resphiTreat[b3 + 1];
            double dt1 = valsUplift[id + 1];
            resphiTreat[b3] = dt0 + dt1;
            double nc0 = numhiContr[b3 + 1];
            double nc1 = valsUplift[id + 2];
            numhiContr[b3] = nc0 + nc1;
            double dc0 = resphiContr[b3 + 1];
            double dc1 = valsUplift[id + 3];
            resphiContr[b3] = dc0 + dc1;
            assert (MathUtils.compare(wlo[b3] + whi[b3] + wNA, tot, 1.0E-5, 1.0E-5));
        }
        double best_seL = Double.MAX_VALUE;
        double best_seR = Double.MAX_VALUE;
        DHistogram.NASplitDir nasplit = DHistogram.NASplitDir.None;
        double seNonNA = wYYhi[0] - wYhi[0] * wYhi[0] / whi[0];
        if (seNonNA < 0.0) {
            seNonNA = 0.0;
        }
        double seBefore = seNonNA;
        double nLeft = 0.0;
        double nRight = 0.0;
        double predLeft = 0.0;
        double predRight = 0.0;
        double tree_p0 = 0.0;
        double tree_p1 = 0.0;
        double numTreatNA = hs.numTreatmentNA();
        double respTreatNA = hs.respTreatmentNA();
        double numContrNA = hs.numControlNA();
        double respContrNA = hs.respControlNA();
        double bestNLCT1 = 0.0;
        double bestNLCT0 = 0.0;
        double bestNRCT1 = 0.0;
        double bestNRCT0 = 0.0;
        double bestPrLY1CT1 = 0.0;
        double bestPrLY1CT0 = 0.0;
        double bestPrRY1CT1 = 0.0;
        double bestPrRY1CT0 = 0.0;
        double nCT1 = numhiTreat[0];
        double nCT0 = numhiContr[0];
        double prY1CT1 = resphiTreat[0] / nCT1;
        double prY1CT0 = resphiContr[0] / nCT0;
        double bestUpliftGain = upliftMetric.node(prY1CT1, prY1CT0);
        if (wNA >= min_rows) {
            double prCT1All = (nCT1 + numTreatNA + 1.0) / (nCT0 + numContrNA + nCT1 + numTreatNA + 2.0);
            double prCT0All = 1.0 - prCT1All;
            double prY1CT1All = (resphiTreat[0] + respTreatNA) / (nCT1 + numTreatNA);
            double prY1CT0All = (resphiContr[0] + respContrNA) / (nCT0 + numContrNA);
            double prLCT1 = (nCT1 + 1.0) / (nCT0 + nCT1 + 2.0);
            double prLCT0 = 1.0 - prLCT1;
            double prL = prLCT1 * prCT1All + prLCT0 * prCT0All;
            double prR = 1.0 - prL;
            double nLCT1 = numhiTreat[0];
            double nLCT0 = numhiContr[0];
            double prLY1CT1 = (resphiTreat[0] + 1.0) / (numhiTreat[0] + 2.0);
            double prLY1CT0 = (resphiContr[0] + 1.0) / (numhiContr[0] + 2.0);
            double nRCT1 = numTreatNA;
            double nRCT0 = numContrNA;
            double prRY1CT1 = (respTreatNA + 1.0) / (numTreatNA + 2.0);
            double prRY1CT0 = (respContrNA + 1.0) / (numContrNA + 2.0);
            bestUpliftGain = upliftMetric.value(prY1CT1All, prY1CT0All, prL, prLY1CT1, prLY1CT0, prR, prRY1CT1, prRY1CT0, prCT1All, prCT0All, prLCT1, prLCT0);
            bestNLCT1 = nLCT1;
            bestNLCT0 = nLCT0;
            bestNRCT1 = nRCT1;
            bestNRCT0 = nRCT0;
            bestPrLY1CT1 = prLY1CT1;
            bestPrLY1CT0 = prLY1CT0;
            bestPrRY1CT1 = prRY1CT1;
            bestPrRY1CT0 = prRY1CT0;
            double seAll = wYYhi[0] + wYYNA - (wYhi[0] + wYNA) * (wYhi[0] + wYNA) / (whi[0] + wNA);
            double seNA = wYYNA - wYNA * wYNA / wNA;
            if (seNA < 0.0) {
                seNA = 0.0;
            }
            best_seL = seNonNA;
            best_seR = seNA;
            nasplit = DHistogram.NASplitDir.NAvsREST;
            seBefore = seAll;
            nLeft = whi[0];
            predLeft = wYhi[0];
            nRight = wNA;
            predRight = wYNA;
            tree_p0 = predLeft / nLeft;
            tree_p1 = predRight / nRight;
        }
        int best = 0;
        byte equal = 0;
        for (int b4 = 1; b4 <= nbins - 1; ++b4) {
            double tmpPredRight;
            double tmpPredLeft;
            double upliftGain;
            double prRY1CT0;
            double prRY1CT1;
            double nRCT0;
            double nRCT1;
            double prLY1CT0;
            double prLY1CT1;
            double nLCT0;
            double nLCT1;
            double prR;
            double prL;
            double prLCT0;
            double prLCT1;
            double prCT0;
            double prCT1;
            double sehi;
            double selo;
            if (vals[vals_dim * b4] == 0.0 || wlo[b4] + wNA < min_rows) continue;
            if (whi[b4] + wNA < min_rows) break;
            if (wNA == 0.0) {
                selo = wYYlo[b4] - wYlo[b4] * wYlo[b4] / wlo[b4];
                sehi = wYYhi[b4] - wYhi[b4] * wYhi[b4] / whi[b4];
                if (selo < 0.0) {
                    selo = 0.0;
                }
                if (sehi < 0.0) {
                    sehi = 0.0;
                }
                nCT1 = numhiTreat[b4];
                nCT0 = numhiContr[b4];
                prCT1 = (nCT1 + 1.0) / (nCT0 + nCT1 + 2.0);
                prCT0 = 1.0 - prCT1;
                prLCT1 = (numloTreat[b4] + 1.0) / (numloTreat[b4] + numhiTreat[b4] + 2.0);
                prLCT0 = 1.0 - prLCT1;
                prL = prLCT1 * prCT1 + prLCT0 * prCT0;
                prR = 1.0 - prL;
                nLCT1 = numloTreat[b4];
                nLCT0 = numloContr[b4];
                prLY1CT1 = (resploTreat[b4] + 1.0) / (numloTreat[b4] + 2.0);
                prLY1CT0 = (resploContr[b4] + 1.0) / (numloContr[b4] + 2.0);
                nRCT1 = numhiTreat[b4];
                nRCT0 = numhiContr[b4];
                prRY1CT1 = (resphiTreat[b4] + 1.0) / (numhiTreat[b4] + 2.0);
                prRY1CT0 = (resphiContr[b4] + 1.0) / (numhiContr[b4] + 2.0);
                upliftGain = upliftMetric.value(prY1CT1, prY1CT0, prL, prLY1CT1, prLY1CT0, prR, prRY1CT1, prRY1CT0, prCT1, prCT0, prLCT1, prLCT0);
                if (!(upliftGain > bestUpliftGain)) continue;
                tmpPredLeft = wYlo[b4] / wlo[b4];
                tmpPredRight = wYhi[b4] / whi[b4];
                best_seL = selo;
                best_seR = sehi;
                best = b4;
                nLeft = wlo[best];
                nRight = whi[best];
                predLeft = wYlo[best];
                predRight = wYhi[best];
                tree_p0 = tmpPredLeft;
                tree_p1 = tmpPredRight;
                bestUpliftGain = upliftGain;
                bestNLCT1 = nLCT1;
                bestNLCT0 = nLCT0;
                bestNRCT1 = nRCT1;
                bestNRCT0 = nRCT0;
                bestPrLY1CT1 = prLY1CT1;
                bestPrLY1CT0 = prLY1CT0;
                bestPrRY1CT1 = prRY1CT1;
                bestPrRY1CT0 = prRY1CT0;
                continue;
            }
            selo = wYYlo[b4] + wYYNA - (wYlo[b4] + wYNA) * (wYlo[b4] + wYNA) / (wlo[b4] + wNA);
            sehi = wYYhi[b4] - wYhi[b4] * wYhi[b4] / whi[b4];
            if (selo < 0.0) {
                selo = 0.0;
            }
            if (sehi < 0.0) {
                sehi = 0.0;
            }
            nCT1 = numhiTreat[b4] + numTreatNA;
            nCT0 = numhiContr[b4] + numContrNA;
            prCT1 = (nCT1 + 1.0) / (nCT0 + nCT1 + 2.0);
            prCT0 = 1.0 - prCT1;
            prLCT1 = (numloTreat[b4] + numTreatNA + 1.0) / (numloTreat[b4] + numTreatNA + numhiTreat[b4] + 2.0);
            prLCT0 = 1.0 - prLCT1;
            prL = prLCT1 * prCT1 + prLCT0 * prCT0;
            prR = 1.0 - prL;
            nLCT1 = numloTreat[b4] + numTreatNA;
            nLCT0 = numloContr[b4] + numContrNA;
            prLY1CT1 = (resploTreat[b4] + respTreatNA + 1.0) / (numloTreat[b4] + numTreatNA + 2.0);
            prLY1CT0 = (resploContr[b4] + respContrNA + 1.0) / (numloContr[b4] + numContrNA + 2.0);
            nRCT1 = numhiTreat[b4];
            nRCT0 = numhiContr[b4];
            prRY1CT1 = (resphiTreat[b4] + 1.0) / (numhiTreat[b4] + 2.0);
            prRY1CT0 = (resphiContr[b4] + 1.0) / (numhiContr[b4] + 2.0);
            upliftGain = upliftMetric.value(prY1CT1, prY1CT0, prL, prLY1CT1, prLY1CT0, prR, prRY1CT1, prRY1CT0, prCT1, prCT0, prLCT1, prLCT0);
            if (upliftGain > bestUpliftGain && wlo[b4] + wNA >= min_rows && whi[b4] >= min_rows) {
                tmpPredLeft = (wYlo[b4] + wYNA) / (wlo[b4] + wNA);
                tmpPredRight = wYhi[b4] / whi[b4];
                best_seL = selo;
                best_seR = sehi;
                best = b4;
                nLeft = wlo[best] + wNA;
                nRight = whi[best];
                predLeft = wYlo[best] + wYNA;
                predRight = wYhi[best];
                nasplit = DHistogram.NASplitDir.NALeft;
                tree_p0 = tmpPredLeft;
                tree_p1 = tmpPredRight;
                bestUpliftGain = upliftGain;
                bestNLCT1 = nLCT1;
                bestNLCT0 = nLCT0;
                bestNRCT1 = nRCT1;
                bestNRCT0 = nRCT0;
                bestPrLY1CT1 = prLY1CT1;
                bestPrLY1CT0 = prLY1CT0;
                bestPrRY1CT1 = prRY1CT1;
                bestPrRY1CT0 = prRY1CT0;
            }
            selo = wYYlo[b4] - wYlo[b4] * wYlo[b4] / wlo[b4];
            sehi = wYYhi[b4] + wYYNA - (wYhi[b4] + wYNA) * (wYhi[b4] + wYNA) / (whi[b4] + wNA);
            if (selo < 0.0) {
                selo = 0.0;
            }
            if (sehi < 0.0) {
                sehi = 0.0;
            }
            nCT1 = numhiTreat[b4] + numTreatNA;
            nCT0 = numhiContr[b4] + numContrNA;
            prCT1 = (nCT1 + 1.0) / (nCT0 + nCT1 + 2.0);
            prCT0 = 1.0 - prCT1;
            prLCT1 = (numloTreat[b4] + 1.0) / (numloTreat[b4] + numhiTreat[0] + numTreatNA + 2.0);
            prLCT0 = 1.0 - prLCT1;
            prL = prLCT1 * prCT1 + prLCT0 * prCT0;
            prR = 1.0 - prL;
            nLCT1 = numloTreat[b4];
            nLCT0 = numloContr[b4];
            prLY1CT1 = (resploTreat[b4] + respTreatNA + 1.0) / (numloTreat[b4] + 2.0);
            prLY1CT0 = (resploContr[b4] + respContrNA + 1.0) / (numloContr[b4] + 2.0);
            nRCT1 = numhiTreat[b4] + numTreatNA;
            nRCT0 = numhiContr[b4] + numContrNA;
            prRY1CT1 = (resphiTreat[b4] + 1.0) / (numhiTreat[b4] + numTreatNA + 2.0);
            prRY1CT0 = (resphiContr[b4] + 1.0) / (numhiContr[b4] + numContrNA + 2.0);
            upliftGain = upliftMetric.value(prY1CT1, prY1CT0, prL, prLY1CT1, prLY1CT0, prR, prRY1CT1, prRY1CT0, prCT1, prCT0, prLCT1, prLCT0);
            if (!(upliftGain > bestUpliftGain) || !(wlo[b4] >= min_rows) || !(whi[b4] + wNA >= min_rows)) continue;
            tmpPredLeft = wYlo[b4] / wlo[b4];
            tmpPredRight = (wYhi[b4] + wYNA) / (whi[b4] + wNA);
            best_seL = selo;
            best_seR = sehi;
            best = b4;
            nLeft = wlo[best];
            nRight = whi[best] + wNA;
            predLeft = wYlo[best];
            predRight = wYhi[best] + wYNA;
            nasplit = DHistogram.NASplitDir.NARight;
            tree_p0 = tmpPredLeft;
            tree_p1 = tmpPredRight;
            bestNLCT1 = nLCT1;
            bestNLCT0 = nLCT0;
            bestNRCT1 = nRCT1;
            bestNRCT0 = nRCT0;
            bestPrLY1CT1 = prLY1CT1;
            bestPrLY1CT0 = prLY1CT0;
            bestPrRY1CT1 = prRY1CT1;
            bestPrRY1CT0 = prRY1CT0;
        }
        if (best == 0 && nasplit == DHistogram.NASplitDir.None) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": no optimal split found:\n" + hs));
            }
            return null;
        }
        if (!(best_seL + best_seR < seBefore * (1.0 - hs._minSplitImprovement))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": not enough relative improvement: " + (1.0 - (best_seL + best_seR) / seBefore) + "\n" + hs));
            }
            return null;
        }
        assert (Math.abs(tot - (nRight + nLeft)) < 1.0E-5 * tot);
        if (MathUtils.equalsWithinOneSmallUlp((float)(predLeft / nLeft), (float)(predRight / nRight))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": Predictions for left/right are the same."));
            }
            return null;
        }
        if (nLeft < min_rows || nRight < min_rows) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": split would violate min_rows limit."));
            }
            return null;
        }
        double node_p0 = predLeft / nLeft;
        double node_p1 = predRight / nRight;
        if (MathUtils.equalsWithinOneSmallUlp((float)tree_p0, (float)tree_p1)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": Predictions for left/right are the same."));
            }
            return null;
        }
        IcedBitSet bs = null;
        if (idxs != null && (equal = DTree.fillBitSet(hs, off = (int)hs._min, idxs, best, nbins, bs = new IcedBitSet(nbins, off))) < 0) {
            return null;
        }
        if (nasplit == DHistogram.NASplitDir.None) {
            nasplit = nLeft > nRight ? DHistogram.NASplitDir.Left : DHistogram.NASplitDir.Right;
        }
        Split split2 = new Split(col, best, nasplit, bs, equal, seBefore, best_seL, best_seR, nLeft, nRight, node_p0, node_p1, tree_p0, tree_p1, bestPrLY1CT1, bestPrLY1CT0, bestPrRY1CT1, bestPrRY1CT0, bestNLCT1, bestNLCT0, bestNRCT1, bestNRCT0);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("splitting on " + hs._name + ": " + split2));
        }
        return split2;
    }

    private static byte fillBitSet(DHistogram hs, int off, int[] idxs, int best, int nbins, IcedBitSet bs) {
        for (int i2 = best; i2 < nbins; ++i2) {
            bs.set(idxs[i2] + off);
        }
        int nonEmptyThatWentRight = 0;
        int nonEmptyThatWentLeft = 0;
        for (int i3 = 0; i3 < nbins; ++i3) {
            if (!(hs.w(i3) > 0.0)) continue;
            if (bs.contains(i3 + off)) {
                ++nonEmptyThatWentRight;
                continue;
            }
            ++nonEmptyThatWentLeft;
        }
        boolean shouldGoLeft = nonEmptyThatWentLeft >= nonEmptyThatWentRight;
        for (int i4 = 0; i4 < nbins; ++i4) {
            assert (bs.isInRange(i4 + off));
            if (hs.w(i4) != 0.0) continue;
            if (bs.contains(i4 + off) && shouldGoLeft) {
                bs.clear(i4 + off);
            }
            if (bs.contains(i4 + off) || shouldGoLeft) continue;
            bs.set(i4 + off);
        }
        if (bs.cardinality() == 0 || bs.cardinality() == bs.size()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("can't split " + hs._name + ": no separation of categoricals possible"));
            }
            return -1;
        }
        return (byte)(bs.max() <= 32 ? 2 : 3);
    }

    public static final class LeafNode
    extends Node {
        public float _pred;

        public LeafNode(DTree tree, int pid) {
            super(tree, pid);
            ++tree._leaves;
        }

        public LeafNode(DTree tree, int pid, int nid) {
            super(tree, pid, nid);
            ++tree._leaves;
        }

        public LeafNode(LeafNode node, DTree tree) {
            super(tree, node._pid, node._nid, true);
            this._pred = node._pred;
        }

        public String toString() {
            return "Leaf#" + this._nid + " = " + this._pred;
        }

        @Override
        public final StringBuilder toString2(StringBuilder sb, int depth) {
            for (int d2 = 0; d2 < depth; ++d2) {
                sb.append("  ");
            }
            sb.append(this._nid).append(" ");
            return sb.append("pred=").append(this._pred).append("\n");
        }

        @Override
        protected AutoBuffer compress(AutoBuffer ab, AutoBuffer abAux) {
            assert (!Double.isNaN(this._pred));
            return ab.put4f(this._pred);
        }

        @Override
        protected int size() {
            return 4;
        }

        @Override
        protected int numNodes() {
            return 0;
        }

        public final double pred() {
            return this._pred;
        }

        public final double getSplitPrediction() {
            DecidedNode parent = (DecidedNode)this._tree.node(this._pid);
            boolean isLeft = parent._nids[0] == this._nid;
            return isLeft ? parent._split._tree_p0 : parent._split._tree_p1;
        }
    }

    public static class DecidedNode
    extends Node {
        public final Split _split;
        public final float _splat;
        public final int[] _nids;
        transient byte _nodeType;
        transient int _size = 0;
        transient int _nnodes = 0;

        public DecidedNode(DecidedNode node, DTree tree) {
            super(tree, node._pid, node._nid, true);
            this._split = node._split;
            this._splat = node._splat;
            this._nids = node._nids;
            this._nodeType = node._nodeType;
            this._size = node._size;
            this._nnodes = node._nnodes;
        }

        public UndecidedNode makeUndecidedNode(DHistogram[] hs, Constraints cs, BranchInteractionConstraints bics) {
            return new UndecidedNode(this._tree, this._nid, hs, cs, bics);
        }

        public Split bestCol(UndecidedNode u2, DHistogram[] hs, Constraints cs) {
            Split best = null;
            if (hs == null) {
                return null;
            }
            int maxCols = u2._scoreCols == null ? hs.length : u2._scoreCols.length;
            ArrayList<FindSplits> findSplits = new ArrayList<FindSplits>();
            long nbinsSum = 0L;
            for (int i2 = 0; i2 < maxCols; ++i2) {
                int col;
                int n2 = col = u2._scoreCols == null ? i2 : u2._scoreCols[i2];
                if (hs[col] == null || hs[col].actNBins() <= 1) continue;
                nbinsSum += (long)hs[col].actNBins();
            }
            boolean isSmall = nbinsSum <= 1024L;
            for (int i3 = 0; i3 < maxCols; ++i3) {
                int col;
                int n3 = col = u2._scoreCols == null ? i3 : u2._scoreCols[i3];
                if (hs[col] == null || hs[col].actNBins() <= 1) continue;
                FindSplits fs = new FindSplits(hs, cs, col, u2._nid);
                findSplits.add(fs);
                if (!isSmall) continue;
                fs.compute();
            }
            if (!isSmall) {
                ForkJoinTask.invokeAll(findSplits);
            }
            for (FindSplits fs : findSplits) {
                float splitAt;
                Split s2 = fs._s;
                if (s2 == null || best != null && !(s2.se() < best.se()) || hs[s2._col]._checkFloatSplits && Float.isNaN(splitAt = s2.splat(hs))) continue;
                best = s2;
            }
            return best;
        }

        public DecidedNode(UndecidedNode n2, DHistogram[] hs, Constraints cs, GlobalInteractionConstraints ics) {
            super(n2._tree, n2._pid, n2._nid);
            this._nids = new int[2];
            this._split = this.bestCol(n2, hs, cs);
            if (this._split == null) {
                this._splat = Float.NaN;
                Arrays.fill(this._nids, -1);
                return;
            }
            this._splat = this._split.splat(hs);
            for (int way = 0; way < 2; ++way) {
                Constraints ncs = cs != null ? this._split.nextLevelConstraints(cs, way, this._splat, this._tree._parms) : null;
                BranchInteractionConstraints nbics = n2._bics != null ? n2._bics.nextLevelInteractionConstraints(ics, this._split._col) : null;
                DHistogram[] nhists = this._split.nextLevelHistos(hs, way, this._splat, this._tree._parms, ncs, nbics);
                assert (nhists == null || nhists.length == this._tree._ncols);
                this._nids[way] = nhists == null ? -1 : this.makeUndecidedNode((DHistogram[])nhists, (Constraints)ncs, (BranchInteractionConstraints)nbics)._nid;
            }
        }

        public int getChildNodeID(Chunk[] chks, int row) {
            double d2 = chks[this._split._col].atd(row);
            int bin = -1;
            boolean isNA = Double.isNaN(d2);
            if (!isNA) {
                if (this._split._nasplit == DHistogram.NASplitDir.NAvsREST) {
                    bin = 0;
                } else if (this._split._equal == 0) {
                    assert (!Float.isNaN(this._splat));
                    bin = d2 >= (double)this._splat ? 1 : 0;
                } else if (this._split._equal >= 2) {
                    int b2 = (int)d2;
                    if (this._split._bs.isInRange(b2)) {
                        bin = this._split._bs.contains(b2) ? 1 : 0;
                    } else {
                        isNA = true;
                    }
                }
            }
            if (isNA) {
                if (this._split._nasplit == DHistogram.NASplitDir.NALeft || this._split._nasplit == DHistogram.NASplitDir.Left) {
                    bin = 0;
                } else if (this._split._nasplit == DHistogram.NASplitDir.NARight || this._split._nasplit == DHistogram.NASplitDir.Right || this._split._nasplit == DHistogram.NASplitDir.NAvsREST) {
                    bin = 1;
                } else if (this._split._nasplit == DHistogram.NASplitDir.None) {
                    bin = 1;
                } else {
                    throw H2O.unimpl();
                }
            }
            return this._nids[bin];
        }

        public double pred(int nid) {
            return nid == 0 ? this._split._p0 : this._split._p1;
        }

        public double predTreatment(int nid) {
            return nid == 0 ? this._split._p0Treat : this._split._p1Treat;
        }

        public double predControl(int nid) {
            return nid == 0 ? this._split._p0Contr : this._split._p1Contr;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DecidedNode:\n");
            sb.append("_nid: " + this._nid + "\n");
            sb.append("_nids (children): " + Arrays.toString(this._nids) + "\n");
            if (this._split != null) {
                sb.append("_split:" + this._split.toString() + "\n");
            }
            sb.append("_splat:" + this._splat + "\n");
            if (this._split == null) {
                sb.append(" col = -1\n");
            } else {
                int col = this._split._col;
                if (this._split._equal == 1) {
                    sb.append(this._tree._names[col] + " != " + this._splat + "\n" + this._tree._names[col] + " == " + this._splat + "\n");
                } else if (this._split._equal == 2 || this._split._equal == 3) {
                    sb.append(this._tree._names[col] + " not in " + this._split._bs.toString() + "\n" + this._tree._names[col] + "  is in " + this._split._bs.toString() + "\n");
                } else {
                    sb.append(this._tree._names[col] + " < " + this._splat + "\n" + this._splat + " >=" + this._tree._names[col] + "\n");
                }
            }
            return sb.toString();
        }

        StringBuilder printChild(StringBuilder sb, int nid) {
            int i2;
            int n2 = i2 = this._nids[0] == nid ? 0 : 1;
            assert (this._nids[i2] == nid) : "No child nid " + nid + "? " + Arrays.toString(this._nids);
            sb.append("[").append(this._tree._names[this._split._col]);
            sb.append(this._split._equal != 0 ? (i2 == 0 ? " != " : " == ") : (i2 == 0 ? " <  " : " >= "));
            sb.append(this._split._equal == 2 || this._split._equal == 3 ? this._split._bs.toString() : Float.valueOf(this._splat)).append("]");
            return sb;
        }

        @Override
        public StringBuilder toString2(StringBuilder sb, int depth) {
            assert (this._nids.length == 2);
            for (int i2 = 0; i2 < this._nids.length; ++i2) {
                for (int d2 = 0; d2 < depth; ++d2) {
                    sb.append("  ");
                }
                sb.append(this._nid).append(" ");
                if (this._split._col < 0) {
                    sb.append("init");
                } else {
                    sb.append(this._tree._names[this._split._col]);
                    if (this._split._nasplit == DHistogram.NASplitDir.NAvsREST) {
                        if (i2 == 0) {
                            sb.append(" not NA");
                        }
                        if (i2 == 1) {
                            sb.append(" is NA");
                        }
                    } else {
                        if (this._split._equal < 2) {
                            if (this._split._nasplit == DHistogram.NASplitDir.NARight || this._split._nasplit == DHistogram.NASplitDir.Right || this._split._nasplit == DHistogram.NASplitDir.None) {
                                sb.append(this._split._equal != 0 ? (i2 == 0 ? " != " : " == ") : (i2 == 0 ? " <  " : " is NA or >= "));
                            }
                            if (this._split._nasplit == DHistogram.NASplitDir.NALeft || this._split._nasplit == DHistogram.NASplitDir.Left) {
                                sb.append(this._split._equal != 0 ? (i2 == 0 ? " is NA or != " : " == ") : (i2 == 0 ? " is NA or <  " : " >= "));
                            }
                        } else {
                            sb.append(i2 == 0 ? " not in " : "  is in ");
                        }
                        sb.append(this._split._equal == 2 || this._split._equal == 3 ? this._split._bs.toString() : Float.valueOf(this._splat)).append("\n");
                    }
                }
                if (this._nids[i2] < 0 || this._nids[i2] >= this._tree._len) continue;
                this._tree.node(this._nids[i2]).toString2(sb, depth + 1);
            }
            return sb;
        }

        @Override
        public final int size() {
            if (this._size != 0) {
                return this._size;
            }
            assert (this._nodeType == 0) : "unexpected node type: " + this._nodeType;
            if (this._split._equal != 0) {
                this._nodeType = (byte)(this._nodeType | (this._split._equal == 1 ? 4 : (this._split._equal == 2 ? 8 : 12)));
            }
            int res = this._split._equal == 3 ? 9 + this._split._bs.numBytes() : 7;
            ++res;
            if (this._split._nasplit == DHistogram.NASplitDir.NAvsREST) {
                assert (this._split._equal == 0);
                res -= 4;
            }
            Node left = this._tree.node(this._nids[0]);
            int lsz = left.size();
            res += lsz;
            if (left instanceof LeafNode) {
                this._nodeType = (byte)(this._nodeType | 0x30);
            } else {
                int slen = lsz < 256 ? 0 : (lsz < 65535 ? 1 : (lsz < 0x1000000 ? 2 : 3));
                this._nodeType = (byte)(this._nodeType | slen);
                res += slen + 1;
            }
            Node right = this._tree.node(this._nids[1]);
            if (right instanceof LeafNode) {
                this._nodeType = (byte)(this._nodeType | 0xFFFFFFC0);
            }
            res += right.size();
            assert ((this._nodeType & 0x33) != 51);
            assert (res != 0);
            this._size = res;
            return this._size;
        }

        @Override
        protected int numNodes() {
            if (this._nnodes > 0) {
                return this._nnodes;
            }
            this._nnodes = 1 + this._tree.node(this._nids[0]).numNodes() + this._tree.node(this._nids[1]).numNodes();
            return this._nnodes;
        }

        @Override
        public AutoBuffer compress(AutoBuffer ab, AutoBuffer abAux) {
            int pos = ab.position();
            if (this._nodeType == 0) {
                this.size();
            }
            ab.put1(this._nodeType);
            assert (this._split != null);
            assert (this._split._col >= 0);
            ab.put2((short)this._split._col);
            ab.put1((byte)this._split._nasplit.value());
            if (this._split._nasplit != DHistogram.NASplitDir.NAvsREST) {
                if (this._split._equal == 0 || this._split._equal == 1) {
                    ab.put4f(this._splat);
                } else if (this._split._equal == 2) {
                    this._split._bs.compress2(ab);
                } else {
                    this._split._bs.compress3(ab);
                }
            }
            if (abAux != null) {
                abAux.put4(this._nid);
                abAux.put4(this._tree.node(this._nids[0]).numNodes());
                abAux.put4f((float)this._split._n0);
                abAux.put4f((float)this._split._n1);
                abAux.put4f((float)this._split._p0);
                abAux.put4f((float)this._split._p1);
                abAux.put4f((float)this._split._se0);
                abAux.put4f((float)this._split._se1);
                abAux.put4(this._nids[0]);
                abAux.put4(this._nids[1]);
            }
            Node left = this._tree.node(this._nids[0]);
            if ((this._nodeType & 0x30) == 0) {
                int sz = left.size();
                if (sz < 256) {
                    ab.put1(sz);
                } else if (sz < 65535) {
                    ab.put2((short)sz);
                } else if (sz < 0x1000000) {
                    ab.put3(sz);
                } else {
                    ab.put4(sz);
                }
            }
            left.compress(ab, abAux);
            Node rite = this._tree.node(this._nids[1]);
            rite.compress(ab, abAux);
            assert (this._size == ab.position() - pos) : "reported size = " + this._size + " , real size = " + (ab.position() - pos);
            return ab;
        }

        public final class FindSplits
        extends RecursiveAction {
            final DHistogram[] _hs;
            final Constraints _cs;
            final int _col;
            final int _nid;
            Split _s;
            final boolean _useUplift;

            public FindSplits(DHistogram[] hs, Constraints cs, int col, UndecidedNode node) {
                this(hs, cs, col, node._nid);
            }

            private FindSplits(DHistogram[] hs, Constraints cs, int col, int nid) {
                this._hs = hs;
                this._cs = cs;
                this._col = col;
                this._nid = nid;
                this._useUplift = this._hs[this._col].useUplift();
            }

            @Override
            public void compute() {
                this.computeSplit();
            }

            public final Split computeSplit() {
                Distribution dist;
                boolean useBounds;
                int constraint;
                double max;
                double min2;
                if (this._cs != null) {
                    min2 = this._cs._min;
                    max = this._cs._max;
                    constraint = this._cs.getColumnConstraint(this._col);
                    useBounds = this._cs.useBounds();
                    dist = this._cs._dist;
                } else {
                    min2 = Double.NaN;
                    max = Double.NaN;
                    constraint = 0;
                    useBounds = false;
                    dist = null;
                }
                this._s = this._useUplift ? DTree.findBestSplitPointUplift(this._hs[this._col], this._col, DecidedNode.this._tree._parms._min_rows) : DTree.findBestSplitPoint(this._hs[this._col], this._col, DecidedNode.this._tree._parms._min_rows, constraint, min2, max, useBounds, dist);
                return this._s;
            }
        }
    }

    public static class UndecidedNode
    extends Node {
        public transient DHistogram[] _hs;
        public transient Constraints _cs;
        public transient BranchInteractionConstraints _bics;
        public final int[] _scoreCols;

        public UndecidedNode(DTree tree, int pid, DHistogram[] hs, Constraints cs, BranchInteractionConstraints bics) {
            super(tree, pid);
            assert (hs.length == tree._ncols);
            this._hs = hs;
            this._cs = cs;
            this._bics = bics;
            this._scoreCols = this.scoreCols();
        }

        public UndecidedNode(UndecidedNode node, DTree tree) {
            super(tree, node._pid, node._nid, true);
            this._hs = node._hs;
            this._cs = node._cs;
            this._bics = node._bics;
            this._scoreCols = node._scoreCols;
        }

        public int[] scoreCols() {
            DTree tree = this._tree;
            if (tree.actual_mtries() == this._hs.length && tree._mtrys_per_tree == this._hs.length) {
                return null;
            }
            int[] activeCols = tree._cols;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("For tree with seed " + tree._seed + ", out of " + this._hs.length + " cols, the following cols are activated via mtry_per_tree=" + tree._mtrys_per_tree + ": " + Arrays.toString(activeCols)));
            }
            int[] cols = new int[activeCols.length];
            int len = 0;
            for (int i2 = 0; i2 < activeCols.length; ++i2) {
                int idx = activeCols[i2];
                assert (idx == i2 || tree._mtrys_per_tree < this._hs.length);
                if (this._hs[idx] == null) continue;
                assert (this._hs[idx]._min < this._hs[idx]._maxEx && this._hs[idx].actNBins() > 1) : "broken histo range " + this._hs[idx];
                cols[len++] = idx;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("These columns can be split: " + Arrays.toString(Arrays.copyOfRange(cols, 0, len))));
            }
            int choices = len;
            int mtries = tree.actual_mtries();
            if (choices > 0) {
                for (int i3 = 0; i3 < mtries && len != 0; ++i3) {
                    int idx2 = tree._rand.nextInt(len);
                    int col = cols[idx2];
                    cols[idx2] = cols[--len];
                    cols[len] = col;
                }
                assert (len < choices);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Picking these (mtry=" + mtries + ") columns to evaluate for splitting: " + Arrays.toString(Arrays.copyOfRange(cols, len, choices))));
            }
            return Arrays.copyOfRange(cols, len, choices);
        }

        public void doNotSplit() {
            if (this._pid == -1) {
                return;
            }
            DecidedNode dn = this._tree.decided(this._pid);
            for (int i2 = 0; i2 < dn._nids.length; ++i2) {
                if (dn._nids[i2] != this._nid) continue;
                dn._nids[i2] = -1;
                return;
            }
            throw H2O.fail();
        }

        public String toString() {
            String colPad = "  ";
            int cntW = 4;
            int mmmW = 4;
            int menW = 5;
            int varW = 5;
            int colW = 26;
            StringBuilder sb = new StringBuilder();
            sb.append("Nid# ").append(this._nid).append(", ");
            this.printLine(sb).append("\n");
            if (this._hs == null) {
                return sb.append("_hs==null").toString();
            }
            for (DHistogram hs : this._hs) {
                if (hs == null) continue;
                UndecidedNode.p(sb, hs._name + String.format(", %4.1f-%4.1f", hs._min, hs._maxEx), 26).append("  ");
            }
            sb.append('\n');
            for (DHistogram hs : this._hs) {
                if (hs == null) continue;
                UndecidedNode.p(sb, "cnt", 4).append('/');
                UndecidedNode.p(sb, "min", 4).append('/');
                UndecidedNode.p(sb, "max", 4).append('/');
                UndecidedNode.p(sb, "mean", 5).append('/');
                UndecidedNode.p(sb, "var", 5).append("  ");
            }
            sb.append('\n');
            int nbins = 0;
            for (DHistogram hs : this._hs) {
                if (hs == null || hs.nbins() <= nbins) continue;
                nbins = hs.nbins();
            }
            for (int i2 = 0; i2 < nbins; ++i2) {
                for (DHistogram h2 : this._hs) {
                    if (h2 == null) continue;
                    if (i2 < h2.nbins() && h2._vals != null) {
                        UndecidedNode.p(sb, h2.bins(i2), 4).append('/');
                        UndecidedNode.p(sb, h2.binAt(i2), 4).append('/');
                        UndecidedNode.p(sb, h2.binAt(i2 + 1), 4).append('/');
                        UndecidedNode.p(sb, h2.mean(i2), 5).append('/');
                        UndecidedNode.p(sb, h2.var(i2), 5).append("  ");
                        continue;
                    }
                    UndecidedNode.p(sb, "", 26).append("  ");
                }
                sb.append('\n');
            }
            sb.append("Nid# ").append(this._nid);
            return sb.toString();
        }

        private static StringBuilder p(StringBuilder sb, String s2, int w2) {
            return sb.append(StringUtils.fixedLength(s2, w2));
        }

        private static StringBuilder p(StringBuilder sb, double d2, int w2) {
            String s2;
            String string = Double.isNaN(d2) ? "NaN" : (d2 == 3.4028234663852886E38 || d2 == -3.4028234663852886E38 || d2 == Double.MAX_VALUE || d2 == -1.7976931348623157E308 ? " -" : (s2 = d2 == 0.0 ? " 0" : Double.toString(d2)));
            if (s2.length() <= w2) {
                return UndecidedNode.p(sb, s2, w2);
            }
            s2 = String.format("% 4.2f", d2);
            if (s2.length() > w2) {
                s2 = String.format("%4.1f", d2);
            }
            if (s2.length() > w2) {
                s2 = String.format("%4.0f", d2);
            }
            return UndecidedNode.p(sb, s2, w2);
        }

        @Override
        public StringBuilder toString2(StringBuilder sb, int depth) {
            for (int d2 = 0; d2 < depth; ++d2) {
                sb.append("  ");
            }
            return sb.append("Undecided\n");
        }

        @Override
        protected AutoBuffer compress(AutoBuffer ab, AutoBuffer abAux) {
            throw H2O.fail();
        }

        @Override
        protected int size() {
            throw H2O.fail();
        }

        @Override
        protected int numNodes() {
            throw H2O.fail();
        }
    }

    public static class Split
    extends Iced {
        public final int _col;
        public final int _bin;
        final DHistogram.NASplitDir _nasplit;
        final IcedBitSet _bs;
        final byte _equal;
        final double _se;
        final double _se0;
        final double _se1;
        final double _n0;
        final double _n1;
        final double _p0;
        final double _p1;
        final double _tree_p0;
        final double _tree_p1;
        final double _p0Treat;
        final double _p0Contr;
        final double _p1Treat;
        final double _p1Contr;
        final double _n0Treat;
        final double _n0Contr;
        final double _n1Treat;
        final double _n1Contr;

        public Split(int col, int bin, DHistogram.NASplitDir nasplit, IcedBitSet bs, byte equal, double se, double se0, double se1, double n0, double n1, double p0, double p1, double tree_p0, double tree_p1) {
            assert (nasplit != DHistogram.NASplitDir.None);
            assert (nasplit != DHistogram.NASplitDir.NAvsREST || bs == null) : "Split type NAvsREST shouldn't have a bitset";
            assert (equal != 1);
            assert (col >= 0);
            assert (bin >= 0);
            this._col = col;
            this._bin = bin;
            this._nasplit = nasplit;
            this._bs = bs;
            this._equal = equal;
            this._se = se;
            this._n0 = n0;
            this._n1 = n1;
            this._se0 = se0;
            this._se1 = se1;
            this._p0 = p0;
            this._p1 = p1;
            this._tree_p0 = tree_p0;
            this._tree_p1 = tree_p1;
            this._p1Contr = 0.0;
            this._p1Treat = 0.0;
            this._p0Contr = 0.0;
            this._p0Treat = 0.0;
            this._n1Contr = 0.0;
            this._n1Treat = 0.0;
            this._n0Contr = 0.0;
            this._n0Treat = 0.0;
        }

        public Split(int col, int bin, DHistogram.NASplitDir nasplit, IcedBitSet bs, byte equal, double se, double se0, double se1, double n0, double n1, double p0, double p1, double tree_p0, double tree_p1, double p0Treat, double p0Contr, double p1Treat, double p1Contr, double n0Treat, double n0Contr, double n1Treat, double n1Contr) {
            assert (nasplit != DHistogram.NASplitDir.None);
            assert (equal != 1);
            assert (col >= 0);
            assert (bin >= 0);
            this._col = col;
            this._bin = bin;
            this._nasplit = nasplit;
            this._bs = bs;
            this._equal = equal;
            this._se = se;
            this._n0 = n0;
            this._n1 = n1;
            this._se0 = se0;
            this._se1 = se1;
            this._p0 = p0;
            this._p1 = p1;
            this._tree_p0 = tree_p0;
            this._tree_p1 = tree_p1;
            this._p0Treat = p0Treat;
            this._p0Contr = p0Contr;
            this._p1Treat = p1Treat;
            this._p1Contr = p1Contr;
            this._n0Treat = n0Treat;
            this._n0Contr = n0Contr;
            this._n1Treat = n1Treat;
            this._n1Contr = n1Contr;
        }

        public final double pre_split_se() {
            return this._se;
        }

        public final double se() {
            return this._se0 + this._se1;
        }

        public final int col() {
            return this._col;
        }

        public final int bin() {
            return this._bin;
        }

        public final DHistogram.NASplitDir naSplitDir() {
            return this._nasplit;
        }

        public final double n0() {
            return this._n0;
        }

        public final double n1() {
            return this._n1;
        }

        float splat(DHistogram[] hs) {
            return this.isNumericSplit() ? this.splatNumeric(hs[this._col]) : -1.0f;
        }

        boolean isNumericSplit() {
            return this._nasplit != DHistogram.NASplitDir.NAvsREST && (this._equal == 0 || this._equal == 1);
        }

        float splatNumeric(DHistogram h2) {
            int n2;
            int x2;
            assert (this._nasplit != DHistogram.NASplitDir.NAvsREST) : "Shouldn't be called for NA split type 'NA vs REST'";
            assert (this._bin > 0 && this._bin < h2.nbins());
            assert (this._bs == null) : "Dividing point is a bitset, not a bin#, so don't call splat() as result is meaningless";
            assert (this._equal != 1);
            assert (this._equal == 0);
            for (x2 = this._bin - 1; x2 >= 0 && h2.bins(x2) == 0.0; --x2) {
            }
            for (n2 = this._bin; n2 < h2.nbins() && h2.bins(n2) == 0.0; ++n2) {
            }
            double lo = h2.binAt(x2 + 1);
            double hi = h2.binAt(n2);
            if (h2._isInt > 0) {
                lo = h2._step == 1.0 ? lo - 1.0 : Math.floor(lo);
                hi = h2._step == 1.0 ? hi : Math.ceil(hi);
            }
            float splitAt = (float)((lo + hi) / 2.0);
            if (h2._checkFloatSplits && lo != hi && (lo > (double)splitAt || hi < (double)splitAt)) {
                return Float.NaN;
            }
            return splitAt;
        }

        public DHistogram[] nextLevelHistos(DHistogram[] currentHistos, int way, double splat, SharedTreeModel.SharedTreeParameters parms, Constraints cs, BranchInteractionConstraints bcs) {
            double se;
            double n2;
            double d2 = n2 = way == 0 ? this._n0 : this._n1;
            if (n2 < parms._min_rows) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Not splitting: too few observations left: " + n2));
                }
                return null;
            }
            double d3 = se = way == 0 ? this._se0 : this._se1;
            if (se <= 1.0E-30) {
                LOG.trace((Object)"Not splitting: pure node (perfect prediction).");
                return null;
            }
            int cnt = 0;
            DHistogram[] nhists = new DHistogram[currentHistos.length];
            boolean checkBranchInteractions = bcs != null;
            block5: for (int j2 = 0; j2 < currentHistos.length; ++j2) {
                int nonEmptyBins;
                double density;
                double maxEx;
                double min2;
                DHistogram h2;
                if (checkBranchInteractions && !bcs.isAllowedIndex(j2) || (h2 = currentHistos[j2]) == null) continue;
                int adj_nbins = Math.max(h2.nbins() >> 1, parms._nbins);
                if (h2._vals == null || this._equal > 1) {
                    min2 = h2._min;
                    maxEx = h2._maxEx;
                } else {
                    min2 = h2.find_min();
                    if (h2.find_maxIn() == min2) continue;
                    maxEx = h2.find_maxEx();
                }
                if (this._nasplit == DHistogram.NASplitDir.NAvsREST && way == 1) continue;
                if (this._col == j2) {
                    switch (this._equal) {
                        case 0: {
                            if (this._nasplit != DHistogram.NASplitDir.NAvsREST && h2._vals[h2._vals_dim * this._bin] == 0.0) {
                                throw H2O.unimpl();
                            }
                            assert (this._bs == null) : "splat not defined for BitSet splits";
                            double split2 = splat;
                            if (h2._isInt > 0) {
                                split2 = (float)Math.ceil(split2);
                            }
                            if (this._nasplit == DHistogram.NASplitDir.NAvsREST) break;
                            if (way == 0) {
                                maxEx = split2;
                                break;
                            }
                            min2 = split2;
                            break;
                        }
                        case 1: {
                            if (way != 1) break;
                            continue block5;
                        }
                        case 2: 
                        case 3: {
                            break;
                        }
                        default: {
                            throw H2O.fail();
                        }
                    }
                }
                if (min2 > maxEx || MathUtils.equalsWithinOneSmallUlp(min2, maxEx) || Double.isInfinite((double)adj_nbins / (maxEx - min2)) || h2._isInt > 0 && !(min2 + 1.0 < maxEx)) continue;
                assert (min2 < maxEx && adj_nbins > 1) : "" + min2 + "<" + maxEx + " nbins=" + adj_nbins;
                boolean hasNAs = (this._nasplit == DHistogram.NASplitDir.NALeft && way == 0 || this._nasplit == DHistogram.NASplitDir.NARight && way == 1) && h2.hasNABin();
                double[] customSplitPoints = h2._customSplitPoints;
                if (parms._histogram_type == SharedTreeModel.SharedTreeParameters.HistogramType.UniformRobust && j2 != this._col && GuidedSplitPoints.isApplicableTo(h2) && (density = (double)(nonEmptyBins = h2.nonEmptyBins()) / (double)h2.nbins()) <= 0.2) {
                    customSplitPoints = GuidedSplitPoints.makeSplitPoints(h2, adj_nbins, min2, maxEx);
                }
                nhists[j2] = DHistogram.make(h2._name, adj_nbins, h2._isInt, min2, maxEx, h2._intOpt, hasNAs, h2._seed * 912559L + (long)(way + 1), parms, h2._globalQuantilesKey, cs, h2._checkFloatSplits, customSplitPoints);
                ++cnt;
            }
            return cnt == 0 ? null : nhists;
        }

        public Constraints nextLevelConstraints(Constraints currentConstraints, int way, double splat, SharedTreeModel.SharedTreeParameters parms) {
            int constraint = currentConstraints.getColumnConstraint(this._col);
            if (constraint == 0) {
                return currentConstraints;
            }
            double mid = (this._tree_p0 + this._tree_p1) / 2.0;
            return currentConstraints.withNewConstraint(this._col, way, mid);
        }

        public String toString() {
            return "Splitting: col=" + this._col + " type=" + (this._equal == 0 ? " < " : "bitset") + ", splitpoint=" + this._bin + ", nadir=" + this._nasplit.toString() + ", se0=" + this._se0 + ", se1=" + this._se1 + ", n0=" + this._n0 + ", n1=" + this._n1;
        }
    }

    public static abstract class Node
    extends Iced {
        protected transient DTree _tree;
        public final int _pid;
        protected final int _nid;

        Node(DTree tree, int pid, int nid) {
            this._tree = tree;
            this._pid = pid;
            this._nid = nid;
            ((DTree)tree)._ns[this._nid] = this;
        }

        Node(DTree tree, int pid) {
            this._tree = tree;
            this._pid = pid;
            this._nid = tree.newIdx(this);
        }

        Node(DTree tree, int pid, int nid, boolean copy) {
            this._tree = tree;
            this._pid = pid;
            this._nid = copy ? nid : tree.newIdx(this);
        }

        StringBuilder printLine(StringBuilder sb) {
            if (this._pid == -1) {
                return sb.append("[root]");
            }
            DecidedNode parent = this._tree.decided(this._pid);
            parent.printLine(sb).append(" to ");
            return parent.printChild(sb, this._nid);
        }

        public abstract StringBuilder toString2(StringBuilder var1, int var2);

        protected abstract AutoBuffer compress(AutoBuffer var1, AutoBuffer var2);

        protected abstract int size();

        protected abstract int numNodes();

        public final int nid() {
            return this._nid;
        }

        public final int pid() {
            return this._pid;
        }
    }
}

