/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import java.util.Collection;
import water.Iced;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.IcedHashSet;
import water.util.IcedInt;

public class GlobalInteractionConstraints
extends Iced<GlobalInteractionConstraints> {
    private IcedHashMap<IcedInt, IcedHashSet<IcedInt>> allowedInteractionMap = new IcedHashMap();

    public GlobalInteractionConstraints(String[][] userFeatureInteractions, String[] treeFeatureNames) {
        this.parseInteractionsIndices(userFeatureInteractions, treeFeatureNames);
        assert (this.allowedInteractionMap != null);
        assert (this.allowedInteractionMap.size() != 0);
    }

    private void parseInteractionsIndices(String[][] userInteractionConstraints, String[] columnNames) {
        for (String[] list : userInteractionConstraints) {
            IcedHashSet<IcedInt> interactions = new IcedHashSet<IcedInt>();
            for (int i2 = 0; i2 < list.length; ++i2) {
                String item = list[i2];
                int start = ArrayUtils.findWithPrefix(columnNames, item);
                assert (start != -1) : "Column name should be in defined column names.";
                if (start > -1) {
                    interactions.add(new IcedInt(start));
                    continue;
                }
                start = -start - 2;
                assert (columnNames[start].startsWith(item)) : "The column name should be find correctly.";
                for (int end = start; end < columnNames.length && columnNames[end].startsWith(item); ++end) {
                    interactions.add(new IcedInt(end));
                }
            }
            this.addInteractionsSetToMap(interactions);
        }
    }

    private void addInteractionsSetToMap(IcedHashSet<IcedInt> interactions) {
        for (IcedInt index : interactions) {
            if (!this.allowedInteractionMap.containsKey(index)) {
                this.allowedInteractionMap.put(index, interactions);
                continue;
            }
            IcedHashSet<IcedInt> set = new IcedHashSet<IcedInt>();
            set.addAll((Collection)this.allowedInteractionMap.get(index));
            set.addAll((Collection<IcedInt>)interactions);
            this.allowedInteractionMap.put(index, set);
        }
    }

    public IcedHashSet<IcedInt> getAllowedInteractionForIndex(int columnIndex) {
        return (IcedHashSet)this.allowedInteractionMap.get(new IcedInt(columnIndex));
    }

    public boolean allowedInteractionContainsColumn(int columnIndex) {
        return this.allowedInteractionMap.containsKey(new IcedInt(columnIndex));
    }

    public IcedHashSet<IcedInt> getAllAllowedColumnIndices() {
        IcedHashSet<IcedInt> indices = new IcedHashSet<IcedInt>();
        indices.addAll(this.allowedInteractionMap.keySet());
        return indices;
    }
}

