/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import water.DKV;
import water.Job;
import water.Key;
import water.Lockable;
import water.fvec.Frame;
import water.util.ArrayUtils;

class GlobalQuantilesCalc {
    GlobalQuantilesCalc() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static double[][] splitPoints(Frame fr, String weightsColumn, int N2, int nbins_top_level) {
        Key rndKey = Key.make();
        DKV.put(rndKey, fr);
        Lockable qm = null;
        try {
            QuantileModel.QuantileParameters p2 = new QuantileModel.QuantileParameters();
            p2._train = rndKey;
            p2._weights_column = weightsColumn;
            p2._combine_method = QuantileModel.CombineMethod.INTERPOLATE;
            p2._probs = new double[N2];
            for (int i2 = 0; i2 < N2; ++i2) {
                p2._probs[i2] = (double)i2 * 1.0 / (double)N2;
            }
            Job job = new Quantile(p2).trainModel();
            qm = (QuantileModel)job.get();
            job.remove();
            double[][] origQuantiles = ((QuantileModel.QuantileOutput)((QuantileModel)qm)._output)._quantiles;
            double[][] splitPoints = new double[origQuantiles.length][];
            for (int i3 = 0; i3 < origQuantiles.length; ++i3) {
                if (!fr.vec(i3).isNumeric() || fr.vec(i3).isCategorical() || fr.vec(i3).isBinary() || origQuantiles[i3].length <= 1) continue;
                splitPoints[i3] = ArrayUtils.makeUniqueAndLimitToRange(origQuantiles[i3], fr.vec(i3).min(), fr.vec(i3).max());
                splitPoints[i3] = (double[])(splitPoints[i3].length <= 1 ? null : ArrayUtils.padUniformly(splitPoints[i3], nbins_top_level));
                assert (splitPoints[i3] == null || splitPoints[i3].length > 1);
            }
            double[][] dArrayArray = splitPoints;
            return dArrayArray;
        }
        finally {
            DKV.remove(rndKey);
            if (qm != null) {
                qm.delete();
            }
        }
    }
}

