/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.DHistogram;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import water.util.ArrayUtils;

public class GuidedSplitPoints {
    static final double LOW_DENSITY_THRESHOLD = 0.2;

    static boolean isApplicableTo(DHistogram h2) {
        return h2._vals != null && h2._isInt != 2 && !h2._intOpt;
    }

    static double[] makeSplitPoints(DHistogram h2, int targetNBins, double min2, double maxEx) {
        int newBins;
        List<BinDescriptor> bins = GuidedSplitPoints.extractNonEmptyBins(h2);
        int totalBudget = targetNBins - bins.size() - 2;
        if (bins.isEmpty() || totalBudget <= 0) {
            return null;
        }
        int budgetLeft = totalBudget;
        double totalSE = 0.0;
        for (BinDescriptor bin : bins) {
            totalSE += bin._se;
        }
        int[] newBinCounts = new int[bins.size()];
        Collections.sort(bins);
        for (int b2 = 0; budgetLeft > 0 && b2 < newBinCounts.length; budgetLeft -= newBins, ++b2) {
            BinDescriptor bin = bins.get(b2);
            newBins = Math.min((int)Math.ceil((double)totalBudget * bin._se / totalSE), budgetLeft);
            newBinCounts[b2] = newBins;
        }
        double[] customSplitPoints = new double[targetNBins - budgetLeft];
        int i2 = 0;
        for (int b3 = 0; b3 < newBinCounts.length; ++b3) {
            BinDescriptor bin = bins.get(b3);
            customSplitPoints[i2++] = bin._start;
            double stepSize = (bin._end - bin._start) / (double)(1 + newBinCounts[b3]);
            for (int s2 = 0; s2 < newBinCounts[b3]; ++s2) {
                customSplitPoints[i2] = customSplitPoints[i2 - 1] + stepSize;
                ++i2;
            }
        }
        customSplitPoints[i2++] = min2;
        customSplitPoints[i2++] = h2._maxIn;
        assert (i2 == customSplitPoints.length);
        Arrays.sort(customSplitPoints);
        return ArrayUtils.makeUniqueAndLimitToRange(customSplitPoints, min2, maxEx);
    }

    static List<BinDescriptor> extractNonEmptyBins(DHistogram h2) {
        int nonEmptyBins = h2.nonEmptyBins();
        ArrayList<BinDescriptor> bins = new ArrayList<BinDescriptor>(nonEmptyBins);
        for (int i2 = 0; i2 < h2.nbins(); ++i2) {
            double weight = h2.w(i2);
            if (!(weight > 0.0)) continue;
            BinDescriptor bin = BinDescriptor.fromBin(h2, i2);
            bins.add(bin);
        }
        return bins;
    }

    static class BinDescriptor
    implements Comparable<BinDescriptor> {
        final double _start;
        final double _end;
        final double _se;
        final double _weight;

        public BinDescriptor(double start, double end, double se, double weight) {
            this._start = start;
            this._end = end;
            this._se = Math.max(se, 0.0);
            this._weight = weight;
        }

        @Override
        public int compareTo(BinDescriptor o2) {
            return -Double.compare(this._se, o2._se);
        }

        static BinDescriptor fromBin(DHistogram h2, int i2) {
            double w2 = h2.w(i2);
            double wY = h2.wY(i2);
            double wYY = h2.wYY(i2);
            double se = w2 != 0.0 ? wYY - wY * wY / w2 : 0.0;
            return new BinDescriptor(h2.binAt(i2), h2.binAt(i2 + 1), se, w2);
        }

        public String toString() {
            return "BinDescriptor{_start=" + this._start + ", _end=" + this._end + ", _se=" + this._se + ", _weight=" + this._weight + '}';
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            BinDescriptor that = (BinDescriptor)o2;
            if (Double.compare(that._start, this._start) != 0) {
                return false;
            }
            if (Double.compare(that._end, this._end) != 0) {
                return false;
            }
            if (Double.compare(that._se, this._se) != 0) {
                return false;
            }
            return Double.compare(that._weight, this._weight) == 0;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this._start);
            int result = (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this._end);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this._se);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this._weight);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

