/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.tree.CompressedTree;

public abstract class MojoUtils {
    public static CompressedTree[][] extractCompressedTrees(SharedTreeMojoModel mojo) {
        int ntrees = mojo.getNTreeGroups();
        int ntreesPerGroup = mojo.getNTreesPerGroup();
        int nclasses = mojo.nclasses();
        CompressedTree[][] trees = new CompressedTree[ntrees][];
        for (int t2 = 0; t2 < ntrees; ++t2) {
            CompressedTree[] tc = new CompressedTree[nclasses];
            for (int c2 = 0; c2 < ntreesPerGroup; ++c2) {
                tc[c2] = new CompressedTree(mojo.treeBytes(t2, c2), -1L, t2, c2);
            }
            trees[t2] = tc;
        }
        return trees;
    }

    public static boolean isUsingBinomialOpt(SharedTreeMojoModel mojo, CompressedTree[][] trees) {
        if (mojo.nclasses() != 2) {
            return false;
        }
        for (CompressedTree[] group2 : trees) {
            if (group2.length == 2 && group2[1] == null) continue;
            return false;
        }
        return true;
    }
}

