/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.genmodel.utils.DistributionFamily;
import hex.tree.DHistogram;
import hex.tree.DTree;
import water.H2O;
import water.MRTask;

public class ScoreBuildHistogram
extends MRTask<ScoreBuildHistogram> {
    final int _k;
    final int _ncols;
    final int _nbins;
    final DTree _tree;
    final int _leaf;
    DHistogram[][] _hcs;
    final DistributionFamily _family;
    final int _weightIdx;
    final int _workIdx;
    final int _nidIdx;
    final int _treatmentIdx;
    public static final int DECIDED_ROW = -1;
    public static final int OUT_OF_BAG = -2;
    public static final int UNDECIDED_CHILD_NODE_ID = -1;
    public static final int FRESH = 0;

    public ScoreBuildHistogram(H2O.H2OCountedCompleter cc, int k2, int ncols, int nbins, DTree tree, int leaf, DHistogram[][] hcs, DistributionFamily family, int weightIdx, int workIdx, int nidIdx, int treatmentIdx) {
        super(cc);
        this._k = k2;
        this._ncols = ncols;
        this._nbins = nbins;
        this._tree = tree;
        this._leaf = leaf;
        this._hcs = hcs;
        this._family = family;
        this._weightIdx = weightIdx;
        this._workIdx = workIdx;
        this._nidIdx = nidIdx;
        this._treatmentIdx = treatmentIdx;
    }

    public static boolean isOOBRow(int nid) {
        return nid <= -2;
    }

    public static boolean isDecidedRow(int nid) {
        return nid == -1;
    }

    public static int oob2Nid(int oobNid) {
        return -oobNid + -2;
    }

    public static int nid2Oob(int nid) {
        return -nid + -2;
    }

    @Override
    public void reduce(ScoreBuildHistogram sbh) {
        if (sbh._hcs == this._hcs) {
            return;
        }
        for (int i2 = 0; i2 < this._hcs.length; ++i2) {
            DHistogram[] hs1 = this._hcs[i2];
            DHistogram[] hs2 = sbh._hcs[i2];
            if (hs1 == null) {
                this._hcs[i2] = hs2;
                continue;
            }
            if (hs2 == null) continue;
            for (int j2 = 0; j2 < hs1.length; ++j2) {
                if (hs1[j2] == null) {
                    hs1[j2] = hs2[j2];
                    continue;
                }
                if (hs2[j2] == null) continue;
                hs1[j2].add(hs2[j2]);
            }
        }
    }
}

