/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.genmodel.utils.DistributionFamily;
import hex.tree.DHistogram;
import hex.tree.DTree;
import hex.tree.ScoreBuildHistogram;
import hex.tree.SharedTree;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import jsr166y.CountedCompleter;
import water.H2O;
import water.Iced;
import water.LocalMR;
import water.MemoryManager;
import water.MrFun;
import water.fvec.C4VolatileChunk;
import water.fvec.C8DVolatileChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.IcedBitSet;
import water.util.Log;
import water.util.VecUtils;

public class ScoreBuildHistogram2
extends ScoreBuildHistogram {
    transient int[] _cids;
    transient Chunk[][] _chks;
    transient double[][] _ys;
    transient double[][] _ws;
    transient int[][] _nhs;
    transient int[][] _rss;
    Frame _fr2;
    final int _numLeafs;
    final IcedBitSet _activeCols;
    final int _respIdx;
    final int _predsIdx;
    final boolean _reproducibleHistos;
    final boolean _reduceHistoPrecision;
    transient Consumer<DHistogram[][]> _hcsMonitor;
    final int _treatmentIdx;

    public ScoreBuildHistogram2(SharedTree.ScoreBuildOneTree sb, int treeNum, int k2, int ncols, int nbins, DTree tree, int leaf, DHistogram[][] hcs, DistributionFamily family, int respIdx, int weightIdx, int predsIdx, int workIdx, int nidIdxs, int treatmentIdx) {
        super(sb, k2, ncols, nbins, tree, leaf, hcs, family, weightIdx, workIdx, nidIdxs, treatmentIdx);
        this._numLeafs = this._hcs.length;
        this._respIdx = respIdx;
        this._predsIdx = predsIdx;
        this._treatmentIdx = treatmentIdx;
        int hcslen = this._hcs.length;
        IcedBitSet activeCols = new IcedBitSet(ncols);
        for (int n2 = 0; n2 < hcslen; ++n2) {
            int[] acs = this._tree.undecided((int)(n2 + this._leaf))._scoreCols;
            if (acs != null) {
                for (int c2 : acs) {
                    activeCols.set(c2);
                }
                continue;
            }
            activeCols = null;
            break;
        }
        this._activeCols = activeCols;
        this._hcs = ArrayUtils.transpose(this._hcs);
        SharedTree.SharedTreeDebugParams dp = sb._st.getDebugParams();
        this._reproducibleHistos = tree._parms.forceStrictlyReproducibleHistograms() || dp._reproducible_histos;
        boolean bl = this._reduceHistoPrecision = !dp._keep_orig_histo_precision;
        if (this._reproducibleHistos && treeNum == 0 && k2 == 0 && leaf == 0) {
            Log.info("Using a deterministic way of building histograms");
        }
        this._hcsMonitor = dp.makeDHistogramMonitor(treeNum, k2, leaf);
    }

    void dfork2(Frame fr) {
        this._fr2 = fr;
        this.asyncExecOnAllNodes();
    }

    @Override
    public void map(Chunk[] chks) {
        throw H2O.unimpl();
    }

    protected int[] score_decide(Chunk[] chks, int[] nnids) {
        int[] res = (int[])nnids.clone();
        for (int row = 0; row < nnids.length; ++row) {
            int nid = nnids[row];
            if (ScoreBuildHistogram2.isDecidedRow(nid)) {
                int n2 = row;
                res[n2] = res[n2] - this._leaf;
                continue;
            }
            boolean oob = ScoreBuildHistogram2.isOOBRow(nid);
            if (oob) {
                nid = ScoreBuildHistogram2.oob2Nid(nid);
            }
            DTree.DecidedNode dn = this._tree.decided(nid);
            if (dn._split == null) {
                int xnid;
                if (DTree.isRootNode(dn)) {
                    res[row] = nid - this._leaf;
                    continue;
                }
                nid = dn._pid;
                nnids[row] = xnid = oob ? ScoreBuildHistogram2.nid2Oob(nid) : nid;
                res[row] = xnid - this._leaf;
                dn = this._tree.decided(nid);
            }
            assert (!ScoreBuildHistogram2.isDecidedRow(nid));
            nid = dn.getChildNodeID(chks, row);
            if (!ScoreBuildHistogram2.isDecidedRow(nid)) {
                if (oob) {
                    nid = ScoreBuildHistogram2.nid2Oob(nid);
                }
                nnids[row] = nid;
            }
            res[row] = nid - this._leaf;
        }
        return res;
    }

    @Override
    public void setupLocal() {
        this.addToPendingCount(1);
        this._tree.init_tree();
        Vec v2 = this._fr2.anyVec();
        assert (v2 != null);
        this._cids = VecUtils.getLocalChunkIds(v2);
        this._chks = new Chunk[this._cids.length][this._fr2.numCols()];
        this._ys = new double[this._cids.length][];
        this._ws = new double[this._cids.length][];
        this._nhs = new int[this._cids.length][];
        this._rss = new int[this._cids.length][];
        long[] espc = v2.espc();
        int largestChunkSz = 0;
        for (int i2 = 1; i2 < espc.length; ++i2) {
            int sz = (int)(espc[i2] - espc[i2 - 1]);
            if (sz <= largestChunkSz) continue;
            largestChunkSz = sz;
        }
        final int fLargestChunkSz = largestChunkSz;
        final AtomicInteger cidx = new AtomicInteger(0);
        new LocalMR(new MrFun(){

            private void map(int id, Chunk[] chks) {
                int[] nnids;
                C4VolatileChunk nids = (C4VolatileChunk)chks[ScoreBuildHistogram2.this._nidIdx];
                if (ScoreBuildHistogram2.this._leaf > 0) {
                    nnids = ScoreBuildHistogram2.this.score_decide(chks, nids.getValues());
                } else {
                    nnids = new int[nids._len];
                    int[] is = nids.getValues();
                    for (int row = 0; row < nids._len; ++row) {
                        if (!ScoreBuildHistogram.isDecidedRow(is[row])) continue;
                        nnids[row] = -1;
                    }
                }
                ScoreBuildHistogram2.this._nhs[id] = new int[ScoreBuildHistogram2.this._numLeafs + 1];
                int[] nh = ScoreBuildHistogram2.this._nhs[id];
                for (int i2 : nnids) {
                    if (i2 < 0) continue;
                    int n2 = i2 + 1;
                    nh[n2] = nh[n2] + 1;
                }
                for (int i3 = 0; i3 < ScoreBuildHistogram2.this._numLeafs; ++i3) {
                    int n3 = i3 + 1;
                    nh[n3] = nh[n3] + nh[i3];
                }
                ScoreBuildHistogram2.this._rss[id] = new int[nnids.length];
                int[] rows = ScoreBuildHistogram2.this._rss[id];
                for (int row = 0; row < nnids.length; ++row) {
                    if (nnids[row] < 0) continue;
                    int n4 = nnids[row];
                    int n5 = nh[n4];
                    nh[n4] = n5 + 1;
                    rows[n5] = row;
                }
            }

            @Override
            protected void map(int id) {
                Vec[] vecs = ScoreBuildHistogram2.this._fr2.vecs();
                id = cidx.getAndIncrement();
                while (id < ScoreBuildHistogram2.this._cids.length) {
                    int cidx2 = ScoreBuildHistogram2.this._cids[id];
                    Chunk[] chks = ScoreBuildHistogram2.this._chks[id];
                    for (int i2 = 0; i2 < chks.length; ++i2) {
                        chks[i2] = vecs[i2].chunkForChunkIdx(cidx2);
                    }
                    this.map(id, chks);
                    chks[ScoreBuildHistogram2.this._nidIdx].close(cidx2, ScoreBuildHistogram2.this._fs);
                    Chunk resChk = chks[ScoreBuildHistogram2.this._workIdx];
                    int len = resChk.len();
                    double[] y2 = resChk instanceof C8DVolatileChunk ? ((C8DVolatileChunk)resChk).getValues() : resChk.getDoubles(MemoryManager.malloc8d(len), 0, len);
                    int[] nh = ScoreBuildHistogram2.this._nhs[id];
                    ScoreBuildHistogram2.this._ys[id] = MemoryManager.malloc8d(len);
                    for (int n2 = 0; n2 < nh.length; ++n2) {
                        int hi = nh[n2];
                        int lo = n2 == 0 ? 0 : nh[n2 - 1];
                        if (hi == lo) continue;
                        for (int i3 = lo; i3 < hi; ++i3) {
                            ScoreBuildHistogram2.this._ys[id][i3] = y2[ScoreBuildHistogram2.this._rss[id][i3]];
                        }
                    }
                    if (ScoreBuildHistogram2.this._weightIdx != -1) {
                        ScoreBuildHistogram2.this._ws[id] = chks[ScoreBuildHistogram2.this._weightIdx].getDoubles(MemoryManager.malloc8d(len), 0, len);
                    }
                    id = cidx.getAndIncrement();
                }
            }
        }, new H2O.H2OCountedCompleter(this){

            @Override
            public void onCompletion(CountedCompleter cc) {
                int ncols = ScoreBuildHistogram2.this._ncols;
                final int[] active_cols = ScoreBuildHistogram2.this._activeCols == null ? null : new int[Math.max(1, ScoreBuildHistogram2.this._activeCols.cardinality())];
                int nactive_cols = active_cols == null ? ncols : active_cols.length;
                ScoreBuildHistogram2.this.addToPendingCount(1 + nactive_cols);
                if (active_cols != null) {
                    int j2 = 0;
                    for (int i2 = 0; i2 < ncols; ++i2) {
                        if (!ScoreBuildHistogram2.this._activeCols.contains(i2)) continue;
                        active_cols[j2++] = i2;
                    }
                }
                final int numWrks = ScoreBuildHistogram2.this._hcs.length * nactive_cols < 16384 ? H2O.NUMCPUS : Math.min(H2O.NUMCPUS, Math.max(4 * H2O.NUMCPUS / nactive_cols, 1));
                final int rem = H2O.NUMCPUS - numWrks * ncols;
                new LocalMR(new MrFun(){

                    @Override
                    protected void map(int c2) {
                        c2 = active_cols == null ? c2 : active_cols[c2];
                        int nthreads = numWrks + (c2 < rem ? 1 : 0);
                        WorkAllocator workAllocator = ScoreBuildHistogram2.this._reproducibleHistos ? new RangeWorkAllocator(ScoreBuildHistogram2.this._cids.length, nthreads) : new SharedPoolWorkAllocator(ScoreBuildHistogram2.this._cids.length);
                        ComputeHistoThread computeHistoThread = new ComputeHistoThread(ScoreBuildHistogram2.this._hcs.length == 0 ? new DHistogram[]{} : ScoreBuildHistogram2.this._hcs[c2], c2, fLargestChunkSz, workAllocator);
                        LocalMR mr = new LocalMR(computeHistoThread, nthreads, ScoreBuildHistogram2.this);
                        if (ScoreBuildHistogram2.this._reproducibleHistos) {
                            mr = mr.withNoPrevTaskReuse();
                            assert (mr.isReproducible());
                        }
                        mr.fork();
                    }
                }, nactive_cols, ScoreBuildHistogram2.this).fork();
            }
        }).fork();
    }

    private static void mergeHistos(DHistogram[] hcs, DHistogram[] hcs2) {
        for (int i2 = 0; i2 < hcs.length; ++i2) {
            DHistogram hs1 = hcs[i2];
            DHistogram hs2 = hcs2[i2];
            if (hs1 == null) {
                hcs[i2] = hs2;
                continue;
            }
            if (hs2 == null) continue;
            hs1.add(hs2);
        }
    }

    @Override
    public void postGlobal() {
        DHistogram[][] dHistogramArray = this._hcs = ArrayUtils.transpose(this._hcs);
        int n2 = dHistogramArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            DHistogram[] ary;
            for (DHistogram dh : ary = dHistogramArray[i2]) {
                if (dh == null || !this._reduceHistoPrecision) continue;
                dh.reducePrecision();
            }
        }
        if (this._hcsMonitor != null) {
            this._hcsMonitor.accept(this._hcs);
        }
    }

    private class ComputeHistoThread
    extends MrFun<ComputeHistoThread> {
        final int _maxChunkSz;
        final int _col;
        final DHistogram[] _lh;
        WorkAllocator _allocator;

        ComputeHistoThread(DHistogram[] hcs, int col, int maxChunkSz, WorkAllocator allocator) {
            this._lh = hcs;
            this._col = col;
            this._maxChunkSz = maxChunkSz;
            this._allocator = allocator;
        }

        public ComputeHistoThread makeCopy() {
            return new ComputeHistoThread((DHistogram[])ArrayUtils.deepClone((Iced[])this._lh), this._col, this._maxChunkSz, this._allocator);
        }

        @Override
        protected void map(int id) {
            Object cs = null;
            double[] resp = null;
            double[] preds = null;
            double[] treatment = null;
            int maxWorkId = this._allocator.getMaxId(id);
            int i2 = this._allocator.allocateWork(id);
            while (i2 < maxWorkId) {
                if (cs == null) {
                    if (ScoreBuildHistogram2.this._respIdx >= 0) {
                        resp = MemoryManager.malloc8d(this._maxChunkSz);
                    }
                    if (ScoreBuildHistogram2.this._predsIdx >= 0) {
                        preds = MemoryManager.malloc8d(this._maxChunkSz);
                    }
                    if (ScoreBuildHistogram2.this._treatmentIdx >= 0) {
                        treatment = MemoryManager.malloc8d(this._maxChunkSz);
                    }
                }
                cs = this.computeChunk(i2, cs, ScoreBuildHistogram2.this._ws[i2], resp, preds, treatment);
                i2 = this._allocator.allocateWork(id);
            }
        }

        private Object computeChunk(int id, Object cs, double[] ws, double[] resp, double[] preds, double[] treatment) {
            int[] nh = ScoreBuildHistogram2.this._nhs[id];
            int[] rs = ScoreBuildHistogram2.this._rss[id];
            Chunk resChk = ScoreBuildHistogram2.this._chks[id][ScoreBuildHistogram2.this._workIdx];
            int len = resChk._len;
            double[] ys = ScoreBuildHistogram2.this._ys[id];
            int hcslen = this._lh.length;
            boolean extracted = false;
            for (int n2 = 0; n2 < hcslen; ++n2) {
                int lo;
                int[] sCols = ScoreBuildHistogram2.this._tree.undecided((int)(n2 + ScoreBuildHistogram2.this._leaf))._scoreCols;
                if (sCols != null && ArrayUtils.find(sCols, this._col) < 0) continue;
                DHistogram h2 = this._lh[n2];
                int hi = nh[n2];
                int n3 = lo = n2 == 0 ? 0 : nh[n2 - 1];
                if (hi == lo || h2 == null) continue;
                if (h2._vals == null) {
                    h2.init();
                }
                if (!extracted) {
                    cs = h2.extractData(ScoreBuildHistogram2.this._chks[id][this._col], cs, len, this._maxChunkSz);
                    if (h2._vals_dim >= 6) {
                        ScoreBuildHistogram2.this._chks[id][ScoreBuildHistogram2.this._respIdx].getDoubles(resp, 0, len);
                        if (h2._vals_dim == 7) {
                            ScoreBuildHistogram2.this._chks[id][ScoreBuildHistogram2.this._predsIdx].getDoubles(preds, 0, len);
                        }
                    }
                    if (h2._useUplift) {
                        ScoreBuildHistogram2.this._chks[id][ScoreBuildHistogram2.this._respIdx].getDoubles(resp, 0, len);
                        ScoreBuildHistogram2.this._chks[id][ScoreBuildHistogram2.this._treatmentIdx].getDoubles(treatment, 0, len);
                    }
                    extracted = true;
                }
                h2.updateHisto(ws, resp, cs, ys, preds, rs, hi, lo, treatment);
            }
            return cs;
        }

        @Override
        protected void reduce(ComputeHistoThread cc) {
            assert (this._lh != cc._lh);
            ScoreBuildHistogram2.mergeHistos(this._lh, cc._lh);
        }
    }

    static class RangeWorkAllocator
    implements WorkAllocator {
        final int _workAmount;
        final int[] _rangePositions;
        final int _rangeLength;

        RangeWorkAllocator(int workAmount, int nWorkers) {
            this._workAmount = workAmount;
            this._rangePositions = new int[nWorkers];
            this._rangeLength = (int)Math.ceil((double)workAmount / (double)nWorkers);
            int p2 = 0;
            for (int i2 = 0; i2 < this._rangePositions.length; ++i2) {
                this._rangePositions[i2] = p2;
                p2 += this._rangeLength;
            }
        }

        @Override
        public int getMaxId(int subsetId) {
            return Math.min((subsetId + 1) * this._rangeLength, this._workAmount);
        }

        @Override
        public int allocateWork(int subsetId) {
            int n2 = subsetId;
            int n3 = this._rangePositions[n2];
            this._rangePositions[n2] = n3 + 1;
            return n3;
        }
    }

    static class SharedPoolWorkAllocator
    implements WorkAllocator {
        final int _workAmount;
        final AtomicInteger _id;

        SharedPoolWorkAllocator(int workAmount) {
            this._workAmount = workAmount;
            this._id = new AtomicInteger();
        }

        @Override
        public int getMaxId(int subsetId) {
            return this._workAmount;
        }

        @Override
        public int allocateWork(int subsetId) {
            return this._id.getAndIncrement();
        }
    }

    static interface WorkAllocator {
        public int getMaxId(int var1);

        public int allocateWork(int var1);
    }
}

