/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.gbm;

import hex.Distribution;
import hex.DistributionFactory;
import hex.LinkFunctionFactory;
import hex.Model;
import hex.ModelCategory;
import hex.PojoWriter;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.gbm.GbmMojoModel;
import hex.genmodel.utils.DistributionFamily;
import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import hex.tree.BranchInteractionConstraints;
import hex.tree.CompressedTree;
import hex.tree.Constraints;
import hex.tree.DHistogram;
import hex.tree.DTree;
import hex.tree.MojoUtils;
import hex.tree.Sample;
import hex.tree.ScoreBuildHistogram;
import hex.tree.SharedTree;
import hex.tree.SharedTreeModel;
import hex.tree.TreeUtils;
import hex.tree.gbm.GBMModel;
import hex.tree.gbm.GbmPojoWriter;
import hex.util.LinearAlgebraUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.log4j.Logger;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.C0DChunk;
import water.fvec.C4VolatileChunk;
import water.fvec.C8DVolatileChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.MathUtils;
import water.util.RandomBase;
import water.util.RandomUtils;
import water.util.VecUtils;

public class GBM
extends SharedTree<GBMModel, GBMModel.GBMParameters, GBMModel.GBMOutput> {
    private static final Logger LOG = Logger.getLogger(GBM.class);

    @Override
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial, ModelCategory.Multinomial};
    }

    public GBM(GBMModel.GBMParameters parms) {
        super(parms);
        this.init(false);
    }

    public GBM(GBMModel.GBMParameters parms, Key<GBMModel> key) {
        super(parms, key);
        this.init(false);
    }

    public GBM(boolean startup_once) {
        super(new GBMModel.GBMParameters(), startup_once);
    }

    @Override
    protected int nModelsInParallel(int folds) {
        int defaultParallelization = this.nclasses() <= 2 ? 2 : 1;
        return this.nModelsInParallel(folds, defaultParallelization);
    }

    @Override
    protected GBMDriver trainModelImpl() {
        return new GBMDriver();
    }

    @Override
    public void init(boolean expensive) {
        super.init(expensive);
        if (expensive) {
            if (this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(this);
            }
            if (((GBMModel.GBMParameters)this._parms)._distribution == DistributionFamily.AUTO) {
                if (this._nclass == 1) {
                    ((GBMModel.GBMParameters)this._parms)._distribution = DistributionFamily.gaussian;
                }
                if (this._nclass == 2) {
                    ((GBMModel.GBMParameters)this._parms)._distribution = DistributionFamily.bernoulli;
                }
                if (this._nclass >= 3) {
                    ((GBMModel.GBMParameters)this._parms)._distribution = DistributionFamily.multinomial;
                }
            }
            this.checkDistributions();
            if (this.hasOffsetCol() && this.isClassifier() && (((GBMModel.GBMParameters)this._parms)._distribution == DistributionFamily.multinomial || ((GBMModel.GBMParameters)this._parms)._distribution == DistributionFamily.custom)) {
                this.error("_offset_column", "Offset is not supported for " + (Object)((Object)((GBMModel.GBMParameters)this._parms)._distribution) + " distribution.");
            }
            if (((GBMModel.GBMParameters)this._parms)._monotone_constraints != null && ((GBMModel.GBMParameters)this._parms)._monotone_constraints.length > 0 && !this.supportMonotoneConstraints(((GBMModel.GBMParameters)this._parms)._distribution)) {
                this.error("_monotone_constraints", "Monotone constraints are only supported for Gaussian, Bernoulli, Tweedie and Quantile distributions, your distribution: " + (Object)((Object)((GBMModel.GBMParameters)this._parms)._distribution) + ".");
            }
            if (this._origTrain != null && this._origTrain != this._train) {
                ArrayList<Double> projections = new ArrayList<Double>();
                for (int i2 = 0; i2 < this._origTrain.numCols(); ++i2) {
                    double[] actProjection;
                    Vec currentCol = this._origTrain.vec(i2);
                    if (!currentCol.isCategorical()) continue;
                    for (double v2 : actProjection = LinearAlgebraUtils.toEigenArray(currentCol)) {
                        projections.add(v2);
                    }
                }
                double[] primitive_projections = new double[projections.size()];
                for (int i3 = 0; i3 < projections.size(); ++i3) {
                    primitive_projections[i3] = (Double)projections.get(i3);
                }
                this._orig_projection_array = primitive_projections;
            }
        }
        switch (((GBMModel.GBMParameters)this._parms)._distribution) {
            case bernoulli: {
                if (this._nclass == 2) break;
                this.error("_distribution", H2O.technote(2, "Binomial requires the response to be a 2-class categorical"));
                break;
            }
            case quasibinomial: {
                if (!this._response.isNumeric()) {
                    this.error("_distribution", H2O.technote(2, "Quasibinomial requires the response to be numeric."));
                }
                if (this._nclass == 2) break;
                this.error("_distribution", H2O.technote(2, "Quasibinomial requires the response to be binary."));
                break;
            }
            case modified_huber: {
                if (this._nclass == 2) break;
                this.error("_distribution", H2O.technote(2, "Modified Huber requires the response to be a 2-class categorical."));
                break;
            }
            case multinomial: {
                if (this.isClassifier()) break;
                this.error("_distribution", H2O.technote(2, "Multinomial requires an categorical response."));
                break;
            }
            case huber: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote(2, "Huber requires the response to be numeric."));
                break;
            }
            case poisson: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote(2, "Poisson requires the response to be numeric."));
                break;
            }
            case gamma: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote(2, "Gamma requires the response to be numeric."));
                break;
            }
            case tweedie: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote(2, "Tweedie requires the response to be numeric."));
                break;
            }
            case gaussian: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote(2, "Gaussian requires the response to be numeric."));
                break;
            }
            case laplace: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote(2, "Laplace requires the response to be numeric."));
                break;
            }
            case quantile: {
                if (!this.isClassifier()) break;
                this.error("_distribution", H2O.technote(2, "Quantile requires the response to be numeric."));
                break;
            }
            case custom: {
                if (((GBMModel.GBMParameters)this._parms)._custom_distribution_func != null) break;
                this.error("_distribution", H2O.technote(2, "Custom requires custom function loaded."));
                break;
            }
            case AUTO: {
                break;
            }
            default: {
                this.error("_distribution", "Invalid distribution: " + (Object)((Object)((GBMModel.GBMParameters)this._parms)._distribution));
            }
        }
        if (!(0.0 < ((GBMModel.GBMParameters)this._parms)._learn_rate) || !(((GBMModel.GBMParameters)this._parms)._learn_rate <= 1.0)) {
            this.error("_learn_rate", "learn_rate must be between 0 and 1");
        }
        if (!(0.0 < ((GBMModel.GBMParameters)this._parms)._learn_rate_annealing) || !(((GBMModel.GBMParameters)this._parms)._learn_rate_annealing <= 1.0)) {
            this.error("_learn_rate_annealing", "learn_rate_annealing must be between 0 and 1");
        }
        if (!(0.0 < ((GBMModel.GBMParameters)this._parms)._col_sample_rate) || !(((GBMModel.GBMParameters)this._parms)._col_sample_rate <= 1.0)) {
            this.error("_col_sample_rate", "col_sample_rate must be between 0 and 1");
        }
        if (((GBMModel.GBMParameters)this._parms)._max_abs_leafnode_pred <= 0.0) {
            this.error("_max_abs_leafnode_pred", "max_abs_leafnode_pred must be larger than 0.");
        }
        if (((GBMModel.GBMParameters)this._parms)._pred_noise_bandwidth < 0.0) {
            this.error("_pred_noise_bandwidth", "pred_noise_bandwidth must be >= 0.");
        }
        if (this._train != null && ((GBMModel.GBMParameters)this._parms)._monotone_constraints != null) {
            TreeUtils.checkMonotoneConstraints(this, this._train, ((GBMModel.GBMParameters)this._parms)._monotone_constraints);
        }
        if (this._train != null && ((GBMModel.GBMParameters)this._parms)._interaction_constraints != null) {
            if (((GBMModel.GBMParameters)this._parms)._categorical_encoding != Model.Parameters.CategoricalEncodingScheme.AUTO && ((GBMModel.GBMParameters)this._parms)._categorical_encoding != Model.Parameters.CategoricalEncodingScheme.OneHotInternal) {
                this.error("_categorical_encoding", "Interaction constraints can be used when the categorical encoding is set to ``AUTO`` (``one_hot_internal`` or ``OneHotInternal``) only.");
            }
            TreeUtils.checkInteractionConstraints(this, this._train, ((GBMModel.GBMParameters)this._parms)._interaction_constraints);
            if (this.error_count() == 0) {
                this._ics = ((GBMModel.GBMParameters)this._parms).interactionConstraints(this._train);
            }
        }
    }

    private boolean supportMonotoneConstraints(DistributionFamily distributionFamily) {
        switch (distributionFamily) {
            case bernoulli: 
            case tweedie: 
            case gaussian: 
            case quantile: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected double score1(Chunk[] chks, double weight, double offset, double[] fs, int row) {
        return GBM.score1static(chks, this.idx_tree(0), offset, fs, row, DistributionFactory.getDistribution(this._parms), this._nclass);
    }

    private static double score1static(Chunk[] chks, int treeIdx, double offset, double[] fs, int row, Distribution dist, int nClasses) {
        double f2 = chks[treeIdx].atd(row) + offset;
        double p2 = dist.linkInv(f2);
        if (dist._family == DistributionFamily.modified_huber || dist._family == DistributionFamily.bernoulli || dist._family == DistributionFamily.quasibinomial || dist._family == DistributionFamily.custom && nClasses == 2) {
            fs[2] = p2;
            fs[1] = 1.0 - p2;
            return 1.0;
        }
        if (dist._family == DistributionFamily.multinomial || dist._family == DistributionFamily.custom && nClasses > 2) {
            if (nClasses == 2) {
                fs[1] = p2;
                fs[2] = 1.0 / p2;
                return fs[1] + fs[2];
            }
            assert (offset == 0.0);
            fs[1] = f2;
            for (int k2 = 1; k2 < nClasses; ++k2) {
                fs[k2 + 1] = chks[treeIdx + k2].atd(row);
            }
            return GenModel.log_rescale(fs);
        }
        fs[0] = p2;
        return fs[0];
    }

    @Override
    public PojoWriter makePojoWriter(Model<?, ?, ?> genericModel, MojoModel mojoModel) {
        GbmMojoModel gbmMojoModel = (GbmMojoModel)mojoModel;
        CompressedTree[][] trees = MojoUtils.extractCompressedTrees(gbmMojoModel);
        boolean binomialOpt = MojoUtils.isUsingBinomialOpt(gbmMojoModel, trees);
        return new GbmPojoWriter(genericModel, gbmMojoModel.getCategoricalEncoding(), binomialOpt, trees, gbmMojoModel._init_f, gbmMojoModel._balanceClasses, gbmMojoModel._family, LinkFunctionFactory.getLinkFunction(gbmMojoModel._link_function));
    }

    private static class AddTreeContributions
    extends MRTask<AddTreeContributions> {
        private SharedTree.FrameMap fm;
        private DTree[] _ktrees;
        private int _nclass;
        private double _pred_noise_bandwidth;
        private long _seed;
        private int _ntrees1;
        private int _ntrees2;

        public AddTreeContributions(SharedTree.FrameMap frameMap, DTree[] ktrees, double predictionNoiseBandwidth, long seed, int nTreesInp, int nTreesOut) {
            this.fm = frameMap;
            this._ktrees = ktrees;
            this._nclass = ktrees.length;
            this._pred_noise_bandwidth = predictionNoiseBandwidth;
            this._seed = seed;
            this._ntrees1 = nTreesInp;
            this._ntrees2 = nTreesOut;
        }

        @Override
        protected boolean modifiesVolatileVecs() {
            return true;
        }

        @Override
        public void map(Chunk[] chks) {
            RandomBase rand = RandomUtils.getRNG(this._seed);
            for (int k2 = 0; k2 < this._nclass; ++k2) {
                DTree tree = this._ktrees[k2];
                if (tree == null) continue;
                C4VolatileChunk nids = (C4VolatileChunk)chks[this.fm.nids0Index + k2];
                int[] nids_vals = nids.getValues();
                C8DVolatileChunk ct = (C8DVolatileChunk)chks[this.fm.tree0Index + k2];
                double[] ct_vals = ct.getValues();
                Chunk y2 = chks[this.fm.responseIndex];
                Chunk weights = this.fm.weightIndex >= 0 ? chks[this.fm.weightIndex] : new C0DChunk(1.0, chks[0]._len);
                long baseseed = (912559L + this._seed) * (long)(-89478485 + k2 * this._ntrees1 + this._ntrees2);
                for (int row = 0; row < nids._len; ++row) {
                    int nid = nids_vals[row];
                    nids_vals[row] = 0;
                    if (nid < 0) {
                        if (weights.atd(row) != 0.0 && !y2.isNA(row)) continue;
                        nids_vals[row] = -1;
                        continue;
                    }
                    double factor = 1.0;
                    if (this._pred_noise_bandwidth != 0.0) {
                        rand.setSeed(baseseed + (long)nid);
                        factor += rand.nextGaussian() * this._pred_noise_bandwidth;
                    }
                    ct_vals[row] = (float)(ct.atd(row) + factor * (double)((DTree.LeafNode)tree.node((int)nid))._pred);
                }
            }
        }
    }

    private static class GammaPass
    extends MRTask<GammaPass> {
        private final SharedTree.FrameMap fm;
        private final DTree[] _trees;
        private final int[] _leafs;
        private final Distribution _dist;
        private final int _nclass;
        private double[][] _num;
        private double[][] _denom;

        public GammaPass(SharedTree.FrameMap frameMap, DTree[] trees, int[] leafs, Distribution distribution, int nClasses) {
            this.fm = frameMap;
            this._leafs = leafs;
            this._trees = trees;
            this._dist = distribution;
            this._nclass = nClasses;
        }

        double gamma(int tree, int nid) {
            return this.gamma(tree, nid, this._num[tree][nid]);
        }

        double gamma(int tree, int nid, double num) {
            if (this._denom[tree][nid] == 0.0) {
                return 0.0;
            }
            double g2 = num / this._denom[tree][nid];
            assert (!Double.isInfinite(g2) && !Double.isNaN(g2));
            return this.gamma(g2);
        }

        double gamma(double g2) {
            if (this._dist._family == DistributionFamily.poisson || this._dist._family == DistributionFamily.gamma || this._dist._family == DistributionFamily.tweedie) {
                return this._dist.link(g2);
            }
            return g2;
        }

        @Override
        protected boolean modifiesVolatileVecs() {
            return true;
        }

        @Override
        public void map(Chunk[] chks) {
            this._denom = new double[this._nclass][];
            this._num = new double[this._nclass][];
            Chunk resp = chks[this.fm.responseIndex];
            for (int k2 = 0; k2 < this._nclass; ++k2) {
                Chunk weights;
                DTree tree = this._trees[k2];
                int leaf = this._leafs[k2];
                if (tree == null) continue;
                assert (tree._len - leaf >= 0);
                this._denom[k2] = new double[tree._len - leaf];
                double[] denom = this._denom[k2];
                this._num[k2] = new double[tree._len - leaf];
                double[] num = this._num[k2];
                C4VolatileChunk nids = (C4VolatileChunk)chks[this.fm.nids0Index + k2];
                int[] nids_vals = nids.getValues();
                Chunk ress = chks[this.fm.work0Index + k2];
                Chunk offset = this.fm.offsetIndex >= 0 ? chks[this.fm.offsetIndex] : new C0DChunk(0.0, chks[0]._len);
                Chunk preds = chks[this.fm.tree0Index + k2];
                Chunk chunk = weights = this.fm.weightIndex >= 0 ? chks[this.fm.weightIndex] : new C0DChunk(1.0, chks[0]._len);
                if (tree.root() instanceof DTree.LeafNode) continue;
                for (int row = 0; row < nids._len; ++row) {
                    int idx;
                    double y2;
                    double w2 = weights.atd(row);
                    if (w2 == 0.0 || Double.isNaN(y2 = resp.atd(row))) continue;
                    int nid = (int)nids.at8(row);
                    boolean wasOOBRow = ScoreBuildHistogram.isOOBRow(nid);
                    if (wasOOBRow) {
                        nid = ScoreBuildHistogram.oob2Nid(nid);
                    }
                    if (nid < 0) continue;
                    DTree.DecidedNode dn = tree.decided(nid);
                    if (dn._split == null) {
                        dn = tree.decided(dn.pid());
                    }
                    int leafnid = dn.getChildNodeID(chks, row);
                    assert (leaf <= leafnid && leafnid < tree._len) : "leaf: " + leaf + " leafnid: " + leafnid + " tree._len: " + tree._len + "\ndn: " + dn;
                    assert (tree.node(leafnid) instanceof DTree.LeafNode);
                    nids_vals[row] = leafnid;
                    assert (!ress.isNA(row));
                    if (wasOOBRow || this._dist._family == DistributionFamily.laplace || this._dist._family == DistributionFamily.huber || this._dist._family == DistributionFamily.quantile) continue;
                    double z2 = ress.atd(row);
                    double f2 = preds.atd(row) + offset.atd(row);
                    int n2 = idx = leafnid - leaf;
                    num[n2] = num[n2] + this._dist.gammaNum(w2, y2, z2, f2);
                    int n3 = idx;
                    denom[n3] = denom[n3] + this._dist.gammaDenom(w2, y2, z2, f2);
                }
            }
        }

        @Override
        public void reduce(GammaPass gp) {
            ArrayUtils.add(this._denom, gp._denom);
            ArrayUtils.add(this._num, gp._num);
        }
    }

    private static class StoreResiduals
    extends MRTask<StoreResiduals> {
        private SharedTree.FrameMap fm;
        private Distribution dist;

        public StoreResiduals(SharedTree.FrameMap frameMap, Distribution distribution) {
            this.fm = frameMap;
            this.dist = distribution;
        }

        @Override
        protected boolean modifiesVolatileVecs() {
            return true;
        }

        @Override
        public void map(Chunk[] chks) {
            Chunk ys = chks[this.fm.responseIndex];
            Chunk offset = this.fm.offsetIndex >= 0 ? chks[this.fm.offsetIndex] : new C0DChunk(0.0, chks[0]._len);
            Chunk preds = chks[this.fm.tree0Index];
            C8DVolatileChunk wk = (C8DVolatileChunk)chks[this.fm.work0Index];
            Chunk weights = this.fm.weightIndex >= 0 ? chks[this.fm.weightIndex] : new C0DChunk(1.0, chks[0]._len);
            for (int row = 0; row < wk._len; ++row) {
                double weight = weights.atd(row);
                if (weight == 0.0 || ys.isNA(row)) continue;
                double f2 = preds.atd(row) + offset.atd(row);
                double y2 = ys.atd(row);
                wk.getValues()[row] = (float)this.dist.negHalfGradient(y2, f2);
            }
        }
    }

    private static final class HuberLeafMath
    extends MRTask<HuberLeafMath> {
        final SharedTree.FrameMap fm;
        final double _huberDelta;
        final Vec _strata;
        final int _strataMin;
        final int _strataMax;
        double[] _huberGamma;
        double[] _wcounts;

        public HuberLeafMath(SharedTree.FrameMap frameMap, double huberDelta, Vec strata) {
            this.fm = frameMap;
            this._huberDelta = huberDelta;
            this._strata = strata;
            this._strataMin = (int)this._strata.min();
            this._strataMax = (int)this._strata.max();
        }

        @Override
        public void map(Chunk[] cs) {
            if (this._strata.length() == 0L) {
                LOG.warn((Object)"No Huber math can be done since there's no strata.");
                this._huberGamma = new double[0];
                return;
            }
            int nstrata = this._strataMax - this._strataMin + 1;
            LOG.info((Object)("Computing Huber math for (up to) " + nstrata + " different strata."));
            this._huberGamma = new double[nstrata];
            this._wcounts = new double[nstrata];
            Chunk weights = this.fm.weightIndex >= 0 ? cs[this.fm.weightIndex] : new C0DChunk(1.0, cs[0]._len);
            Chunk stratum = cs[this.fm.nids0Index];
            Chunk diffMinusMedianDiff = cs[cs.length - 1];
            for (int row = 0; row < cs[0]._len; ++row) {
                int nidx;
                int n2 = nidx = (int)stratum.at8(row) - this._strataMin;
                this._huberGamma[n2] = this._huberGamma[n2] + weights.atd(row) * Math.signum(diffMinusMedianDiff.atd(row)) * Math.min(Math.abs(diffMinusMedianDiff.atd(row)), this._huberDelta);
                int n3 = nidx;
                this._wcounts[n3] = this._wcounts[n3] + weights.atd(row);
            }
        }

        @Override
        public void reduce(HuberLeafMath mrt) {
            ArrayUtils.add(this._huberGamma, mrt._huberGamma);
            ArrayUtils.add(this._wcounts, mrt._wcounts);
        }

        @Override
        protected void postGlobal() {
            for (int i2 = 0; i2 < this._huberGamma.length; ++i2) {
                int n2 = i2;
                this._huberGamma[n2] = this._huberGamma[n2] / this._wcounts[i2];
            }
        }
    }

    public static class DiffMinusMedianDiff
    extends MRTask<DiffMinusMedianDiff> {
        private final int _strataMin;
        private double[] _terminalMedians;

        public DiffMinusMedianDiff(Vec strata, double[] terminalMedians) {
            this._strataMin = (int)strata.min();
            this._terminalMedians = terminalMedians;
        }

        @Override
        public void map(Chunk[] chks) {
            Chunk strata = chks[0];
            Chunk diff = chks[1];
            for (int i2 = 0; i2 < chks[0].len(); ++i2) {
                int nid = (int)strata.atd(i2);
                diff.set(i2, diff.atd(i2) - this._terminalMedians[nid - this._strataMin]);
            }
        }
    }

    private static class ComputeAbsDiff
    extends MRTask<ComputeAbsDiff> {
        private SharedTree.FrameMap fm;

        public ComputeAbsDiff(SharedTree.FrameMap frameMap) {
            this.fm = frameMap;
        }

        @Override
        public void map(Chunk[] chks, NewChunk[] nc) {
            Chunk y2 = chks[this.fm.responseIndex];
            Chunk o2 = this.fm.offsetIndex >= 0 ? chks[this.fm.offsetIndex] : new C0DChunk(0.0, chks[0]._len);
            Chunk f2 = chks[this.fm.tree0Index];
            for (int i2 = 0; i2 < chks[0].len(); ++i2) {
                nc[0].addNum(Math.abs(y2.atd(i2) - (f2.atd(i2) + o2.atd(i2))));
            }
        }
    }

    private static class ComputeDiff
    extends MRTask<ComputeDiff> {
        private SharedTree.FrameMap fm;

        public ComputeDiff(SharedTree.FrameMap frameMap) {
            this.fm = frameMap;
        }

        @Override
        public void map(Chunk[] chks, NewChunk[] nc) {
            Chunk y2 = chks[this.fm.responseIndex];
            Chunk o2 = this.fm.offsetIndex >= 0 ? chks[this.fm.offsetIndex] : new C0DChunk(0.0, chks[0]._len);
            Chunk f2 = chks[this.fm.tree0Index];
            for (int i2 = 0; i2 < chks[0].len(); ++i2) {
                nc[0].addNum(y2.atd(i2) - (f2.atd(i2) + o2.atd(i2)));
            }
        }
    }

    private static class ComputeMinMax
    extends MRTask<ComputeMinMax> {
        private SharedTree.FrameMap fm;
        int firstLeafIdx;
        int _totalNumNodes;
        float[] _mins;
        float[] _maxs;

        public ComputeMinMax(SharedTree.FrameMap frameMap, int firstLeafIndex, int totalNumNodes) {
            this.fm = frameMap;
            this.firstLeafIdx = firstLeafIndex;
            this._totalNumNodes = totalNumNodes;
        }

        @Override
        public void map(Chunk[] chks) {
            int len = this._totalNumNodes - this.firstLeafIdx;
            this._mins = new float[len];
            this._maxs = new float[len];
            Arrays.fill(this._mins, Float.MAX_VALUE);
            Arrays.fill(this._maxs, -3.4028235E38f);
            Chunk ys = chks[this.fm.responseIndex];
            Chunk offset = this.fm.offsetIndex >= 0 ? chks[this.fm.offsetIndex] : new C0DChunk(0.0, chks[0]._len);
            Chunk preds = chks[this.fm.tree0Index];
            Chunk nids = chks[this.fm.nids0Index];
            Chunk weights = this.fm.weightIndex >= 0 ? chks[this.fm.weightIndex] : new C0DChunk(1.0, chks[0]._len);
            for (int row = 0; row < preds._len; ++row) {
                if (ys.isNA(row) || weights.atd(row) == 0.0) continue;
                int nid = (int)nids.at8(row);
                assert (nid != -1);
                if (nid < 0) continue;
                float f2 = (float)(preds.atd(row) + offset.atd(row));
                int idx = nid - this.firstLeafIdx;
                this._mins[idx] = Math.min(this._mins[idx], f2);
                this._maxs[idx] = Math.max(this._maxs[idx], f2);
            }
        }

        @Override
        public void reduce(ComputeMinMax mrt) {
            ArrayUtils.reduceMin(this._mins, mrt._mins);
            ArrayUtils.reduceMax(this._maxs, mrt._maxs);
        }
    }

    private static class ComputePredAndRes
    extends MRTask<ComputePredAndRes> {
        private SharedTree.FrameMap fm;
        private int nclass;
        private boolean[] out;
        private Distribution dist;

        public ComputePredAndRes(SharedTree.FrameMap frameMap, int nClasses, double[] outputDistribution, Distribution distribution) {
            this.fm = frameMap;
            this.nclass = nClasses;
            this.dist = distribution;
            this.out = new boolean[outputDistribution.length];
            for (int i2 = 0; i2 < this.out.length; ++i2) {
                this.out[i2] = outputDistribution[i2] != 0.0;
            }
        }

        @Override
        public void map(Chunk[] chks) {
            Chunk ys = chks[this.fm.responseIndex];
            Chunk offset = this.fm.offsetIndex >= 0 ? chks[this.fm.offsetIndex] : new C0DChunk(0.0, chks[0]._len);
            Chunk preds = chks[this.fm.tree0Index];
            C8DVolatileChunk wk = (C8DVolatileChunk)chks[this.fm.work0Index];
            Chunk weights = this.fm.weightIndex >= 0 ? chks[this.fm.weightIndex] : new C0DChunk(1.0, chks[0]._len);
            double[] fs = this.nclass > 1 ? new double[this.nclass + 1] : null;
            for (int row = 0; row < wk._len; ++row) {
                double weight = weights.atd(row);
                if (weight == 0.0 || ys.isNA(row)) continue;
                double f2 = preds.atd(row) + offset.atd(row);
                double y2 = ys.atd(row);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(f2 + " vs " + y2));
                }
                if (this.dist._family == DistributionFamily.multinomial && fs != null || this.dist._family == DistributionFamily.custom && this.nclass > 2) {
                    int k2;
                    double sum = GBM.score1static(chks, this.fm.tree0Index, 0.0, fs, row, this.dist, this.nclass);
                    if (Double.isInfinite(sum)) {
                        for (k2 = 0; k2 < this.nclass; ++k2) {
                            wk = (C8DVolatileChunk)chks[this.fm.work0Index + k2];
                            wk.getValues()[row] = (float)this.dist.negHalfGradient(y2, Double.isInfinite(fs[k2 + 1]) ? 1.0f : 0.0f, k2);
                        }
                        continue;
                    }
                    for (k2 = 0; k2 < this.nclass; ++k2) {
                        if (!this.out[k2]) continue;
                        wk = (C8DVolatileChunk)chks[this.fm.work0Index + k2];
                        wk.getValues()[row] = (float)this.dist.negHalfGradient(y2, (float)(fs[k2 + 1] / sum), k2);
                    }
                    continue;
                }
                wk.getValues()[row] = (float)this.dist.negHalfGradient(y2, f2);
            }
        }
    }

    private static class NewtonRaphson
    extends MRTask<NewtonRaphson> {
        private SharedTree.FrameMap fm;
        private Distribution dist;
        private double _init;
        private double _numerator;
        private double _denominator;

        public NewtonRaphson(SharedTree.FrameMap frameMap, Distribution distribution, double initialValue) {
            assert (frameMap != null && distribution != null);
            this.fm = frameMap;
            this.dist = distribution;
            this._init = initialValue;
            this._numerator = 0.0;
            this._denominator = 0.0;
        }

        public double value() {
            return this._init + this._numerator / this._denominator;
        }

        @Override
        public void map(Chunk[] chks) {
            Chunk ys = chks[this.fm.responseIndex];
            Chunk offset = chks[this.fm.offsetIndex];
            Chunk weight = this.fm.weightIndex >= 0 ? chks[this.fm.weightIndex] : new C0DChunk(1.0, chks[0]._len);
            for (int row = 0; row < ys._len; ++row) {
                double w2 = weight.atd(row);
                if (w2 == 0.0 || ys.isNA(row)) continue;
                double y2 = ys.atd(row);
                double o2 = offset.atd(row);
                double p2 = this.dist.linkInv(o2 + this._init);
                this._numerator += w2 * (y2 - p2);
                this._denominator += w2 * p2 * (1.0 - p2);
            }
        }

        @Override
        public void reduce(NewtonRaphson mrt) {
            this._numerator += mrt._numerator;
            this._denominator += mrt._denominator;
        }
    }

    private static class ResponseLessOffsetTask
    extends MRTask<ResponseLessOffsetTask> {
        private SharedTree.FrameMap fm;

        public ResponseLessOffsetTask(SharedTree.FrameMap frameMap) {
            this.fm = frameMap;
        }

        @Override
        public void map(Chunk[] chks, NewChunk[] nc) {
            Chunk resp = chks[this.fm.responseIndex];
            Chunk offset = chks[this.fm.offsetIndex];
            for (int i2 = 0; i2 < chks[0]._len; ++i2) {
                nc[0].addNum(resp.atd(i2) - offset.atd(i2));
            }
        }
    }

    private static class FillVecWithConstant
    extends MRTask<FillVecWithConstant> {
        private double init;

        public FillVecWithConstant(double d2) {
            this.init = d2;
        }

        @Override
        protected boolean modifiesVolatileVecs() {
            return true;
        }

        @Override
        public void map(Chunk tree) {
            if (tree instanceof C8DVolatileChunk) {
                Arrays.fill(((C8DVolatileChunk)tree).getValues(), this.init);
            } else {
                for (int i2 = 0; i2 < tree._len; ++i2) {
                    tree.set(i2, this.init);
                }
            }
        }
    }

    private class GBMDriver
    extends SharedTree.Driver {
        private transient SharedTree.FrameMap frameMap;
        private transient long _skippedCnt;
        private static final double MIN_LOG_TRUNC = -19.0;
        private static final double MAX_LOG_TRUNC = 19.0;

        private GBMDriver() {
        }

        @Override
        protected Frame makeValidWorkspace() {
            Vec[] tmp;
            int nClasses = this.numClassTrees();
            if (this.validWorkspaceCanReuseTrainWorkspace()) {
                tmp = new Vec[nClasses];
                for (int i2 = 0; i2 < nClasses; ++i2) {
                    tmp[i2] = GBM.this._train.vec(GBM.this.idx_tree(i2));
                    assert (tmp[i2].isVolatile());
                }
            } else {
                tmp = GBM.this._valid.anyVec().makeVolatileDoubles(nClasses);
            }
            String[] tmpNames = new String[tmp.length];
            for (int i3 = 0; i3 < tmpNames.length; ++i3) {
                tmpNames[i3] = "__P_" + i3;
            }
            return new Frame(tmpNames, tmp);
        }

        private boolean validWorkspaceCanReuseTrainWorkspace() {
            if (!((GBMModel.GBMParameters)GBM.this._parms)._is_cv_model) {
                return false;
            }
            return ((GBM)GBM.this)._vresponse._key.equals(((GBM)GBM.this)._response._key);
        }

        @Override
        protected boolean doOOBScoring() {
            return false;
        }

        @Override
        protected void initializeModelSpecifics() {
            long zeroWeights;
            this.frameMap = new SharedTree.FrameMap(GBM.this);
            GBM.this._mtry_per_tree = Math.max(1, (int)(((GBMModel.GBMParameters)GBM.this._parms)._col_sample_rate_per_tree * (double)GBM.this._ncols));
            assert (((GBMModel.GBMParameters)GBM.this._parms).useColSampling() || GBM.this._mtry_per_tree == GBM.this._ncols);
            if (1 > GBM.this._mtry_per_tree || GBM.this._mtry_per_tree > GBM.this._ncols) {
                throw new IllegalArgumentException("Computed mtry_per_tree should be in interval <1," + GBM.this._ncols + "> but it is " + GBM.this._mtry_per_tree);
            }
            GBM.this._mtry = Math.max(1, (int)(((GBMModel.GBMParameters)GBM.this._parms)._col_sample_rate * ((GBMModel.GBMParameters)GBM.this._parms)._col_sample_rate_per_tree * (double)GBM.this._ncols));
            assert (((GBMModel.GBMParameters)GBM.this._parms).useColSampling() || GBM.this._mtry == GBM.this._ncols);
            if (1 > GBM.this._mtry || GBM.this._mtry > GBM.this._ncols) {
                throw new IllegalArgumentException("Computed mtry should be in interval <1," + GBM.this._ncols + "> but it is " + GBM.this._mtry);
            }
            DistributionFamily distr = ((GBMModel.GBMParameters)GBM.this._parms)._distribution;
            GBM.this._initialPrediction = GBM.this._nclass > 2 || distr == DistributionFamily.laplace || distr == DistributionFamily.huber || distr == DistributionFamily.quantile ? 0.0 : GBM.this.getInitialValue();
            if (distr == DistributionFamily.quasibinomial) {
                ((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._quasibinomialDomains = ((VecUtils.CollectDoubleDomain)new VecUtils.CollectDoubleDomain(null, 2).doAll(GBM.this._response)).stringDomain(GBM.this._response.isInt());
            }
            if (distr == DistributionFamily.bernoulli || distr == DistributionFamily.quasibinomial) {
                if (GBM.this.hasOffsetCol()) {
                    GBM.this._initialPrediction = this.getInitialValueBernoulliOffset(GBM.this._train);
                }
            } else if (distr == DistributionFamily.laplace || distr == DistributionFamily.huber) {
                GBM.this._initialPrediction = this.getInitialValueQuantile(0.5);
            } else if (distr == DistributionFamily.quantile) {
                GBM.this._initialPrediction = this.getInitialValueQuantile(((GBMModel.GBMParameters)GBM.this._parms)._quantile_alpha);
            }
            ((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._init_f = GBM.this._initialPrediction;
            if (((GBMModel)((GBM)GBM.this)._model).evalAutoParamsEnabled) {
                ((GBMModel)GBM.this._model).initActualParamValuesAfterOutputSetup(GBM.this._nclass, GBM.this.isClassifier());
            }
            if (GBM.this._initialPrediction != 0.0) {
                new FillVecWithConstant(GBM.this._initialPrediction).doAll(GBM.this.vec_tree(GBM.this._train, 0), ((GBMModel.GBMParameters)GBM.this._parms)._build_tree_one_node);
            }
            long l2 = zeroWeights = GBM.this.hasWeightCol() ? GBM.this._weights.length() - GBM.this._weights.nzCnt() : 0L;
            if (zeroWeights > 0L || GBM.this.response().naCnt() > 0L) {
                Vec[] vecs = new Vec[]{GBM.this._response};
                if (GBM.this.hasWeightCol()) {
                    vecs = ArrayUtils.append(vecs, GBM.this._weights);
                }
                for (int k2 = 0; k2 < GBM.this._nclass; ++k2) {
                    Vec nidsVecK = GBM.this.vec_nids(GBM.this._train, k2);
                    if (nidsVecK.min() == -1.0) {
                        assert (((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._distribution[k2] == 0.0);
                        assert (nidsVecK.isConst());
                        continue;
                    }
                    vecs = ArrayUtils.append(vecs, nidsVecK);
                }
                this._skippedCnt = ((MarkDecidedRows)(GBMDriver)this.new MarkDecidedRows().doAll((Vec[])vecs)).markedCnt;
                assert (this._skippedCnt >= zeroWeights);
                assert (this._skippedCnt >= GBM.this.response().naCnt());
                assert (this._skippedCnt <= GBM.this.response().naCnt() + zeroWeights);
            } else {
                this._skippedCnt = 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private double getInitialValueQuantile(double quantile) {
            double res;
            Vec y2 = GBM.this.hasOffsetCol() ? ((ResponseLessOffsetTask)new ResponseLessOffsetTask(this.frameMap).doAll(1, (byte)3, GBM.this._train)).outputFrame().anyVec() : GBM.this.response();
            Keyed qm = null;
            Frame tempFrame = null;
            try {
                tempFrame = new Frame(Key.make(H2O.SELF), new String[]{"y"}, new Vec[]{y2});
                if (GBM.this.hasWeightCol()) {
                    tempFrame.add("w", GBM.this._weights);
                }
                DKV.put(tempFrame);
                QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
                parms._train = tempFrame._key;
                parms._probs = new double[]{quantile};
                parms._weights_column = GBM.this.hasWeightCol() ? "w" : null;
                Job job1 = new Quantile(parms).trainModel();
                qm = (QuantileModel)job1.get();
                res = ((QuantileModel.QuantileOutput)((QuantileModel)qm)._output)._quantiles[0][0];
            }
            finally {
                if (qm != null) {
                    qm.remove();
                }
                if (tempFrame != null) {
                    DKV.remove(tempFrame._key);
                }
            }
            return res;
        }

        private double getInitialValueBernoulliOffset(Frame train) {
            double delta;
            LOG.info((Object)"Running Newton-Raphson iteration to find the initial value since offsets are specified.");
            int count2 = 0;
            double tol = 1.0E-4;
            int N2 = 1;
            double init = 0.0;
            do {
                double newInit = ((NewtonRaphson)new NewtonRaphson(this.frameMap, DistributionFactory.getDistribution(GBM.this._parms), init).doAll(train)).value();
                delta = Math.abs(init - newInit);
                init = newInit;
                LOG.info((Object)("Iteration " + ++count2 + ": initial value: " + init));
            } while (count2 < N2 && delta >= tol);
            if (delta > tol) {
                LOG.warn((Object)"Not fully converged.");
            }
            LOG.info((Object)("Newton-Raphson iteration ran for " + count2 + " iteration(s). Final residual: " + delta));
            return init;
        }

        private void truncatePreds(DTree tree, int firstLeafIndex, DistributionFamily dist) {
            if (firstLeafIndex == tree._len) {
                return;
            }
            ComputeMinMax minMax = (ComputeMinMax)new ComputeMinMax(this.frameMap, firstLeafIndex, tree._len).doAll(GBM.this._train);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Number of leaf nodes: " + minMax._mins.length));
                LOG.trace((Object)("Min: " + Arrays.toString(minMax._mins)));
                LOG.trace((Object)("Max: " + Arrays.toString(minMax._maxs)));
            }
            for (int i2 = 0; i2 < tree._len - firstLeafIndex; ++i2) {
                DTree.LeafNode node = (DTree.LeafNode)tree.node(firstLeafIndex + i2);
                int nidx = node.nid();
                float nodeMin = minMax._mins[nidx - firstLeafIndex];
                float nodeMax = minMax._maxs[nidx - firstLeafIndex];
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Node: " + nidx + " min/max: " + nodeMin + "/" + nodeMax));
                }
                double val = node._pred;
                if (dist == DistributionFamily.gamma || dist == DistributionFamily.tweedie) {
                    val += (double)nodeMax;
                }
                if (val > 19.0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Truncating large positive leaf prediction (log): " + node._pred + " to " + (19.0 - (double)nodeMax)));
                    }
                    node._pred = (float)(19.0 - (double)nodeMax);
                }
                val = node._pred;
                if (dist == DistributionFamily.gamma || dist == DistributionFamily.tweedie) {
                    val += (double)nodeMin;
                }
                if (val < -19.0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Truncating large negative leaf prediction (log): " + node._pred + " to " + (-19.0 - (double)nodeMin)));
                    }
                    node._pred = (float)(-19.0 - (double)nodeMin);
                }
                if (!((double)node._pred < -19.0) || !((double)node._pred > 19.0)) continue;
                LOG.warn((Object)("Terminal node prediction outside of allowed interval in log-space: " + node._pred + " (should be in " + -19.0 + "..." + 19.0 + ")."));
            }
        }

        @Override
        protected boolean buildNextKTrees() {
            boolean converged;
            DTree[] ktrees = new DTree[GBM.this._nclass];
            int[] leaves = new int[GBM.this._nclass];
            Distribution distributionImpl = DistributionFactory.getDistribution(GBM.this._parms);
            double huberDelta = Double.NaN;
            if (((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.huber) {
                Vec diff = ((ComputeAbsDiff)new ComputeAbsDiff(this.frameMap).doAll(1, (byte)3, GBM.this._train)).outputFrame().anyVec();
                huberDelta = MathUtils.computeWeightedQuantile(GBM.this._weights, diff, ((GBMModel.GBMParameters)GBM.this._parms)._huber_alpha);
                distributionImpl.setHuberDelta(huberDelta);
                new StoreResiduals(this.frameMap, distributionImpl).doAll(GBM.this._train, ((GBMModel.GBMParameters)GBM.this._parms)._build_tree_one_node);
            } else {
                new ComputePredAndRes(this.frameMap, GBM.this._nclass, ((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._distribution, distributionImpl).doAll(GBM.this._train, ((GBMModel.GBMParameters)GBM.this._parms)._build_tree_one_node);
            }
            for (int k2 = 0; k2 < GBM.this._nclass; ++k2) {
                if (!LOG.isTraceEnabled() || ktrees[k2] == null) continue;
                LOG.trace((Object)("Updated predictions in WORK col for class " + k2 + ":\n" + new Frame(new String[]{"WORK"}, new Vec[]{GBM.this.vec_work(GBM.this._train, k2)}).toTwoDimTable()));
            }
            Constraints cs = ((GBMModel.GBMParameters)GBM.this._parms).constraints(GBM.this._train);
            BranchInteractionConstraints bics = null;
            if (((GBMModel.GBMParameters)GBM.this._parms)._interaction_constraints != null) {
                bics = ((GBMModel.GBMParameters)GBM.this._parms).initialInteractionConstraints(GBM.this._ics);
            }
            this.growTrees(ktrees, leaves, GBM.this._rand, cs, bics);
            for (int k3 = 0; k3 < GBM.this._nclass; ++k3) {
                if (!LOG.isTraceEnabled() || ktrees[k3] == null) continue;
                LOG.trace((Object)("Grew trees. Updated NIDs for class " + k3 + ":\n" + new Frame(new String[]{"NIDS"}, new Vec[]{GBM.this.vec_nids(GBM.this._train, k3)}).toTwoDimTable()));
            }
            GammaPass gp = new GammaPass(this.frameMap, ktrees, leaves, distributionImpl, GBM.this._nclass);
            gp.doAll(GBM.this._train);
            if (((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.laplace) {
                this.fitBestConstantsQuantile(ktrees, leaves[0], 0.5);
            } else if (((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.quantile) {
                if (cs == null) {
                    this.fitBestConstantsQuantile(ktrees, leaves[0], ((GBMModel.GBMParameters)GBM.this._parms)._quantile_alpha);
                } else {
                    this.fitBestConstants(ktrees, leaves, gp, cs);
                    this.resetQuantileConstants(ktrees, ((GBMModel.GBMParameters)GBM.this._parms)._quantile_alpha, cs);
                }
            } else if (((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.huber) {
                this.fitBestConstantsHuber(ktrees, leaves[0], huberDelta);
            } else {
                this.fitBestConstants(ktrees, leaves, gp, cs);
            }
            if (((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.gamma || ((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.poisson || ((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.tweedie) {
                assert (GBM.this._nclass == 1);
                this.truncatePreds(ktrees[0], leaves[0], ((GBMModel.GBMParameters)GBM.this._parms)._distribution);
            }
            if (cs != null && this.constraintCheckEnabled()) {
                GBM.this._job.update(0L, "Checking monotonicity constraints on the final model");
                this.checkConstraints(ktrees, leaves, cs);
            }
            new AddTreeContributions(this.frameMap, ktrees, ((GBMModel.GBMParameters)GBM.this._parms)._pred_noise_bandwidth, ((GBMModel.GBMParameters)GBM.this._parms)._seed, ((GBMModel.GBMParameters)GBM.this._parms)._ntrees, ((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._ntrees).doAll(GBM.this._train);
            for (int k4 = 0; k4 < GBM.this._nclass; ++k4) {
                assert (ktrees[k4] == null || GBM.this.vec_nids(GBM.this._train, k4).nzCnt() == this._skippedCnt);
            }
            ((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output).addKTrees(ktrees);
            if (!((GBMModel.GBMParameters)GBM.this._parms).isStochastic()) {
                converged = true;
                for (DTree tree : ktrees) {
                    if (tree == null) continue;
                    DTree.Node root = tree.root();
                    boolean bl = converged = root instanceof DTree.LeafNode && ((DTree.LeafNode)root)._pred == 0.0f;
                    if (!converged) break;
                }
                if (converged) {
                    LOG.warn((Object)("Model cannot be further improved by building more trees, stopping with ntrees=" + ((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._ntrees + "."));
                    return true;
                }
            }
            boolean bl = converged = this.effective_learning_rate() < 1.0E-6;
            if (converged) {
                LOG.warn((Object)("Effective learning rate dropped below 1e-6 (" + ((GBMModel.GBMParameters)GBM.this._parms)._learn_rate + " * " + ((GBMModel.GBMParameters)GBM.this._parms)._learn_rate_annealing + "^" + (((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._ntrees - 1) + ") - stopping the model now."));
            }
            return converged;
        }

        private int numClassTrees() {
            return GBM.this._nclass == 2 ? 1 : GBM.this._nclass;
        }

        private void growTrees(DTree[] ktrees, int[] leaves, Random rand, Constraints cs, BranchInteractionConstraints bics) {
            DHistogram[][][] hcs = new DHistogram[GBM.this._nclass][1][GBM.this._ncols];
            int adj_nbins = Math.max(((GBMModel.GBMParameters)GBM.this._parms)._nbins_top_level, ((GBMModel.GBMParameters)GBM.this._parms)._nbins);
            long rseed = rand.nextLong();
            for (int k2 = 0; k2 < this.numClassTrees(); ++k2) {
                if (((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._distribution[k2] == 0.0) continue;
                ktrees[k2] = new DTree(GBM.this._train, GBM.this._ncols, GBM.this._mtry, GBM.this._mtry_per_tree, rseed, (SharedTreeModel.SharedTreeParameters)GBM.this._parms);
                DHistogram[] hist = DHistogram.initialHist(GBM.this._train, GBM.this._ncols, adj_nbins, hcs[k2][0], rseed, (SharedTreeModel.SharedTreeParameters)GBM.this._parms, this.getGlobalQuantilesKeys(), cs, false, GBM.this._ics);
                new DTree.UndecidedNode(ktrees[k2], -1, hist, cs, bics);
            }
            if (((GBMModel.GBMParameters)GBM.this._parms).useRowSampling()) {
                int k3;
                Sample[] ss = new Sample[GBM.this._nclass];
                for (k3 = 0; k3 < GBM.this._nclass; ++k3) {
                    if (ktrees[k3] == null) continue;
                    ss[k3] = (Sample)new Sample(ktrees[k3], ((GBMModel.GBMParameters)GBM.this._parms)._sample_rate, ((GBMModel.GBMParameters)GBM.this._parms)._sample_rate_per_class).dfork(null, new Frame(GBM.this.vec_nids(GBM.this._train, k3), GBM.this._response), ((GBMModel.GBMParameters)GBM.this._parms)._build_tree_one_node);
                }
                for (k3 = 0; k3 < GBM.this._nclass; ++k3) {
                    if (ss[k3] == null) continue;
                    ss[k3].getResult();
                    if (!LOG.isTraceEnabled() || ktrees[k3] == null) continue;
                    LOG.trace((Object)("Sampled OOB rows. NIDS:\n" + new Frame(GBM.this.vec_nids(GBM.this._train, k3)).toTwoDimTable()));
                }
            }
            for (int depth = 0; depth < ((GBMModel.GBMParameters)GBM.this._parms)._max_depth && (hcs = GBM.this.buildLayer(GBM.this._train, ((GBMModel.GBMParameters)GBM.this._parms)._nbins, ktrees, leaves, hcs, ((GBMModel.GBMParameters)GBM.this._parms)._build_tree_one_node)) != null; ++depth) {
            }
            for (int k4 = 0; k4 < GBM.this._nclass; ++k4) {
                int leaf;
                DTree tree = ktrees[k4];
                if (tree == null) continue;
                leaves[k4] = leaf = tree.len();
                for (int nid = 0; nid < leaf; ++nid) {
                    if (!(tree.node(nid) instanceof DTree.DecidedNode)) continue;
                    DTree.DecidedNode dn = tree.decided(nid);
                    if (dn._split == null) {
                        if (nid != 0) continue;
                        new DTree.LeafNode(tree, -1, 0);
                        continue;
                    }
                    for (int i2 = 0; i2 < dn._nids.length; ++i2) {
                        int cnid = dn._nids[i2];
                        if (cnid != -1 && !(tree.node(cnid) instanceof DTree.UndecidedNode) && (!(tree.node(cnid) instanceof DTree.DecidedNode) || ((DTree.DecidedNode)tree.node((int)cnid))._split != null)) continue;
                        dn._nids[i2] = new DTree.LeafNode(tree, nid).nid();
                    }
                }
            }
        }

        private void fitBestConstantsHuber(DTree[] ktrees, int firstLeafIndex, double huberDelta) {
            if (firstLeafIndex == ktrees[0]._len) {
                return;
            }
            assert (GBM.this._nclass == 1);
            Vec diff = ((ComputeDiff)new ComputeDiff(this.frameMap).doAll(1, (byte)3, GBM.this._train)).outputFrame().anyVec();
            Vec weights = GBM.this.hasWeightCol() ? GBM.this._train.vecs()[GBM.this.idx_weight()] : null;
            Vec strata = GBM.this.vec_nids(GBM.this._train, 0);
            Quantile.StratifiedQuantilesTask sqt = new Quantile.StratifiedQuantilesTask(null, 0.5, diff, weights, strata, QuantileModel.CombineMethod.INTERPOLATE);
            H2O.submitTask(sqt);
            sqt.join();
            DiffMinusMedianDiff hp = new DiffMinusMedianDiff(strata, sqt._quantiles);
            Frame tmpFrame1 = new Frame(new String[]{"strata", "diff"}, new Vec[]{strata, diff});
            hp.doAll(tmpFrame1);
            Vec diffMinusMedianDiff = diff;
            Frame tmpFrame2 = new Frame(GBM.this._train.vecs());
            tmpFrame2.add("resMinusMedianRes", diffMinusMedianDiff);
            double[] huberGamma = ((HuberLeafMath)new HuberLeafMath((SharedTree.FrameMap)this.frameMap, (double)huberDelta, (Vec)strata).doAll((Frame)tmpFrame2))._huberGamma;
            DTree tree = ktrees[0];
            for (int i2 = 0; i2 < sqt._quantiles.length; ++i2) {
                double huber = sqt._quantiles[i2] + huberGamma[i2];
                if (Double.isNaN(sqt._quantiles[i2])) continue;
                double val = this.effective_learning_rate() * huber;
                assert (!Double.isNaN(val) && !Double.isInfinite(val));
                if (val > ((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred) {
                    val = ((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred;
                }
                if (val < -((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred) {
                    val = -((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred;
                }
                ((DTree.LeafNode)tree.node((int)sqt._nids[i2]))._pred = (float)val;
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Leaf " + sqt._nids[i2] + " has huber value: " + huber));
            }
            diffMinusMedianDiff.remove();
        }

        private double effective_learning_rate() {
            return ((GBMModel.GBMParameters)GBM.this._parms)._learn_rate * Math.pow(((GBMModel.GBMParameters)GBM.this._parms)._learn_rate_annealing, ((GBMModel.GBMOutput)((GBMModel)((GBM)GBM.this)._model)._output)._ntrees - 1);
        }

        private void fitBestConstantsQuantile(DTree[] ktrees, int firstLeafIndex, double quantile) {
            if (firstLeafIndex == ktrees[0]._len) {
                return;
            }
            assert (GBM.this._nclass == 1);
            Vec diff = ((ComputeDiff)new ComputeDiff(this.frameMap).doAll(1, (byte)3, GBM.this._train)).outputFrame().anyVec();
            Vec weights = GBM.this.hasWeightCol() ? GBM.this._train.vecs()[GBM.this.idx_weight()] : null;
            Vec strata = GBM.this.vec_nids(GBM.this._train, 0);
            QuantileModel.CombineMethod combine_method = QuantileModel.CombineMethod.INTERPOLATE;
            Quantile.StratifiedQuantilesTask sqt = new Quantile.StratifiedQuantilesTask(null, quantile, diff, weights, strata, combine_method);
            H2O.submitTask(sqt);
            sqt.join();
            DTree tree = ktrees[0];
            for (int i2 = 0; i2 < sqt._quantiles.length; ++i2) {
                double leafQuantile = sqt._quantiles[i2];
                if (Double.isNaN(leafQuantile)) continue;
                double val = this.effective_learning_rate() * leafQuantile;
                if (val > ((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred) {
                    val = ((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred;
                }
                if (val < -((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred) {
                    val = -((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred;
                }
                ((DTree.LeafNode)tree.node((int)sqt._nids[i2]))._pred = (float)val;
            }
        }

        private void resetQuantileConstants(DTree[] ktrees, double quantile, Constraints cs) {
            Vec diff = ((ComputeDiff)new ComputeDiff(this.frameMap).doAll(1, (byte)3, GBM.this._train)).outputFrame().anyVec();
            Vec weights = GBM.this.hasWeightCol() ? GBM.this._train.vecs()[GBM.this.idx_weight()] : null;
            Vec strata = GBM.this.vec_nids(GBM.this._train, 0);
            QuantileModel.CombineMethod combine_method = QuantileModel.CombineMethod.INTERPOLATE;
            Quantile.StratifiedQuantilesTask sqt = new Quantile.StratifiedQuantilesTask(null, quantile, diff, weights, strata, combine_method);
            H2O.submitTask(sqt);
            sqt.join();
            for (int k2 = 0; k2 < GBM.this._nclass; ++k2) {
                DTree tree = ktrees[k2];
                if (tree == null || tree.len() < 2) continue;
                float[] mins = new float[tree._len];
                int[] min_ids = new int[tree._len];
                float[] maxs = new float[tree._len];
                int[] max_ids = new int[tree._len];
                int dnSize = tree._len - tree._leaves;
                this.rollupMinMaxPreds(tree, tree.root(), mins, min_ids, maxs, max_ids);
                for (int i2 = dnSize; i2 < tree.len(); ++i2) {
                    DTree.LeafNode node = (DTree.LeafNode)tree.node(i2);
                    int quantileId = i2 - dnSize;
                    double leafQuantile = sqt._quantiles[quantileId];
                    if (Double.isNaN(leafQuantile)) continue;
                    boolean canBeReplaced = true;
                    DTree.Node tmpNode = tree.node(i2);
                    while (tmpNode.pid() != -1) {
                        DTree.DecidedNode parent = (DTree.DecidedNode)tree.node(tmpNode._pid);
                        int constraint = cs.getColumnConstraint(parent._split._col);
                        if (parent._split.naSplitDir() == DHistogram.NASplitDir.NAvsREST || constraint == 0) {
                            tmpNode = parent;
                            continue;
                        }
                        if (constraint > 0) {
                            if (leafQuantile > (double)mins[parent._nids[0]] || leafQuantile < (double)maxs[parent._nids[1]]) {
                                canBeReplaced = false;
                                break;
                            }
                        } else if (leafQuantile < (double)maxs[parent._nids[0]] || leafQuantile > (double)mins[parent._nids[1]]) {
                            canBeReplaced = false;
                            break;
                        }
                        tmpNode = parent;
                    }
                    if (!canBeReplaced) continue;
                    node._pred = (float)leafQuantile;
                }
            }
        }

        private void fitBestConstants(DTree[] ktrees, int[] leafs, GammaPass gp, Constraints cs) {
            boolean useSplitPredictions = cs != null && cs.useBounds();
            double m1class = GBM.this._nclass > 1 && ((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.multinomial || GBM.this._nclass > 2 && ((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.custom ? (double)(GBM.this._nclass - 1) / (double)GBM.this._nclass : 1.0;
            for (int k2 = 0; k2 < GBM.this._nclass; ++k2) {
                int i2;
                DTree tree = ktrees[k2];
                if (tree == null) continue;
                if (LOG.isTraceEnabled()) {
                    for (i2 = 0; i2 < ktrees[k2]._len - leafs[k2]; ++i2) {
                        LOG.trace((Object)ktrees[k2].node(leafs[k2] + i2).toString());
                    }
                }
                for (i2 = 0; i2 < tree._len - leafs[k2]; ++i2) {
                    DTree.LeafNode leafNode = (DTree.LeafNode)ktrees[k2].node(leafs[k2] + i2);
                    double gamma = useSplitPredictions ? gp.gamma(leafNode.getSplitPrediction()) : gp.gamma(k2, i2);
                    double gf = this.effective_learning_rate() * m1class * gamma;
                    if (((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.multinomial || ((GBMModel.GBMParameters)GBM.this._parms)._distribution == DistributionFamily.custom && GBM.this._nclass > 2) {
                        if (gf > 10000.0) {
                            gf = 10000.0;
                        } else if (gf < -10000.0) {
                            gf = -10000.0;
                        }
                    }
                    if (Double.isNaN(gf)) {
                        gf = 0.0;
                    } else if (Double.isInfinite(gf)) {
                        gf = Math.signum(gf) * 10000.0;
                    }
                    if (gf > ((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred) {
                        gf = ((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred;
                    }
                    if (gf < -((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred) {
                        gf = -((GBMModel.GBMParameters)GBM.this._parms)._max_abs_leafnode_pred;
                    }
                    leafNode._pred = (float)gf;
                }
            }
        }

        private boolean constraintCheckEnabled() {
            return Boolean.parseBoolean(GBM.this.getSysProperty("gbm.monotonicity.checkEnabled", "true"));
        }

        private void checkConstraints(DTree[] ktrees, int[] leafs, Constraints cs) {
            for (int k2 = 0; k2 < GBM.this._nclass; ++k2) {
                DTree tree = ktrees[k2];
                if (tree == null) continue;
                float[] mins = new float[tree._len];
                int[] min_ids = new int[tree._len];
                float[] maxs = new float[tree._len];
                int[] max_ids = new int[tree._len];
                this.rollupMinMaxPreds(tree, tree.root(), mins, min_ids, maxs, max_ids);
                for (int i2 = 0; i2 < tree._len - leafs.length; ++i2) {
                    DTree.Node node = tree.node(i2);
                    if (!(node instanceof DTree.DecidedNode)) continue;
                    DTree.DecidedNode dn = (DTree.DecidedNode)node;
                    if (dn._split == null) continue;
                    int constraint = cs.getColumnConstraint(dn._split._col);
                    if (dn._split.naSplitDir() == DHistogram.NASplitDir.NAvsREST) continue;
                    if (constraint > 0) {
                        if (!(maxs[dn._nids[0]] > mins[dn._nids[1]])) continue;
                        String message = "Monotonicity constraint " + constraint + " violated on column '" + GBM.this._train.name(dn._split._col) + "' (max(left) > min(right)): " + maxs[dn._nids[0]] + " > " + mins[dn._nids[1]] + "\nNode: " + node + "\nLeft Node (max): " + tree.node(max_ids[dn._nids[0]]) + "\nRight Node (min): " + tree.node(min_ids[dn._nids[1]]);
                        throw new IllegalStateException(message);
                    }
                    if (constraint >= 0 || !(mins[dn._nids[0]] < maxs[dn._nids[1]])) continue;
                    String message = "Monotonicity constraint " + constraint + " violated on column '" + GBM.this._train.name(dn._split._col) + "' (min(left) < max(right)): " + mins[dn._nids[0]] + " < " + maxs[dn._nids[1]] + "\nNode: " + node + "\nLeft Node (min): " + tree.node(min_ids[dn._nids[0]]) + "\nRight Node (max): " + tree.node(max_ids[dn._nids[1]]);
                    throw new IllegalStateException(message);
                }
            }
        }

        private void rollupMinMaxPreds(DTree tree, DTree.Node node, float[] mins, int[] min_ids, float[] maxs, int[] max_ids) {
            if (node instanceof DTree.LeafNode) {
                mins[node.nid()] = ((DTree.LeafNode)node)._pred;
                min_ids[node.nid()] = node.nid();
                maxs[node.nid()] = ((DTree.LeafNode)node)._pred;
                max_ids[node.nid()] = node.nid();
                return;
            }
            DTree.DecidedNode dn = (DTree.DecidedNode)node;
            this.rollupMinMaxPreds(tree, tree.node(dn._nids[0]), mins, min_ids, maxs, max_ids);
            this.rollupMinMaxPreds(tree, tree.node(dn._nids[1]), mins, min_ids, maxs, max_ids);
            int min_id = mins[dn._nids[0]] < mins[dn._nids[1]] ? dn._nids[0] : dn._nids[1];
            mins[node.nid()] = mins[min_id];
            min_ids[node.nid()] = min_ids[min_id];
            int max_id = maxs[dn._nids[0]] > maxs[dn._nids[1]] ? dn._nids[0] : dn._nids[1];
            maxs[node.nid()] = maxs[max_id];
            max_ids[node.nid()] = max_ids[max_id];
        }

        protected GBMModel makeModel(Key<GBMModel> modelKey, GBMModel.GBMParameters parms) {
            return new GBMModel(modelKey, parms, new GBMModel.GBMOutput(GBM.this));
        }

        class MarkDecidedRows
        extends MRTask<MarkDecidedRows> {
            int markedCnt;

            MarkDecidedRows() {
            }

            @Override
            public void map(Chunk[] cs) {
                int colStart;
                Chunk weights;
                Chunk y2;
                if (GBM.this.hasWeightCol()) {
                    y2 = cs[0];
                    weights = cs[1];
                    colStart = 2;
                } else {
                    y2 = cs[0];
                    weights = new C0DChunk(1.0, cs[0]._len);
                    colStart = 1;
                }
                for (int row = 0; row < y2._len; ++row) {
                    if (weights.atd(row) != 0.0 && !y2.isNA(row)) continue;
                    ++this.markedCnt;
                    for (int c2 = colStart; c2 < cs.length; ++c2) {
                        cs[c2].set(row, -1L);
                    }
                }
            }

            @Override
            public void reduce(MarkDecidedRows mrt) {
                this.markedCnt += mrt.markedCnt;
            }

            @Override
            protected boolean modifiesVolatileVecs() {
                return true;
            }
        }
    }
}

