/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isoforextended.isolationtree;

import hex.tree.isoforextended.isolationtree.CompressedIsolationTree;
import hex.tree.isoforextended.isolationtree.CompressedLeaf;
import hex.tree.isoforextended.isolationtree.CompressedNode;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import water.util.ArrayUtils;
import water.util.RandomBase;
import water.util.RandomUtils;

public class IsolationTree {
    private static final Logger LOG = Logger.getLogger(IsolationTree.class);
    private Node[] _nodes;
    private final int _heightLimit;
    private final int _extensionLevel;
    private int _isolatedPoints = 0;
    private long _notIsolatedPoints = 0L;
    private int _zeroSplits = 0;
    private int _leaves = 0;
    private int _depth = 0;

    public IsolationTree(int _heightLimit, int _extensionLevel) {
        this._heightLimit = _heightLimit;
        this._extensionLevel = _extensionLevel;
    }

    public CompressedIsolationTree buildTree(double[][] data, long seed, int treeNum) {
        int maxNumNodesInTree = (int)Math.pow(2.0, this._heightLimit + 1) - 1;
        this._isolatedPoints = 0;
        this._notIsolatedPoints = 0L;
        this._zeroSplits = 0;
        this._leaves = 0;
        this._depth = 0;
        this._nodes = new Node[maxNumNodesInTree];
        CompressedIsolationTree compressedIsolationTree = new CompressedIsolationTree(this._heightLimit);
        this._nodes[0] = new Node(data, data[0].length, 0);
        for (int i2 = 0; i2 < this._nodes.length; ++i2) {
            LOG.trace((Object)(i2 + 1 + " from " + this._nodes.length + " is being prepared on tree " + treeNum));
            Node node = this._nodes[i2];
            if (node == null || node._external) continue;
            double[][] nodeData = node._data;
            int currentHeight = node._height;
            if (node._height >= this._heightLimit || nodeData[0].length <= 1) {
                node._external = true;
                node._numRows = nodeData[0].length;
                node._height = currentHeight;
                Node.access$102(node, null);
                compressedIsolationTree.getNodes()[i2] = new CompressedLeaf(node);
                if (nodeData[0].length == 1) {
                    ++this._isolatedPoints;
                }
                if (nodeData[0].length > 1) {
                    this._notIsolatedPoints += (long)node._numRows;
                }
                ++this._leaves;
                continue;
            }
            if (this.rightChildIndex(i2) < this._nodes.length) {
                this._depth = ++currentHeight;
                Node.access$402(node, ArrayUtils.uniformDistFromArray(nodeData, seed + (long)i2));
                Node.access$502(node, IsolationTree.gaussianVector(nodeData.length, nodeData.length - this._extensionLevel - 1, seed + (long)i2));
                FilteredData ret = IsolationTree.extendedIsolationForestSplit(nodeData, node._p, node._n);
                compressedIsolationTree.getNodes()[i2] = new CompressedNode(node);
                if (ret.left != null) {
                    this._nodes[this.leftChildIndex((int)i2)] = new Node(ret.left, ret.left[0].length, currentHeight);
                    compressedIsolationTree.getNodes()[this.leftChildIndex((int)i2)] = new CompressedNode(this._nodes[this.leftChildIndex(i2)]);
                } else {
                    this._nodes[this.leftChildIndex((int)i2)] = new Node(null, 0, currentHeight);
                    this._nodes[this.leftChildIndex(i2)]._external = true;
                    compressedIsolationTree.getNodes()[this.leftChildIndex((int)i2)] = new CompressedLeaf(this._nodes[this.leftChildIndex(i2)]);
                    ++this._leaves;
                    ++this._zeroSplits;
                }
                if (ret.right != null) {
                    this._nodes[this.rightChildIndex((int)i2)] = new Node(ret.right, ret.right[0].length, currentHeight);
                    compressedIsolationTree.getNodes()[this.rightChildIndex((int)i2)] = new CompressedNode(this._nodes[this.rightChildIndex(i2)]);
                } else {
                    this._nodes[this.rightChildIndex((int)i2)] = new Node(null, 0, currentHeight);
                    this._nodes[this.rightChildIndex(i2)]._external = true;
                    compressedIsolationTree.getNodes()[this.rightChildIndex((int)i2)] = new CompressedLeaf(this._nodes[this.rightChildIndex(i2)]);
                    ++this._leaves;
                    ++this._zeroSplits;
                }
            } else {
                compressedIsolationTree.getNodes()[i2] = new CompressedLeaf(node);
                ++this._leaves;
            }
            Node.access$102(node, null);
        }
        return compressedIsolationTree;
    }

    private int leftChildIndex(int i2) {
        return 2 * i2 + 1;
    }

    private int rightChildIndex(int i2) {
        return 2 * i2 + 2;
    }

    public void logNodesNumRows(Level level) {
        StringBuilder logMessage = new StringBuilder();
        for (int i2 = 0; i2 < this._nodes.length; ++i2) {
            if (this._nodes[i2] == null) {
                logMessage.append(". ");
                continue;
            }
            logMessage.append(this._nodes[i2]._numRows + " ");
        }
        LOG.log((Priority)level, (Object)logMessage.toString());
    }

    public void logNodesHeight(Level level) {
        StringBuilder logMessage = new StringBuilder();
        for (int i2 = 0; i2 < this._nodes.length; ++i2) {
            if (this._nodes[i2] == null) {
                logMessage.append(". ");
                continue;
            }
            logMessage.append(this._nodes[i2]._height + " ");
        }
        LOG.log((Priority)level, (Object)logMessage.toString());
    }

    public static FilteredData extendedIsolationForestSplit(double[][] data, double[] p2, double[] n2) {
        double[] res = new double[data[0].length];
        int leftLength = 0;
        int rightLength = 0;
        for (int row = 0; row < data[0].length; ++row) {
            for (int col = 0; col < data.length; ++col) {
                int n3 = row;
                res[n3] = res[n3] + (data[col][row] - p2[col]) * n2[col];
            }
            if (res[row] <= 0.0) {
                ++leftLength;
                continue;
            }
            ++rightLength;
        }
        double[][] left = null;
        if (leftLength > 0) {
            left = new double[data.length][leftLength];
        }
        double[][] right = null;
        if (rightLength > 0) {
            right = new double[data.length][rightLength];
        }
        int rowLeft = 0;
        int rowRight = 0;
        for (int row = 0; row < data[0].length; ++row) {
            int col;
            if (res[row] <= 0.0) {
                for (col = 0; col < data.length; ++col) {
                    left[col][rowLeft] = data[col][row];
                }
                ++rowLeft;
                continue;
            }
            for (col = 0; col < data.length; ++col) {
                right[col][rowRight] = data[col][row];
            }
            ++rowRight;
        }
        return new FilteredData(left, right);
    }

    public static double[] gaussianVector(int n2, int zeroNum, long seed) {
        double[] gaussian = ArrayUtils.gaussianVector(n2, seed);
        RandomBase r2 = RandomUtils.getRNG(seed);
        while (zeroNum > 0) {
            int pos = r2.nextInt(n2);
            if (Double.isNaN(gaussian[pos])) continue;
            gaussian[pos] = Double.NaN;
            --zeroNum;
        }
        for (int i2 = 0; i2 < gaussian.length; ++i2) {
            if (!Double.isNaN(gaussian[i2])) continue;
            gaussian[i2] = 0.0;
        }
        return gaussian;
    }

    public int getIsolatedPoints() {
        return this._isolatedPoints;
    }

    public long getNotIsolatedPoints() {
        return this._notIsolatedPoints;
    }

    public int getZeroSplits() {
        return this._zeroSplits;
    }

    public int getLeaves() {
        return this._leaves;
    }

    public int getDepth() {
        return this._depth;
    }

    public static class FilteredData {
        private final double[][] left;
        private final double[][] right;

        public FilteredData(double[][] left, double[][] right) {
            this.left = left;
            this.right = right;
        }

        public double[][] getLeft() {
            return this.left;
        }

        public double[][] getRight() {
            return this.right;
        }
    }

    public static class Node {
        private double[][] _data;
        private double[] _n;
        private double[] _p;
        private int _height;
        private boolean _external = false;
        private int _numRows;

        public Node(double[][] data, int numRows, int currentHeight) {
            this._data = data;
            this._numRows = numRows;
            this._height = currentHeight;
        }

        public double[] getN() {
            return this._n;
        }

        public double[] getP() {
            return this._p;
        }

        public int getHeight() {
            return this._height;
        }

        public int getNumRows() {
            return this._numRows;
        }

        static /* synthetic */ double[][] access$102(Node x0, double[][] x1) {
            x0._data = x1;
            return x1;
        }

        static /* synthetic */ double[] access$402(Node x0, double[] x1) {
            x0._p = x1;
            return x1;
        }

        static /* synthetic */ double[] access$502(Node x0, double[] x1) {
            x0._n = x1;
            return x1;
        }
    }
}

