/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import water.H2O;
import water.Iced;
import water.util.IcedHashMapGeneric;
import water.util.TwoDimTable;

public class BoosterParms
extends Iced<BoosterParms> {
    private IcedHashMapGeneric.IcedHashMapStringObject _parms;

    public static BoosterParms fromMap(Map<String, Object> map) {
        BoosterParms bp = new BoosterParms();
        bp._parms = new IcedHashMapGeneric.IcedHashMapStringObject();
        bp._parms.putAll(map);
        return bp;
    }

    public Map<String, Object> get() {
        Map<String, Object> params = BoosterParms.localizeDecimalParams(this._parms);
        BoosterParms.addNodeSpecificParams(params);
        return Collections.unmodifiableMap(params);
    }

    private static void addNodeSpecificParams(Map<String, Object> params) {
        String sysGpuId = H2O.getSysProperty("xgboost.gpu.id", null);
        if (sysGpuId != null) {
            params.put("gpu_id", sysGpuId);
        }
    }

    private static Map<String, Object> localizeDecimalParams(Map<String, Object> params) {
        HashMap<String, Object> localized = new HashMap<String, Object>(params.size());
        for (String key : params.keySet()) {
            Object value = params.get(key);
            Object newValue = value instanceof Float || value instanceof Double ? value.toString() : value;
            localized.put(key, newValue);
        }
        return localized;
    }

    public TwoDimTable toTwoDimTable() {
        int rows = this._parms.size();
        TwoDimTable table = new TwoDimTable("Native XGBoost Parameters", null, new String[rows], new String[]{"Name", "Value"}, new String[]{"String", "String"}, new String[]{"%s", "%s"}, "");
        int row = 0;
        for (Map.Entry p2 : this._parms.entrySet()) {
            table.set(row, 0, p2.getKey());
            table.set(row, 1, p2.getValue());
            ++row;
        }
        assert (row == rows);
        return table;
    }
}

