/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import hex.tree.xgboost.util.GpuUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

class XGBoostGPULock {
    private static final Map<Integer, ReentrantLock> LOCKS = new HashMap<Integer, ReentrantLock>();

    XGBoostGPULock() {
    }

    static int[] lock(int[] gpuIds) {
        if (gpuIds == null) {
            gpuIds = GpuUtils.DEFAULT_GPU_ID;
        }
        XGBoostGPULock.initLocks(gpuIds);
        for (int id : gpuIds) {
            LOCKS.get(id).lock();
        }
        return gpuIds;
    }

    static void unlock(int[] gpuIds) {
        for (int id : gpuIds) {
            LOCKS.get(id).unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initLocks(int[] gpuIds) {
        boolean allPresent = true;
        for (int id : gpuIds) {
            if (LOCKS.containsKey(id)) continue;
            allPresent = false;
            break;
        }
        if (!allPresent) {
            Map<Integer, ReentrantLock> map = LOCKS;
            synchronized (map) {
                for (int id : gpuIds) {
                    if (LOCKS.containsKey(id)) continue;
                    LOCKS.put(id, new ReentrantLock());
                }
            }
        }
    }
}

