/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import hex.Model;
import hex.ModelBuilder;
import hex.ScoreKeeper;
import hex.glm.GLMModel;
import hex.tree.PlattScalingHelper;
import hex.tree.xgboost.XGBoost;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.XgbVarImp;
import java.util.ArrayList;
import java.util.Arrays;
import water.util.TwoDimTable;

public class XGBoostOutput
extends Model.Output
implements Model.GetNTrees,
PlattScalingHelper.OutputWithCalibration {
    int _nums;
    int _cats;
    int[] _catOffsets;
    boolean _useAllFactorLevels;
    public boolean _sparse;
    public int _ntrees;
    public ScoreKeeper[] _scored_train;
    public ScoreKeeper[] _scored_valid;
    public long[] _training_time_ms = new long[]{System.currentTimeMillis()};
    public TwoDimTable _variable_importances;
    public TwoDimTable _variable_importances_cover;
    public TwoDimTable _variable_importances_frequency;
    public XgbVarImp _varimp;
    public TwoDimTable _native_parameters;
    public GLMModel _calib_model;

    public XGBoostOutput(XGBoost b2) {
        super(b2);
        this._scored_train = new ScoreKeeper[]{new ScoreKeeper(Double.NaN)};
        this._scored_valid = new ScoreKeeper[]{new ScoreKeeper(Double.NaN)};
    }

    public ScoreKeeper[] scoreKeepers() {
        ScoreKeeper[] ska;
        ArrayList<ScoreKeeper> skl = new ArrayList<ScoreKeeper>();
        for (ScoreKeeper sk : ska = this._validation_metrics != null ? this._scored_valid : this._scored_train) {
            if (sk.isEmpty()) continue;
            skl.add(sk);
        }
        return skl.toArray(new ScoreKeeper[0]);
    }

    @Override
    public TwoDimTable getVariableImportances() {
        return this._variable_importances;
    }

    @Override
    public TwoDimTable createInputFramesInformationTable(ModelBuilder modelBuilder) {
        XGBoostModel.XGBoostParameters params = (XGBoostModel.XGBoostParameters)modelBuilder._parms;
        TwoDimTable table = super.createInputFramesInformationTable(modelBuilder);
        table.set(2, 0, "calibration_frame");
        table.set(2, 1, params.getCalibrationFrame() != null ? params.getCalibrationFrame().checksum() : -1L);
        table.set(2, 2, params.getCalibrationFrame() != null ? Arrays.toString(params.getCalibrationFrame().anyVec().espc()) : Integer.valueOf(-1));
        return table;
    }

    @Override
    public int getInformationTableNumRows() {
        return super.getInformationTableNumRows() + 1;
    }

    @Override
    public int getNTrees() {
        return this._ntrees;
    }

    @Override
    public GLMModel calibrationModel() {
        return this._calib_model;
    }
}

