/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost;

import ai.h2o.xgboost4j.java.DMatrix;
import ai.h2o.xgboost4j.java.XGBoostError;
import hex.DataInfo;
import hex.tree.xgboost.XGBoostModel;
import hex.tree.xgboost.matrix.DenseMatrixFactory;
import hex.tree.xgboost.matrix.MatrixLoader;
import hex.tree.xgboost.matrix.SparseMatrixFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;
import water.H2O;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.VecUtils;

public class XGBoostUtils {
    private static final Logger LOG = Logger.getLogger(XGBoostUtils.class);

    public static void createFeatureMap(XGBoostModel model, Frame train) {
        DataInfo dataInfo = model.model_info().dataInfo();
        assert (dataInfo != null);
        String featureMap = XGBoostUtils.makeFeatureMap(train, dataInfo);
        model.model_info().setFeatureMap(featureMap);
    }

    private static String makeFeatureMap(Frame f2, DataInfo di) {
        String[] coefnames = di.coefNames();
        StringBuilder sb = new StringBuilder();
        assert (coefnames.length == di.fullN());
        int catCols = di._catOffsets[di._catOffsets.length - 1];
        for (int i2 = 0; i2 < di.fullN(); ++i2) {
            sb.append(i2).append(" ").append(coefnames[i2].replaceAll("\\s*", "")).append(" ");
            if (i2 < catCols || f2.vec(i2 - catCols).isBinary()) {
                sb.append("i");
            } else if (f2.vec(i2 - catCols).isInt()) {
                sb.append("int");
            } else {
                sb.append("q");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static MatrixLoader.DMatrixProvider convertFrameToDMatrix(DataInfo di, Frame frame, String response, String weight, String offset, boolean sparse) {
        MatrixLoader.DMatrixProvider trainMat;
        assert (di != null);
        int[] chunks = VecUtils.getLocalChunkIds(frame.anyVec());
        Vec responseVec = frame.vec(response);
        Vec weightVec = frame.vec(weight);
        Vec offsetsVec = frame.vec(offset);
        int[] nRowsByChunk = new int[chunks.length];
        long nRowsL = XGBoostUtils.sumChunksLength(chunks, responseVec, Optional.ofNullable(weightVec), nRowsByChunk);
        if (nRowsL > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("XGBoost currently doesn't support datasets with more than 2147483647 per node. To train a XGBoost model on this dataset add more nodes to your H2O cluster and use distributed training.");
        }
        int nRows = (int)nRowsL;
        float[] resp = MemoryManager.malloc4f(nRows);
        float[] weights = null;
        float[] offsets = null;
        if (weightVec != null) {
            weights = MemoryManager.malloc4f(nRows);
        }
        if (offsetsVec != null) {
            offsets = MemoryManager.malloc4f(nRows);
        }
        if (sparse) {
            LOG.debug((Object)"Treating matrix as sparse.");
            trainMat = SparseMatrixFactory.csr(frame, chunks, weightVec, offsetsVec, responseVec, di, resp, weights, offsets);
        } else {
            LOG.debug((Object)"Treating matrix as dense.");
            trainMat = DenseMatrixFactory.dense(frame, chunks, nRows, nRowsByChunk, weightVec, offsetsVec, responseVec, di, resp, weights, offsets);
        }
        return trainMat;
    }

    public static long sumChunksLength(int[] chunkIds, Vec vec, Optional<Vec> weightsVector, int[] chunkLengths) {
        assert (chunkLengths.length == chunkIds.length);
        for (int i2 = 0; i2 < chunkIds.length; ++i2) {
            int chunk = chunkIds[i2];
            if (weightsVector.isPresent()) {
                Chunk weightVecChunk = weightsVector.get().chunkForChunkIdx(chunk);
                assert (weightVecChunk.len() == vec.chunkLen(chunk));
                if (weightVecChunk.len() == 0) continue;
                int nzIndex = 0;
                do {
                    if (weightVecChunk.atd(nzIndex) == 0.0) continue;
                    int n2 = i2;
                    chunkLengths[n2] = chunkLengths[n2] + 1;
                } while ((nzIndex = weightVecChunk.nextNZ(nzIndex, true)) > 0 && nzIndex < weightVecChunk._len);
                continue;
            }
            chunkLengths[i2] = vec.chunkLen(chunk);
        }
        long totalChunkLength = 0L;
        for (int cl : chunkLengths) {
            totalChunkLength += (long)cl;
        }
        return totalChunkLength;
    }

    public static DMatrix convertChunksToDMatrix(DataInfo di, Chunk[] chunks, int response, boolean sparse, int offset) throws XGBoostError {
        DMatrix trainMat;
        int nRows = chunks[0]._len;
        float[] resp = MemoryManager.malloc4f(nRows);
        float[] off = null;
        if (offset >= 0) {
            off = MemoryManager.malloc4f(nRows);
        }
        try {
            if (sparse) {
                LOG.debug((Object)"Treating matrix as sparse.");
                trainMat = SparseMatrixFactory.csr(chunks, -1, response, offset, di, resp, null, off);
            } else {
                trainMat = DenseMatrixFactory.dense(chunks, di, response, resp, null, offset, off);
            }
        }
        catch (NegativeArraySizeException e2) {
            throw new IllegalArgumentException(H2O.technote(11, "Data is too large to fit into the 32-bit Java float[] array that needs to be passed to the XGBoost C++ backend. Use H2O GBM instead."));
        }
        int len = (int)trainMat.rowNum();
        if (off != null) {
            off = Arrays.copyOf(off, len);
            trainMat.setBaseMargin(off);
        }
        resp = Arrays.copyOf(resp, len);
        trainMat.setLabel(resp);
        return trainMat;
    }

    public static FeatureProperties assembleFeatureNames(DataInfo di) {
        String[] coefnames = di.coefNames();
        assert (coefnames.length == di.fullN());
        int numCatCols = di._catOffsets[di._catOffsets.length - 1];
        String[] featureNames = new String[di.fullN()];
        boolean[] oneHotEncoded = new boolean[di.fullN()];
        int[] originalColumnIndices = di.coefOriginalColumnIndices();
        for (int i2 = 0; i2 < di.fullN(); ++i2) {
            featureNames[i2] = coefnames[i2];
            if (i2 >= numCatCols) continue;
            oneHotEncoded[i2] = true;
        }
        return new FeatureProperties(di._adaptedFrame._names, featureNames, oneHotEncoded, originalColumnIndices);
    }

    public static class FeatureProperties {
        public String[] _originalNames;
        public Map<String, Integer> _originalNamesMap;
        public String[] _names;
        public boolean[] _oneHotEncoded;
        public int[] _originalColumnIndices;

        public FeatureProperties(String[] originalNames, String[] names, boolean[] oneHotEncoded, int[] originalColumnIndices) {
            this._originalNames = originalNames;
            this._originalNamesMap = new HashMap<String, Integer>();
            for (int i2 = 0; i2 < originalNames.length; ++i2) {
                this._originalNamesMap.put(originalNames[i2], i2);
            }
            this._names = names;
            this._oneHotEncoded = oneHotEncoded;
            this._originalColumnIndices = originalColumnIndices;
        }

        public int getOriginalIndex(String originalName) {
            return this._originalNamesMap.get(originalName);
        }

        public Integer[] mapOriginalNamesToIndices(String[] names) {
            Integer[] res = new Integer[names.length];
            for (int i2 = 0; i2 < names.length; ++i2) {
                res[i2] = this.getOriginalIndex(names[i2]);
            }
            return res;
        }
    }
}

