/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.remote;

import hex.genmodel.utils.IOUtils;
import hex.schemas.XGBoostExecRespV3;
import hex.tree.xgboost.matrix.RemoteMatrixLoader;
import hex.tree.xgboost.matrix.SparseMatrixDimensions;
import hex.tree.xgboost.task.XGBoostUploadMatrixTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import water.AutoBuffer;
import water.BootstrapFreezable;
import water.H2O;
import water.Key;
import water.TypeMap;
import water.server.ServletUtils;

public class RemoteXGBoostUploadServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(RemoteXGBoostUploadServlet.class);

    public static File getUploadDir(String key) {
        return new File(H2O.ICE_ROOT.toString(), key);
    }

    public static File getCheckpointFile(String key) {
        File uploadDir = RemoteXGBoostUploadServlet.getUploadDir(key);
        if (uploadDir.mkdirs()) {
            LOG.debug((Object)("Created temporary directory " + uploadDir));
        }
        return new File(RemoteXGBoostUploadServlet.getUploadDir(key), "checkpoint.bin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(HttpServletRequest request2, HttpServletResponse response) {
        String uri = ServletUtils.getDecodedUri(request2);
        try {
            String model_key = request2.getParameter("model_key");
            String data_type = request2.getParameter("data_type");
            LOG.info((Object)("Upload request for " + model_key + " " + data_type + " received"));
            RequestType type = RequestType.valueOf(data_type);
            if (type == RequestType.checkpoint) {
                File destFile = RemoteXGBoostUploadServlet.getCheckpointFile(model_key);
                this.saveIntoFile(destFile, request2);
            } else {
                this.handleMatrixRequest(model_key, type, request2);
            }
            response.setContentType("application/json");
            response.getWriter().write(new XGBoostExecRespV3(Key.make(model_key)).toJsonString());
        }
        catch (Exception e2) {
            ServletUtils.sendErrorResponse(response, e2, uri);
        }
        finally {
            ServletUtils.logRequest("POST", request2, response);
        }
    }

    private void handleMatrixRequest(String model_key, RequestType type, HttpServletRequest request2) throws IOException {
        BootstrapFreezable requestData;
        try (AutoBuffer ab = new AutoBuffer(request2.getInputStream(), TypeMap.bootstrapClasses());){
            requestData = (BootstrapFreezable)ab.get();
        }
        switch (type) {
            case sparseMatrixDimensions: {
                RemoteMatrixLoader.initSparse(model_key, (SparseMatrixDimensions)requestData);
                break;
            }
            case sparseMatrixChunk: {
                RemoteMatrixLoader.sparseChunk(model_key, (XGBoostUploadMatrixTask.SparseMatrixChunk)requestData);
                break;
            }
            case denseMatrixDimensions: {
                RemoteMatrixLoader.initDense(model_key, (XGBoostUploadMatrixTask.DenseMatrixDimensions)requestData);
                break;
            }
            case denseMatrixChunk: {
                RemoteMatrixLoader.denseChunk(model_key, (XGBoostUploadMatrixTask.DenseMatrixChunk)requestData);
                break;
            }
            case matrixData: {
                RemoteMatrixLoader.matrixData(model_key, (XGBoostUploadMatrixTask.MatrixData)requestData);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected request type: " + (Object)((Object)type));
            }
        }
    }

    private void saveIntoFile(File destFile, HttpServletRequest request2) throws IOException {
        LOG.debug((Object)("Saving contents into " + destFile));
        ServletInputStream is = request2.getInputStream();
        try (FileOutputStream fos = new FileOutputStream(destFile);){
            IOUtils.copyStream(is, fos);
        }
    }

    public static enum RequestType {
        checkpoint,
        sparseMatrixDimensions,
        sparseMatrixChunk,
        denseMatrixDimensions,
        denseMatrixChunk,
        matrixData;

    }
}

