/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.util;

import ai.h2o.xgboost4j.java.Booster;
import ai.h2o.xgboost4j.java.DMatrix;
import ai.h2o.xgboost4j.java.Rabit;
import ai.h2o.xgboost4j.java.XGBoost;
import ai.h2o.xgboost4j.java.XGBoostError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class BoosterHelper {
    public static Booster loadModel(InputStream in) {
        try {
            return XGBoost.loadModel(in);
        }
        catch (XGBoostError | IOException e2) {
            throw new IllegalStateException("Failed to load booster.", e2);
        }
    }

    public static Booster loadModel(byte[] boosterBytes) {
        if (boosterBytes == null) {
            throw new IllegalArgumentException("Booster not initialized!");
        }
        return BoosterHelper.loadModel(new ByteArrayInputStream(boosterBytes));
    }

    public static void dispose(Object ... xgbObjects) throws IllegalStateException {
        Exception firstException = null;
        for (Object xgbObject : xgbObjects) {
            if (xgbObject == null) continue;
            if (xgbObject instanceof Booster) {
                try {
                    ((Booster)xgbObject).dispose();
                }
                catch (Exception e2) {
                    if (firstException != null) continue;
                    firstException = e2;
                }
                continue;
            }
            if (xgbObject instanceof DMatrix) {
                try {
                    ((DMatrix)xgbObject).dispose();
                }
                catch (Exception e3) {
                    if (firstException != null) continue;
                    firstException = e3;
                }
                continue;
            }
            assert (false) : "Unsupported XGBoost object type: " + xgbObject.getClass();
        }
        if (firstException != null) {
            throw new IllegalStateException("We were unable to free-up xgboost memory. This could indicate a memory leak and it can lead to H2O instability.", firstException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X> X doWithLocalRabit(BoosterOp<X> op, Booster booster) throws XGBoostError {
        boolean shutdownRabit = true;
        try {
            HashMap<String, String> rabitEnv = new HashMap<String, String>();
            rabitEnv.put("DMLC_TASK_ID", "0");
            Rabit.init(rabitEnv);
            shutdownRabit = true;
            X result = op.apply(booster);
            Rabit.shutdown();
            shutdownRabit = false;
            X x2 = result;
            return x2;
        }
        finally {
            if (shutdownRabit) {
                try {
                    Rabit.shutdown();
                }
                catch (XGBoostError e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    public static interface BoosterOp<X> {
        public X apply(Booster var1) throws XGBoostError;
    }
}

