/*
 * Decompiled with CFR 0.152.
 */
package hex.util;

import hex.DataInfo;
import hex.util.LinearAlgebraUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.PrettyPrint;
import water.util.TwoDimTable;

public class DimensionReductionUtils {
    public static void generateIPC(double[] std_deviation, double totVar, double[] vars, double[] prop_var, double[] cum_var) {
        double lastCum;
        int arrayLen = std_deviation.length;
        if (totVar > 0.0) {
            for (int i2 = 0; i2 < arrayLen; ++i2) {
                vars[i2] = std_deviation[i2] * std_deviation[i2];
                prop_var[i2] = vars[i2] / totVar;
                cum_var[i2] = i2 == 0 ? prop_var[0] : cum_var[i2 - 1] + prop_var[i2];
            }
        }
        if ((lastCum = cum_var[arrayLen - 1]) > 1.0) {
            double multF = 1.0 / lastCum;
            ArrayUtils.mult(prop_var, multF);
            ArrayUtils.mult(cum_var, multF);
            ArrayUtils.mult(vars, multF);
            ArrayUtils.mult(std_deviation, Math.sqrt(multF));
        }
    }

    public static TwoDimTable createScoringHistoryTableDR(LinkedHashMap<String, ArrayList> scoreTable, String tableName, long startTime) {
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        ArrayList<String> otherTableEntries = new ArrayList<String>();
        for (String fieldName : scoreTable.keySet()) {
            if (fieldName.equals("Timestamp")) {
                colHeaders.add("Timestamp");
                colTypes.add("string");
                colFormat.add("%s");
                colHeaders.add("Duration");
                colTypes.add("string");
                colFormat.add("%s");
                colHeaders.add("Iterations");
                colTypes.add("long");
                colFormat.add("%d");
                continue;
            }
            otherTableEntries.add(fieldName);
            colHeaders.add(fieldName);
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        int rows = scoreTable.get("Timestamp").size();
        TwoDimTable table = new TwoDimTable(tableName, null, new String[rows], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        assert (rows <= table.getRowDim());
        for (int row = 0; row < rows; ++row) {
            int col = 0;
            DateTimeFormatter fmt = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
            table.set(row, col++, fmt.print((Long)scoreTable.get("Timestamp").get(row)));
            table.set(row, col++, PrettyPrint.msecs((Long)scoreTable.get("Timestamp").get(row) - startTime, true));
            table.set(row, col++, row);
            for (int remaining_cols = 0; remaining_cols < otherTableEntries.size(); ++remaining_cols) {
                table.set(row, col++, (double)((Double)scoreTable.get(otherTableEntries.get(remaining_cols)).get(row)));
            }
        }
        return table;
    }

    public static double[][] getTransformedEigenvectors(DataInfo dinfo, double[][] vEigenIn) {
        Frame tempFrame = new Frame(dinfo._adaptedFrame);
        new ArrayUtils();
        Frame eigFrame = ArrayUtils.frame(vEigenIn);
        tempFrame.add(eigFrame);
        LinearAlgebraUtils.SMulTask stsk = new LinearAlgebraUtils.SMulTask(dinfo, eigFrame.numCols(), dinfo._numOffsets[dinfo._numOffsets.length - 1]);
        double[][] eigenVecs = ((LinearAlgebraUtils.SMulTask)stsk.doAll((Frame)tempFrame))._atq;
        if (eigFrame != null) {
            eigFrame.delete();
        }
        double[][] eigenVecsTranspose = ArrayUtils.transpose(eigenVecs);
        double[] eigenNormsI = new double[eigenVecsTranspose.length];
        for (int vecIndex = 0; vecIndex < eigenVecsTranspose.length; ++vecIndex) {
            eigenNormsI[vecIndex] = 1.0 / ArrayUtils.l2norm(eigenVecsTranspose[vecIndex]);
        }
        return ArrayUtils.transpose(ArrayUtils.mult(eigenVecsTranspose, eigenNormsI));
    }
}

