/*
 * Decompiled with CFR 0.152.
 */
package hex.word2vec;

import java.util.Arrays;
import water.Key;
import water.Keyed;

class HBWTree
extends Keyed<HBWTree> {
    private static final int MAX_CODE_LENGTH = 40;
    int[][] _code;
    int[][] _point;

    public HBWTree() {
    }

    private HBWTree(Key<HBWTree> key, int size) {
        super(key);
        this._code = new int[size][];
        this._point = new int[size][];
    }

    static HBWTree buildHuffmanBinaryWordTree(long[] wordCounts) {
        int size = wordCounts.length;
        long[] count2 = new long[size * 2 - 1];
        int[] binary = new int[size * 2 - 1];
        int[] parent_node = new int[size * 2 - 1];
        System.arraycopy(wordCounts, 0, count2, 0, size);
        Arrays.fill(count2, size, size * 2 - 1, 1000000000000000L);
        int pos1 = size - 1;
        int pos2 = size;
        for (int i2 = 0; i2 < size - 1; ++i2) {
            int min1i = pos1 >= 0 ? (count2[pos1] < count2[pos2] ? pos1-- : pos2++) : pos2++;
            int min2i = pos1 >= 0 ? (count2[pos1] < count2[pos2] ? pos1-- : pos2++) : pos2++;
            count2[size + i2] = count2[min1i] + count2[min2i];
            parent_node[min1i] = size + i2;
            parent_node[min2i] = size + i2;
            binary[min2i] = 1;
        }
        HBWTree t2 = new HBWTree(Key.make(), size);
        int[] point = new int[40];
        int[] code = new int[40];
        for (int j2 = 0; j2 < size; ++j2) {
            int k2 = j2;
            int m4 = 0;
            do {
                int val;
                code[m4] = val = binary[k2];
                point[m4] = k2;
                ++m4;
            } while ((k2 = parent_node[k2]) != 0);
            t2._code[j2] = new int[m4];
            t2._point[j2] = new int[m4 + 1];
            t2._point[j2][0] = size - 2;
            for (int l2 = 0; l2 < m4; ++l2) {
                t2._code[j2][m4 - l2 - 1] = code[l2];
                t2._point[j2][m4 - l2] = point[l2] - size;
            }
        }
        return t2;
    }
}

