/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.tags;

import io.opencensus.tags.Tag;
import java.util.HashMap;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class TagContext {
    protected abstract Iterator<Tag> getIterator();

    public String toString() {
        return "TagContext";
    }

    public boolean equals(@Nullable Object other) {
        Tag tag;
        if (!(other instanceof TagContext)) {
            return false;
        }
        TagContext otherTags = (TagContext)other;
        Iterator<Tag> iter1 = this.getIterator();
        Iterator<Tag> iter2 = otherTags.getIterator();
        HashMap<Tag, Integer> tags = new HashMap<Tag, Integer>();
        while (iter1 != null && iter1.hasNext()) {
            tag = iter1.next();
            if (tags.containsKey(tag)) {
                tags.put(tag, (Integer)tags.get(tag) + 1);
                continue;
            }
            tags.put(tag, 1);
        }
        while (iter2 != null && iter2.hasNext()) {
            tag = iter2.next();
            if (!tags.containsKey(tag)) {
                return false;
            }
            int count2 = (Integer)tags.get(tag);
            if (count2 > 1) {
                tags.put(tag, count2 - 1);
                continue;
            }
            tags.remove(tag);
        }
        return tags.isEmpty();
    }

    public final int hashCode() {
        int hashCode = 0;
        Iterator<Tag> i2 = this.getIterator();
        if (i2 == null) {
            return hashCode;
        }
        while (i2.hasNext()) {
            Tag tag = i2.next();
            if (tag == null) continue;
            hashCode += tag.hashCode();
        }
        return hashCode;
    }
}

