/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import jnr.ffi.CallingConvention;
import jnr.ffi.annotations.IgnoreError;
import jnr.ffi.annotations.SaveError;

public final class NativeFunction {
    private final Method method;
    private final Collection<Annotation> annotations;
    private final boolean saveError;
    private final CallingConvention callingConvention;

    public NativeFunction(Method method, CallingConvention callingConvention) {
        this.method = method;
        this.annotations = Collections.unmodifiableCollection(Arrays.asList(method.getAnnotations()));
        boolean saveError = true;
        for (Annotation a2 : this.annotations) {
            if (a2 instanceof IgnoreError) {
                saveError = false;
                continue;
            }
            if (!(a2 instanceof SaveError)) continue;
            saveError = true;
        }
        this.saveError = saveError;
        this.callingConvention = callingConvention;
    }

    public Collection<Annotation> annotations() {
        return this.annotations;
    }

    public CallingConvention convention() {
        return this.callingConvention;
    }

    public String name() {
        return this.method.getName();
    }

    public boolean isErrnoRequired() {
        return this.saveError;
    }

    public Method getMethod() {
        return this.method;
    }
}

