/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.ObjectParameterType;
import java.nio.Buffer;
import java.util.EnumSet;
import jnr.ffi.provider.jffi.ParameterStrategy;

final class HeapBufferParameterStrategy
extends ParameterStrategy {
    private static final HeapBufferParameterStrategy[] heapBufferStrategies;

    public HeapBufferParameterStrategy(ObjectParameterType.ComponentType componentType) {
        super(HEAP, ObjectParameterType.create(ObjectParameterType.ARRAY, componentType));
    }

    public long address(Object o2) {
        return 0L;
    }

    public Object object(Object o2) {
        return ((Buffer)o2).array();
    }

    public int offset(Object o2) {
        Buffer buffer = (Buffer)o2;
        return buffer.arrayOffset() + buffer.position();
    }

    public int length(Object o2) {
        return ((Buffer)o2).remaining();
    }

    static HeapBufferParameterStrategy get(ObjectParameterType.ComponentType componentType) {
        return heapBufferStrategies[componentType.ordinal()];
    }

    static {
        EnumSet<ObjectParameterType.ComponentType> componentTypes = EnumSet.allOf(ObjectParameterType.ComponentType.class);
        heapBufferStrategies = new HeapBufferParameterStrategy[componentTypes.size()];
        for (ObjectParameterType.ComponentType componentType : componentTypes) {
            HeapBufferParameterStrategy.heapBufferStrategies[componentType.ordinal()] = new HeapBufferParameterStrategy(componentType);
        }
    }
}

