/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.util.ref.internal;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Finalizer
extends Thread {
    private static final Logger logger = Logger.getLogger(Finalizer.class.getName());
    private static final String FINALIZABLE_REFERENCE = "jnr.ffi.util.ref.FinalizableReference";
    private final WeakReference<Class<?>> finalizableReferenceClassReference;
    private final PhantomReference<Object> frqReference;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private static final Field inheritableThreadLocals = Finalizer.getInheritableThreadLocalsField();

    public static ReferenceQueue<Object> startFinalizer(Class<?> finalizableReferenceClass, Object frq) {
        if (!finalizableReferenceClass.getName().equals(FINALIZABLE_REFERENCE)) {
            throw new IllegalArgumentException("Expected jnr.ffi.util.ref.FinalizableReference.");
        }
        Finalizer finalizer = new Finalizer(finalizableReferenceClass, frq);
        finalizer.start();
        return finalizer.queue;
    }

    private Finalizer(Class<?> finalizableReferenceClass, Object frq) {
        super(Finalizer.class.getName());
        this.finalizableReferenceClassReference = new WeakReference(finalizableReferenceClass);
        this.frqReference = new PhantomReference<Object>(frq, this.queue);
        this.setDaemon(true);
        this.setPriority(10);
        this.setContextClassLoader(null);
        try {
            if (inheritableThreadLocals != null) {
                inheritableThreadLocals.set(this, null);
            }
        }
        catch (Throwable t2) {
            logger.log(Level.INFO, "Failed to clear thread local values inherited by reference finalizer thread.", t2);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (this.cleanUp(this.queue.remove())) {
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private boolean cleanUp(Reference<?> reference) {
        Method finalizeReferentMethod = this.getFinalizeReferentMethod();
        if (finalizeReferentMethod == null) {
            return false;
        }
        do {
            reference.clear();
            if (reference == this.frqReference) {
                return false;
            }
            try {
                finalizeReferentMethod.invoke(reference, new Object[0]);
            }
            catch (Throwable t2) {
                logger.log(Level.SEVERE, "Error cleaning up after reference.", t2);
            }
        } while ((reference = this.queue.poll()) != null);
        return true;
    }

    private Method getFinalizeReferentMethod() {
        Class finalizableReferenceClass = (Class)this.finalizableReferenceClassReference.get();
        if (finalizableReferenceClass == null) {
            return null;
        }
        try {
            return finalizableReferenceClass.getMethod("finalizeReferent", new Class[0]);
        }
        catch (NoSuchMethodException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    public static Field getInheritableThreadLocalsField() {
        try {
            Field inheritableThreadLocals = Thread.class.getDeclaredField("inheritableThreadLocals");
            inheritableThreadLocals.setAccessible(true);
            return inheritableThreadLocals;
        }
        catch (Throwable t2) {
            logger.log(Level.INFO, "Couldn't access Thread.inheritableThreadLocals. Reference finalizer threads will inherit thread local values.");
            return null;
        }
    }
}

