/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jnr.netdb.NetDBEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NetDBIterator
implements Iterator<NetDBEntry> {
    private final BufferedReader reader;
    private NetDBEntry next = null;

    public NetDBIterator(Reader r2) {
        this.reader = r2 instanceof BufferedReader ? (BufferedReader)r2 : new BufferedReader(r2);
    }

    NetDBEntry readNextEntry() throws IOException {
        String s2 = null;
        while ((s2 = this.reader.readLine()) != null) {
            List<String> aliases;
            String[] fields;
            String[] line = s2.split("#", 2);
            if (line.length < 1 || line[0].length() == 0 || (fields = line[0].trim().split("\\s+")).length < 2 || fields[0] == null || fields[1] == null) continue;
            String serviceName = fields[0];
            String data = fields[1];
            if (fields.length > 2) {
                aliases = new ArrayList(fields.length - 2);
                for (int i2 = 2; i2 < fields.length; ++i2) {
                    if (fields[i2] == null) continue;
                    aliases.add(fields[i2]);
                }
            } else {
                aliases = Collections.emptyList();
            }
            return new NetDBEntry(serviceName, data, aliases);
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.next != null || (this.next = this.readNextEntry()) != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public NetDBEntry next() {
        try {
            NetDBEntry s2;
            NetDBEntry netDBEntry = s2 = this.next != null ? this.next : this.readNextEntry();
            if (s2 == null) {
                throw new NoSuchElementException("not found");
            }
            this.next = null;
            return s2;
        }
        catch (IOException ex) {
            throw new NoSuchElementException(ex.getMessage());
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

