/*
 * Decompiled with CFR 0.152.
 */
package jsr166y;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import sun.misc.Unsafe;

public class ConcurrentLinkedDeque<E>
extends AbstractCollection<E>
implements Deque<E>,
Serializable {
    private static final long serialVersionUID = 876323262645176354L;
    private volatile transient Node<E> head;
    private volatile transient Node<E> tail;
    private static final Node<Object> PREV_TERMINATOR = new Node();
    private static final Node<Object> NEXT_TERMINATOR;
    private static final int HOPS = 2;
    private static final Unsafe UNSAFE;
    private static final long headOffset;
    private static final long tailOffset;

    Node<E> prevTerminator() {
        return PREV_TERMINATOR;
    }

    Node<E> nextTerminator() {
        return NEXT_TERMINATOR;
    }

    private void linkFirst(E e2) {
        Node p2;
        Node h2;
        ConcurrentLinkedDeque.checkNotNull(e2);
        Node newNode = new Node(e2);
        block0: while (true) {
            p2 = h2 = this.head;
            while (true) {
                Node q2;
                if ((q2 = p2.prev) != null) {
                    p2 = q2;
                    q2 = p2.prev;
                    if (q2 != null) {
                        p2 = h2 != (h2 = this.head) ? h2 : q2;
                        continue;
                    }
                }
                if (p2.next == p2) continue block0;
                newNode.lazySetNext(p2);
                if (p2.casPrev(null, newNode)) break block0;
            }
            break;
        }
        if (p2 != h2) {
            this.casHead(h2, newNode);
        }
    }

    private void linkLast(E e2) {
        Node p2;
        Node t2;
        ConcurrentLinkedDeque.checkNotNull(e2);
        Node newNode = new Node(e2);
        block0: while (true) {
            p2 = t2 = this.tail;
            while (true) {
                Node q2;
                if ((q2 = p2.next) != null) {
                    p2 = q2;
                    q2 = p2.next;
                    if (q2 != null) {
                        p2 = t2 != (t2 = this.tail) ? t2 : q2;
                        continue;
                    }
                }
                if (p2.prev == p2) continue block0;
                newNode.lazySetPrev(p2);
                if (p2.casNext(null, newNode)) break block0;
            }
            break;
        }
        if (p2 != t2) {
            this.casTail(t2, newNode);
        }
    }

    void unlink(Node<E> x2) {
        Node prev = x2.prev;
        Node next = x2.next;
        if (prev == null) {
            this.unlinkFirst(x2, next);
        } else if (next == null) {
            this.unlinkLast(x2, prev);
        } else {
            boolean isLast;
            Node activeSucc;
            Node q2;
            boolean isFirst;
            Node activePred;
            int hops = 1;
            Node p2 = prev;
            while (true) {
                if (p2.item != null) {
                    activePred = p2;
                    isFirst = false;
                    break;
                }
                q2 = p2.prev;
                if (q2 == null) {
                    if (p2.next == p2) {
                        return;
                    }
                    activePred = p2;
                    isFirst = true;
                    break;
                }
                if (p2 == q2) {
                    return;
                }
                p2 = q2;
                ++hops;
            }
            p2 = next;
            while (true) {
                if (p2.item != null) {
                    activeSucc = p2;
                    isLast = false;
                    break;
                }
                q2 = p2.next;
                if (q2 == null) {
                    if (p2.prev == p2) {
                        return;
                    }
                    activeSucc = p2;
                    isLast = true;
                    break;
                }
                if (p2 == q2) {
                    return;
                }
                p2 = q2;
                ++hops;
            }
            if (hops < 2 && isFirst | isLast) {
                return;
            }
            this.skipDeletedSuccessors(activePred);
            this.skipDeletedPredecessors(activeSucc);
            if (isFirst | isLast && activePred.next == activeSucc && activeSucc.prev == activePred && (isFirst ? activePred.prev == null : activePred.item != null) && (isLast ? activeSucc.next == null : activeSucc.item != null)) {
                this.updateHead();
                this.updateTail();
                x2.lazySetPrev(isFirst ? this.prevTerminator() : x2);
                x2.lazySetNext(isLast ? this.nextTerminator() : x2);
            }
        }
    }

    private void unlinkFirst(Node<E> first, Node<E> next) {
        Node<E> o2 = null;
        Node<E> p2 = next;
        while (true) {
            Node q2;
            if (p2.item != null || (q2 = p2.next) == null) {
                if (o2 != null && p2.prev != p2 && first.casNext(next, p2)) {
                    this.skipDeletedPredecessors(p2);
                    if (first.prev == null && (p2.next == null || p2.item != null) && p2.prev == first) {
                        this.updateHead();
                        this.updateTail();
                        o2.lazySetNext(o2);
                        o2.lazySetPrev(this.prevTerminator());
                    }
                }
                return;
            }
            if (p2 == q2) {
                return;
            }
            o2 = p2;
            p2 = q2;
        }
    }

    private void unlinkLast(Node<E> last, Node<E> prev) {
        Node<E> o2 = null;
        Node<E> p2 = prev;
        while (true) {
            Node q2;
            if (p2.item != null || (q2 = p2.prev) == null) {
                if (o2 != null && p2.next != p2 && last.casPrev(prev, p2)) {
                    this.skipDeletedSuccessors(p2);
                    if (last.next == null && (p2.prev == null || p2.item != null) && p2.next == last) {
                        this.updateHead();
                        this.updateTail();
                        o2.lazySetPrev(o2);
                        o2.lazySetNext(this.nextTerminator());
                    }
                }
                return;
            }
            if (p2 == q2) {
                return;
            }
            o2 = p2;
            p2 = q2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateHead() {
        block0: while (true) {
            h = this.head;
            if (h.item != null || (p = h.prev) == null) break;
            while (true) {
                block5: {
                    block4: {
                        if ((q = p.prev) == null) break block4;
                        p = q;
                        q = p.prev;
                        if (q != null) break block5;
                    }
                    if (!this.casHead(h, p)) continue block0;
                    return;
                }
                if (h == this.head) ** break;
                continue block0;
                p = q;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateTail() {
        block0: while (true) {
            t = this.tail;
            if (t.item != null || (p = t.next) == null) break;
            while (true) {
                block5: {
                    block4: {
                        if ((q = p.next) == null) break block4;
                        p = q;
                        q = p.next;
                        if (q != null) break block5;
                    }
                    if (!this.casTail(t, p)) continue block0;
                    return;
                }
                if (t == this.tail) ** break;
                continue block0;
                p = q;
            }
            break;
        }
    }

    private void skipDeletedPredecessors(Node<E> x2) {
        block0: do {
            Node prev;
            Node p2 = prev = x2.prev;
            while (p2.item == null) {
                Node q2 = p2.prev;
                if (q2 == null) {
                    if (p2.next != p2) break;
                    continue block0;
                }
                if (p2 == q2) continue block0;
                p2 = q2;
            }
            if (prev != p2 && !x2.casPrev(prev, p2)) continue;
            return;
        } while (x2.item != null || x2.next == null);
    }

    private void skipDeletedSuccessors(Node<E> x2) {
        block0: do {
            Node next;
            Node p2 = next = x2.next;
            while (p2.item == null) {
                Node q2 = p2.next;
                if (q2 == null) {
                    if (p2.prev != p2) break;
                    continue block0;
                }
                if (p2 == q2) continue block0;
                p2 = q2;
            }
            if (next != p2 && !x2.casNext(next, p2)) continue;
            return;
        } while (x2.item != null || x2.prev == null);
    }

    final Node<E> succ(Node<E> p2) {
        Node q2 = p2.next;
        return p2 == q2 ? this.first() : q2;
    }

    final Node<E> pred(Node<E> p2) {
        Node q2 = p2.prev;
        return p2 == q2 ? this.last() : q2;
    }

    Node<E> first() {
        Node<E> h2;
        Node<E> p2;
        block0: do {
            Node q2;
            p2 = h2 = this.head;
            while ((q2 = p2.prev) != null) {
                p2 = q2;
                q2 = p2.prev;
                if (q2 == null) continue block0;
                p2 = h2 != (h2 = this.head) ? h2 : q2;
            }
        } while (p2 != h2 && !this.casHead(h2, p2));
        return p2;
    }

    Node<E> last() {
        Node<E> t2;
        Node<E> p2;
        block0: do {
            Node q2;
            p2 = t2 = this.tail;
            while ((q2 = p2.next) != null) {
                p2 = q2;
                q2 = p2.next;
                if (q2 == null) continue block0;
                p2 = t2 != (t2 = this.tail) ? t2 : q2;
            }
        } while (p2 != t2 && !this.casTail(t2, p2));
        return p2;
    }

    private static void checkNotNull(Object v2) {
        if (v2 == null) {
            throw new NullPointerException();
        }
    }

    private E screenNullResult(E v2) {
        if (v2 == null) {
            throw new NoSuchElementException();
        }
        return v2;
    }

    private ArrayList<E> toArrayList() {
        ArrayList list = new ArrayList();
        Node<E> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null) {
                list.add(item);
            }
            p2 = this.succ(p2);
        }
        return list;
    }

    public ConcurrentLinkedDeque() {
        this.tail = new Node<Object>(null);
        this.head = this.tail;
    }

    public ConcurrentLinkedDeque(Collection<? extends E> c2) {
        Node<E> h2 = null;
        Node<E> t2 = null;
        for (E e2 : c2) {
            ConcurrentLinkedDeque.checkNotNull(e2);
            Node<E> newNode = new Node<E>(e2);
            if (h2 == null) {
                h2 = t2 = newNode;
                continue;
            }
            t2.lazySetNext(newNode);
            newNode.lazySetPrev(t2);
            t2 = newNode;
        }
        this.initHeadTail(h2, t2);
    }

    private void initHeadTail(Node<E> h2, Node<E> t2) {
        if (h2 == t2) {
            if (h2 == null) {
                t2 = new Node<Object>(null);
                h2 = t2;
            } else {
                Node<Object> newNode = new Node<Object>(null);
                t2.lazySetNext(newNode);
                newNode.lazySetPrev(t2);
                t2 = newNode;
            }
        }
        this.head = h2;
        this.tail = t2;
    }

    @Override
    public void addFirst(E e2) {
        this.linkFirst(e2);
    }

    @Override
    public void addLast(E e2) {
        this.linkLast(e2);
    }

    @Override
    public boolean offerFirst(E e2) {
        this.linkFirst(e2);
        return true;
    }

    @Override
    public boolean offerLast(E e2) {
        this.linkLast(e2);
        return true;
    }

    @Override
    public E peekFirst() {
        Node<E> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null) {
                return item;
            }
            p2 = this.succ(p2);
        }
        return null;
    }

    @Override
    public E peekLast() {
        Node<E> p2 = this.last();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null) {
                return item;
            }
            p2 = this.pred(p2);
        }
        return null;
    }

    @Override
    public E getFirst() {
        return this.screenNullResult(this.peekFirst());
    }

    @Override
    public E getLast() {
        return this.screenNullResult(this.peekLast());
    }

    @Override
    public E pollFirst() {
        Node<Object> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null && p2.casItem(item, null)) {
                this.unlink(p2);
                return item;
            }
            p2 = this.succ(p2);
        }
        return null;
    }

    @Override
    public E pollLast() {
        Node<Object> p2 = this.last();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null && p2.casItem(item, null)) {
                this.unlink(p2);
                return item;
            }
            p2 = this.pred(p2);
        }
        return null;
    }

    @Override
    public E removeFirst() {
        return this.screenNullResult(this.pollFirst());
    }

    @Override
    public E removeLast() {
        return this.screenNullResult(this.pollLast());
    }

    @Override
    public boolean offer(E e2) {
        return this.offerLast(e2);
    }

    @Override
    public boolean add(E e2) {
        return this.offerLast(e2);
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public void push(E e2) {
        this.addFirst(e2);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object o2) {
        ConcurrentLinkedDeque.checkNotNull(o2);
        Node<Object> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null && o2.equals(item) && p2.casItem(item, null)) {
                this.unlink(p2);
                return true;
            }
            p2 = this.succ(p2);
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o2) {
        ConcurrentLinkedDeque.checkNotNull(o2);
        Node<Object> p2 = this.last();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null && o2.equals(item) && p2.casItem(item, null)) {
                this.unlink(p2);
                return true;
            }
            p2 = this.pred(p2);
        }
        return false;
    }

    @Override
    public boolean contains(Object o2) {
        if (o2 == null) {
            return false;
        }
        Node<E> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null && o2.equals(item)) {
                return true;
            }
            p2 = this.succ(p2);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.peekFirst() == null;
    }

    @Override
    public int size() {
        int count2 = 0;
        Node<E> p2 = this.first();
        while (p2 != null && (p2.item == null || ++count2 != Integer.MAX_VALUE)) {
            p2 = this.succ(p2);
        }
        return count2;
    }

    @Override
    public boolean remove(Object o2) {
        return this.removeFirstOccurrence(o2);
    }

    @Override
    public boolean addAll(Collection<? extends E> c2) {
        Node t2;
        if (c2 == this) {
            throw new IllegalArgumentException();
        }
        Node beginningOfTheEnd = null;
        Node last = null;
        for (E e2 : c2) {
            ConcurrentLinkedDeque.checkNotNull(e2);
            Node newNode = new Node(e2);
            if (beginningOfTheEnd == null) {
                beginningOfTheEnd = last = newNode;
                continue;
            }
            last.lazySetNext(newNode);
            newNode.lazySetPrev(last);
            last = newNode;
        }
        if (beginningOfTheEnd == null) {
            return false;
        }
        block1: while (true) {
            Node p2 = t2 = this.tail;
            while (true) {
                Node q2;
                if ((q2 = p2.next) != null) {
                    p2 = q2;
                    q2 = p2.next;
                    if (q2 != null) {
                        p2 = t2 != (t2 = this.tail) ? t2 : q2;
                        continue;
                    }
                }
                if (p2.prev == p2) continue block1;
                beginningOfTheEnd.lazySetPrev(p2);
                if (p2.casNext(null, beginningOfTheEnd)) break block1;
            }
            break;
        }
        if (!this.casTail(t2, last)) {
            t2 = this.tail;
            if (last.next == null) {
                this.casTail(t2, last);
            }
        }
        return true;
    }

    @Override
    public void clear() {
        while (this.pollFirst() != null) {
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        return this.toArrayList().toArray(a2);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingItr();
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        Node<E> p2 = this.first();
        while (p2 != null) {
            Object item = p2.item;
            if (item != null) {
                s2.writeObject(item);
            }
            p2 = this.succ(p2);
        }
        s2.writeObject(null);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        Object item;
        s2.defaultReadObject();
        Node<Object> h2 = null;
        Node<Object> t2 = null;
        while ((item = s2.readObject()) != null) {
            Node<Object> newNode = new Node<Object>(item);
            if (h2 == null) {
                h2 = t2 = newNode;
                continue;
            }
            t2.lazySetNext(newNode);
            newNode.lazySetPrev(t2);
            t2 = newNode;
        }
        this.initHeadTail(h2, t2);
    }

    private boolean casHead(Node<E> cmp, Node<E> val) {
        return UNSAFE.compareAndSwapObject(this, headOffset, cmp, val);
    }

    private boolean casTail(Node<E> cmp, Node<E> val) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, cmp, val);
    }

    static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f2 = Unsafe.class.getDeclaredField("theUnsafe");
                        f2.setAccessible(true);
                        return (Unsafe)f2.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e2) {
                throw new RuntimeException("Could not initialize intrinsics", e2.getCause());
            }
        }
    }

    static {
        ConcurrentLinkedDeque.PREV_TERMINATOR.next = PREV_TERMINATOR;
        NEXT_TERMINATOR = new Node();
        ConcurrentLinkedDeque.NEXT_TERMINATOR.prev = NEXT_TERMINATOR;
        try {
            UNSAFE = ConcurrentLinkedDeque.getUnsafe();
            Class<ConcurrentLinkedDeque> k2 = ConcurrentLinkedDeque.class;
            headOffset = UNSAFE.objectFieldOffset(k2.getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(k2.getDeclaredField("tail"));
        }
        catch (Exception e2) {
            throw new Error(e2);
        }
    }

    private class DescendingItr
    extends AbstractItr {
        private DescendingItr() {
        }

        @Override
        Node<E> startNode() {
            return ConcurrentLinkedDeque.this.last();
        }

        @Override
        Node<E> nextNode(Node<E> p2) {
            return ConcurrentLinkedDeque.this.pred(p2);
        }
    }

    private class Itr
    extends AbstractItr {
        private Itr() {
        }

        @Override
        Node<E> startNode() {
            return ConcurrentLinkedDeque.this.first();
        }

        @Override
        Node<E> nextNode(Node<E> p2) {
            return ConcurrentLinkedDeque.this.succ(p2);
        }
    }

    private abstract class AbstractItr
    implements Iterator<E> {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;

        abstract Node<E> startNode();

        abstract Node<E> nextNode(Node<E> var1);

        AbstractItr() {
            this.advance();
        }

        private void advance() {
            Node p2;
            this.lastRet = this.nextNode;
            Node node = p2 = this.nextNode == null ? this.startNode() : this.nextNode(this.nextNode);
            while (true) {
                if (p2 == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    break;
                }
                Object item = p2.item;
                if (item != null) {
                    this.nextNode = p2;
                    this.nextItem = item;
                    break;
                }
                p2 = this.nextNode(p2);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextItem != null;
        }

        @Override
        public E next() {
            Object item = this.nextItem;
            if (item == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return item;
        }

        @Override
        public void remove() {
            Node l2 = this.lastRet;
            if (l2 == null) {
                throw new IllegalStateException();
            }
            l2.item = null;
            ConcurrentLinkedDeque.this.unlink(l2);
            this.lastRet = null;
        }
    }

    static final class Node<E> {
        volatile Node<E> prev;
        volatile E item;
        volatile Node<E> next;
        private static final Unsafe UNSAFE;
        private static final long prevOffset;
        private static final long itemOffset;
        private static final long nextOffset;

        Node() {
        }

        Node(E item) {
            UNSAFE.putObject(this, itemOffset, item);
        }

        boolean casItem(E cmp, E val) {
            return UNSAFE.compareAndSwapObject(this, itemOffset, cmp, val);
        }

        void lazySetNext(Node<E> val) {
            UNSAFE.putOrderedObject(this, nextOffset, val);
        }

        boolean casNext(Node<E> cmp, Node<E> val) {
            return UNSAFE.compareAndSwapObject(this, nextOffset, cmp, val);
        }

        void lazySetPrev(Node<E> val) {
            UNSAFE.putOrderedObject(this, prevOffset, val);
        }

        boolean casPrev(Node<E> cmp, Node<E> val) {
            return UNSAFE.compareAndSwapObject(this, prevOffset, cmp, val);
        }

        static {
            try {
                UNSAFE = ConcurrentLinkedDeque.getUnsafe();
                Class<Node> k2 = Node.class;
                prevOffset = UNSAFE.objectFieldOffset(k2.getDeclaredField("prev"));
                itemOffset = UNSAFE.objectFieldOffset(k2.getDeclaredField("item"));
                nextOffset = UNSAFE.objectFieldOffset(k2.getDeclaredField("next"));
            }
            catch (Exception e2) {
                throw new Error(e2);
            }
        }
    }
}

