/*
 * Decompiled with CFR 0.152.
 */
package jsr166y;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import jsr166y.ForkJoinTask;
import jsr166y.ForkJoinWorkerThread;
import sun.misc.Unsafe;
import water.H2ORuntime;

public class ForkJoinPool
extends AbstractExecutorService {
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    private static final AtomicInteger poolNumberGenerator;
    static final AtomicInteger nextSubmitterSeed;
    private static final RuntimePermission modifyThreadPermission;
    private static final ThreadSubmitter submitters;
    private static final long SHRINK_RATE = 1000000000L;
    private static final long SHRINK_TIMEOUT = 900000000L;
    private static final int MAX_HELP = 64;
    private static final long COMPENSATION_DELAY = 262144L;
    private static final int SEED_INCREMENT = 1640531527;
    private static final int AC_SHIFT = 48;
    private static final int TC_SHIFT = 32;
    private static final int ST_SHIFT = 31;
    private static final int EC_SHIFT = 16;
    private static final int SMASK = 65535;
    private static final int MAX_CAP = Short.MAX_VALUE;
    private static final int SQMASK = 65534;
    private static final int SHORT_SIGN = 32768;
    private static final int INT_SIGN = Integer.MIN_VALUE;
    private static final long STOP_BIT = 0x80000000L;
    private static final long AC_MASK = -281474976710656L;
    private static final long TC_MASK = 0xFFFF00000000L;
    private static final long TC_UNIT = 0x100000000L;
    private static final long AC_UNIT = 0x1000000000000L;
    private static final int UAC_SHIFT = 16;
    private static final int UTC_SHIFT = 0;
    private static final int UAC_MASK = -65536;
    private static final int UTC_MASK = 65535;
    private static final int UAC_UNIT = 65536;
    private static final int UTC_UNIT = 1;
    private static final int E_MASK = Integer.MAX_VALUE;
    private static final int E_SEQ = 65536;
    private static final int SHUTDOWN = Integer.MIN_VALUE;
    static final int LIFO_QUEUE = 0;
    static final int FIFO_QUEUE = 1;
    static final int SHARED_QUEUE = -1;
    volatile long ctl;
    final int parallelism;
    final int localMode;
    final int submitMask;
    int nextSeed;
    volatile int runState;
    WorkQueue[] workQueues;
    final Mutex lock;
    final Condition termination;
    final ForkJoinWorkerThreadFactory factory;
    final Thread.UncaughtExceptionHandler ueh;
    final AtomicLong stealCount;
    final AtomicInteger nextWorkerNumber;
    final String workerNamePrefix;
    private static final Unsafe U;
    private static final long CTL;
    private static final long PARKBLOCKER;
    private static final int ABASE;
    private static final int ASHIFT;

    private static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(modifyThreadPermission);
        }
    }

    private void addWorker() {
        Throwable ex = null;
        ForkJoinWorkerThread wt = null;
        try {
            wt = this.factory.newThread(this);
            if (wt != null) {
                wt.start();
                return;
            }
        }
        catch (Throwable e2) {
            ex = e2;
        }
        this.deregisterWorker(wt, ex);
    }

    final String nextWorkerName() {
        return this.workerNamePrefix.concat(Integer.toString(this.nextWorkerNumber.addAndGet(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerWorker(WorkQueue w2) {
        Mutex lock = this.lock;
        lock.lock();
        try {
            WorkQueue[] ws = this.workQueues;
            if (w2 != null && ws != null) {
                int n2 = ws.length;
                int m4 = n2 - 1;
                int s2 = this.nextSeed += 1640531527;
                w2.seed = s2 == 0 ? 1 : s2;
                int r2 = s2 << 1 | 1;
                if (ws[r2 &= m4] != null) {
                    int step;
                    int probes = 0;
                    int n3 = step = n2 <= 4 ? 2 : (n2 >>> 1 & 0xFFFE) + 2;
                    while (ws[r2 = r2 + step & m4] != null) {
                        if (++probes < n2) continue;
                        this.workQueues = ws = Arrays.copyOf(ws, n2 <<= 1);
                        m4 = n2 - 1;
                        probes = 0;
                    }
                }
                w2.eventCount = w2.poolIndex = r2;
                ws[r2] = w2;
                int rs = this.runState;
                this.runState = rs & Integer.MIN_VALUE | rs + 2 & Integer.MAX_VALUE;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deregisterWorker(ForkJoinWorkerThread wt, Throwable ex) {
        long c2;
        Mutex lock = this.lock;
        WorkQueue w2 = null;
        if (wt != null && (w2 = wt.workQueue) != null) {
            w2.runState = -1;
            this.stealCount.getAndAdd(w2.totalSteals + (long)w2.nsteals);
            int idx = w2.poolIndex;
            lock.lock();
            try {
                WorkQueue[] ws = this.workQueues;
                if (ws != null && idx >= 0 && idx < ws.length && ws[idx] == w2) {
                    ws[idx] = null;
                }
            }
            finally {
                lock.unlock();
            }
        }
        while (!U.compareAndSwapLong(this, CTL, c2 = this.ctl, c2 - 0x1000000000000L & 0xFFFF000000000000L | c2 - 0x100000000L & 0xFFFF00000000L | c2 & 0xFFFFFFFFL)) {
        }
        if (!this.tryTerminate(false, false) && w2 != null) {
            w2.cancelAll();
            if (w2.array != null) {
                this.signalWork();
            }
            if (ex == null) {
                ForkJoinTask.helpExpungeStaleExceptions();
            }
        }
        if (ex != null) {
            U.throwException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doSubmit(ForkJoinTask<?> task) {
        s = (Submitter)ForkJoinPool.submitters.get();
        r = s.seed;
        m = this.submitMask;
        while (true) lbl-1000:
        // 6 sources

        {
            block12: {
                block11: {
                    k = r & m & 65534;
                    if (this.runState < 0) break block11;
                    ws = this.workQueues;
                    if (this.workQueues != null && ws.length > k) break block12;
                }
                throw new RejectedExecutionException();
            }
            q = ws[k];
            if (q == null) {
                nq = new WorkQueue(this, null, -1);
                lock = this.lock;
                lock.lock();
                try {
                    rs = this.runState;
                    if (ws != this.workQueues || ws[k] != null) ** GOTO lbl-1000
                    ws[k] = nq;
                    this.runState = rs & -2147483648 | rs + 2 & 0x7FFFFFFF;
                }
                finally {
                    lock.unlock();
                }
                continue;
            }
            if (q.trySharedPush(task)) {
                this.signalWork();
                return;
            }
            if (m > 1) {
                r ^= r << 13;
                r ^= r >>> 17;
                r ^= r << 5;
                s.seed = r;
                continue;
            }
            Thread.yield();
        }
    }

    final void incrementActiveCount() {
        long c2;
        while (!U.compareAndSwapLong(this, CTL, c2 = this.ctl, c2 + 0x1000000000000L)) {
        }
    }

    final void signalWork() {
        long c2;
        int u2;
        while ((u2 = (int)((c2 = this.ctl) >>> 32)) < 0) {
            long nc;
            WorkQueue[] ws = this.workQueues;
            int e2 = (int)c2;
            if (e2 > 0) {
                WorkQueue w2;
                int i2;
                if (ws == null || (i2 = e2 & 0xFFFF) >= ws.length || (w2 = ws[i2]) == null || w2.eventCount != (e2 | Integer.MIN_VALUE)) break;
                nc = (long)(w2.nextWait & Integer.MAX_VALUE) | (long)(u2 + 65536) << 32;
                if (!U.compareAndSwapLong(this, CTL, c2, nc)) continue;
                w2.eventCount = e2 + 65536 & Integer.MAX_VALUE;
                Thread p2 = w2.parker;
                if (p2 == null) break;
                U.unpark(p2);
                break;
            }
            if (e2 != 0 || (u2 & 0x8000) == 0) break;
            nc = (long)(u2 + 1 & 0xFFFF | u2 + 65536 & 0xFFFF0000) << 32;
            if (!U.compareAndSwapLong(this, CTL, c2, nc)) continue;
            this.addWorker();
            break;
        }
    }

    final void runWorker(WorkQueue w2) {
        w2.growArray(false);
        do {
            w2.runTask(this.scan(w2));
        } while (w2.runState >= 0);
    }

    private final ForkJoinTask<?> scan(WorkQueue w2) {
        int m4;
        int r2 = w2.seed;
        r2 ^= r2 << 13;
        r2 ^= r2 >>> 17;
        r2 ^= r2 << 5;
        w2.seed = r2;
        int rs = this.runState;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null && (m4 = ws.length - 1) > 0) {
            int ec = w2.eventCount;
            int step = r2 >>> 16 | 1;
            int j2 = m4 + 1 << 2;
            while (true) {
                int b2;
                WorkQueue q2;
                if ((q2 = ws[r2 & m4]) != null && (b2 = q2.base) - q2.top < 0) {
                    ForkJoinTask<?>[] a2 = q2.array;
                    if (q2.array != null) {
                        int i2 = ((a2.length - 1 & b2) << ASHIFT) + ABASE;
                        ForkJoinTask t2 = (ForkJoinTask)U.getObjectVolatile(a2, i2);
                        if (q2.base == b2 && ec >= 0 && t2 != null && U.compareAndSwapObject(a2, i2, t2, null)) {
                            q2.base = b2 + 1;
                            if (q2.top - q2.base > 1) {
                                this.signalWork();
                            }
                            return t2;
                        }
                        if (ec < 0 || j2 <= m4) {
                            rs = 0;
                            break;
                        }
                    }
                }
                if (--j2 < 0) break;
                r2 += step;
            }
            long c2 = this.ctl;
            int e2 = (int)c2;
            int a3 = (int)(c2 >> 48);
            if (e2 < 0) {
                w2.runState = -1;
            } else if (rs == 0 || rs != this.runState) {
                WorkQueue v2;
                if (e2 > 0 && a3 < 0 && w2.eventCount == ec && (v2 = ws[e2 & m4]) != null && v2.eventCount == (e2 | Integer.MIN_VALUE)) {
                    long nc = (long)(v2.nextWait & Integer.MAX_VALUE) | c2 + 0x1000000000000L & 0xFFFFFFFF00000000L;
                    if (this.ctl == c2 && U.compareAndSwapLong(this, CTL, c2, nc)) {
                        v2.eventCount = e2 + 65536 & Integer.MAX_VALUE;
                        Thread p2 = v2.parker;
                        if (p2 != null) {
                            U.unpark(p2);
                        }
                    }
                }
            } else if (ec >= 0) {
                long nc = (long)ec | c2 - 0x1000000000000L & 0xFFFFFFFF00000000L;
                w2.nextWait = e2;
                w2.eventCount = ec | Integer.MIN_VALUE;
                if (this.ctl != c2 || !U.compareAndSwapLong(this, CTL, c2, nc)) {
                    w2.eventCount = ec;
                } else {
                    int ns = w2.nsteals;
                    if (ns != 0) {
                        w2.nsteals = 0;
                        w2.rescans = a3 > 0 ? 0 : a3 + this.parallelism;
                        w2.totalSteals += (long)ns;
                    }
                    if (a3 == 1 - this.parallelism) {
                        this.idleAwaitWork(w2, nc, c2);
                    }
                }
            } else if (w2.eventCount < 0) {
                int nr = w2.rescans;
                if (nr > 0) {
                    int ac = a3 + this.parallelism;
                    w2.rescans = ac < nr ? ac : nr - 1;
                    if ((w2.rescans & 3) == 0) {
                        Thread.yield();
                    }
                } else {
                    Thread.interrupted();
                    Thread wt = Thread.currentThread();
                    U.putObject(wt, PARKBLOCKER, this);
                    w2.parker = wt;
                    if (w2.eventCount < 0) {
                        U.park(false, 0L);
                    }
                    w2.parker = null;
                    U.putObject(wt, PARKBLOCKER, null);
                }
            }
        }
        return null;
    }

    private void idleAwaitWork(WorkQueue w2, long currentCtl, long prevCtl) {
        if (w2.eventCount < 0 && !this.tryTerminate(false, false) && (int)prevCtl != 0 && !this.hasQueuedSubmissions() && this.ctl == currentCtl) {
            Thread wt = Thread.currentThread();
            Thread.yield();
            while (this.ctl == currentCtl) {
                long startTime = System.nanoTime();
                Thread.interrupted();
                U.putObject(wt, PARKBLOCKER, this);
                w2.parker = wt;
                if (this.ctl == currentCtl) {
                    U.park(false, 1000000000L);
                }
                w2.parker = null;
                U.putObject(wt, PARKBLOCKER, null);
                if (this.ctl != currentCtl) break;
                if (System.nanoTime() - startTime < 900000000L || !U.compareAndSwapLong(this, CTL, currentCtl, prevCtl)) continue;
                w2.eventCount = w2.eventCount + 65536 | Integer.MAX_VALUE;
                w2.runState = -1;
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int tryHelpStealer(WorkQueue joiner, ForkJoinTask<?> task) {
        stat = 0;
        steps = 0;
        if (joiner != null && task != null) {
            block0: while (true) {
                subtask = task;
                j = joiner;
                while (true) {
                    block9: {
                        block8: {
                            if ((s = task.status) < 0) {
                                stat = s;
                                break block0;
                            }
                            ws = this.workQueues;
                            if (this.workQueues == null || (m = ws.length - 1) <= 0) break block0;
                            h = (j.stealHint | 1) & m;
                            v = ws[h];
                            if (v == null || v.currentSteal != subtask) {
                                origin = h;
                                do {
                                    if (((h = h + 2 & m) & 15) == 1 && (subtask.status < 0 || j.currentJoin != subtask)) continue block0;
                                    v = ws[h];
                                    if (v == null || v.currentSteal != subtask) continue;
                                    j.stealHint = h;
                                    break block8;
                                } while (h != origin);
                                break block0;
                            }
                        }
                        while (true) {
                            if (subtask.status < 0) continue block0;
                            b = v.base;
                            if (b - v.top >= 0) break block9;
                            a = v.array;
                            if (v.array == null) break block9;
                            i = ((a.length - 1 & b) << ForkJoinPool.ASHIFT) + ForkJoinPool.ABASE;
                            t = (ForkJoinTask)ForkJoinPool.U.getObjectVolatile(a, i);
                            if (subtask.status < 0 || j.currentJoin != subtask || v.currentSteal != subtask) continue block0;
                            stat = 1;
                            if (t != null && v.base == b && ForkJoinPool.U.compareAndSwapObject(a, i, t, null)) {
                                v.base = b + 1;
                                joiner.runSubtask(t);
                                continue;
                            }
                            if (v.base == b && ++steps == 64) break;
                        }
                        break block0;
                    }
                    next = v.currentJoin;
                    if (subtask.status >= 0 && j.currentJoin == subtask && v.currentSteal == subtask) ** break;
                    continue block0;
                    if (next == null || ++steps == 64) break block0;
                    subtask = next;
                    j = v;
                }
                break;
            }
        }
        return stat;
    }

    private void tryPollForAndExec(WorkQueue joiner, ForkJoinTask<?> task) {
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int j2 = 1; j2 < ws.length && task.status >= 0; j2 += 2) {
                WorkQueue q2 = ws[j2];
                if (q2 == null || !q2.pollFor(task)) continue;
                joiner.runSubtask(task);
                break;
            }
        }
    }

    final boolean tryCompensate(ForkJoinTask<?> task, ManagedBlocker blocker) {
        int pc = this.parallelism;
        long c2 = this.ctl;
        WorkQueue[] ws = this.workQueues;
        int e2 = (int)c2;
        if (e2 >= 0 && ws != null) {
            WorkQueue w2;
            int u2 = (int)(c2 >>> 32);
            int tc = (short)(u2 >>> 0) + pc;
            boolean replace = false;
            int a2 = u2 >> 16;
            if (a2 <= 0) {
                int hc2;
                int ac = a2 + pc;
                if (ac <= 1) {
                    replace = true;
                } else if (e2 > 0 || task != null && ac <= (hc2 = pc >>> 1) && tc < pc + hc2) {
                    for (int j2 = 0; j2 < ws.length; ++j2) {
                        w2 = ws[j2];
                        if (w2 == null || w2.isEmpty()) continue;
                        replace = true;
                        break;
                    }
                }
            }
            if (!(task != null && task.status < 0 || blocker != null && blocker.isReleasable() || this.ctl != c2)) {
                long nc;
                if (!replace) {
                    long nc2 = c2 - 0x1000000000000L & 0xFFFF000000000000L | c2 & 0xFFFFFFFFFFFFL;
                    if (U.compareAndSwapLong(this, CTL, c2, nc2)) {
                        return true;
                    }
                } else if (e2 != 0) {
                    int i2 = e2 & 0xFFFF;
                    if (i2 < ws.length && (w2 = ws[i2]) != null) {
                        long nc3 = (long)(w2.nextWait & Integer.MAX_VALUE) | c2 & 0xFFFFFFFF00000000L;
                        if (w2.eventCount == (e2 | Integer.MIN_VALUE) && U.compareAndSwapLong(this, CTL, c2, nc3)) {
                            w2.eventCount = e2 + 65536 & Integer.MAX_VALUE;
                            Thread p2 = w2.parker;
                            if (p2 != null) {
                                U.unpark(p2);
                            }
                            return true;
                        }
                    }
                } else if (tc < Short.MAX_VALUE && U.compareAndSwapLong(this, CTL, c2, nc = c2 + 0x100000000L & 0xFFFF00000000L | c2 & 0xFFFF0000FFFFFFFFL)) {
                    this.addWorker();
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int awaitJoin(WorkQueue joiner, ForkJoinTask<?> task) {
        int s2 = task.status;
        if (s2 >= 0) {
            ForkJoinTask<?> prevJoin = joiner.currentJoin;
            joiner.currentJoin = task;
            long startTime = 0L;
            int k2 = 0;
            while (true) {
                if ((s2 = joiner.isEmpty() ? this.tryHelpStealer(joiner, task) : joiner.tryRemoveAndExec(task)) == 0 && (s2 = task.status) >= 0) {
                    if (k2 == 0) {
                        startTime = System.nanoTime();
                        this.tryPollForAndExec(joiner, task);
                    } else if ((k2 & 0x3F) == 0 && System.nanoTime() - startTime >= 262144L && this.tryCompensate(task, null)) {
                        long c2;
                        if (task.trySetSignal()) {
                            ForkJoinTask<?> forkJoinTask = task;
                            synchronized (forkJoinTask) {
                                if (task.status >= 0) {
                                    try {
                                        task.wait();
                                    }
                                    catch (InterruptedException interruptedException) {}
                                } else {
                                    task.notifyAll();
                                }
                            }
                        }
                        while (!U.compareAndSwapLong(this, CTL, c2 = this.ctl, c2 + 0x1000000000000L)) {
                        }
                    }
                }
                if (s2 < 0 || (s2 = task.status) < 0) {
                    joiner.currentJoin = prevJoin;
                    break;
                }
                if ((k2++ & 0x3F) != 32) continue;
                Thread.yield();
            }
        }
        return s2;
    }

    final int helpJoinOnce(WorkQueue joiner, ForkJoinTask<?> task) {
        int s2;
        while ((s2 = task.status) >= 0 && (joiner.isEmpty() ? this.tryHelpStealer(joiner, task) : joiner.tryRemoveAndExec(task)) != 0) {
        }
        return s2;
    }

    private WorkQueue findNonEmptyStealQueue(WorkQueue w2) {
        int r2 = w2.seed;
        r2 ^= r2 << 13;
        r2 ^= r2 >>> 17;
        r2 ^= r2 << 5;
        w2.seed = r2;
        int step = r2 >>> 16 | 1;
        block0: while (true) {
            int m4;
            int rs = this.runState;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null || (m4 = ws.length - 1) < 1) {
                return null;
            }
            int j2 = m4 + 1 << 2;
            while (true) {
                WorkQueue q2;
                if ((q2 = ws[(r2 << 1 | 1) & m4]) != null && !q2.isEmpty()) {
                    return q2;
                }
                if (--j2 < 0) {
                    if (this.runState != rs) continue block0;
                    return null;
                }
                r2 += step;
            }
            break;
        }
    }

    final void helpQuiescePool(WorkQueue w2) {
        long c2;
        boolean active = true;
        while (true) {
            ForkJoinTask<?> localTask;
            if ((localTask = w2.nextLocalTask()) != null) {
                localTask.doExec();
                continue;
            }
            WorkQueue q2 = this.findNonEmptyStealQueue(w2);
            if (q2 != null) {
                ForkJoinTask<?> t2;
                int b2;
                if (!active) {
                    long c3;
                    active = true;
                    while (!U.compareAndSwapLong(this, CTL, c3 = this.ctl, c3 + 0x1000000000000L)) {
                    }
                }
                if ((b2 = q2.base) - q2.top >= 0 || (t2 = q2.pollAt(b2)) == null) continue;
                w2.runSubtask(t2);
                continue;
            }
            if (active) {
                active = false;
                do {
                    c2 = this.ctl;
                } while (!U.compareAndSwapLong(this, CTL, c2, c2 -= 0x1000000000000L));
            } else {
                c2 = this.ctl;
            }
            if ((int)(c2 >> 48) + this.parallelism == 0) break;
        }
        while (!U.compareAndSwapLong(this, CTL, c2 = this.ctl, c2 + 0x1000000000000L)) {
        }
    }

    final ForkJoinTask<?> nextTaskFor(WorkQueue w2) {
        ForkJoinTask<?> t2;
        WorkQueue q2;
        int b2;
        do {
            if ((t2 = w2.nextLocalTask()) != null) {
                return t2;
            }
            q2 = this.findNonEmptyStealQueue(w2);
            if (q2 != null) continue;
            return null;
        } while ((b2 = q2.base) - q2.top >= 0 || (t2 = q2.pollAt(b2)) == null);
        return t2;
    }

    final int idlePerActive() {
        int p2 = this.parallelism;
        int a2 = p2 + (int)(this.ctl >> 48);
        return a2 > (p2 >>>= 1) ? 0 : (a2 > (p2 >>>= 1) ? 1 : (a2 > (p2 >>>= 1) ? 2 : (a2 > (p2 >>>= 1) ? 4 : 8)));
    }

    /*
     * Unable to fully structure code
     */
    private boolean tryTerminate(boolean now, boolean enable) {
        lock = this.lock;
        block0: while (true) {
            if (((c = this.ctl) & 0x80000000L) != 0L) {
                if ((short)(c >>> 32) == -this.parallelism) {
                    lock.lock();
                    this.termination.signalAll();
                    lock.unlock();
                }
                return true;
            }
            if (this.runState >= 0) {
                if (!enable) {
                    return false;
                }
                lock.lock();
                this.runState |= -2147483648;
                lock.unlock();
            }
            if (!now) {
                if ((int)(c >> 48) != -this.parallelism || this.hasQueuedSubmissions()) {
                    return false;
                }
                ws = this.workQueues;
                if (ws != null) {
                    for (i = 1; i < ws.length; i += 2) {
                        w = ws[i];
                        if (w == null || w.eventCount < 0) continue;
                        return false;
                    }
                }
            }
            if (!ForkJoinPool.U.compareAndSwapLong(this, ForkJoinPool.CTL, c, c | 0x80000000L)) continue;
            pass = 0;
            while (true) {
                if (pass < 3) ** break;
                continue block0;
                ws = this.workQueues;
                if (ws != null) {
                    n = ws.length;
                    for (i = 0; i < n; ++i) {
                        w = ws[i];
                        if (w == null) continue;
                        w.runState = -1;
                        if (pass <= 0) continue;
                        w.cancelAll();
                        if (pass <= 1) continue;
                        w.interruptOwner();
                    }
                    while ((e = (int)(cc = this.ctl) & 0x7FFFFFFF) != 0 && (i = e & 65535) < n && (w = ws[i]) != null) {
                        nc = (long)(w.nextWait & 0x7FFFFFFF) | cc + 0x1000000000000L & -281474976710656L | cc & 0xFFFF80000000L;
                        if (w.eventCount != (e | -2147483648) || !ForkJoinPool.U.compareAndSwapLong(this, ForkJoinPool.CTL, cc, nc)) continue;
                        w.eventCount = e + 65536 & 0x7FFFFFFF;
                        w.runState = -1;
                        p = w.parker;
                        if (p == null) continue;
                        ForkJoinPool.U.unpark(p);
                    }
                }
                ++pass;
            }
            break;
        }
    }

    public ForkJoinPool() {
        this(H2ORuntime.availableProcessors(), defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int parallelism) {
        this(parallelism, defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, boolean asyncMode) {
        ForkJoinPool.checkPermission();
        if (factory == null) {
            throw new NullPointerException();
        }
        if (parallelism <= 0 || parallelism > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.parallelism = parallelism;
        this.factory = factory;
        this.ueh = handler;
        this.localMode = asyncMode ? 1 : 0;
        long np = -parallelism;
        this.ctl = np << 48 & 0xFFFF000000000000L | np << 32 & 0xFFFF00000000L;
        int n2 = parallelism - 1;
        n2 |= n2 >>> 1;
        n2 |= n2 >>> 2;
        n2 |= n2 >>> 4;
        n2 |= n2 >>> 8;
        n2 |= n2 >>> 16;
        int size = n2 + 1 << 1;
        this.submitMask = size - 1;
        this.workQueues = new WorkQueue[size];
        this.lock = new Mutex();
        this.termination = this.lock.newCondition();
        this.stealCount = new AtomicLong();
        this.nextWorkerNumber = new AtomicInteger();
        int pn = poolNumberGenerator.incrementAndGet();
        StringBuilder sb = new StringBuilder("FJ-");
        sb.append(Integer.toString(pn));
        sb.append("-");
        this.workerNamePrefix = sb.toString();
        this.lock.lock();
        this.runState = 1;
        this.lock.unlock();
    }

    public <T> T invoke(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.doSubmit(task);
        return task.join();
    }

    public void execute(ForkJoinTask<?> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.doSubmit(task);
    }

    @Override
    public void execute(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask job = task instanceof ForkJoinTask ? (ForkJoinTask)((Object)task) : new ForkJoinTask.AdaptedRunnableAction(task);
        this.doSubmit(job);
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.doSubmit(task);
        return task;
    }

    public <T> ForkJoinTask<T> submit(Callable<T> task) {
        ForkJoinTask.AdaptedCallable<T> job = new ForkJoinTask.AdaptedCallable<T>(task);
        this.doSubmit(job);
        return job;
    }

    public <T> ForkJoinTask<T> submit(Runnable task, T result) {
        ForkJoinTask.AdaptedRunnable<T> job = new ForkJoinTask.AdaptedRunnable<T>(task, result);
        this.doSubmit(job);
        return job;
    }

    public ForkJoinTask<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask job = task instanceof ForkJoinTask ? (ForkJoinTask)((Object)task) : new ForkJoinTask.AdaptedRunnableAction(task);
        this.doSubmit(job);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        ArrayList<ForkJoinTask.AdaptedCallable<T>> fs;
        ArrayList<ForkJoinTask.AdaptedCallable<T>> futures = fs = new ArrayList<ForkJoinTask.AdaptedCallable<T>>(tasks.size());
        boolean done = false;
        try {
            for (Callable<T> callable : tasks) {
                ForkJoinTask.AdaptedCallable<T> adaptedCallable = new ForkJoinTask.AdaptedCallable<T>(callable);
                this.doSubmit(adaptedCallable);
                fs.add(adaptedCallable);
            }
            for (ForkJoinTask forkJoinTask : fs) {
                forkJoinTask.quietlyJoin();
            }
            done = true;
            ArrayList<ForkJoinTask.AdaptedCallable<T>> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                for (ForkJoinTask forkJoinTask : fs) {
                    forkJoinTask.cancel(false);
                }
            }
        }
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.ueh;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getPoolSize() {
        return this.parallelism + (short)(this.ctl >>> 32);
    }

    public boolean getAsyncMode() {
        return this.localMode != 0;
    }

    public int getRunningThreadCount() {
        int rc = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i2 = 1; i2 < ws.length; i2 += 2) {
                WorkQueue w2 = ws[i2];
                if (w2 == null || !w2.isApparentlyUnblocked()) continue;
                ++rc;
            }
        }
        return rc;
    }

    public int getActiveThreadCount() {
        int r2 = this.parallelism + (int)(this.ctl >> 48);
        return r2 <= 0 ? 0 : r2;
    }

    public boolean isQuiescent() {
        return (int)(this.ctl >> 48) + this.parallelism == 0;
    }

    public long getStealCount() {
        long count2 = this.stealCount.get();
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i2 = 1; i2 < ws.length; i2 += 2) {
                WorkQueue w2 = ws[i2];
                if (w2 == null) continue;
                count2 += w2.totalSteals;
            }
        }
        return count2;
    }

    public long getQueuedTaskCount() {
        long count2 = 0L;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i2 = 1; i2 < ws.length; i2 += 2) {
                WorkQueue w2 = ws[i2];
                if (w2 == null) continue;
                count2 += (long)w2.queueSize();
            }
        }
        return count2;
    }

    public int getQueuedSubmissionCount() {
        int count2 = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i2 = 0; i2 < ws.length; i2 += 2) {
                WorkQueue w2 = ws[i2];
                if (w2 == null) continue;
                count2 += w2.queueSize();
            }
        }
        return count2;
    }

    public boolean hasQueuedSubmissions() {
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i2 = 0; i2 < ws.length; i2 += 2) {
                WorkQueue w2 = ws[i2];
                if (w2 == null || w2.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected ForkJoinTask<?> pollSubmission() {
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i2 = 0; i2 < ws.length; i2 += 2) {
                ForkJoinTask<?> t2;
                WorkQueue w2 = ws[i2];
                if (w2 == null || (t2 = w2.poll()) == null) continue;
                return t2;
            }
        }
        return null;
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> c2) {
        int count2 = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i2 = 0; i2 < ws.length; ++i2) {
                ForkJoinTask<?> t2;
                WorkQueue w2 = ws[i2];
                if (w2 == null) continue;
                while ((t2 = w2.poll()) != null) {
                    c2.add(t2);
                    ++count2;
                }
            }
        }
        return count2;
    }

    public String toString() {
        long qt = 0L;
        long qs = 0L;
        int rc = 0;
        long st = this.stealCount.get();
        long c2 = this.ctl;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i2 = 0; i2 < ws.length; ++i2) {
                WorkQueue w2 = ws[i2];
                if (w2 == null) continue;
                int size = w2.queueSize();
                if ((i2 & 1) == 0) {
                    qs += (long)size;
                    continue;
                }
                qt += (long)size;
                st += w2.totalSteals;
                if (!w2.isApparentlyUnblocked()) continue;
                ++rc;
            }
        }
        int pc = this.parallelism;
        int tc = pc + (short)(c2 >>> 32);
        int ac = pc + (int)(c2 >> 48);
        if (ac < 0) {
            ac = 0;
        }
        String level = (c2 & 0x80000000L) != 0L ? (tc == 0 ? "Terminated" : "Terminating") : (this.runState < 0 ? "Shutting down" : "Running");
        return super.toString() + "[" + level + ", parallelism = " + pc + ", size = " + tc + ", active = " + ac + ", running = " + rc + ", steals = " + st + ", tasks = " + qt + ", submissions = " + qs + "]";
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(false, true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(true, true);
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        long c2 = this.ctl;
        return (c2 & 0x80000000L) != 0L && (short)(c2 >>> 32) == -this.parallelism;
    }

    public boolean isTerminating() {
        long c2 = this.ctl;
        return (c2 & 0x80000000L) != 0L && (short)(c2 >>> 32) != -this.parallelism;
    }

    @Override
    public boolean isShutdown() {
        return this.runState < 0;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        Mutex lock = this.lock;
        lock.lock();
        try {
            while (true) {
                if (this.isTerminated()) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void managedBlock(ManagedBlocker blocker) throws InterruptedException {
        ForkJoinPool p2;
        Thread t2 = Thread.currentThread();
        ForkJoinPool forkJoinPool = p2 = t2 instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t2).pool : null;
        while (!blocker.isReleasable()) {
            if (p2 != null && !p2.tryCompensate(null, blocker)) continue;
            try {
                while (!blocker.isReleasable() && !blocker.block()) {
                }
                break;
            }
            finally {
                if (p2 != null) {
                    p2.incrementActiveCount();
                }
            }
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new ForkJoinTask.AdaptedRunnable<T>(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new ForkJoinTask.AdaptedCallable<T>(callable);
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f2 = Unsafe.class.getDeclaredField("theUnsafe");
                        f2.setAccessible(true);
                        return (Unsafe)f2.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e2) {
                throw new RuntimeException("Could not initialize intrinsics", e2.getCause());
            }
        }
    }

    static {
        int s2;
        poolNumberGenerator = new AtomicInteger();
        nextSubmitterSeed = new AtomicInteger(0x55555555);
        modifyThreadPermission = new RuntimePermission("modifyThread");
        defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
        submitters = new ThreadSubmitter();
        try {
            U = ForkJoinPool.getUnsafe();
            Class<ForkJoinPool> k2 = ForkJoinPool.class;
            Class<ForkJoinTask[]> ak = ForkJoinTask[].class;
            CTL = U.objectFieldOffset(k2.getDeclaredField("ctl"));
            Class<Thread> tk = Thread.class;
            PARKBLOCKER = U.objectFieldOffset(tk.getDeclaredField("parkBlocker"));
            ABASE = U.arrayBaseOffset(ak);
            s2 = U.arrayIndexScale(ak);
        }
        catch (Exception e2) {
            throw new Error(e2);
        }
        if ((s2 & s2 - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        ASHIFT = 31 - Integer.numberOfLeadingZeros(s2);
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class ThreadSubmitter
    extends ThreadLocal<Submitter> {
        ThreadSubmitter() {
        }

        @Override
        public Submitter initialValue() {
            return new Submitter();
        }
    }

    static final class Submitter {
        int seed;

        Submitter() {
            int s2 = nextSubmitterSeed.getAndAdd(1640531527);
            this.seed = s2 == 0 ? 1 : s2;
        }
    }

    static final class WorkQueue {
        static final int INITIAL_QUEUE_CAPACITY = 8192;
        static final int MAXIMUM_QUEUE_CAPACITY = 0x4000000;
        volatile long totalSteals;
        int seed;
        volatile int eventCount;
        int nextWait;
        int rescans;
        int nsteals;
        final int mode;
        int poolIndex;
        int stealHint;
        volatile int runState;
        volatile int base;
        int top;
        ForkJoinTask<?>[] array;
        final ForkJoinPool pool;
        final ForkJoinWorkerThread owner;
        volatile Thread parker;
        volatile ForkJoinTask<?> currentJoin;
        ForkJoinTask<?> currentSteal;
        Object p00;
        Object p01;
        Object p02;
        Object p03;
        Object p04;
        Object p05;
        Object p06;
        Object p07;
        Object p08;
        Object p09;
        Object p0a;
        Object p0b;
        Object p0c;
        Object p0d;
        Object p0e;
        private static final Unsafe U;
        private static final long RUNSTATE;
        private static final int ABASE;
        private static final int ASHIFT;

        WorkQueue(ForkJoinPool pool, ForkJoinWorkerThread owner, int mode) {
            this.mode = mode;
            this.pool = pool;
            this.owner = owner;
            this.top = 4096;
            this.base = 4096;
        }

        final int queueSize() {
            int n2 = this.base - this.top;
            return n2 >= 0 ? 0 : -n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean isEmpty() {
            int s2 = this.top;
            int n2 = this.base - s2;
            if (n2 >= 0) return true;
            if (n2 != -1) return false;
            ForkJoinTask<?>[] a2 = this.array;
            if (this.array == null) return true;
            int m4 = a2.length - 1;
            if (m4 < 0) return true;
            if (U.getObjectVolatile(a2, ((m4 & s2 - 1) << ASHIFT) + ABASE) != null) return false;
            return true;
        }

        final void push(ForkJoinTask<?> task) {
            int s2 = this.top;
            ForkJoinTask<?>[] a2 = this.array;
            if (this.array != null) {
                int m4 = a2.length - 1;
                U.putOrderedObject(a2, ((m4 & s2) << ASHIFT) + ABASE, task);
                this.top = s2 + 1;
                int n2 = this.top - this.base;
                if (n2 <= 2) {
                    ForkJoinPool p2 = this.pool;
                    if (p2 != null) {
                        p2.signalWork();
                    }
                } else if (n2 >= m4) {
                    this.growArray(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean trySharedPush(ForkJoinTask<?> task) {
            boolean submitted = false;
            if (this.runState == 0 && U.compareAndSwapInt(this, RUNSTATE, 0, 1)) {
                ForkJoinTask<?>[] a2 = this.array;
                int s2 = this.top;
                try {
                    if (a2 != null && a2.length > s2 + 1 - this.base || (a2 = this.growArray(false)) != null) {
                        int j2 = ((a2.length - 1 & s2) << ASHIFT) + ABASE;
                        U.putObject(a2, j2, task);
                        this.top = s2 + 1;
                        submitted = true;
                    }
                }
                finally {
                    this.runState = 0;
                }
            }
            return submitted;
        }

        final ForkJoinTask<?> pop() {
            int m4;
            ForkJoinTask<?>[] a2 = this.array;
            if (this.array != null && (m4 = a2.length - 1) >= 0) {
                long j2;
                ForkJoinTask t2;
                int s2;
                while ((s2 = this.top - 1) - this.base >= 0 && (t2 = (ForkJoinTask)U.getObject(a2, j2 = (long)(((m4 & s2) << ASHIFT) + ABASE))) != null) {
                    if (!U.compareAndSwapObject(a2, j2, t2, null)) continue;
                    this.top = s2;
                    return t2;
                }
            }
            return null;
        }

        final ForkJoinTask<?> pollAt(int b2) {
            int j2;
            ForkJoinTask t2;
            ForkJoinTask<?>[] a2 = this.array;
            if (this.array != null && (t2 = (ForkJoinTask)U.getObjectVolatile(a2, j2 = ((a2.length - 1 & b2) << ASHIFT) + ABASE)) != null && this.base == b2 && U.compareAndSwapObject(a2, j2, t2, null)) {
                this.base = b2 + 1;
                return t2;
            }
            return null;
        }

        final ForkJoinTask<?> poll() {
            int b2;
            while ((b2 = this.base) - this.top < 0) {
                ForkJoinTask<?>[] a2 = this.array;
                if (this.array == null) break;
                int j2 = ((a2.length - 1 & b2) << ASHIFT) + ABASE;
                ForkJoinTask t2 = (ForkJoinTask)U.getObjectVolatile(a2, j2);
                if (t2 != null) {
                    if (this.base != b2 || !U.compareAndSwapObject(a2, j2, t2, null)) continue;
                    this.base = b2 + 1;
                    return t2;
                }
                if (this.base != b2) continue;
                if (b2 + 1 == this.top) break;
                Thread.yield();
            }
            return null;
        }

        final ForkJoinTask<?> nextLocalTask() {
            return this.mode == 0 ? this.pop() : this.poll();
        }

        final ForkJoinTask<?> peek() {
            int m4;
            ForkJoinTask<?>[] a2 = this.array;
            if (a2 == null || (m4 = a2.length - 1) < 0) {
                return null;
            }
            int i2 = this.mode == 0 ? this.top - 1 : this.base;
            int j2 = ((i2 & m4) << ASHIFT) + ABASE;
            return (ForkJoinTask)U.getObjectVolatile(a2, j2);
        }

        final boolean tryUnpush(ForkJoinTask<?> t2) {
            int s2;
            ForkJoinTask<?>[] a2 = this.array;
            if (this.array != null && (s2 = this.top) != this.base && U.compareAndSwapObject(a2, ((a2.length - 1 & --s2) << ASHIFT) + ABASE, t2, null)) {
                this.top = s2;
                return true;
            }
            return false;
        }

        final boolean pollFor(ForkJoinTask<?> task) {
            int b2 = this.base;
            if (b2 - this.top < 0) {
                int j2;
                ForkJoinTask<?>[] a2 = this.array;
                if (this.array != null && U.getObjectVolatile(a2, j2 = ((a2.length - 1 & b2) << ASHIFT) + ABASE) == task && this.base == b2 && U.compareAndSwapObject(a2, j2, task, null)) {
                    this.base = b2 + 1;
                    return true;
                }
            }
            return false;
        }

        final ForkJoinTask<?>[] growArray(boolean rejectOnFailure) {
            int size;
            ForkJoinTask<?>[] oldA = this.array;
            int n2 = size = oldA != null ? oldA.length << 1 : 8192;
            if (size <= 0x4000000) {
                int b2;
                int t2;
                int oldMask;
                this.array = new ForkJoinTask[size];
                ForkJoinTask[] a2 = this.array;
                if (oldA != null && (oldMask = oldA.length - 1) >= 0 && (t2 = this.top) - (b2 = this.base) > 0) {
                    int mask = size - 1;
                    do {
                        int oldj = ((b2 & oldMask) << ASHIFT) + ABASE;
                        int j2 = ((b2 & mask) << ASHIFT) + ABASE;
                        ForkJoinTask x2 = (ForkJoinTask)U.getObjectVolatile(oldA, oldj);
                        if (x2 == null || !U.compareAndSwapObject(oldA, oldj, x2, null)) continue;
                        U.putObjectVolatile(a2, j2, x2);
                    } while (++b2 != t2);
                }
                return a2;
            }
            if (!rejectOnFailure) {
                return null;
            }
            throw new RejectedExecutionException("Queue capacity exceeded");
        }

        final void cancelAll() {
            ForkJoinTask<?> t2;
            ForkJoinTask.cancelIgnoringExceptions(this.currentJoin);
            ForkJoinTask.cancelIgnoringExceptions(this.currentSteal);
            while ((t2 = this.poll()) != null) {
                ForkJoinTask.cancelIgnoringExceptions(t2);
            }
        }

        final int nextSeed() {
            int r2 = this.seed;
            r2 ^= r2 << 13;
            r2 ^= r2 >>> 17;
            r2 ^= r2 << 5;
            this.seed = r2;
            return r2;
        }

        private void popAndExecAll() {
            while (true) {
                long j2;
                ForkJoinTask t2;
                int s2;
                int m4;
                ForkJoinTask<?>[] a2 = this.array;
                if (this.array == null || (m4 = a2.length - 1) < 0 || (s2 = this.top - 1) - this.base < 0 || (t2 = (ForkJoinTask)U.getObject(a2, j2 = (long)(((m4 & s2) << ASHIFT) + ABASE))) == null) break;
                if (!U.compareAndSwapObject(a2, j2, t2, null)) continue;
                this.top = s2;
                t2.doExec();
            }
        }

        private void pollAndExecAll() {
            ForkJoinTask<?> t2;
            while ((t2 = this.poll()) != null) {
                t2.doExec();
            }
        }

        final int tryRemoveAndExec(ForkJoinTask<?> task) {
            int b2;
            int s2;
            int n2;
            int m4;
            int stat = 1;
            boolean removed = false;
            boolean empty = true;
            ForkJoinTask<?>[] a2 = this.array;
            if (this.array != null && (m4 = a2.length - 1) >= 0 && (n2 = (s2 = this.top) - (b2 = this.base)) > 0) {
                int j2;
                ForkJoinTask t2;
                while ((t2 = (ForkJoinTask)U.getObjectVolatile(a2, j2 = ((--s2 & m4) << ASHIFT) + ABASE)) != null) {
                    if (t2 == task) {
                        if (s2 + 1 == this.top) {
                            if (!U.compareAndSwapObject(a2, j2, task, null)) break;
                            this.top = s2;
                            removed = true;
                            break;
                        }
                        if (this.base != b2) break;
                        removed = U.compareAndSwapObject(a2, j2, task, new EmptyTask());
                        break;
                    }
                    if (t2.status >= 0) {
                        empty = false;
                    } else if (s2 + 1 == this.top) {
                        if (!U.compareAndSwapObject(a2, j2, t2, null)) break;
                        this.top = s2;
                        break;
                    }
                    if (--n2 != 0) continue;
                    if (empty || this.base != b2) break;
                    stat = 0;
                    break;
                }
            }
            if (removed) {
                task.doExec();
            }
            return stat;
        }

        final void runTask(ForkJoinTask<?> t2) {
            if (t2 != null) {
                this.currentSteal = t2;
                t2.doExec();
                if (this.top != this.base) {
                    if (this.mode == 0) {
                        this.popAndExecAll();
                    } else {
                        this.pollAndExecAll();
                    }
                }
                ++this.nsteals;
                this.currentSteal = null;
            }
        }

        final void runSubtask(ForkJoinTask<?> t2) {
            if (t2 != null) {
                ForkJoinTask<?> ps = this.currentSteal;
                this.currentSteal = t2;
                t2.doExec();
                this.currentSteal = ps;
            }
        }

        final boolean isApparentlyUnblocked() {
            Thread.State s2;
            ForkJoinWorkerThread wt;
            return this.eventCount >= 0 && (wt = this.owner) != null && (s2 = wt.getState()) != Thread.State.BLOCKED && s2 != Thread.State.WAITING && s2 != Thread.State.TIMED_WAITING;
        }

        final void interruptOwner() {
            Thread p2;
            ForkJoinWorkerThread wt = this.owner;
            if (wt != null && !wt.isInterrupted()) {
                try {
                    wt.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if ((p2 = this.parker) != null) {
                U.unpark(p2);
            }
        }

        static {
            int s2;
            try {
                U = ForkJoinPool.getUnsafe();
                Class<WorkQueue> k2 = WorkQueue.class;
                Class<ForkJoinTask[]> ak = ForkJoinTask[].class;
                RUNSTATE = U.objectFieldOffset(k2.getDeclaredField("runState"));
                ABASE = U.arrayBaseOffset(ak);
                s2 = U.arrayIndexScale(ak);
            }
            catch (Exception e2) {
                throw new Error(e2);
            }
            if ((s2 & s2 - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(s2);
        }
    }

    static final class EmptyTask
    extends ForkJoinTask<Void> {
        EmptyTask() {
            this.status = -268435456;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void x2) {
        }

        @Override
        public final boolean exec() {
            return true;
        }
    }

    static final class Mutex
    extends AbstractQueuedSynchronizer {
        Mutex() {
        }

        @Override
        public final boolean tryAcquire(int ignore) {
            return this.compareAndSetState(0, 1);
        }

        @Override
        public final boolean tryRelease(int ignore) {
            this.setState(0);
            return true;
        }

        public final void lock() {
            this.acquire(0);
        }

        public final void unlock() {
            this.release(0);
        }

        @Override
        public final boolean isHeldExclusively() {
            return this.getState() == 1;
        }

        public final Condition newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }
    }

    static class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new ForkJoinWorkerThread(pool);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

