/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.DummyLogger;
import no.priv.garshol.duke.Link;
import no.priv.garshol.duke.LinkDatabase;
import no.priv.garshol.duke.LinkKind;
import no.priv.garshol.duke.LinkStatus;
import no.priv.garshol.duke.Logger;
import no.priv.garshol.duke.utils.JDBCUtils;

public abstract class RDBMSLinkDatabase
implements LinkDatabase {
    private DatabaseType dbtype;
    private String tblprefix;
    protected Statement stmt;
    private Logger logger;
    private static final SimpleDateFormat dtformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public RDBMSLinkDatabase(String dbtype) {
        this.dbtype = RDBMSLinkDatabase.getDatabaseType(dbtype);
        this.tblprefix = "";
        this.logger = new DummyLogger();
    }

    public void init() {
        try {
            this.verifySchema();
        }
        catch (Throwable e2) {
            this.close();
            throw new DukeException(e2);
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setTablePrefix(String tblprefix) {
        this.tblprefix = tblprefix;
    }

    public List<Link> getAllLinks() {
        return this.getChangesSince(0L, 0L, 0);
    }

    public List<Link> getChangesSince(long since) {
        return this.getChangesSince(since, 0L, 0);
    }

    public List<Link> getChangesSince(long since, long before) {
        return this.getChangesSince(since, before, 0);
    }

    public List<Link> getChangesSince(long since, long before, int pagesize) {
        String where = "";
        if (since != 0L || before != 0L) {
            where = "where ";
        }
        if (since != 0L) {
            where = where + "timestamp > TIMESTAMP '" + dtformat.format(since) + "'";
        }
        if (before != 0L) {
            if (since != 0L) {
                where = where + "and ";
            }
            where = where + "timestamp <= TIMESTAMP '" + dtformat.format(before) + "'";
        }
        String limit = "";
        if (pagesize != 0 && (limit = this.dbtype.getLimit(pagesize)).length() == 0) {
            where = where.length() > 0 ? where + " AND " + this.dbtype.getWhereLimit(pagesize) : where + " where " + this.dbtype.getWhereLimit(pagesize);
        }
        return this.queryForLinks("select * from " + this.tblprefix + "links " + where + " order by timestamp desc " + limit);
    }

    @Override
    public Collection<Link> getAllLinksFor(String id) {
        return this.queryForLinks("select * from " + this.tblprefix + "links where " + "id1 = '" + this.escape(id) + "' or " + "id2 = '" + this.escape(id) + "'");
    }

    @Override
    public void assertLink(Link link) {
        this.logger.debug("Asserting link " + link);
        try {
            String query;
            Link existing = null;
            ResultSet rs = this.stmt.executeQuery("select * from " + this.tblprefix + "links where " + "id1 = '" + this.escape(link.getID1()) + "' and " + "id2 = '" + this.escape(link.getID2()) + "'");
            if (rs.next()) {
                existing = this.makeLink(rs);
                rs.close();
                if (!link.overrides(existing)) {
                    return;
                }
            }
            rs.close();
            if (existing != null) {
                this.logger.trace("Updating link for " + link.getID1() + " and " + link.getID2());
                query = "update " + this.tblprefix + "links set status = " + link.getStatus().getId() + " , kind = " + link.getKind().getId() + " , timestamp = " + this.dbtype.getNow() + " " + " , confidence = " + link.getConfidence() + " " + "where id1 = '" + this.escape(link.getID1()) + "' " + "      and id2 = '" + this.escape(link.getID2()) + "' ";
            } else {
                this.logger.trace("Inserting link for " + link.getID1() + " and " + link.getID2());
                query = "insert into " + this.tblprefix + "links values ('" + this.escape(link.getID1()) + "', " + "  '" + this.escape(link.getID2()) + "', " + link.getKind().getId() + "  , " + link.getStatus().getId() + ", " + this.dbtype.getNow() + ", " + link.getConfidence() + ") ";
            }
            this.stmt.executeUpdate(query);
        }
        catch (SQLException e2) {
            this.close();
            throw new DukeException(e2);
        }
    }

    @Override
    public Link inferLink(String id1, String id2) {
        throw new DukeException("not implemented yet");
    }

    @Override
    public void clear() {
        try {
            this.stmt.executeUpdate("delete from " + this.tblprefix + "links");
        }
        catch (SQLException e2) {
            this.close();
            throw new DukeException(e2);
        }
    }

    @Override
    public void commit() {
        try {
            Connection conn = this.stmt.getConnection();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (SQLException e2) {
            this.close();
            throw new DukeException(e2);
        }
    }

    @Override
    public void close() {
        JDBCUtils.close(this.stmt);
    }

    private void verifySchema() throws SQLException {
        boolean present;
        String lastpart = "";
        if (!this.tblprefix.equals("")) {
            lastpart = "AND owner = '" + this.tblprefix.substring(0, this.tblprefix.length() - 1) + "'";
        }
        if (present = JDBCUtils.queryHasResult(this.stmt, "select * from " + this.dbtype.getMetaTableName() + " " + "where table_name = 'LINKS'" + lastpart)) {
            return;
        }
        this.logger.warn("Table LINKS not found; recreating");
        this.stmt.executeUpdate(this.dbtype.getCreateTable());
        this.stmt.executeUpdate("create index " + this.tblprefix + "links_ix_id1 on " + this.tblprefix + "links (id1)");
        this.stmt.executeUpdate("create index " + this.tblprefix + "links_ix_id2 on " + this.tblprefix + "links (id2)");
    }

    private String escape(String strval) {
        return strval.replace("'", "''");
    }

    private List<Link> queryForLinks(String query) {
        ArrayList<Link> links = new ArrayList<Link>();
        try {
            this.logger.trace("Querying for links: " + query);
            ResultSet rs = this.stmt.executeQuery(query);
            while (rs.next()) {
                links.add(this.makeLink(rs));
            }
            rs.close();
        }
        catch (SQLException e2) {
            this.close();
            throw new DukeException(e2);
        }
        return links;
    }

    private Link makeLink(ResultSet rs) throws SQLException {
        return new Link(rs.getString("id1"), rs.getString("id2"), LinkStatus.getbyid(rs.getInt("status")), LinkKind.getbyid(rs.getInt("kind")), rs.getTimestamp("timestamp").getTime(), rs.getDouble("confidence"));
    }

    private static DatabaseType getDatabaseType(String dbtype) {
        if (dbtype.equals("h2")) {
            return DatabaseType.H2;
        }
        if (dbtype.equals("oracle")) {
            return DatabaseType.ORACLE;
        }
        if (dbtype.equals("mysql")) {
            return DatabaseType.MYSQL;
        }
        throw new DukeConfigException("Unknown database type: '" + dbtype + "'");
    }

    public static enum DatabaseType {
        MYSQL{

            @Override
            public String getMetaTableName() {
                return "information_schema.tables";
            }

            @Override
            public String getCreateTable() {
                return "create table LINKS (   id1 varchar (100) not null,   id2 varchar (100) not null,   kind int not null,   status int not null,   timestamp timestamp not null,   confidence float not null,   primary key (id1, id2)) ";
            }

            @Override
            public String getNow() {
                return "now()";
            }

            @Override
            public String getLimit(int no) {
                return "limit " + no;
            }

            @Override
            public String getWhereLimit(int no) {
                return "";
            }
        }
        ,
        H2{

            @Override
            public String getMetaTableName() {
                return "information_schema.tables";
            }

            @Override
            public String getCreateTable() {
                return "create table LINKS (   id1 varchar not null,   id2 varchar not null,   kind int not null,   status int not null,   timestamp timestamp not null,   confidence float not null,   primary key (id1, id2)) ";
            }

            @Override
            public String getNow() {
                return "now()";
            }

            @Override
            public String getLimit(int no) {
                return "limit " + no;
            }

            @Override
            public String getWhereLimit(int no) {
                return "";
            }
        }
        ,
        ORACLE{

            @Override
            public String getMetaTableName() {
                return "all_tables";
            }

            @Override
            public String getCreateTable() {
                return "create table LINKS (   id1 varchar(200) not null,   id2 varchar(200) not null,   kind int not null,   status int not null,   timestamp timestamp not null,   confidence float not null,   primary key (id1, id2)) ";
            }

            @Override
            public String getNow() {
                return "current_timestamp";
            }

            @Override
            public String getLimit(int no) {
                return "";
            }

            @Override
            public String getWhereLimit(int no) {
                return "rownum <= " + no;
            }
        };


        public abstract String getMetaTableName();

        public abstract String getCreateTable();

        public abstract String getNow();

        public abstract String getLimit(int var1);

        public abstract String getWhereLimit(int var1);
    }
}

