/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.cleaners;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import no.priv.garshol.duke.Cleaner;
import no.priv.garshol.duke.cleaners.LowerCaseNormalizeCleaner;
import no.priv.garshol.duke.utils.StringUtils;

public class PersonNameCleaner
implements Cleaner {
    private LowerCaseNormalizeCleaner sub = new LowerCaseNormalizeCleaner();
    private Map<String, String> mapping;

    public PersonNameCleaner() {
        try {
            this.mapping = this.loadMapping();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public String clean(String value) {
        if ((value = this.sub.clean(value)) == null || value.equals("")) {
            return value;
        }
        String[] tokens = StringUtils.split(value);
        for (int ix = 0; ix < tokens.length; ++ix) {
            String mapsto = this.mapping.get(tokens[ix]);
            if (mapsto == null) continue;
            tokens[ix] = mapsto;
        }
        return StringUtils.join(tokens);
    }

    private Map<String, String> loadMapping() throws IOException {
        String mapfile = "no/priv/garshol/duke/name-mappings.txt";
        HashMap<String, String> mapping = new HashMap<String, String>();
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();
        InputStream istream = cloader.getResourceAsStream(mapfile);
        InputStreamReader reader = new InputStreamReader(istream, "utf-8");
        BufferedReader in = new BufferedReader(reader);
        String line = in.readLine();
        while (line != null) {
            int pos = line.indexOf(44);
            mapping.put(line.substring(0, pos), line.substring(pos + 1));
            line = in.readLine();
        }
        in.close();
        return mapping;
    }
}

