/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import no.priv.garshol.duke.Comparator;

public class WeightedLevenshtein
implements Comparator {
    private WeightEstimator estimator = new DefaultWeightEstimator();

    @Override
    public double compare(String s1, String s2) {
        if (s1.equals(s2)) {
            return 1.0;
        }
        int len = Math.min(s1.length(), s2.length());
        double dist = WeightedLevenshtein.distance(s1, s2, this.estimator);
        if (dist > (double)len) {
            return 0.0;
        }
        return 1.0 - dist / (double)len;
    }

    @Override
    public boolean isTokenized() {
        return true;
    }

    public void setEstimator(WeightEstimator estimator) {
        this.estimator = estimator;
    }

    public static double distance(String s1, String s2, WeightEstimator weight) {
        int s1len = s1.length();
        if (s1len == 0) {
            return WeightedLevenshtein.estimateCharacters(s2, weight);
        }
        if (s2.length() == 0) {
            return WeightedLevenshtein.estimateCharacters(s1, weight);
        }
        double[] matrix = new double[(s1len + 1) * (s2.length() + 1)];
        for (int col = 0; col <= s2.length(); ++col) {
            matrix[col * s1len] = col;
        }
        for (int row = 0; row <= s1len; ++row) {
            matrix[row] = row;
        }
        for (int ix1 = 0; ix1 < s1len; ++ix1) {
            char ch1 = s1.charAt(ix1);
            for (int ix2 = 0; ix2 < s2.length(); ++ix2) {
                char ch2 = s2.charAt(ix2);
                double cost = ch1 == ch2 ? 0.0 : weight.substitute(ix1, ch1, s2.charAt(ix2));
                double left = matrix[ix1 + (ix2 + 1) * s1len] + weight.delete(ix1, ch1);
                double above = matrix[ix1 + 1 + ix2 * s1len] + weight.insert(ix1, ch2);
                double aboveleft = matrix[ix1 + ix2 * s1len] + cost;
                matrix[ix1 + 1 + (ix2 + 1) * s1len] = Math.min(left, Math.min(above, aboveleft));
            }
        }
        return matrix[s1len + s2.length() * s1len];
    }

    public static double compactDistance(String s1, String s2, WeightEstimator weight) {
        int s1len = s1.length();
        if (s1len == 0) {
            return WeightedLevenshtein.estimateCharacters(s2, weight);
        }
        if (s2.length() == 0) {
            return WeightedLevenshtein.estimateCharacters(s1, weight);
        }
        double maxdist = (double)Math.min(s1.length(), s2.length()) / 2.0;
        double[] column = new double[s1len + 1];
        int ix2 = 0;
        char ch2 = s2.charAt(ix2);
        column[0] = 1.0;
        for (int ix1 = 1; ix1 <= s1len; ++ix1) {
            double cost = s1.charAt(ix1 - 1) == ch2 ? 0.0 : weight.substitute(ix1, s1.charAt(ix1 - 1), ch2);
            column[ix1] = Math.min(column[ix1 - 1], (double)(ix1 - 1)) + cost;
        }
        double above = 0.0;
        for (ix2 = 1; ix2 < s2.length(); ++ix2) {
            ch2 = s2.charAt(ix2);
            above = ix2 + 1;
            double smallest = Double.MAX_VALUE;
            for (int ix1 = 1; ix1 <= s1len; ++ix1) {
                char ch1 = s1.charAt(ix1 - 1);
                double cost = ch1 == ch2 ? 0.0 : weight.substitute(ix1, ch1, ch2);
                double left = column[ix1] + weight.delete(ix1, ch1);
                double aboveleft = column[ix1 - 1] + cost;
                double above2 = above + weight.insert(ix1, ch2);
                double value = Math.min(Math.min(above2, left), aboveleft);
                column[ix1 - 1] = above;
                above = value;
                smallest = Math.min(smallest, value);
            }
            column[s1len] = above;
            if (!(smallest > maxdist)) continue;
            return smallest;
        }
        return above;
    }

    private static double estimateCharacters(String s2, WeightEstimator e2) {
        double sum = 0.0;
        for (int ix = 0; ix < s2.length(); ++ix) {
            sum += Math.min(e2.insert(ix, s2.charAt(ix)), e2.delete(ix, s2.charAt(ix)));
        }
        return sum;
    }

    public static void timing(String s1, String s2) {
        int ix;
        int TIMES = 100000;
        System.out.println("----- (" + s1 + ", " + s2 + ")");
        DefaultWeightEstimator e2 = new DefaultWeightEstimator();
        long time = System.currentTimeMillis();
        for (ix = 0; ix < 100000; ++ix) {
            WeightedLevenshtein.distance(s1, s2, e2);
        }
        System.out.println("default: " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        for (ix = 0; ix < 100000; ++ix) {
            WeightedLevenshtein.compactDistance(s1, s2, e2);
        }
        System.out.println("compact: " + (System.currentTimeMillis() - time));
    }

    public static class DefaultWeightEstimator
    implements WeightEstimator {
        private double[] charweight;
        private double digits = 2.0;
        private double letters = 1.0;
        private double punctuation = 0.1;
        private double other = 1.0;

        public DefaultWeightEstimator() {
            this.recompute();
        }

        @Override
        public double substitute(int pos, char ch1, char ch2) {
            return Math.max(this.insert(pos, ch1), this.insert(pos, ch2));
        }

        @Override
        public double delete(int pos, char ch) {
            return this.insert(pos, ch);
        }

        @Override
        public double insert(int pos, char ch) {
            if (ch > this.charweight.length) {
                return this.other;
            }
            return this.charweight[ch];
        }

        public void setDigitWeight(double digits) {
            this.digits = digits;
            this.recompute();
        }

        public void setLetterWeight(double letters) {
            this.letters = letters;
            this.recompute();
        }

        public void setOtherWeight(double other) {
            this.other = other;
            this.recompute();
        }

        public void setPunctuationWeight(double punctuation) {
            this.punctuation = punctuation;
            this.recompute();
        }

        private void recompute() {
            this.charweight = new double[255];
            for (int ix = 0; ix < this.charweight.length; ++ix) {
                char ch = (char)ix;
                double weight = this.other;
                if (Character.isLetter(ch)) {
                    weight = this.letters;
                } else if (Character.isDigit(ch)) {
                    weight = this.digits;
                } else {
                    int type = Character.getType(ch);
                    if (Character.isSpace(ch) || type >= 20 && type <= 27) {
                        weight = this.punctuation;
                    }
                }
                this.charweight[ix] = weight;
            }
        }
    }

    public static interface WeightEstimator {
        public double substitute(int var1, char var2, char var3);

        public double delete(int var1, char var2);

        public double insert(int var1, char var2);
    }
}

