/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.databases;

import java.util.HashMap;
import java.util.Map;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.databases.Bucket;
import no.priv.garshol.duke.databases.KeyValueStore;

public class InMemoryKeyValueStore
implements KeyValueStore {
    private long nextid;
    private Record[] records = new Record[1000];
    private Map<String, Bucket> tokens = new HashMap<String, Bucket>();
    private Map<String, Long> byid = new HashMap<String, Long>();

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    public void commit() {
        for (Bucket b2 : this.tokens.values()) {
            b2.sort();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public long makeNewRecordId() {
        return this.nextid++;
    }

    @Override
    public void registerRecord(long id, Record record) {
        if (id >= (long)this.records.length) {
            Record[] newbuf = new Record[this.records.length * 2];
            System.arraycopy(this.records, 0, newbuf, 0, this.records.length);
            this.records = newbuf;
        }
        this.records[(int)id] = record;
    }

    @Override
    public void registerId(long id, String extid) {
        this.byid.put(extid, id);
    }

    @Override
    public void registerToken(long id, String propname, String token) {
        String key = propname + '|' + token;
        Bucket bucket = this.tokens.get(key);
        if (bucket == null) {
            bucket = new Bucket();
            this.tokens.put(key, bucket);
        }
        bucket.add(id);
    }

    @Override
    public Record findRecordById(String extid) {
        Long id = this.byid.get(extid);
        if (id == null) {
            return null;
        }
        return this.records[id.intValue()];
    }

    @Override
    public Record findRecordById(long id) {
        return this.records[(int)id];
    }

    @Override
    public Bucket lookupToken(String propname, String token) {
        return this.tokens.get(propname + '|' + token);
    }

    public String toString() {
        return "InMemoryKeyValueStore";
    }
}

