/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.datasources.Column;
import no.priv.garshol.duke.datasources.ColumnarDataSource;
import no.priv.garshol.duke.datasources.RecordBuilder;
import no.priv.garshol.duke.utils.JDBCUtils;

public class JDBCDataSource
extends ColumnarDataSource {
    private String jdbcuri;
    private String driverclass;
    private String username;
    private String password;
    private String query;

    public void setConnectionString(String str) {
        this.jdbcuri = str;
    }

    public void setDriverClass(String klass) {
        this.driverclass = klass;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public String getDriverClass() {
        return this.driverclass;
    }

    public String getConnectionString() {
        return this.jdbcuri;
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public RecordIterator getRecords() {
        this.verifyProperty(this.jdbcuri, "connection-string");
        this.verifyProperty(this.driverclass, "driver-class");
        this.verifyProperty(this.query, "query");
        try {
            Properties props = new Properties();
            if (this.username != null) {
                props.put("user", this.username);
            }
            if (this.password != null) {
                props.put("password", this.password);
            }
            Statement stmt2 = JDBCUtils.open(this.driverclass, this.jdbcuri, props);
            ResultSet rs = stmt2.executeQuery(this.query);
            return new JDBCIterator(rs);
        }
        catch (SQLException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    protected String getSourceName() {
        return "JDBC";
    }

    public class JDBCIterator
    extends RecordIterator {
        private Statement stmt;
        private ResultSet rs;
        private boolean next;
        private RecordBuilder builder;

        public JDBCIterator(ResultSet rs) throws SQLException {
            this.rs = rs;
            this.next = rs.next();
            this.stmt = rs.getStatement();
            this.builder = new RecordBuilder(JDBCDataSource.this);
        }

        @Override
        public boolean hasNext() {
            return this.next;
        }

        @Override
        public Record next() {
            try {
                this.builder.newRecord();
                for (Column col : JDBCDataSource.this.getColumns()) {
                    String value = this.rs.getString(col.getName());
                    this.builder.addValue(col, value);
                }
                this.next = this.rs.next();
                return this.builder.getRecord();
            }
            catch (SQLException e2) {
                throw new RuntimeException(e2);
            }
        }

        @Override
        public void close() {
            try {
                try {
                    if (!this.rs.isClosed()) {
                        this.rs.close();
                    }
                }
                catch (UnsupportedOperationException e2) {
                    this.rs.close();
                }
            }
            catch (SQLException e3) {
                throw new DukeException(e3);
            }
            JDBCUtils.close(this.stmt);
        }
    }
}

