/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.genetic;

import java.util.ArrayList;
import java.util.List;
import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.genetic.Aspect;
import no.priv.garshol.duke.genetic.ComparatorAspect;
import no.priv.garshol.duke.genetic.HighProbabilityAspect;
import no.priv.garshol.duke.genetic.LowProbabilityAspect;
import no.priv.garshol.duke.genetic.ThresholdAspect;

public class GeneticConfiguration
implements Comparable<GeneticConfiguration> {
    private GeneticConfiguration parent;
    private Configuration config;
    private List<Aspect> aspects;
    private double f;
    private int rank;

    public GeneticConfiguration(Configuration config) {
        this.config = config;
        this.aspects = new ArrayList<Aspect>();
        this.aspects.add(new ThresholdAspect());
        for (Property prop : config.getProperties()) {
            if (prop.isIdProperty()) continue;
            this.aspects.add(new ComparatorAspect(prop));
            this.aspects.add(new LowProbabilityAspect(prop));
            this.aspects.add(new HighProbabilityAspect(prop));
        }
    }

    public GeneticConfiguration(GeneticConfiguration config) {
        this.parent = config;
        this.config = this.parent.getConfiguration().copy();
        this.aspects = this.parent.aspects;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public double getFNumber() {
        return this.f;
    }

    public void setFNumber(double f2) {
        this.f = f2;
    }

    public GeneticConfiguration getParent() {
        return this.parent;
    }

    public GeneticConfiguration makeRandomCopy() {
        GeneticConfiguration copy = new GeneticConfiguration(this);
        Configuration theconfig = copy.getConfiguration();
        for (Aspect aspect : this.aspects) {
            aspect.setRandomly(theconfig);
        }
        return copy;
    }

    public void mutate() {
        Aspect aspect = this.aspects.get((int)(Math.random() * (double)this.aspects.size()));
        aspect.setRandomly(this.config);
    }

    public void mateWith(GeneticConfiguration other) {
        Configuration otherc = other.getConfiguration();
        for (Aspect aspect : this.aspects) {
            if (!(Math.random() < 0.5)) continue;
            aspect.setFromOther(this.config, otherc);
        }
    }

    @Override
    public int compareTo(GeneticConfiguration other) {
        if (this.f < other.getFNumber()) {
            return 1;
        }
        if (this.f == other.getFNumber()) {
            return 0;
        }
        return -1;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[GeneticConfiguration " + this.shortnum(this.config.getThreshold()));
        for (Property p2 : this.config.getProperties()) {
            if (p2.isIdProperty()) {
                buf.append(" [" + p2.getName() + "]");
                continue;
            }
            buf.append(" [" + p2.getName() + " " + this.shortname(p2.getComparator()) + " " + this.shortnum(p2.getHighProbability()) + " " + this.shortnum(p2.getLowProbability()) + "]");
        }
        buf.append("]");
        return buf.toString();
    }

    private String shortname(Comparator comp) {
        return comp.getClass().getSimpleName();
    }

    private String shortnum(double number) {
        String str = "" + number;
        if (str.length() > 4) {
            return str.substring(0, 4);
        }
        return str;
    }
}

