/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.matchers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.Link;
import no.priv.garshol.duke.LinkDatabase;
import no.priv.garshol.duke.LinkKind;
import no.priv.garshol.duke.LinkStatus;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.matchers.AbstractMatchListener;
import no.priv.garshol.duke.matchers.PrintMatchListener;

public class LinkDatabaseMatchListener
extends AbstractMatchListener {
    private Configuration config;
    private LinkDatabase linkdb;
    private Record current;
    private Collection<Link> curlinks;

    public LinkDatabaseMatchListener(Configuration config, LinkDatabase linkdb) {
        this.config = config;
        this.linkdb = linkdb;
    }

    @Override
    public void matches(Record r1, Record r2, double confidence) {
        if (r1 != this.current) {
            if (this.current != null) {
                this.endRecord_();
            }
            this.startRecord_(r1);
        }
        String id1 = this.getIdentity(r1);
        String id2 = this.getIdentity(r2);
        this.curlinks.add(new Link(id1, id2, LinkStatus.INFERRED, LinkKind.SAME, confidence));
    }

    @Override
    public void matchesPerhaps(Record r1, Record r2, double confidence) {
        if (r1 != this.current) {
            if (this.current != null) {
                this.endRecord_();
            }
            this.startRecord_(r1);
        }
        String id1 = this.getIdentity(r1);
        String id2 = this.getIdentity(r2);
        this.curlinks.add(new Link(id1, id2, LinkStatus.INFERRED, LinkKind.MAYBESAME, confidence));
    }

    @Override
    public void noMatchFor(Record record) {
        if (this.current != null) {
            this.endRecord_();
        }
        this.startRecord_(record);
    }

    public void startRecord_(Record r2) {
        this.current = r2;
        this.curlinks = new ArrayList<Link>();
    }

    public void endRecord_() {
        Collection<Link> oldlinks = this.linkdb.getAllLinksFor(this.getIdentity(this.current));
        if (oldlinks != null) {
            HashMap<String, Link> oldmap = new HashMap<String, Link>(oldlinks.size());
            for (Link l2 : oldlinks) {
                oldmap.put(this.makeKey(l2), l2);
            }
            for (Link newl : new ArrayList<Link>(this.curlinks)) {
                String key = this.makeKey(newl);
                Link oldl = (Link)oldmap.get(key);
                if (oldl == null) continue;
                if (oldl.overrides(newl)) {
                    this.curlinks.remove(newl);
                    continue;
                }
                oldmap.remove(key);
            }
            for (Link oldl : oldmap.values()) {
                if (oldl.getStatus() != LinkStatus.INFERRED) continue;
                oldl.retract();
                this.curlinks.add(oldl);
            }
        }
        for (Link l3 : this.curlinks) {
            this.linkdb.assertLink(l3);
        }
    }

    @Override
    public void batchReady(int size) {
        this.linkdb.validateConnection();
    }

    @Override
    public void batchDone() {
        this.endRecord_();
        this.current = null;
        this.linkdb.commit();
    }

    private String getIdentity(Record r2) {
        for (Property p2 : this.config.getIdentityProperties()) {
            Iterator<String> i$;
            Collection<String> vs = r2.getValues(p2.getName());
            if (vs == null || !(i$ = vs.iterator()).hasNext()) continue;
            String v2 = i$.next();
            return v2;
        }
        throw new DukeException("No identity found in record [" + PrintMatchListener.toString(r2) + "]");
    }

    private String makeKey(Link l2) {
        return l2.getID1() + "\t" + l2.getID2();
    }
}

