/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.utils.ObjectUtils;

public class JDBCUtils {
    public static Statement open(String jndiPath) {
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(jndiPath);
            Connection conn = ds.getConnection();
            return conn.createStatement();
        }
        catch (NamingException e2) {
            throw new DukeException("No database configuration found via JNDI at " + jndiPath, e2);
        }
        catch (SQLException e3) {
            throw new DukeException("Error connecting to database via " + jndiPath, e3);
        }
    }

    public static Statement open(String driverklass, String jdbcuri, Properties props) {
        try {
            Driver driver = (Driver)ObjectUtils.instantiate(driverklass);
            Connection conn = driver.connect(jdbcuri, props);
            if (conn == null) {
                throw new DukeException("Couldn't connect to database at " + jdbcuri);
            }
            return conn.createStatement();
        }
        catch (SQLException e2) {
            throw new DukeException(e2);
        }
    }

    public static void close(Statement stmt2) {
        try {
            Connection conn = stmt2.getConnection();
            try {
                if (!stmt2.isClosed()) {
                    stmt2.close();
                }
            }
            catch (UnsupportedOperationException e2) {
                stmt2.close();
            }
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException e3) {
            throw new DukeException(e3);
        }
    }

    public static boolean validate(Statement stmt2) {
        try {
            Connection conn = stmt2.getConnection();
            if (conn == null) {
                return false;
            }
            if (!conn.isClosed() && conn.isValid(10)) {
                return true;
            }
            stmt2.close();
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int queryForInt(Statement stmt2, String sql, int nullvalue) {
        try {
            ResultSet rs = stmt2.executeQuery(sql);
            try {
                if (!rs.next()) {
                    int n2 = nullvalue;
                    return n2;
                }
                int n3 = rs.getInt(1);
                return n3;
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e2) {
            throw new DukeException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean queryHasResult(Statement stmt2, String sql) {
        boolean bl;
        ResultSet rs = stmt2.executeQuery(sql);
        try {
            bl = rs.next();
        }
        catch (Throwable throwable) {
            try {
                rs.close();
                throw throwable;
            }
            catch (SQLException e2) {
                throw new DukeException(e2);
            }
        }
        rs.close();
        return bl;
    }
}

