/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import no.priv.garshol.duke.StatementHandler;

public class NTriplesWriter
implements StatementHandler {
    private Writer out;

    public NTriplesWriter(OutputStream out) {
        try {
            this.out = new OutputStreamWriter(out, "utf-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void statement(String subject, String property, String object, boolean literal) {
        try {
            if (subject.startsWith("_:")) {
                this.out.write(subject + " ");
            } else {
                this.out.write("<" + subject + "> ");
            }
            this.out.write("<" + property + "> ");
            if (literal) {
                this.out.write('\"' + this.escape(object) + '\"' + ' ');
            } else if (object.startsWith("_:")) {
                this.out.write(object + " ");
            } else {
                this.out.write("<" + object + "> ");
            }
            this.out.write(".\n");
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void done() throws IOException {
        this.out.flush();
    }

    private String escape(String str) {
        int pos = 0;
        char[] buf = new char[str.length() * 10];
        for (int ix = 0; ix < str.length(); ++ix) {
            char ch = str.charAt(ix);
            if (ch == ' ' || ch == '!' || ch >= '#' && ch <= '[' || ch >= ']' && ch <= '~') {
                buf[pos++] = ch;
                continue;
            }
            buf[pos++] = 92;
            if (ch < '\b' || ch == '\u000b' || ch == '\f' || ch >= '\u000e' && ch <= '\u001f' || ch >= '\u007f' && ch < '\uffff') {
                buf[pos++] = 117;
                buf[pos++] = this.hex(ch >> 12);
                buf[pos++] = this.hex(ch >> 8 & 0xF);
                buf[pos++] = this.hex(ch >> 4 & 0xF);
                buf[pos++] = this.hex(ch & 0xF);
                continue;
            }
            if (ch == '\t') {
                buf[pos++] = 116;
                continue;
            }
            if (ch == '\n') {
                buf[pos++] = 110;
                continue;
            }
            if (ch == '\r') {
                buf[pos++] = 114;
                continue;
            }
            if (ch == '\"') {
                buf[pos++] = 34;
                continue;
            }
            if (ch != '\\') continue;
            buf[pos++] = 92;
        }
        return new String(buf, 0, pos);
    }

    private char hex(int ch) {
        if (ch < 10) {
            return (char)(48 + (char)ch);
        }
        return (char)(65 + (char)(ch - 10));
    }
}

