/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import no.priv.garshol.duke.DukeException;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;

public class XMLPrettyPrinter
implements DocumentHandler {
    private static final String NL = System.getProperty("line.separator");
    protected Writer writer;
    protected String encoding;
    protected boolean[] subelements;
    protected char[] startline;
    protected int offset;
    protected int level;
    protected int encodeCharsFrom = -1;
    protected boolean dropControlChars = true;

    public XMLPrettyPrinter(OutputStream stream) throws UnsupportedEncodingException {
        this(stream, "utf-8");
    }

    public XMLPrettyPrinter(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(stream, encoding), encoding);
    }

    public XMLPrettyPrinter(Writer writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding;
        this.makeSubelements(20);
        this.makeStartLineBuffer(100);
    }

    @Override
    public void startDocument() {
        if (this.encoding != null) {
            this.write(this.writer, "<?xml version=\"1.0\" encoding=\"");
            this.write(this.writer, this.encoding);
            this.write(this.writer, "\" standalone=\"yes\"?>" + NL);
        }
        this.level = 0;
    }

    @Override
    public void startElement(String name, AttributeList atts) {
        if (this.level > 0) {
            this.indent();
        }
        this.write(this.writer, '<');
        this.write(this.writer, name);
        if (atts != null) {
            for (int i2 = 0; i2 < atts.getLength(); ++i2) {
                this.write(this.writer, ' ');
                this.write(this.writer, atts.getName(i2));
                this.write(this.writer, "=\"");
                this.escapeAttrValue(atts.getValue(i2), this.writer);
                this.write(this.writer, "\"");
            }
        }
        this.write(this.writer, '>');
        ++this.level;
        if (this.offset + this.level * 2 > this.startline.length) {
            this.makeStartLineBuffer((this.offset + this.level * 2) * 2);
        }
        if (this.level >= this.subelements.length) {
            this.makeSubelements(this.level * 2);
        }
        if (this.level > 0) {
            this.subelements[this.level - 1] = true;
        }
        this.subelements[this.level] = false;
    }

    @Override
    public void endElement(String name) {
        if (this.subelements[this.level--]) {
            this.indent();
        }
        this.write(this.writer, "</");
        this.write(this.writer, name);
        this.write(this.writer, '>');
    }

    public void text(String text) {
        this.characters(text.toCharArray(), 0, text.length());
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        block5: for (int i2 = start; i2 < start + length; ++i2) {
            switch (ch[i2]) {
                case '&': {
                    this.write(this.writer, "&amp;");
                    continue block5;
                }
                case '<': {
                    this.write(this.writer, "&lt;");
                    continue block5;
                }
                case '>': {
                    this.write(this.writer, "&gt;");
                    continue block5;
                }
                default: {
                    if (ch[i2] > '\u001f' || ch[i2] == '\n' || ch[i2] == '\t' || ch[i2] == '\r') {
                        if (this.encodeCharsFrom > 0 && ch[i2] >= this.encodeCharsFrom) {
                            this.write(this.writer, "&#");
                            this.write(this.writer, Integer.toString(ch[i2]));
                            this.write(this.writer, ';');
                            continue block5;
                        }
                        this.write(this.writer, ch[i2]);
                        continue block5;
                    }
                    if (this.dropControlChars) continue block5;
                    this.write(this.writer, "&#");
                    this.write(this.writer, Integer.toString(ch[i2]));
                    this.write(this.writer, ';');
                }
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
        this.write(this.writer, "<?");
        this.write(this.writer, target);
        this.write(this.writer, ' ');
        this.write(this.writer, data);
        this.write(this.writer, "?>");
    }

    @Override
    public void endDocument() {
        this.write(this.writer, NL);
        this.flush(this.writer);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    public void setEncodeCharactersFrom(int charnumber) {
        this.encodeCharsFrom = charnumber;
    }

    public void setDropControlCharacters(boolean dropControlChars) {
        this.dropControlChars = dropControlChars;
    }

    public void addUnescaped(String content) {
        this.write(this.writer, content);
    }

    protected void write(Writer writer, String s2) {
        try {
            writer.write(s2);
        }
        catch (IOException e2) {
            throw new DukeException(e2);
        }
    }

    protected void write(Writer writer, char c2) {
        try {
            writer.write(c2);
        }
        catch (IOException e2) {
            throw new DukeException(e2);
        }
    }

    protected void write(Writer writer, char[] c2, int off, int len) {
        try {
            writer.write(c2, off, len);
        }
        catch (IOException e2) {
            throw new DukeException(e2);
        }
    }

    protected void flush(Writer writer) {
        try {
            writer.flush();
        }
        catch (IOException e2) {
            throw new DukeException(e2);
        }
    }

    protected void indent() {
        this.write(this.writer, this.startline, 0, this.offset + this.level * 2);
    }

    protected void escapeAttrValue(String attrval, Writer writer) {
        int len = attrval.length();
        block5: for (int i2 = 0; i2 < len; ++i2) {
            char c2 = attrval.charAt(i2);
            switch (c2) {
                case '&': {
                    this.write(writer, "&amp;");
                    continue block5;
                }
                case '<': {
                    this.write(writer, "&lt;");
                    continue block5;
                }
                case '\"': {
                    this.write(writer, "&quot;");
                    continue block5;
                }
                default: {
                    if (c2 > '\u001f' || c2 == '\n' || c2 == '\t' || c2 == '\r') {
                        if (this.encodeCharsFrom > 0 && c2 >= this.encodeCharsFrom) {
                            this.write(writer, "&#");
                            this.write(writer, Integer.toString(c2));
                            this.write(writer, ';');
                            continue block5;
                        }
                        this.write(writer, c2);
                        continue block5;
                    }
                    if (this.dropControlChars) continue block5;
                    this.write(writer, "&#");
                    this.write(writer, Integer.toString(c2));
                    this.write(writer, ';');
                }
            }
        }
    }

    protected void makeStartLineBuffer(int size) {
        int ix;
        this.startline = new char[size];
        this.offset = NL.length();
        for (ix = 0; ix < this.offset; ++ix) {
            this.startline[ix] = NL.charAt(ix);
        }
        while (ix < size) {
            this.startline[ix] = 32;
            ++ix;
        }
    }

    protected void makeSubelements(int size) {
        boolean[] subs = new boolean[size];
        if (this.subelements != null) {
            System.arraycopy(this.subelements, 0, subs, 0, this.subelements.length);
        }
        this.subelements = subs;
    }
}

