/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.AbstractPackMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.Vector;
import org.netlib.util.intW;

abstract class AbstractSymmPackMatrix
extends AbstractPackMatrix {
    private UpLo uplo;

    AbstractSymmPackMatrix(int n2, UpLo uplo) {
        super(n2);
        this.uplo = uplo;
    }

    AbstractSymmPackMatrix(Matrix A2, UpLo uplo) {
        this(A2, true, uplo);
    }

    AbstractSymmPackMatrix(Matrix A2, boolean deep, UpLo uplo) {
        super(A2, deep);
        this.uplo = uplo;
    }

    @Override
    public Vector multAdd(double alpha, Vector x2, Vector y2) {
        if (!(x2 instanceof DenseVector) || !(y2 instanceof DenseVector)) {
            return super.multAdd(alpha, x2, y2);
        }
        this.checkMultAdd(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y2).getData();
        BLAS.getInstance().dspmv(this.uplo.netlib(), this.numRows, alpha, this.data, xd, 1, 1.0, yd, 1);
        return y2;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x2, Vector y2) {
        return this.multAdd(alpha, x2, y2);
    }

    @Override
    public Matrix rank1(double alpha, Vector x2, Vector y2) {
        if (x2 != y2) {
            throw new IllegalArgumentException("x != y");
        }
        if (!(x2 instanceof DenseVector)) {
            return super.rank1(alpha, x2, y2);
        }
        this.checkRank1(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        BLAS.getInstance().dspr(this.uplo.netlib(), this.numRows, alpha, xd, 1, this.data);
        return this;
    }

    @Override
    public Matrix rank2(double alpha, Vector x2, Vector y2) {
        if (!(x2 instanceof DenseVector) || !(y2 instanceof DenseVector)) {
            return super.rank2(alpha, x2, y2);
        }
        this.checkRank2(x2, y2);
        double[] xd = ((DenseVector)x2).getData();
        double[] yd = ((DenseVector)y2).getData();
        BLAS.getInstance().dspr2(this.uplo.netlib(), this.numRows, alpha, xd, 1, yd, 1, this.data);
        return this;
    }

    @Override
    public Matrix solve(Matrix B2, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B2, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B2);
        int[] ipiv = new int[this.numRows];
        intW info = new intW(0);
        LAPACK.getInstance().dspsv(this.uplo.netlib(), this.numRows, X.numColumns(), (double[])this.data.clone(), ipiv, Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    public Vector solve(Vector b2, Vector x2) {
        DenseMatrix B2 = new DenseMatrix(b2, false);
        DenseMatrix X = new DenseMatrix(x2, false);
        this.solve(B2, X);
        return x2;
    }

    @Override
    public Matrix transSolve(Matrix B2, Matrix X) {
        return this.solve(B2, X);
    }

    @Override
    public Vector transSolve(Vector b2, Vector x2) {
        return this.solve(b2, x2);
    }

    Matrix SPDsolve(Matrix B2, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B2, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B2);
        intW info = new intW(0);
        LAPACK.getInstance().dppsv(this.uplo.netlib(), this.numRows, X.numColumns(), (double[])this.data.clone(), Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixNotSPDException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    public Matrix transpose() {
        return this;
    }
}

